/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource.bitmap;

import android.graphics.Bitmap;
import android.util.Log;
import androidx.core.os.TraceCompat;
import com.bumptech.glide.load.EncodeStrategy;
import com.bumptech.glide.load.Option;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.ResourceEncoder;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.util.LogTime;
import com.bumptech.glide.util.Util;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BitmapEncoder
implements ResourceEncoder<Bitmap> {
    public static final Option<Bitmap.CompressFormat> COMPRESSION_FORMAT;
    public static final Option<Integer> COMPRESSION_QUALITY;
    private static final String TAG = "BitmapEncoder";

    static {
        COMPRESSION_QUALITY = Option.memory("com.bumptech.glide.load.resource.bitmap.BitmapEncoder.CompressionQuality", 90);
        COMPRESSION_FORMAT = Option.memory("com.bumptech.glide.load.resource.bitmap.BitmapEncoder.CompressionFormat");
    }

    private Bitmap.CompressFormat getFormat(Bitmap bitmap2, Options options) {
        if ((options = options.get(COMPRESSION_FORMAT)) != null) {
            return options;
        }
        if (bitmap2.hasAlpha()) {
            return Bitmap.CompressFormat.PNG;
        }
        return Bitmap.CompressFormat.JPEG;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean encode(Resource<Bitmap> object, File object2, Options options) {
        void var2_9;
        boolean bl;
        long l3;
        Bitmap.CompressFormat compressFormat;
        Bitmap bitmap2;
        block18: {
            block19: {
                Object object3;
                boolean bl2;
                boolean bl3;
                block20: {
                    bitmap2 = (Bitmap)object.get();
                    compressFormat = this.getFormat(bitmap2, options);
                    object = new StringBuilder();
                    ((StringBuilder)object).append("encode: [");
                    ((StringBuilder)object).append(bitmap2.getWidth());
                    ((StringBuilder)object).append("x");
                    ((StringBuilder)object).append(bitmap2.getHeight());
                    ((StringBuilder)object).append("] ");
                    ((StringBuilder)object).append(compressFormat);
                    TraceCompat.beginSection((String)((StringBuilder)object).toString());
                    l3 = LogTime.getLogTime();
                    int n2 = options.get(COMPRESSION_QUALITY);
                    bl3 = false;
                    bl2 = false;
                    Object var11_17 = null;
                    Object var12_18 = null;
                    object = var12_18;
                    object = var12_18;
                    object3 = new FileOutputStream((File)object2);
                    bitmap2.compress(compressFormat, n2, (OutputStream)object3);
                    ((OutputStream)object3).close();
                    bl = true;
                    bl2 = true;
                    ((OutputStream)object3).close();
                    bl = bl2;
                    break block18;
                    catch (Throwable throwable) {
                        object = object3;
                        break block19;
                    }
                    catch (IOException iOException) {
                        object2 = object3;
                        object3 = iOException;
                        break block20;
                    }
                    catch (Throwable throwable) {
                        break block19;
                    }
                    catch (IOException iOException) {
                        object2 = var11_17;
                    }
                }
                object = object2;
                {
                    if (Log.isLoggable((String)TAG, (int)3)) {
                        object = object2;
                        Log.d((String)TAG, (String)"Failed to encode Bitmap", (Throwable)object3);
                    }
                    bl = bl2;
                    if (object2 == null) break block18;
                    bl = bl3;
                }
                ((OutputStream)object2).close();
                bl = bl2;
            }
            if (object == null) throw var2_9;
            ((OutputStream)object).close();
            throw var2_9;
            catch (IOException iOException) {}
        }
        if (!Log.isLoggable((String)TAG, (int)2)) return bl;
        object = new StringBuilder();
        ((StringBuilder)object).append("Compressed with type: ");
        ((StringBuilder)object).append(compressFormat);
        ((StringBuilder)object).append(" of size ");
        ((StringBuilder)object).append(Util.getBitmapByteSize(bitmap2));
        ((StringBuilder)object).append(" in ");
        ((StringBuilder)object).append(LogTime.getElapsedMillis(l3));
        ((StringBuilder)object).append(", options format: ");
        ((StringBuilder)object).append(options.get(COMPRESSION_FORMAT));
        ((StringBuilder)object).append(", hasAlpha: ");
        ((StringBuilder)object).append(bitmap2.hasAlpha());
        Log.v((String)TAG, (String)((StringBuilder)object).toString());
        return bl;
        finally {
            TraceCompat.endSection();
        }
        catch (IOException iOException) {
            throw var2_9;
        }
    }

    @Override
    public EncodeStrategy getEncodeStrategy(Options options) {
        return EncodeStrategy.TRANSFORMED;
    }
}

