/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.model;

import android.content.res.AssetFileDescriptor;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.model.ModelLoader;
import com.bumptech.glide.load.model.ModelLoaderFactory;
import com.bumptech.glide.load.model.MultiModelLoaderFactory;
import java.io.File;
import java.io.InputStream;

public class StringLoader<Data>
implements ModelLoader<String, Data> {
    private final ModelLoader<Uri, Data> uriLoader;

    public StringLoader(ModelLoader<Uri, Data> modelLoader) {
        this.uriLoader = modelLoader;
    }

    private static Uri parseUri(String string2) {
        Uri uri;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        string2 = string2.charAt(0) == '/' ? StringLoader.toFileUri(string2) : ((uri = Uri.parse((String)string2)).getScheme() == null ? StringLoader.toFileUri(string2) : uri);
        return string2;
    }

    private static Uri toFileUri(String string2) {
        return Uri.fromFile((File)new File(string2));
    }

    @Override
    public ModelLoader.LoadData<Data> buildLoadData(String object, int n2, int n3, Options options) {
        object = (object = StringLoader.parseUri((String)object)) == null ? null : this.uriLoader.buildLoadData((Uri)object, n2, n3, options);
        return object;
    }

    @Override
    public boolean handles(String string2) {
        return true;
    }

    public static final class AssetFileDescriptorFactory
    implements ModelLoaderFactory<String, AssetFileDescriptor> {
        @Override
        public ModelLoader<String, AssetFileDescriptor> build(MultiModelLoaderFactory multiModelLoaderFactory) {
            return new StringLoader<AssetFileDescriptor>(multiModelLoaderFactory.build(Uri.class, AssetFileDescriptor.class));
        }

        @Override
        public void teardown() {
        }
    }

    public static class FileDescriptorFactory
    implements ModelLoaderFactory<String, ParcelFileDescriptor> {
        @Override
        public ModelLoader<String, ParcelFileDescriptor> build(MultiModelLoaderFactory multiModelLoaderFactory) {
            return new StringLoader<ParcelFileDescriptor>(multiModelLoaderFactory.build(Uri.class, ParcelFileDescriptor.class));
        }

        @Override
        public void teardown() {
        }
    }

    public static class StreamFactory
    implements ModelLoaderFactory<String, InputStream> {
        @Override
        public ModelLoader<String, InputStream> build(MultiModelLoaderFactory multiModelLoaderFactory) {
            return new StringLoader<InputStream>(multiModelLoaderFactory.build(Uri.class, InputStream.class));
        }

        @Override
        public void teardown() {
        }
    }
}

