/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.model;

import androidx.core.util.Pools;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.data.DataFetcher;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.load.model.ModelLoader;
import com.bumptech.glide.util.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

class MultiModelLoader<Model, Data>
implements ModelLoader<Model, Data> {
    private final Pools.Pool<List<Throwable>> exceptionListPool;
    private final List<ModelLoader<Model, Data>> modelLoaders;

    MultiModelLoader(List<ModelLoader<Model, Data>> list, Pools.Pool<List<Throwable>> pool) {
        this.modelLoaders = list;
        this.exceptionListPool = pool;
    }

    @Override
    public ModelLoader.LoadData<Data> buildLoadData(Model object, int n2, int n3, Options options) {
        int n4 = this.modelLoaders.size();
        ArrayList arrayList = new ArrayList(n4);
        Object var7_7 = null;
        Key key = null;
        for (int i3 = 0; i3 < n4; ++i3) {
            Object object2 = this.modelLoaders.get(i3);
            Key key2 = key;
            if (object2.handles(object)) {
                object2 = object2.buildLoadData(object, n2, n3, options);
                key2 = key;
                if (object2 != null) {
                    key2 = ((ModelLoader.LoadData)object2).sourceKey;
                    arrayList.add(((ModelLoader.LoadData)object2).fetcher);
                }
            }
            key = key2;
        }
        object = var7_7;
        if (!arrayList.isEmpty()) {
            object = new ModelLoader.LoadData(key, new MultiFetcher(arrayList, this.exceptionListPool));
        }
        return object;
    }

    @Override
    public boolean handles(Model Model2) {
        Iterator<ModelLoader<Model, Data>> iterator = this.modelLoaders.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().handles(Model2)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("MultiModelLoader{modelLoaders=");
        stringBuilder.append(Arrays.toString(this.modelLoaders.toArray()));
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    static class MultiFetcher<Data>
    implements DataFetcher<Data>,
    DataFetcher.DataCallback<Data> {
        private DataFetcher.DataCallback<? super Data> callback;
        private int currentIndex;
        private List<Throwable> exceptions;
        private final List<DataFetcher<Data>> fetchers;
        private Priority priority;
        private final Pools.Pool<List<Throwable>> throwableListPool;

        MultiFetcher(List<DataFetcher<Data>> list, Pools.Pool<List<Throwable>> pool) {
            this.throwableListPool = pool;
            Preconditions.checkNotEmpty(list);
            this.fetchers = list;
            this.currentIndex = 0;
        }

        private void startNextOrFail() {
            if (this.currentIndex < this.fetchers.size() - 1) {
                ++this.currentIndex;
                this.loadData(this.priority, this.callback);
            } else {
                Preconditions.checkNotNull(this.exceptions);
                this.callback.onLoadFailed(new GlideException("Fetch failed", new ArrayList<Throwable>(this.exceptions)));
            }
        }

        @Override
        public void cancel() {
            Iterator<DataFetcher<Data>> iterator = this.fetchers.iterator();
            while (iterator.hasNext()) {
                iterator.next().cancel();
            }
        }

        @Override
        public void cleanup() {
            List<Throwable> list = this.exceptions;
            if (list != null) {
                this.throwableListPool.release(list);
            }
            this.exceptions = null;
            list = this.fetchers.iterator();
            while (list.hasNext()) {
                ((DataFetcher)list.next()).cleanup();
            }
        }

        @Override
        public Class<Data> getDataClass() {
            return this.fetchers.get(0).getDataClass();
        }

        @Override
        public DataSource getDataSource() {
            return this.fetchers.get(0).getDataSource();
        }

        @Override
        public void loadData(Priority priority, DataFetcher.DataCallback<? super Data> dataCallback) {
            this.priority = priority;
            this.callback = dataCallback;
            this.exceptions = (List)this.throwableListPool.acquire();
            this.fetchers.get(this.currentIndex).loadData(priority, this);
        }

        @Override
        public void onDataReady(Data Data) {
            if (Data != null) {
                this.callback.onDataReady(Data);
            } else {
                this.startNextOrFail();
            }
        }

        @Override
        public void onLoadFailed(Exception exception) {
            Preconditions.checkNotNull(this.exceptions).add(exception);
            this.startNextOrFail();
        }
    }
}

