/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.model;

import com.bumptech.glide.util.LruCache;
import com.bumptech.glide.util.Util;
import java.util.Queue;

public class ModelCache<A, B> {
    private static final int DEFAULT_SIZE = 250;
    private final LruCache<ModelKey<A>, B> cache;

    public ModelCache() {
        this(250L);
    }

    public ModelCache(long l3) {
        this.cache = new LruCache<ModelKey<A>, B>(l3){

            @Override
            protected void onItemEvicted(ModelKey<A> modelKey, B b3) {
                modelKey.release();
            }
        };
    }

    public void clear() {
        this.cache.clearMemory();
    }

    public B get(A object, int n2, int n3) {
        ModelKey<A> modelKey = ModelKey.get(object, n2, n3);
        object = this.cache.get(modelKey);
        modelKey.release();
        return (B)object;
    }

    public void put(A object, int n2, int n3, B b3) {
        object = ModelKey.get(object, n2, n3);
        this.cache.put((ModelKey<A>)object, b3);
    }

    static final class ModelKey<A> {
        private static final Queue<ModelKey<?>> KEY_QUEUE = Util.createQueue(0);
        private int height;
        private A model;
        private int width;

        private ModelKey() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static <A> ModelKey<A> get(A a3, int n2, int n3) {
            ModelKey<?> modelKey;
            ModelKey<A> modelKey2 = KEY_QUEUE;
            synchronized (modelKey2) {
                modelKey = KEY_QUEUE.poll();
            }
            modelKey2 = modelKey;
            if (modelKey == null) {
                modelKey2 = new ModelKey<A>();
            }
            super.init(a3, n2, n3);
            return modelKey2;
        }

        private void init(A a3, int n2, int n3) {
            this.model = a3;
            this.width = n2;
            this.height = n3;
        }

        public boolean equals(Object object) {
            boolean bl;
            boolean bl2 = object instanceof ModelKey;
            boolean bl3 = bl = false;
            if (bl2) {
                object = (ModelKey)object;
                bl3 = bl;
                if (this.width == ((ModelKey)object).width) {
                    bl3 = bl;
                    if (this.height == ((ModelKey)object).height) {
                        bl3 = bl;
                        if (this.model.equals(((ModelKey)object).model)) {
                            bl3 = true;
                        }
                    }
                }
            }
            return bl3;
        }

        public int hashCode() {
            return (this.height * 31 + this.width) * 31 + this.model.hashCode();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void release() {
            Queue<ModelKey<?>> queue = KEY_QUEUE;
            synchronized (queue) {
                KEY_QUEUE.offer(this);
                return;
            }
        }
    }
}

