/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine.prefill;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import com.bumptech.glide.load.DecodeFormat;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.engine.cache.MemoryCache;
import com.bumptech.glide.load.engine.prefill.BitmapPreFillRunner;
import com.bumptech.glide.load.engine.prefill.PreFillQueue;
import com.bumptech.glide.load.engine.prefill.PreFillType;
import com.bumptech.glide.util.Util;
import java.util.HashMap;

public final class BitmapPreFiller {
    private final BitmapPool bitmapPool;
    private BitmapPreFillRunner current;
    private final DecodeFormat defaultFormat;
    private final Handler handler = new Handler(Looper.getMainLooper());
    private final MemoryCache memoryCache;

    public BitmapPreFiller(MemoryCache memoryCache, BitmapPool bitmapPool, DecodeFormat decodeFormat) {
        this.memoryCache = memoryCache;
        this.bitmapPool = bitmapPool;
        this.defaultFormat = decodeFormat;
    }

    private static int getSizeInBytes(PreFillType preFillType) {
        return Util.getBitmapByteSize(preFillType.getWidth(), preFillType.getHeight(), preFillType.getConfig());
    }

    PreFillQueue generateAllocationOrder(PreFillType ... preFillTypeArray) {
        int n2;
        long l3 = this.memoryCache.getMaxSize();
        long l4 = this.memoryCache.getCurrentSize();
        long l5 = this.bitmapPool.getMaxSize();
        int n3 = preFillTypeArray.length;
        int n4 = 0;
        int n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            n5 += preFillTypeArray[n2].getWeight();
        }
        float f3 = (float)(l3 - l4 + l5) / (float)n5;
        HashMap<PreFillType, Integer> hashMap = new HashMap<PreFillType, Integer>();
        n5 = preFillTypeArray.length;
        for (n2 = n4; n2 < n5; ++n2) {
            PreFillType preFillType = preFillTypeArray[n2];
            hashMap.put(preFillType, Math.round((float)preFillType.getWeight() * f3) / BitmapPreFiller.getSizeInBytes(preFillType));
        }
        return new PreFillQueue(hashMap);
    }

    public void preFill(PreFillType.Builder ... object) {
        BitmapPreFillRunner bitmapPreFillRunner = this.current;
        if (bitmapPreFillRunner != null) {
            bitmapPreFillRunner.cancel();
        }
        PreFillType[] preFillTypeArray = new PreFillType[((PreFillType.Builder[])object).length];
        for (int i3 = 0; i3 < ((PreFillType.Builder[])object).length; ++i3) {
            PreFillType.Builder builder = object[i3];
            if (builder.getConfig() == null) {
                bitmapPreFillRunner = this.defaultFormat != DecodeFormat.PREFER_ARGB_8888 && this.defaultFormat != DecodeFormat.PREFER_ARGB_8888_DISALLOW_HARDWARE ? Bitmap.Config.RGB_565 : Bitmap.Config.ARGB_8888;
                builder.setConfig((Bitmap.Config)bitmapPreFillRunner);
            }
            preFillTypeArray[i3] = builder.build();
        }
        object = this.generateAllocationOrder(preFillTypeArray);
        this.current = new BitmapPreFillRunner(this.bitmapPool, this.memoryCache, (PreFillQueue)object);
        this.handler.post((Runnable)this.current);
    }
}

