/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine.executor;

import android.os.Build;
import android.os.StrictMode;
import android.util.Log;
import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;

final class RuntimeCompat {
    private static final String CPU_LOCATION = "/sys/devices/system/cpu/";
    private static final String CPU_NAME_REGEX = "cpu[0-9]+";
    private static final String TAG = "GlideRuntimeCompat";

    private RuntimeCompat() {
    }

    static int availableProcessors() {
        int n2;
        int n3 = n2 = Runtime.getRuntime().availableProcessors();
        if (Build.VERSION.SDK_INT < 17) {
            n3 = Math.max(RuntimeCompat.getCoreCountPre17(), n2);
        }
        return n3;
    }

    private static int getCoreCountPre17() {
        File[] fileArray;
        StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
        try {
            File file = new File(CPU_LOCATION);
            fileArray = Pattern.compile(CPU_NAME_REGEX);
            FilenameFilter filenameFilter = new FilenameFilter((Pattern)fileArray){
                final /* synthetic */ Pattern val$cpuNamePattern;
                {
                    this.val$cpuNamePattern = pattern;
                }

                @Override
                public boolean accept(File file, String string2) {
                    return this.val$cpuNamePattern.matcher(string2).matches();
                }
            };
            fileArray = file.listFiles(filenameFilter);
        }
        catch (Throwable throwable) {
            if (Log.isLoggable((String)TAG, (int)6)) {
                Log.e((String)TAG, (String)"Failed to calculate accurate cpu count", (Throwable)throwable);
            }
            fileArray = null;
        }
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        int n2 = fileArray != null ? fileArray.length : 0;
        return Math.max(1, n2);
        {
            finally {
                StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
            }
        }
    }
}

