/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine.executor;

import android.os.Process;
import android.os.StrictMode;
import android.util.Log;
import com.bumptech.glide.load.engine.executor.RuntimeCompat;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class GlideExecutor
implements ExecutorService {
    private static final String ANIMATION_EXECUTOR_NAME = "animation";
    private static final String DEFAULT_DISK_CACHE_EXECUTOR_NAME = "disk-cache";
    private static final int DEFAULT_DISK_CACHE_EXECUTOR_THREADS = 1;
    private static final String DEFAULT_SOURCE_EXECUTOR_NAME = "source";
    private static final long KEEP_ALIVE_TIME_MS = TimeUnit.SECONDS.toMillis(10L);
    private static final int MAXIMUM_AUTOMATIC_THREAD_COUNT = 4;
    private static final String SOURCE_UNLIMITED_EXECUTOR_NAME = "source-unlimited";
    private static final String TAG = "GlideExecutor";
    private static volatile int bestThreadCount;
    private final ExecutorService delegate;

    GlideExecutor(ExecutorService executorService) {
        this.delegate = executorService;
    }

    public static int calculateBestThreadCount() {
        if (bestThreadCount == 0) {
            bestThreadCount = Math.min(4, RuntimeCompat.availableProcessors());
        }
        return bestThreadCount;
    }

    public static GlideExecutor newAnimationExecutor() {
        int n2 = GlideExecutor.calculateBestThreadCount() >= 4 ? 2 : 1;
        return GlideExecutor.newAnimationExecutor(n2, UncaughtThrowableStrategy.DEFAULT);
    }

    public static GlideExecutor newAnimationExecutor(int n2, UncaughtThrowableStrategy uncaughtThrowableStrategy) {
        return new GlideExecutor(new ThreadPoolExecutor(0, n2, KEEP_ALIVE_TIME_MS, TimeUnit.MILLISECONDS, new PriorityBlockingQueue<Runnable>(), new DefaultThreadFactory(ANIMATION_EXECUTOR_NAME, uncaughtThrowableStrategy, true)));
    }

    public static GlideExecutor newDiskCacheExecutor() {
        return GlideExecutor.newDiskCacheExecutor(1, DEFAULT_DISK_CACHE_EXECUTOR_NAME, UncaughtThrowableStrategy.DEFAULT);
    }

    public static GlideExecutor newDiskCacheExecutor(int n2, String string2, UncaughtThrowableStrategy uncaughtThrowableStrategy) {
        return new GlideExecutor(new ThreadPoolExecutor(n2, n2, 0L, TimeUnit.MILLISECONDS, new PriorityBlockingQueue<Runnable>(), new DefaultThreadFactory(string2, uncaughtThrowableStrategy, true)));
    }

    public static GlideExecutor newDiskCacheExecutor(UncaughtThrowableStrategy uncaughtThrowableStrategy) {
        return GlideExecutor.newDiskCacheExecutor(1, DEFAULT_DISK_CACHE_EXECUTOR_NAME, uncaughtThrowableStrategy);
    }

    public static GlideExecutor newSourceExecutor() {
        return GlideExecutor.newSourceExecutor(GlideExecutor.calculateBestThreadCount(), DEFAULT_SOURCE_EXECUTOR_NAME, UncaughtThrowableStrategy.DEFAULT);
    }

    public static GlideExecutor newSourceExecutor(int n2, String string2, UncaughtThrowableStrategy uncaughtThrowableStrategy) {
        return new GlideExecutor(new ThreadPoolExecutor(n2, n2, 0L, TimeUnit.MILLISECONDS, new PriorityBlockingQueue<Runnable>(), new DefaultThreadFactory(string2, uncaughtThrowableStrategy, false)));
    }

    public static GlideExecutor newSourceExecutor(UncaughtThrowableStrategy uncaughtThrowableStrategy) {
        return GlideExecutor.newSourceExecutor(GlideExecutor.calculateBestThreadCount(), DEFAULT_SOURCE_EXECUTOR_NAME, uncaughtThrowableStrategy);
    }

    public static GlideExecutor newUnlimitedSourceExecutor() {
        return new GlideExecutor(new ThreadPoolExecutor(0, Integer.MAX_VALUE, KEEP_ALIVE_TIME_MS, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new DefaultThreadFactory(SOURCE_UNLIMITED_EXECUTOR_NAME, UncaughtThrowableStrategy.DEFAULT, false)));
    }

    @Override
    public boolean awaitTermination(long l3, TimeUnit timeUnit) throws InterruptedException {
        return this.delegate.awaitTermination(l3, timeUnit);
    }

    @Override
    public void execute(Runnable runnable) {
        this.delegate.execute(runnable);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection) throws InterruptedException {
        return this.delegate.invokeAll(collection);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection, long l3, TimeUnit timeUnit) throws InterruptedException {
        return this.delegate.invokeAll(collection, l3, timeUnit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection) throws InterruptedException, ExecutionException {
        return this.delegate.invokeAny(collection);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection, long l3, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.invokeAny(collection, l3, timeUnit);
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        return this.delegate.submit(runnable);
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T t2) {
        return this.delegate.submit(runnable, t2);
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        return this.delegate.submit(callable);
    }

    public String toString() {
        return this.delegate.toString();
    }

    private static final class DefaultThreadFactory
    implements ThreadFactory {
        private static final int DEFAULT_PRIORITY = 9;
        private final String name;
        final boolean preventNetworkOperations;
        private int threadNum;
        final UncaughtThrowableStrategy uncaughtThrowableStrategy;

        DefaultThreadFactory(String string2, UncaughtThrowableStrategy uncaughtThrowableStrategy, boolean bl) {
            this.name = string2;
            this.uncaughtThrowableStrategy = uncaughtThrowableStrategy;
            this.preventNetworkOperations = bl;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            synchronized (this) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("glide-");
                stringBuilder.append(this.name);
                stringBuilder.append("-thread-");
                stringBuilder.append(this.threadNum);
                Thread thread = new Thread(runnable, stringBuilder.toString()){

                    @Override
                    public void run() {
                        Process.setThreadPriority((int)9);
                        if (DefaultThreadFactory.this.preventNetworkOperations) {
                            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)new StrictMode.ThreadPolicy.Builder().detectNetwork().penaltyDeath().build());
                        }
                        try {
                            super.run();
                        }
                        catch (Throwable throwable) {
                            DefaultThreadFactory.this.uncaughtThrowableStrategy.handle(throwable);
                        }
                    }
                };
                ++this.threadNum;
                return thread;
            }
        }
    }

    public static interface UncaughtThrowableStrategy {
        public static final UncaughtThrowableStrategy DEFAULT;
        public static final UncaughtThrowableStrategy IGNORE;
        public static final UncaughtThrowableStrategy LOG;
        public static final UncaughtThrowableStrategy THROW;

        static {
            IGNORE = new UncaughtThrowableStrategy(){

                @Override
                public void handle(Throwable throwable) {
                }
            };
            LOG = new UncaughtThrowableStrategy(){

                @Override
                public void handle(Throwable throwable) {
                    if (throwable != null && Log.isLoggable((String)GlideExecutor.TAG, (int)6)) {
                        Log.e((String)GlideExecutor.TAG, (String)"Request threw uncaught throwable", (Throwable)throwable);
                    }
                }
            };
            THROW = new UncaughtThrowableStrategy(){

                @Override
                public void handle(Throwable throwable) {
                    if (throwable == null) {
                        return;
                    }
                    throw new RuntimeException("Request threw uncaught throwable", throwable);
                }
            };
            DEFAULT = LOG;
        }

        public void handle(Throwable var1);
    }
}

