/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine.bitmap_recycle;

import android.graphics.Bitmap;
import com.bumptech.glide.load.engine.bitmap_recycle.BaseKeyPool;
import com.bumptech.glide.load.engine.bitmap_recycle.GroupedLinkedMap;
import com.bumptech.glide.load.engine.bitmap_recycle.LruPoolStrategy;
import com.bumptech.glide.load.engine.bitmap_recycle.Poolable;
import com.bumptech.glide.load.engine.bitmap_recycle.PrettyPrintTreeMap;
import com.bumptech.glide.util.Util;
import java.util.NavigableMap;

final class SizeStrategy
implements LruPoolStrategy {
    private static final int MAX_SIZE_MULTIPLE = 8;
    private final GroupedLinkedMap<Key, Bitmap> groupedMap;
    private final KeyPool keyPool = new KeyPool();
    private final NavigableMap<Integer, Integer> sortedSizes;

    SizeStrategy() {
        this.groupedMap = new GroupedLinkedMap();
        this.sortedSizes = new PrettyPrintTreeMap<Integer, Integer>();
    }

    private void decrementBitmapOfSize(Integer n2) {
        Integer n3 = (Integer)this.sortedSizes.get(n2);
        if (n3 == 1) {
            this.sortedSizes.remove(n2);
        } else {
            this.sortedSizes.put(n2, n3 - 1);
        }
    }

    static String getBitmapString(int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        stringBuilder.append(n2);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private static String getBitmapString(Bitmap bitmap2) {
        return SizeStrategy.getBitmapString(Util.getBitmapByteSize(bitmap2));
    }

    @Override
    public Bitmap get(int n2, int n3, Bitmap.Config config) {
        int n4 = Util.getBitmapByteSize(n2, n3, config);
        Key key = this.keyPool.get(n4);
        Integer n5 = this.sortedSizes.ceilingKey(n4);
        Key key2 = key;
        if (n5 != null) {
            key2 = key;
            if (n5 != n4) {
                key2 = key;
                if (n5 <= n4 * 8) {
                    this.keyPool.offer(key);
                    key2 = this.keyPool.get(n5);
                }
            }
        }
        if ((key2 = this.groupedMap.get(key2)) != null) {
            key2.reconfigure(n2, n3, config);
            this.decrementBitmapOfSize(n5);
        }
        return key2;
    }

    @Override
    public int getSize(Bitmap bitmap2) {
        return Util.getBitmapByteSize(bitmap2);
    }

    @Override
    public String logBitmap(int n2, int n3, Bitmap.Config config) {
        return SizeStrategy.getBitmapString(Util.getBitmapByteSize(n2, n3, config));
    }

    @Override
    public String logBitmap(Bitmap bitmap2) {
        return SizeStrategy.getBitmapString(bitmap2);
    }

    @Override
    public void put(Bitmap object) {
        int n2 = Util.getBitmapByteSize((Bitmap)object);
        Key key = this.keyPool.get(n2);
        this.groupedMap.put(key, (Bitmap)object);
        Integer n3 = (Integer)this.sortedSizes.get(key.size);
        object = this.sortedSizes;
        int n4 = key.size;
        n2 = 1;
        if (n3 != null) {
            n2 = 1 + n3;
        }
        object.put(n4, n2);
    }

    @Override
    public Bitmap removeLast() {
        Bitmap bitmap2 = this.groupedMap.removeLast();
        if (bitmap2 != null) {
            this.decrementBitmapOfSize(Util.getBitmapByteSize(bitmap2));
        }
        return bitmap2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SizeStrategy:\n  ");
        stringBuilder.append(this.groupedMap);
        stringBuilder.append("\n  SortedSizes");
        stringBuilder.append(this.sortedSizes);
        return stringBuilder.toString();
    }

    static final class Key
    implements Poolable {
        private final KeyPool pool;
        int size;

        Key(KeyPool keyPool) {
            this.pool = keyPool;
        }

        public boolean equals(Object object) {
            boolean bl;
            boolean bl2 = object instanceof Key;
            boolean bl3 = bl = false;
            if (bl2) {
                object = (Key)object;
                bl3 = bl;
                if (this.size == ((Key)object).size) {
                    bl3 = true;
                }
            }
            return bl3;
        }

        public int hashCode() {
            return this.size;
        }

        public void init(int n2) {
            this.size = n2;
        }

        @Override
        public void offer() {
            this.pool.offer(this);
        }

        public String toString() {
            return SizeStrategy.getBitmapString(this.size);
        }
    }

    static class KeyPool
    extends BaseKeyPool<Key> {
        KeyPool() {
        }

        @Override
        protected Key create() {
            return new Key(this);
        }

        public Key get(int n2) {
            Key key = (Key)super.get();
            key.init(n2);
            return key;
        }
    }
}

