/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine.bitmap_recycle;

import android.graphics.Bitmap;
import com.bumptech.glide.load.engine.bitmap_recycle.BaseKeyPool;
import com.bumptech.glide.load.engine.bitmap_recycle.GroupedLinkedMap;
import com.bumptech.glide.load.engine.bitmap_recycle.LruPoolStrategy;
import com.bumptech.glide.load.engine.bitmap_recycle.Poolable;
import com.bumptech.glide.util.Util;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class SizeConfigStrategy
implements LruPoolStrategy {
    private static final Bitmap.Config[] ALPHA_8_IN_CONFIGS;
    private static final Bitmap.Config[] ARGB_4444_IN_CONFIGS;
    private static final Bitmap.Config[] ARGB_8888_IN_CONFIGS;
    private static final int MAX_SIZE_MULTIPLE = 8;
    private static final Bitmap.Config[] RGB_565_IN_CONFIGS;
    private final GroupedLinkedMap<Key, Bitmap> groupedMap;
    private final KeyPool keyPool = new KeyPool();
    private final Map<Bitmap.Config, NavigableMap<Integer, Integer>> sortedSizes;

    static {
        ARGB_8888_IN_CONFIGS = new Bitmap.Config[]{Bitmap.Config.ARGB_8888, null};
        RGB_565_IN_CONFIGS = new Bitmap.Config[]{Bitmap.Config.RGB_565};
        ARGB_4444_IN_CONFIGS = new Bitmap.Config[]{Bitmap.Config.ARGB_4444};
        ALPHA_8_IN_CONFIGS = new Bitmap.Config[]{Bitmap.Config.ALPHA_8};
    }

    public SizeConfigStrategy() {
        this.groupedMap = new GroupedLinkedMap();
        this.sortedSizes = new HashMap<Bitmap.Config, NavigableMap<Integer, Integer>>();
    }

    private void decrementBitmapOfSize(Integer n2, Bitmap bitmap2) {
        NavigableMap<Integer, Integer> navigableMap = this.getSizesForConfig(bitmap2.getConfig());
        Integer n3 = (Integer)navigableMap.get(n2);
        if (n3 != null) {
            if (n3 == 1) {
                navigableMap.remove(n2);
            } else {
                navigableMap.put(n2, n3 - 1);
            }
            return;
        }
        navigableMap = new StringBuilder();
        ((StringBuilder)((Object)navigableMap)).append("Tried to decrement empty size, size: ");
        ((StringBuilder)((Object)navigableMap)).append(n2);
        ((StringBuilder)((Object)navigableMap)).append(", removed: ");
        ((StringBuilder)((Object)navigableMap)).append(this.logBitmap(bitmap2));
        ((StringBuilder)((Object)navigableMap)).append(", this: ");
        ((StringBuilder)((Object)navigableMap)).append(this);
        throw new NullPointerException(((StringBuilder)((Object)navigableMap)).toString());
    }

    private Key findBestKey(int n2, Bitmap.Config config) {
        Key key;
        Key key2 = this.keyPool.get(n2, config);
        Bitmap.Config[] configArray = SizeConfigStrategy.getInConfigs(config);
        int n3 = configArray.length;
        int n4 = 0;
        while (true) {
            key = key2;
            if (n4 >= n3) break;
            Bitmap.Config config2 = configArray[n4];
            Integer n5 = this.getSizesForConfig(config2).ceilingKey(n2);
            if (n5 != null && n5 <= n2 * 8) {
                if (n5 == n2) {
                    if (config2 == null) {
                        key = key2;
                        if (config == null) break;
                    } else {
                        key = key2;
                        if (config2.equals((Object)config)) break;
                    }
                }
                this.keyPool.offer(key2);
                key = this.keyPool.get(n5, config2);
                break;
            }
            ++n4;
        }
        return key;
    }

    static String getBitmapString(int n2, Bitmap.Config config) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        stringBuilder.append(n2);
        stringBuilder.append("](");
        stringBuilder.append(config);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private static Bitmap.Config[] getInConfigs(Bitmap.Config config) {
        int n2 = 1.$SwitchMap$android$graphics$Bitmap$Config[config.ordinal()];
        if (n2 != 1) {
            if (n2 != 2) {
                if (n2 != 3) {
                    if (n2 != 4) {
                        return new Bitmap.Config[]{config};
                    }
                    return ALPHA_8_IN_CONFIGS;
                }
                return ARGB_4444_IN_CONFIGS;
            }
            return RGB_565_IN_CONFIGS;
        }
        return ARGB_8888_IN_CONFIGS;
    }

    private NavigableMap<Integer, Integer> getSizesForConfig(Bitmap.Config config) {
        NavigableMap<Integer, Integer> navigableMap;
        NavigableMap<Integer, Integer> navigableMap2 = navigableMap = this.sortedSizes.get(config);
        if (navigableMap == null) {
            navigableMap2 = new TreeMap<Integer, Integer>();
            this.sortedSizes.put(config, navigableMap2);
        }
        return navigableMap2;
    }

    @Override
    public Bitmap get(int n2, int n3, Bitmap.Config object) {
        Bitmap bitmap2 = this.groupedMap.get((Key)(object = this.findBestKey(Util.getBitmapByteSize(n2, n3, object), (Bitmap.Config)object)));
        if (bitmap2 != null) {
            this.decrementBitmapOfSize(object.size, bitmap2);
            object = bitmap2.getConfig() != null ? bitmap2.getConfig() : Bitmap.Config.ARGB_8888;
            bitmap2.reconfigure(n2, n3, object);
        }
        return bitmap2;
    }

    @Override
    public int getSize(Bitmap bitmap2) {
        return Util.getBitmapByteSize(bitmap2);
    }

    @Override
    public String logBitmap(int n2, int n3, Bitmap.Config config) {
        return SizeConfigStrategy.getBitmapString(Util.getBitmapByteSize(n2, n3, config), config);
    }

    @Override
    public String logBitmap(Bitmap bitmap2) {
        return SizeConfigStrategy.getBitmapString(Util.getBitmapByteSize(bitmap2), bitmap2.getConfig());
    }

    @Override
    public void put(Bitmap object) {
        int n2 = Util.getBitmapByteSize((Bitmap)object);
        Key key = this.keyPool.get(n2, object.getConfig());
        this.groupedMap.put(key, (Bitmap)object);
        NavigableMap<Integer, Integer> navigableMap = this.getSizesForConfig(object.getConfig());
        object = (Integer)navigableMap.get(key.size);
        int n3 = key.size;
        n2 = 1;
        if (object != null) {
            n2 = 1 + (Integer)object;
        }
        navigableMap.put(n3, n2);
    }

    @Override
    public Bitmap removeLast() {
        Bitmap bitmap2 = this.groupedMap.removeLast();
        if (bitmap2 != null) {
            this.decrementBitmapOfSize(Util.getBitmapByteSize(bitmap2), bitmap2);
        }
        return bitmap2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SizeConfigStrategy{groupedMap=");
        stringBuilder.append(this.groupedMap);
        stringBuilder.append(", sortedSizes=(");
        for (Map.Entry<Bitmap.Config, NavigableMap<Integer, Integer>> entry : this.sortedSizes.entrySet()) {
            stringBuilder.append(entry.getKey());
            stringBuilder.append('[');
            stringBuilder.append(entry.getValue());
            stringBuilder.append("], ");
        }
        if (!this.sortedSizes.isEmpty()) {
            stringBuilder.replace(stringBuilder.length() - 2, stringBuilder.length(), "");
        }
        stringBuilder.append(")}");
        return stringBuilder.toString();
    }

    static final class Key
    implements Poolable {
        private Bitmap.Config config;
        private final KeyPool pool;
        int size;

        public Key(KeyPool keyPool) {
            this.pool = keyPool;
        }

        Key(KeyPool keyPool, int n2, Bitmap.Config config) {
            this(keyPool);
            this.init(n2, config);
        }

        public boolean equals(Object object) {
            boolean bl;
            boolean bl2 = object instanceof Key;
            boolean bl3 = bl = false;
            if (bl2) {
                object = (Key)object;
                bl3 = bl;
                if (this.size == ((Key)object).size) {
                    bl3 = bl;
                    if (Util.bothNullOrEqual(this.config, ((Key)object).config)) {
                        bl3 = true;
                    }
                }
            }
            return bl3;
        }

        public int hashCode() {
            int n2 = this.size;
            Bitmap.Config config = this.config;
            int n3 = config != null ? config.hashCode() : 0;
            return n2 * 31 + n3;
        }

        public void init(int n2, Bitmap.Config config) {
            this.size = n2;
            this.config = config;
        }

        @Override
        public void offer() {
            this.pool.offer(this);
        }

        public String toString() {
            return SizeConfigStrategy.getBitmapString(this.size, this.config);
        }
    }

    static class KeyPool
    extends BaseKeyPool<Key> {
        KeyPool() {
        }

        @Override
        protected Key create() {
            return new Key(this);
        }

        public Key get(int n2, Bitmap.Config config) {
            Key key = (Key)this.get();
            key.init(n2, config);
            return key;
        }
    }
}

