/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine.bitmap_recycle;

import android.graphics.Bitmap;
import android.os.Build;
import android.util.Log;
import com.bumptech.glide.load.engine.bitmap_recycle.AttributeStrategy;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.engine.bitmap_recycle.LruPoolStrategy;
import com.bumptech.glide.load.engine.bitmap_recycle.SizeConfigStrategy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class LruBitmapPool
implements BitmapPool {
    private static final Bitmap.Config DEFAULT_CONFIG = Bitmap.Config.ARGB_8888;
    private static final String TAG = "LruBitmapPool";
    private final Set<Bitmap.Config> allowedConfigs;
    private long currentSize;
    private int evictions;
    private int hits;
    private final long initialMaxSize;
    private long maxSize;
    private int misses;
    private int puts;
    private final LruPoolStrategy strategy;
    private final BitmapTracker tracker;

    public LruBitmapPool(long l3) {
        this(l3, LruBitmapPool.getDefaultStrategy(), LruBitmapPool.getDefaultAllowedConfigs());
    }

    LruBitmapPool(long l3, LruPoolStrategy lruPoolStrategy, Set<Bitmap.Config> set) {
        this.initialMaxSize = l3;
        this.maxSize = l3;
        this.strategy = lruPoolStrategy;
        this.allowedConfigs = set;
        this.tracker = new NullBitmapTracker();
    }

    public LruBitmapPool(long l3, Set<Bitmap.Config> set) {
        this(l3, LruBitmapPool.getDefaultStrategy(), set);
    }

    private static void assertNotHardwareConfig(Bitmap.Config config) {
        if (Build.VERSION.SDK_INT < 26) {
            return;
        }
        if (config != Bitmap.Config.HARDWARE) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Cannot create a mutable Bitmap with config: ");
        stringBuilder.append(config);
        stringBuilder.append(". Consider setting Downsampler#ALLOW_HARDWARE_CONFIG to false in your RequestOptions and/or in GlideBuilder.setDefaultRequestOptions");
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    private static Bitmap createBitmap(int n2, int n3, Bitmap.Config config) {
        if (config == null) {
            config = DEFAULT_CONFIG;
        }
        return Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)config);
    }

    private void dump() {
        if (Log.isLoggable((String)TAG, (int)2)) {
            this.dumpUnchecked();
        }
    }

    private void dumpUnchecked() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Hits=");
        stringBuilder.append(this.hits);
        stringBuilder.append(", misses=");
        stringBuilder.append(this.misses);
        stringBuilder.append(", puts=");
        stringBuilder.append(this.puts);
        stringBuilder.append(", evictions=");
        stringBuilder.append(this.evictions);
        stringBuilder.append(", currentSize=");
        stringBuilder.append(this.currentSize);
        stringBuilder.append(", maxSize=");
        stringBuilder.append(this.maxSize);
        stringBuilder.append("\nStrategy=");
        stringBuilder.append(this.strategy);
        Log.v((String)TAG, (String)stringBuilder.toString());
    }

    private void evict() {
        this.trimToSize(this.maxSize);
    }

    private static Set<Bitmap.Config> getDefaultAllowedConfigs() {
        HashSet<Bitmap.Config> hashSet = new HashSet<Bitmap.Config>(Arrays.asList(Bitmap.Config.values()));
        if (Build.VERSION.SDK_INT >= 19) {
            hashSet.add(null);
        }
        if (Build.VERSION.SDK_INT >= 26) {
            hashSet.remove(Bitmap.Config.HARDWARE);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    private static LruPoolStrategy getDefaultStrategy() {
        LruPoolStrategy lruPoolStrategy = Build.VERSION.SDK_INT >= 19 ? new SizeConfigStrategy() : new AttributeStrategy();
        return lruPoolStrategy;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Bitmap getDirtyOrNull(int n2, int n3, Bitmap.Config config) {
        synchronized (this) {
            LruBitmapPool.assertNotHardwareConfig(config);
            Object object = this.strategy;
            Bitmap.Config config2 = config != null ? config : DEFAULT_CONFIG;
            config2 = object.get(n2, n3, config2);
            if (config2 == null) {
                if (Log.isLoggable((String)TAG, (int)3)) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Missing bitmap=");
                    ((StringBuilder)object).append(this.strategy.logBitmap(n2, n3, config));
                    Log.d((String)TAG, (String)((StringBuilder)object).toString());
                }
                ++this.misses;
            } else {
                ++this.hits;
                this.currentSize -= (long)this.strategy.getSize((Bitmap)config2);
                this.tracker.remove((Bitmap)config2);
                LruBitmapPool.normalize((Bitmap)config2);
            }
            if (Log.isLoggable((String)TAG, (int)2)) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Get bitmap=");
                ((StringBuilder)object).append(this.strategy.logBitmap(n2, n3, config));
                Log.v((String)TAG, (String)((StringBuilder)object).toString());
            }
            this.dump();
            return config2;
        }
    }

    private static void maybeSetPreMultiplied(Bitmap bitmap2) {
        if (Build.VERSION.SDK_INT >= 19) {
            bitmap2.setPremultiplied(true);
        }
    }

    private static void normalize(Bitmap bitmap2) {
        bitmap2.setHasAlpha(true);
        LruBitmapPool.maybeSetPreMultiplied(bitmap2);
    }

    private void trimToSize(long l3) {
        synchronized (this) {
            while (this.currentSize > l3) {
                Bitmap bitmap2 = this.strategy.removeLast();
                if (bitmap2 == null) {
                    if (Log.isLoggable((String)TAG, (int)5)) {
                        Log.w((String)TAG, (String)"Size mismatch, resetting");
                        this.dumpUnchecked();
                    }
                    this.currentSize = 0L;
                    return;
                }
                this.tracker.remove(bitmap2);
                this.currentSize -= (long)this.strategy.getSize(bitmap2);
                ++this.evictions;
                if (Log.isLoggable((String)TAG, (int)3)) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Evicting bitmap=");
                    stringBuilder.append(this.strategy.logBitmap(bitmap2));
                    Log.d((String)TAG, (String)stringBuilder.toString());
                }
                this.dump();
                bitmap2.recycle();
            }
            return;
        }
    }

    @Override
    public void clearMemory() {
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)"clearMemory");
        }
        this.trimToSize(0L);
    }

    @Override
    public Bitmap get(int n2, int n3, Bitmap.Config config) {
        Bitmap bitmap2 = this.getDirtyOrNull(n2, n3, config);
        if (bitmap2 != null) {
            bitmap2.eraseColor(0);
            config = bitmap2;
        } else {
            config = LruBitmapPool.createBitmap(n2, n3, config);
        }
        return config;
    }

    @Override
    public Bitmap getDirty(int n2, int n3, Bitmap.Config config) {
        Bitmap bitmap2;
        Bitmap bitmap3 = bitmap2 = this.getDirtyOrNull(n2, n3, config);
        if (bitmap2 == null) {
            bitmap3 = LruBitmapPool.createBitmap(n2, n3, config);
        }
        return bitmap3;
    }

    @Override
    public long getMaxSize() {
        return this.maxSize;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void put(Bitmap object) {
        synchronized (this) {
            Throwable throwable2;
            if (object != null) {
                try {
                    if (object.isRecycled()) {
                        object = new IllegalStateException("Cannot pool recycled bitmap");
                        throw object;
                    }
                    if (object.isMutable() && (long)this.strategy.getSize((Bitmap)object) <= this.maxSize && this.allowedConfigs.contains(object.getConfig())) {
                        int n2 = this.strategy.getSize((Bitmap)object);
                        this.strategy.put((Bitmap)object);
                        this.tracker.add((Bitmap)object);
                        ++this.puts;
                        this.currentSize += (long)n2;
                        if (Log.isLoggable((String)TAG, (int)2)) {
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append("Put bitmap in pool=");
                            stringBuilder.append(this.strategy.logBitmap((Bitmap)object));
                            Log.v((String)TAG, (String)stringBuilder.toString());
                        }
                        this.dump();
                        this.evict();
                        return;
                    }
                    if (Log.isLoggable((String)TAG, (int)2)) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("Reject bitmap from pool, bitmap: ");
                        stringBuilder.append(this.strategy.logBitmap((Bitmap)object));
                        stringBuilder.append(", is mutable: ");
                        stringBuilder.append(object.isMutable());
                        stringBuilder.append(", is allowed config: ");
                        stringBuilder.append(this.allowedConfigs.contains(object.getConfig()));
                        Log.v((String)TAG, (String)stringBuilder.toString());
                    }
                    object.recycle();
                    return;
                }
                catch (Throwable throwable2) {}
            } else {
                object = new NullPointerException("Bitmap must not be null");
                throw object;
            }
            throw throwable2;
        }
    }

    @Override
    public void setSizeMultiplier(float f3) {
        synchronized (this) {
            this.maxSize = Math.round((float)this.initialMaxSize * f3);
            this.evict();
            return;
        }
    }

    @Override
    public void trimMemory(int n2) {
        if (Log.isLoggable((String)TAG, (int)3)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("trimMemory, level=");
            stringBuilder.append(n2);
            Log.d((String)TAG, (String)stringBuilder.toString());
        }
        if (n2 >= 40) {
            this.clearMemory();
        } else if (n2 >= 20) {
            this.trimToSize(this.maxSize / 2L);
        }
    }

    private static interface BitmapTracker {
        public void add(Bitmap var1);

        public void remove(Bitmap var1);
    }

    private static final class NullBitmapTracker
    implements BitmapTracker {
        NullBitmapTracker() {
        }

        @Override
        public void add(Bitmap bitmap2) {
        }

        @Override
        public void remove(Bitmap bitmap2) {
        }
    }

    private static class ThrowingBitmapTracker
    implements BitmapTracker {
        private final Set<Bitmap> bitmaps = Collections.synchronizedSet(new HashSet());

        private ThrowingBitmapTracker() {
        }

        @Override
        public void add(Bitmap bitmap2) {
            if (!this.bitmaps.contains(bitmap2)) {
                this.bitmaps.add(bitmap2);
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Can't add already added bitmap: ");
            stringBuilder.append(bitmap2);
            stringBuilder.append(" [");
            stringBuilder.append(bitmap2.getWidth());
            stringBuilder.append("x");
            stringBuilder.append(bitmap2.getHeight());
            stringBuilder.append("]");
            throw new IllegalStateException(stringBuilder.toString());
        }

        @Override
        public void remove(Bitmap bitmap2) {
            if (this.bitmaps.contains(bitmap2)) {
                this.bitmaps.remove(bitmap2);
                return;
            }
            throw new IllegalStateException("Cannot remove bitmap not in tracker");
        }
    }
}

