/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine.bitmap_recycle;

import android.util.Log;
import com.bumptech.glide.load.engine.bitmap_recycle.ArrayAdapterInterface;
import com.bumptech.glide.load.engine.bitmap_recycle.ArrayPool;
import com.bumptech.glide.load.engine.bitmap_recycle.BaseKeyPool;
import com.bumptech.glide.load.engine.bitmap_recycle.ByteArrayAdapter;
import com.bumptech.glide.load.engine.bitmap_recycle.GroupedLinkedMap;
import com.bumptech.glide.load.engine.bitmap_recycle.IntegerArrayAdapter;
import com.bumptech.glide.load.engine.bitmap_recycle.Poolable;
import com.bumptech.glide.util.Preconditions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public final class LruArrayPool
implements ArrayPool {
    private static final int DEFAULT_SIZE = 0x400000;
    static final int MAX_OVER_SIZE_MULTIPLE = 8;
    private static final int SINGLE_ARRAY_MAX_SIZE_DIVISOR = 2;
    private final Map<Class<?>, ArrayAdapterInterface<?>> adapters;
    private int currentSize;
    private final GroupedLinkedMap<Key, Object> groupedMap = new GroupedLinkedMap();
    private final KeyPool keyPool = new KeyPool();
    private final int maxSize;
    private final Map<Class<?>, NavigableMap<Integer, Integer>> sortedSizes = new HashMap();

    public LruArrayPool() {
        this.adapters = new HashMap();
        this.maxSize = 0x400000;
    }

    public LruArrayPool(int n2) {
        this.adapters = new HashMap();
        this.maxSize = n2;
    }

    private void decrementArrayOfSize(int n2, Class<?> object) {
        Integer n3 = (Integer)(object = this.getSizesForAdapter((Class<?>)object)).get(n2);
        if (n3 != null) {
            if (n3 == 1) {
                object.remove(n2);
            } else {
                object.put(n2, n3 - 1);
            }
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Tried to decrement empty size, size: ");
        ((StringBuilder)object).append(n2);
        ((StringBuilder)object).append(", this: ");
        ((StringBuilder)object).append(this);
        throw new NullPointerException(((StringBuilder)object).toString());
    }

    private void evict() {
        this.evictToSize(this.maxSize);
    }

    private void evictToSize(int n2) {
        while (this.currentSize > n2) {
            Object object = this.groupedMap.removeLast();
            Preconditions.checkNotNull(object);
            ArrayAdapterInterface<Object> arrayAdapterInterface = this.getAdapterFromObject(object);
            this.currentSize -= arrayAdapterInterface.getArrayLength(object) * arrayAdapterInterface.getElementSizeInBytes();
            this.decrementArrayOfSize(arrayAdapterInterface.getArrayLength(object), object.getClass());
            if (!Log.isLoggable((String)arrayAdapterInterface.getTag(), (int)2)) continue;
            String string2 = arrayAdapterInterface.getTag();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("evicted: ");
            stringBuilder.append(arrayAdapterInterface.getArrayLength(object));
            Log.v((String)string2, (String)stringBuilder.toString());
        }
    }

    private <T> ArrayAdapterInterface<T> getAdapterFromObject(T t2) {
        return this.getAdapterFromType(t2.getClass());
    }

    private <T> ArrayAdapterInterface<T> getAdapterFromType(Class<T> clazz) {
        Object object;
        block4: {
            IntegerArrayAdapter integerArrayAdapter = this.adapters.get(clazz);
            object = integerArrayAdapter;
            if (integerArrayAdapter != null) break block4;
            if (clazz.equals(int[].class)) {
                object = new IntegerArrayAdapter();
            } else {
                if (!clazz.equals(byte[].class)) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("No array pool found for: ");
                    ((StringBuilder)object).append(clazz.getSimpleName());
                    throw new IllegalArgumentException(((StringBuilder)object).toString());
                }
                object = new ByteArrayAdapter();
            }
            this.adapters.put(clazz, (ArrayAdapterInterface<?>)object);
        }
        return object;
    }

    private <T> T getArrayForKey(Key key) {
        return (T)this.groupedMap.get(key);
    }

    private <T> T getForKey(Key key, Class<T> object) {
        ArrayAdapterInterface<T> arrayAdapterInterface = this.getAdapterFromType((Class<T>)object);
        Object object2 = this.getArrayForKey(key);
        if (object2 != null) {
            this.currentSize -= arrayAdapterInterface.getArrayLength(object2) * arrayAdapterInterface.getElementSizeInBytes();
            this.decrementArrayOfSize(arrayAdapterInterface.getArrayLength(object2), (Class<?>)object);
        }
        object = object2;
        if (object2 == null) {
            if (Log.isLoggable((String)arrayAdapterInterface.getTag(), (int)2)) {
                object = arrayAdapterInterface.getTag();
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("Allocated ");
                ((StringBuilder)object2).append(key.size);
                ((StringBuilder)object2).append(" bytes");
                Log.v((String)object, (String)((StringBuilder)object2).toString());
            }
            object = arrayAdapterInterface.newArray(key.size);
        }
        return (T)object;
    }

    private NavigableMap<Integer, Integer> getSizesForAdapter(Class<?> clazz) {
        NavigableMap<Integer, Integer> navigableMap;
        NavigableMap<Integer, Integer> navigableMap2 = navigableMap = this.sortedSizes.get(clazz);
        if (navigableMap == null) {
            navigableMap2 = new TreeMap<Integer, Integer>();
            this.sortedSizes.put(clazz, navigableMap2);
        }
        return navigableMap2;
    }

    private boolean isNoMoreThanHalfFull() {
        int n2 = this.currentSize;
        boolean bl = n2 == 0 || this.maxSize / n2 >= 2;
        return bl;
    }

    private boolean isSmallEnoughForReuse(int n2) {
        boolean bl = n2 <= this.maxSize / 2;
        return bl;
    }

    private boolean mayFillRequest(int n2, Integer n3) {
        boolean bl = n3 != null && (this.isNoMoreThanHalfFull() || n3 <= n2 * 8);
        return bl;
    }

    @Override
    public void clearMemory() {
        synchronized (this) {
            this.evictToSize(0);
            return;
        }
    }

    @Override
    public <T> T get(int n2, Class<T> clazz) {
        synchronized (this) {
            Object object = this.getSizesForAdapter(clazz).ceilingKey(n2);
            object = this.mayFillRequest(n2, (Integer)object) ? this.keyPool.get((Integer)object, clazz) : this.keyPool.get(n2, clazz);
            clazz = this.getForKey((Key)object, clazz);
            return (T)clazz;
        }
    }

    int getCurrentSize() {
        Iterator<Class<?>> iterator = this.sortedSizes.keySet().iterator();
        int n2 = 0;
        block0: while (iterator.hasNext()) {
            Class<?> clazz = iterator.next();
            Iterator iterator2 = this.sortedSizes.get(clazz).keySet().iterator();
            int n3 = n2;
            while (true) {
                n2 = n3;
                if (!iterator2.hasNext()) continue block0;
                Integer n4 = (Integer)iterator2.next();
                ArrayAdapterInterface<?> arrayAdapterInterface = this.getAdapterFromType(clazz);
                n3 += n4 * (Integer)this.sortedSizes.get(clazz).get(n4) * arrayAdapterInterface.getElementSizeInBytes();
            }
        }
        return n2;
    }

    @Override
    public <T> T getExact(int n2, Class<T> clazz) {
        synchronized (this) {
            clazz = this.getForKey(this.keyPool.get(n2, clazz), clazz);
            return (T)clazz;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> void put(T object) {
        synchronized (this) {
            Object object2 = object.getClass();
            Object object3 = this.getAdapterFromType((Class<T>)object2);
            int n2 = object3.getArrayLength(object);
            int n3 = object3.getElementSizeInBytes() * n2;
            boolean bl = this.isSmallEnoughForReuse(n3);
            if (!bl) {
                return;
            }
            object3 = this.keyPool.get(n2, (Class<?>)object2);
            this.groupedMap.put((Key)object3, object);
            object2 = this.getSizesForAdapter((Class<?>)object2);
            object = (Integer)object2.get(((Key)object3).size);
            int n4 = ((Key)object3).size;
            n2 = 1;
            if (object != null) {
                n2 = 1 + (Integer)object;
            }
            object2.put(n4, n2);
            this.currentSize += n3;
            this.evict();
            return;
        }
    }

    @Override
    @Deprecated
    public <T> void put(T t2, Class<T> clazz) {
        this.put(t2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void trimMemory(int n2) {
        synchronized (this) {
            block6: {
                Throwable throwable2;
                block5: {
                    if (n2 >= 40) {
                        try {
                            this.clearMemory();
                        }
                        catch (Throwable throwable2) {
                            break block5;
                        }
                    }
                    if (n2 >= 20) {
                        this.evictToSize(this.maxSize / 2);
                    }
                    break block6;
                }
                throw throwable2;
            }
            return;
        }
    }

    private static final class Key
    implements Poolable {
        private Class<?> arrayClass;
        private final KeyPool pool;
        int size;

        Key(KeyPool keyPool) {
            this.pool = keyPool;
        }

        public boolean equals(Object object) {
            boolean bl;
            boolean bl2 = object instanceof Key;
            boolean bl3 = bl = false;
            if (bl2) {
                object = (Key)object;
                bl3 = bl;
                if (this.size == ((Key)object).size) {
                    bl3 = bl;
                    if (this.arrayClass == ((Key)object).arrayClass) {
                        bl3 = true;
                    }
                }
            }
            return bl3;
        }

        public int hashCode() {
            int n2 = this.size;
            Class<?> clazz = this.arrayClass;
            int n3 = clazz != null ? clazz.hashCode() : 0;
            return n2 * 31 + n3;
        }

        void init(int n2, Class<?> clazz) {
            this.size = n2;
            this.arrayClass = clazz;
        }

        @Override
        public void offer() {
            this.pool.offer(this);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Key{size=");
            stringBuilder.append(this.size);
            stringBuilder.append("array=");
            stringBuilder.append(this.arrayClass);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }
    }

    private static final class KeyPool
    extends BaseKeyPool<Key> {
        KeyPool() {
        }

        @Override
        protected Key create() {
            return new Key(this);
        }

        Key get(int n2, Class<?> clazz) {
            Key key = (Key)this.get();
            key.init(n2, clazz);
            return key;
        }
    }
}

