/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine.bitmap_recycle;

import com.bumptech.glide.load.engine.bitmap_recycle.Poolable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class GroupedLinkedMap<K extends Poolable, V> {
    private final LinkedEntry<K, V> head = new LinkedEntry();
    private final Map<K, LinkedEntry<K, V>> keyToEntry = new HashMap<K, LinkedEntry<K, V>>();

    GroupedLinkedMap() {
    }

    private void makeHead(LinkedEntry<K, V> linkedEntry) {
        GroupedLinkedMap.removeEntry(linkedEntry);
        LinkedEntry<K, V> linkedEntry2 = this.head;
        linkedEntry.prev = linkedEntry2;
        linkedEntry.next = linkedEntry2.next;
        GroupedLinkedMap.updateEntry(linkedEntry);
    }

    private void makeTail(LinkedEntry<K, V> linkedEntry) {
        GroupedLinkedMap.removeEntry(linkedEntry);
        linkedEntry.prev = this.head.prev;
        linkedEntry.next = this.head;
        GroupedLinkedMap.updateEntry(linkedEntry);
    }

    private static <K, V> void removeEntry(LinkedEntry<K, V> linkedEntry) {
        linkedEntry.prev.next = linkedEntry.next;
        linkedEntry.next.prev = linkedEntry.prev;
    }

    private static <K, V> void updateEntry(LinkedEntry<K, V> linkedEntry) {
        linkedEntry.next.prev = linkedEntry;
        linkedEntry.prev.next = linkedEntry;
    }

    public V get(K object) {
        LinkedEntry<K, V> linkedEntry = this.keyToEntry.get(object);
        if (linkedEntry == null) {
            linkedEntry = new LinkedEntry(object);
            this.keyToEntry.put(object, linkedEntry);
            object = linkedEntry;
        } else {
            object.offer();
            object = linkedEntry;
        }
        this.makeHead((LinkedEntry<K, V>)object);
        return ((LinkedEntry)object).removeLast();
    }

    public void put(K object, V v2) {
        LinkedEntry<K, V> linkedEntry = this.keyToEntry.get(object);
        if (linkedEntry == null) {
            linkedEntry = new LinkedEntry(object);
            this.makeTail(linkedEntry);
            this.keyToEntry.put(object, linkedEntry);
            object = linkedEntry;
        } else {
            object.offer();
            object = linkedEntry;
        }
        ((LinkedEntry)object).add(v2);
    }

    public V removeLast() {
        LinkedEntry linkedEntry = this.head.prev;
        while (!linkedEntry.equals(this.head)) {
            Object v2 = linkedEntry.removeLast();
            if (v2 != null) {
                return v2;
            }
            GroupedLinkedMap.removeEntry(linkedEntry);
            this.keyToEntry.remove(linkedEntry.key);
            ((Poolable)linkedEntry.key).offer();
            linkedEntry = linkedEntry.prev;
        }
        return null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("GroupedLinkedMap( ");
        LinkedEntry linkedEntry = this.head.next;
        boolean bl = false;
        while (!linkedEntry.equals(this.head)) {
            bl = true;
            stringBuilder.append('{');
            stringBuilder.append(linkedEntry.key);
            stringBuilder.append(':');
            stringBuilder.append(linkedEntry.size());
            stringBuilder.append("}, ");
            linkedEntry = linkedEntry.next;
        }
        if (bl) {
            stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
        }
        stringBuilder.append(" )");
        return stringBuilder.toString();
    }

    private static class LinkedEntry<K, V> {
        final K key;
        LinkedEntry<K, V> next;
        LinkedEntry<K, V> prev = this;
        private List<V> values;

        LinkedEntry() {
            this(null);
        }

        LinkedEntry(K k3) {
            this.next = this;
            this.key = k3;
        }

        public void add(V v2) {
            if (this.values == null) {
                this.values = new ArrayList<V>();
            }
            this.values.add(v2);
        }

        public V removeLast() {
            int n2 = this.size();
            V v2 = n2 > 0 ? (V)this.values.remove(n2 - 1) : null;
            return v2;
        }

        public int size() {
            List<V> list = this.values;
            int n2 = list != null ? list.size() : 0;
            return n2;
        }
    }
}

