/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine;

import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.data.DataFetcher;
import com.bumptech.glide.load.engine.DataFetcherGenerator;
import com.bumptech.glide.load.engine.DecodeHelper;
import com.bumptech.glide.load.engine.ResourceCacheKey;
import com.bumptech.glide.load.model.ModelLoader;
import java.io.File;
import java.io.Serializable;
import java.util.List;

class ResourceCacheGenerator
implements DataFetcherGenerator,
DataFetcher.DataCallback<Object> {
    private File cacheFile;
    private final DataFetcherGenerator.FetcherReadyCallback cb;
    private ResourceCacheKey currentKey;
    private final DecodeHelper<?> helper;
    private volatile ModelLoader.LoadData<?> loadData;
    private int modelLoaderIndex;
    private List<ModelLoader<File, ?>> modelLoaders;
    private int resourceClassIndex = -1;
    private int sourceIdIndex;
    private Key sourceKey;

    ResourceCacheGenerator(DecodeHelper<?> decodeHelper, DataFetcherGenerator.FetcherReadyCallback fetcherReadyCallback) {
        this.helper = decodeHelper;
        this.cb = fetcherReadyCallback;
    }

    private boolean hasNextModelLoader() {
        boolean bl = this.modelLoaderIndex < this.modelLoaders.size();
        return bl;
    }

    @Override
    public void cancel() {
        ModelLoader.LoadData<?> loadData = this.loadData;
        if (loadData != null) {
            loadData.fetcher.cancel();
        }
    }

    @Override
    public void onDataReady(Object object) {
        this.cb.onDataFetcherReady(this.sourceKey, object, this.loadData.fetcher, DataSource.RESOURCE_DISK_CACHE, this.currentKey);
    }

    @Override
    public void onLoadFailed(Exception exception) {
        this.cb.onDataFetcherFailed(this.currentKey, exception, this.loadData.fetcher, DataSource.RESOURCE_DISK_CACHE);
    }

    @Override
    public boolean startNext() {
        List<Key> list = this.helper.getCacheKeys();
        boolean bl = list.isEmpty();
        boolean bl2 = false;
        if (bl) {
            return false;
        }
        List<Class<?>> list2 = this.helper.getRegisteredResourceClasses();
        while (true) {
            Object object;
            if (this.modelLoaders != null && this.hasNextModelLoader()) {
                this.loadData = null;
                while (!bl2 && this.hasNextModelLoader()) {
                    object = this.modelLoaders;
                    int n2 = this.modelLoaderIndex;
                    this.modelLoaderIndex = n2 + 1;
                    this.loadData = ((ModelLoader)object.get(n2)).buildLoadData(this.cacheFile, this.helper.getWidth(), this.helper.getHeight(), this.helper.getOptions());
                    if (this.loadData == null || !this.helper.hasLoadPath(this.loadData.fetcher.getDataClass())) continue;
                    this.loadData.fetcher.loadData(this.helper.getPriority(), this);
                    bl2 = true;
                }
                return bl2;
            }
            ++this.resourceClassIndex;
            if (this.resourceClassIndex >= list2.size()) {
                ++this.sourceIdIndex;
                if (this.sourceIdIndex >= list.size()) {
                    return false;
                }
                this.resourceClassIndex = 0;
            }
            object = list.get(this.sourceIdIndex);
            Serializable serializable = list2.get(this.resourceClassIndex);
            Transformation<?> transformation = this.helper.getTransformation(serializable);
            this.currentKey = new ResourceCacheKey(this.helper.getArrayPool(), (Key)object, this.helper.getSignature(), this.helper.getWidth(), this.helper.getHeight(), transformation, (Class<?>)serializable, this.helper.getOptions());
            this.cacheFile = this.helper.getDiskCache().get(this.currentKey);
            serializable = this.cacheFile;
            if (serializable == null) continue;
            this.sourceKey = object;
            this.modelLoaders = this.helper.getModelLoaders((File)serializable);
            this.modelLoaderIndex = 0;
        }
    }
}

