/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine;

import android.os.Looper;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.util.Preconditions;

class EngineResource<Z>
implements Resource<Z> {
    private int acquired;
    private final boolean isCacheable;
    private final boolean isRecyclable;
    private boolean isRecycled;
    private Key key;
    private ResourceListener listener;
    private final Resource<Z> resource;

    EngineResource(Resource<Z> resource, boolean bl, boolean bl2) {
        this.resource = Preconditions.checkNotNull(resource);
        this.isCacheable = bl;
        this.isRecyclable = bl2;
    }

    void acquire() {
        if (!this.isRecycled) {
            if (Looper.getMainLooper().equals(Looper.myLooper())) {
                ++this.acquired;
                return;
            }
            throw new IllegalThreadStateException("Must call acquire on the main thread");
        }
        throw new IllegalStateException("Cannot acquire a recycled resource");
    }

    @Override
    public Z get() {
        return this.resource.get();
    }

    Resource<Z> getResource() {
        return this.resource;
    }

    @Override
    public Class<Z> getResourceClass() {
        return this.resource.getResourceClass();
    }

    @Override
    public int getSize() {
        return this.resource.getSize();
    }

    boolean isCacheable() {
        return this.isCacheable;
    }

    @Override
    public void recycle() {
        if (this.acquired <= 0) {
            if (!this.isRecycled) {
                this.isRecycled = true;
                if (this.isRecyclable) {
                    this.resource.recycle();
                }
                return;
            }
            throw new IllegalStateException("Cannot recycle a resource that has already been recycled");
        }
        throw new IllegalStateException("Cannot recycle a resource while it is still acquired");
    }

    void release() {
        if (this.acquired > 0) {
            if (Looper.getMainLooper().equals(Looper.myLooper())) {
                int n2;
                this.acquired = n2 = this.acquired - 1;
                if (n2 == 0) {
                    this.listener.onResourceReleased(this.key, this);
                }
                return;
            }
            throw new IllegalThreadStateException("Must call release on the main thread");
        }
        throw new IllegalStateException("Cannot release a recycled or not yet acquired resource");
    }

    void setResourceListener(Key key, ResourceListener resourceListener) {
        this.key = key;
        this.listener = resourceListener;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("EngineResource{isCacheable=");
        stringBuilder.append(this.isCacheable);
        stringBuilder.append(", listener=");
        stringBuilder.append(this.listener);
        stringBuilder.append(", key=");
        stringBuilder.append(this.key);
        stringBuilder.append(", acquired=");
        stringBuilder.append(this.acquired);
        stringBuilder.append(", isRecycled=");
        stringBuilder.append(this.isRecycled);
        stringBuilder.append(", resource=");
        stringBuilder.append(this.resource);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    static interface ResourceListener {
        public void onResourceReleased(Key var1, EngineResource<?> var2);
    }
}

