/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import androidx.core.util.Pools;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.engine.DecodeJob;
import com.bumptech.glide.load.engine.EngineJobListener;
import com.bumptech.glide.load.engine.EngineResource;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.executor.GlideExecutor;
import com.bumptech.glide.request.ResourceCallback;
import com.bumptech.glide.util.Util;
import com.bumptech.glide.util.pool.FactoryPools;
import com.bumptech.glide.util.pool.StateVerifier;
import java.util.ArrayList;
import java.util.List;

class EngineJob<R>
implements DecodeJob.Callback<R>,
FactoryPools.Poolable {
    private static final EngineResourceFactory DEFAULT_FACTORY = new EngineResourceFactory();
    private static final Handler MAIN_THREAD_HANDLER = new Handler(Looper.getMainLooper(), (Handler.Callback)new MainThreadCallback());
    private static final int MSG_CANCELLED = 3;
    private static final int MSG_COMPLETE = 1;
    private static final int MSG_EXCEPTION = 2;
    private final GlideExecutor animationExecutor;
    private final List<ResourceCallback> cbs = new ArrayList<ResourceCallback>(2);
    private DataSource dataSource;
    private DecodeJob<R> decodeJob;
    private final GlideExecutor diskCacheExecutor;
    private EngineResource<?> engineResource;
    private final EngineResourceFactory engineResourceFactory;
    private GlideException exception;
    private boolean hasLoadFailed;
    private boolean hasResource;
    private List<ResourceCallback> ignoredCallbacks;
    private boolean isCacheable;
    private volatile boolean isCancelled;
    private Key key;
    private final EngineJobListener listener;
    private boolean onlyRetrieveFromCache;
    private final Pools.Pool<EngineJob<?>> pool;
    private Resource<?> resource;
    private final GlideExecutor sourceExecutor;
    private final GlideExecutor sourceUnlimitedExecutor;
    private final StateVerifier stateVerifier = StateVerifier.newInstance();
    private boolean useAnimationPool;
    private boolean useUnlimitedSourceGeneratorPool;

    EngineJob(GlideExecutor glideExecutor, GlideExecutor glideExecutor2, GlideExecutor glideExecutor3, GlideExecutor glideExecutor4, EngineJobListener engineJobListener, Pools.Pool<EngineJob<?>> pool) {
        this(glideExecutor, glideExecutor2, glideExecutor3, glideExecutor4, engineJobListener, pool, DEFAULT_FACTORY);
    }

    EngineJob(GlideExecutor glideExecutor, GlideExecutor glideExecutor2, GlideExecutor glideExecutor3, GlideExecutor glideExecutor4, EngineJobListener engineJobListener, Pools.Pool<EngineJob<?>> pool, EngineResourceFactory engineResourceFactory) {
        this.diskCacheExecutor = glideExecutor;
        this.sourceExecutor = glideExecutor2;
        this.sourceUnlimitedExecutor = glideExecutor3;
        this.animationExecutor = glideExecutor4;
        this.listener = engineJobListener;
        this.pool = pool;
        this.engineResourceFactory = engineResourceFactory;
    }

    private void addIgnoredCallback(ResourceCallback resourceCallback) {
        if (this.ignoredCallbacks == null) {
            this.ignoredCallbacks = new ArrayList<ResourceCallback>(2);
        }
        if (!this.ignoredCallbacks.contains(resourceCallback)) {
            this.ignoredCallbacks.add(resourceCallback);
        }
    }

    private GlideExecutor getActiveSourceExecutor() {
        GlideExecutor glideExecutor = this.useUnlimitedSourceGeneratorPool ? this.sourceUnlimitedExecutor : (this.useAnimationPool ? this.animationExecutor : this.sourceExecutor);
        return glideExecutor;
    }

    private boolean isInIgnoredCallbacks(ResourceCallback resourceCallback) {
        List<ResourceCallback> list = this.ignoredCallbacks;
        boolean bl = list != null && list.contains(resourceCallback);
        return bl;
    }

    private void release(boolean bl) {
        Util.assertMainThread();
        this.cbs.clear();
        this.key = null;
        this.engineResource = null;
        this.resource = null;
        List<ResourceCallback> list = this.ignoredCallbacks;
        if (list != null) {
            list.clear();
        }
        this.hasLoadFailed = false;
        this.isCancelled = false;
        this.hasResource = false;
        this.decodeJob.release(bl);
        this.decodeJob = null;
        this.exception = null;
        this.dataSource = null;
        this.pool.release((Object)this);
    }

    void addCallback(ResourceCallback resourceCallback) {
        Util.assertMainThread();
        this.stateVerifier.throwIfRecycled();
        if (this.hasResource) {
            resourceCallback.onResourceReady(this.engineResource, this.dataSource);
        } else if (this.hasLoadFailed) {
            resourceCallback.onLoadFailed(this.exception);
        } else {
            this.cbs.add(resourceCallback);
        }
    }

    void cancel() {
        if (!(this.hasLoadFailed || this.hasResource || this.isCancelled)) {
            this.isCancelled = true;
            this.decodeJob.cancel();
            this.listener.onEngineJobCancelled(this, this.key);
        }
    }

    @Override
    public StateVerifier getVerifier() {
        return this.stateVerifier;
    }

    void handleCancelledOnMainThread() {
        this.stateVerifier.throwIfRecycled();
        if (this.isCancelled) {
            this.listener.onEngineJobCancelled(this, this.key);
            this.release(false);
            return;
        }
        throw new IllegalStateException("Not cancelled");
    }

    void handleExceptionOnMainThread() {
        this.stateVerifier.throwIfRecycled();
        if (this.isCancelled) {
            this.release(false);
            return;
        }
        if (!this.cbs.isEmpty()) {
            if (!this.hasLoadFailed) {
                this.hasLoadFailed = true;
                this.listener.onEngineJobComplete(this, this.key, null);
                for (ResourceCallback resourceCallback : this.cbs) {
                    if (this.isInIgnoredCallbacks(resourceCallback)) continue;
                    resourceCallback.onLoadFailed(this.exception);
                }
                this.release(false);
                return;
            }
            throw new IllegalStateException("Already failed once");
        }
        throw new IllegalStateException("Received an exception without any callbacks to notify");
    }

    void handleResultOnMainThread() {
        this.stateVerifier.throwIfRecycled();
        if (this.isCancelled) {
            this.resource.recycle();
            this.release(false);
            return;
        }
        if (!this.cbs.isEmpty()) {
            if (!this.hasResource) {
                this.engineResource = this.engineResourceFactory.build(this.resource, this.isCacheable);
                this.hasResource = true;
                this.engineResource.acquire();
                this.listener.onEngineJobComplete(this, this.key, this.engineResource);
                int n2 = this.cbs.size();
                for (int i3 = 0; i3 < n2; ++i3) {
                    ResourceCallback resourceCallback = this.cbs.get(i3);
                    if (this.isInIgnoredCallbacks(resourceCallback)) continue;
                    this.engineResource.acquire();
                    resourceCallback.onResourceReady(this.engineResource, this.dataSource);
                }
                this.engineResource.release();
                this.release(false);
                return;
            }
            throw new IllegalStateException("Already have resource");
        }
        throw new IllegalStateException("Received a resource without any callbacks to notify");
    }

    EngineJob<R> init(Key key, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.key = key;
        this.isCacheable = bl;
        this.useUnlimitedSourceGeneratorPool = bl2;
        this.useAnimationPool = bl3;
        this.onlyRetrieveFromCache = bl4;
        return this;
    }

    boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public void onLoadFailed(GlideException glideException) {
        this.exception = glideException;
        MAIN_THREAD_HANDLER.obtainMessage(2, (Object)this).sendToTarget();
    }

    @Override
    public void onResourceReady(Resource<R> resource, DataSource dataSource) {
        this.resource = resource;
        this.dataSource = dataSource;
        MAIN_THREAD_HANDLER.obtainMessage(1, (Object)this).sendToTarget();
    }

    boolean onlyRetrieveFromCache() {
        return this.onlyRetrieveFromCache;
    }

    void removeCallback(ResourceCallback resourceCallback) {
        Util.assertMainThread();
        this.stateVerifier.throwIfRecycled();
        if (!this.hasResource && !this.hasLoadFailed) {
            this.cbs.remove(resourceCallback);
            if (this.cbs.isEmpty()) {
                this.cancel();
            }
        } else {
            this.addIgnoredCallback(resourceCallback);
        }
    }

    @Override
    public void reschedule(DecodeJob<?> decodeJob) {
        this.getActiveSourceExecutor().execute(decodeJob);
    }

    public void start(DecodeJob<R> decodeJob) {
        this.decodeJob = decodeJob;
        GlideExecutor glideExecutor = decodeJob.willDecodeFromCache() ? this.diskCacheExecutor : this.getActiveSourceExecutor();
        glideExecutor.execute(decodeJob);
    }

    static class EngineResourceFactory {
        EngineResourceFactory() {
        }

        public <R> EngineResource<R> build(Resource<R> resource, boolean bl) {
            return new EngineResource<R>(resource, bl, true);
        }
    }

    private static class MainThreadCallback
    implements Handler.Callback {
        MainThreadCallback() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean handleMessage(Message message) {
            Object object = (EngineJob)message.obj;
            int n2 = message.what;
            if (n2 == 1) {
                ((EngineJob)object).handleResultOnMainThread();
                return true;
            }
            if (n2 == 2) {
                ((EngineJob)object).handleExceptionOnMainThread();
                return true;
            }
            if (n2 == 3) {
                ((EngineJob)object).handleCancelledOnMainThread();
                return true;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Unrecognized message: ");
            ((StringBuilder)object).append(message.what);
            throw new IllegalStateException(((StringBuilder)object).toString());
        }
    }
}

