/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine;

import android.util.Log;
import androidx.core.util.Pools;
import com.bumptech.glide.GlideContext;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.ActiveResources;
import com.bumptech.glide.load.engine.DecodeJob;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.engine.EngineJob;
import com.bumptech.glide.load.engine.EngineJobListener;
import com.bumptech.glide.load.engine.EngineKey;
import com.bumptech.glide.load.engine.EngineKeyFactory;
import com.bumptech.glide.load.engine.EngineResource;
import com.bumptech.glide.load.engine.Jobs;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.ResourceRecycler;
import com.bumptech.glide.load.engine.cache.DiskCache;
import com.bumptech.glide.load.engine.cache.DiskCacheAdapter;
import com.bumptech.glide.load.engine.cache.MemoryCache;
import com.bumptech.glide.load.engine.executor.GlideExecutor;
import com.bumptech.glide.request.ResourceCallback;
import com.bumptech.glide.util.LogTime;
import com.bumptech.glide.util.Preconditions;
import com.bumptech.glide.util.Util;
import com.bumptech.glide.util.pool.FactoryPools;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public class Engine
implements EngineJobListener,
MemoryCache.ResourceRemovedListener,
EngineResource.ResourceListener {
    private static final int JOB_POOL_SIZE = 150;
    private static final String TAG = "Engine";
    private final ActiveResources activeResources;
    private final MemoryCache cache;
    private final DecodeJobFactory decodeJobFactory;
    private final LazyDiskCacheProvider diskCacheProvider;
    private final EngineJobFactory engineJobFactory;
    private final Jobs jobs;
    private final EngineKeyFactory keyFactory;
    private final ResourceRecycler resourceRecycler;

    Engine(MemoryCache memoryCache, DiskCache.Factory object, GlideExecutor glideExecutor, GlideExecutor glideExecutor2, GlideExecutor glideExecutor3, GlideExecutor glideExecutor4, Jobs jobs, EngineKeyFactory engineKeyFactory, ActiveResources activeResources, EngineJobFactory engineJobFactory, DecodeJobFactory decodeJobFactory, ResourceRecycler resourceRecycler, boolean bl) {
        this.cache = memoryCache;
        this.diskCacheProvider = new LazyDiskCacheProvider((DiskCache.Factory)object);
        if (activeResources == null) {
            activeResources = new ActiveResources(bl);
        }
        this.activeResources = activeResources;
        activeResources.setListener(this);
        if (engineKeyFactory == null) {
            engineKeyFactory = new EngineKeyFactory();
        }
        this.keyFactory = engineKeyFactory;
        if (jobs == null) {
            jobs = new Jobs();
        }
        this.jobs = jobs;
        if (engineJobFactory == null) {
            engineJobFactory = new EngineJobFactory(glideExecutor, glideExecutor2, glideExecutor3, glideExecutor4, this);
        }
        this.engineJobFactory = engineJobFactory;
        if (decodeJobFactory == null) {
            decodeJobFactory = new DecodeJobFactory(this.diskCacheProvider);
        }
        this.decodeJobFactory = decodeJobFactory;
        object = resourceRecycler == null ? new ResourceRecycler() : resourceRecycler;
        this.resourceRecycler = object;
        memoryCache.setResourceRemovedListener(this);
    }

    public Engine(MemoryCache memoryCache, DiskCache.Factory factory, GlideExecutor glideExecutor, GlideExecutor glideExecutor2, GlideExecutor glideExecutor3, GlideExecutor glideExecutor4, boolean bl) {
        this(memoryCache, factory, glideExecutor, glideExecutor2, glideExecutor3, glideExecutor4, null, null, null, null, null, null, bl);
    }

    private EngineResource<?> getEngineResourceFromCache(Key engineResource) {
        engineResource = (engineResource = this.cache.remove((Key)((Object)engineResource))) == null ? null : (engineResource instanceof EngineResource ? (EngineResource)engineResource : new EngineResource(engineResource, true, true));
        return engineResource;
    }

    private EngineResource<?> loadFromActiveResources(Key object, boolean bl) {
        if (!bl) {
            return null;
        }
        if ((object = this.activeResources.get((Key)object)) != null) {
            ((EngineResource)object).acquire();
        }
        return object;
    }

    private EngineResource<?> loadFromCache(Key key, boolean bl) {
        if (!bl) {
            return null;
        }
        EngineResource<?> engineResource = this.getEngineResourceFromCache(key);
        if (engineResource != null) {
            engineResource.acquire();
            this.activeResources.activate(key, engineResource);
        }
        return engineResource;
    }

    private static void logWithTimeAndKey(String string2, long l3, Key key) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append(" in ");
        stringBuilder.append(LogTime.getElapsedMillis(l3));
        stringBuilder.append("ms, key: ");
        stringBuilder.append(key);
        Log.v((String)TAG, (String)stringBuilder.toString());
    }

    public void clearDiskCache() {
        this.diskCacheProvider.getDiskCache().clear();
    }

    public <R> LoadStatus load(GlideContext object, Object object2, Key key, int n2, int n3, Class<?> clazz, Class<R> clazz2, Priority priority, DiskCacheStrategy diskCacheStrategy, Map<Class<?>, Transformation<?>> map, boolean bl, boolean bl2, Options options, boolean bl3, boolean bl4, boolean bl5, boolean bl6, ResourceCallback resourceCallback) {
        Util.assertMainThread();
        long l3 = LogTime.getLogTime();
        EngineKey engineKey = this.keyFactory.buildKey(object2, key, n2, n3, map, clazz, clazz2, options);
        EngineJob<?> engineJob = this.loadFromActiveResources(engineKey, bl3);
        if (engineJob != null) {
            resourceCallback.onResourceReady((Resource<?>)((Object)engineJob), DataSource.MEMORY_CACHE);
            if (Log.isLoggable((String)TAG, (int)2)) {
                Engine.logWithTimeAndKey("Loaded resource from active resources", l3, engineKey);
            }
            return null;
        }
        engineJob = this.loadFromCache(engineKey, bl3);
        if (engineJob != null) {
            resourceCallback.onResourceReady((Resource<?>)((Object)engineJob), DataSource.MEMORY_CACHE);
            if (Log.isLoggable((String)TAG, (int)2)) {
                Engine.logWithTimeAndKey("Loaded resource from cache", l3, engineKey);
            }
            return null;
        }
        engineJob = this.jobs.get(engineKey, bl6);
        if (engineJob != null) {
            engineJob.addCallback(resourceCallback);
            if (Log.isLoggable((String)TAG, (int)2)) {
                Engine.logWithTimeAndKey("Added to existing load", l3, engineKey);
            }
            return new LoadStatus(resourceCallback, engineJob);
        }
        engineJob = this.engineJobFactory.build(engineKey, bl3, bl4, bl5, bl6);
        object = this.decodeJobFactory.build((GlideContext)((Object)object), object2, engineKey, key, n2, n3, clazz, clazz2, priority, diskCacheStrategy, map, bl, bl2, bl6, options, engineJob);
        this.jobs.put(engineKey, engineJob);
        engineJob.addCallback(resourceCallback);
        engineJob.start((DecodeJob<?>)object);
        if (Log.isLoggable((String)TAG, (int)2)) {
            Engine.logWithTimeAndKey("Started new load", l3, engineKey);
        }
        return new LoadStatus(resourceCallback, engineJob);
    }

    @Override
    public void onEngineJobCancelled(EngineJob<?> engineJob, Key key) {
        Util.assertMainThread();
        this.jobs.removeIfCurrent(key, engineJob);
    }

    @Override
    public void onEngineJobComplete(EngineJob<?> engineJob, Key key, EngineResource<?> engineResource) {
        Util.assertMainThread();
        if (engineResource != null) {
            engineResource.setResourceListener(key, this);
            if (engineResource.isCacheable()) {
                this.activeResources.activate(key, engineResource);
            }
        }
        this.jobs.removeIfCurrent(key, engineJob);
    }

    @Override
    public void onResourceReleased(Key key, EngineResource<?> engineResource) {
        Util.assertMainThread();
        this.activeResources.deactivate(key);
        if (engineResource.isCacheable()) {
            this.cache.put(key, engineResource);
        } else {
            this.resourceRecycler.recycle(engineResource);
        }
    }

    @Override
    public void onResourceRemoved(Resource<?> resource) {
        Util.assertMainThread();
        this.resourceRecycler.recycle(resource);
    }

    public void release(Resource<?> resource) {
        Util.assertMainThread();
        if (resource instanceof EngineResource) {
            ((EngineResource)resource).release();
            return;
        }
        throw new IllegalArgumentException("Cannot release anything but an EngineResource");
    }

    public void shutdown() {
        this.engineJobFactory.shutdown();
        this.diskCacheProvider.clearDiskCacheIfCreated();
        this.activeResources.shutdown();
    }

    static class DecodeJobFactory {
        private int creationOrder;
        final DecodeJob.DiskCacheProvider diskCacheProvider;
        final Pools.Pool<DecodeJob<?>> pool = FactoryPools.simple(150, new FactoryPools.Factory<DecodeJob<?>>(){

            @Override
            public DecodeJob<?> create() {
                return new DecodeJob(DecodeJobFactory.this.diskCacheProvider, DecodeJobFactory.this.pool);
            }
        });

        DecodeJobFactory(DecodeJob.DiskCacheProvider diskCacheProvider) {
            this.diskCacheProvider = diskCacheProvider;
        }

        <R> DecodeJob<R> build(GlideContext glideContext, Object object, EngineKey engineKey, Key key, int n2, int n3, Class<?> clazz, Class<R> clazz2, Priority priority, DiskCacheStrategy diskCacheStrategy, Map<Class<?>, Transformation<?>> map, boolean bl, boolean bl2, boolean bl3, Options options, DecodeJob.Callback<R> callback) {
            DecodeJob decodeJob = Preconditions.checkNotNull((DecodeJob)this.pool.acquire());
            int n4 = this.creationOrder;
            this.creationOrder = n4 + 1;
            return decodeJob.init(glideContext, object, engineKey, key, n2, n3, clazz, clazz2, priority, diskCacheStrategy, map, bl, bl2, bl3, options, callback, n4);
        }
    }

    static class EngineJobFactory {
        final GlideExecutor animationExecutor;
        final GlideExecutor diskCacheExecutor;
        final EngineJobListener listener;
        final Pools.Pool<EngineJob<?>> pool = FactoryPools.simple(150, new FactoryPools.Factory<EngineJob<?>>(){

            @Override
            public EngineJob<?> create() {
                return new EngineJob(EngineJobFactory.this.diskCacheExecutor, EngineJobFactory.this.sourceExecutor, EngineJobFactory.this.sourceUnlimitedExecutor, EngineJobFactory.this.animationExecutor, EngineJobFactory.this.listener, EngineJobFactory.this.pool);
            }
        });
        final GlideExecutor sourceExecutor;
        final GlideExecutor sourceUnlimitedExecutor;

        EngineJobFactory(GlideExecutor glideExecutor, GlideExecutor glideExecutor2, GlideExecutor glideExecutor3, GlideExecutor glideExecutor4, EngineJobListener engineJobListener) {
            this.diskCacheExecutor = glideExecutor;
            this.sourceExecutor = glideExecutor2;
            this.sourceUnlimitedExecutor = glideExecutor3;
            this.animationExecutor = glideExecutor4;
            this.listener = engineJobListener;
        }

        private static void shutdownAndAwaitTermination(ExecutorService object) {
            object.shutdown();
            try {
                if (!object.awaitTermination(5L, TimeUnit.SECONDS)) {
                    object.shutdownNow();
                    if (!object.awaitTermination(5L, TimeUnit.SECONDS)) {
                        object = new RuntimeException("Failed to shutdown");
                        throw object;
                    }
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }

        <R> EngineJob<R> build(Key key, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            return Preconditions.checkNotNull((EngineJob)this.pool.acquire()).init(key, bl, bl2, bl3, bl4);
        }

        void shutdown() {
            EngineJobFactory.shutdownAndAwaitTermination(this.diskCacheExecutor);
            EngineJobFactory.shutdownAndAwaitTermination(this.sourceExecutor);
            EngineJobFactory.shutdownAndAwaitTermination(this.sourceUnlimitedExecutor);
            EngineJobFactory.shutdownAndAwaitTermination(this.animationExecutor);
        }
    }

    private static class LazyDiskCacheProvider
    implements DecodeJob.DiskCacheProvider {
        private volatile DiskCache diskCache;
        private final DiskCache.Factory factory;

        LazyDiskCacheProvider(DiskCache.Factory factory) {
            this.factory = factory;
        }

        void clearDiskCacheIfCreated() {
            synchronized (this) {
                block4: {
                    DiskCache diskCache = this.diskCache;
                    if (diskCache != null) break block4;
                    return;
                }
                this.diskCache.clear();
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public DiskCache getDiskCache() {
            if (this.diskCache != null) return this.diskCache;
            synchronized (this) {
                if (this.diskCache == null) {
                    this.diskCache = this.factory.build();
                }
                if (this.diskCache != null) return this.diskCache;
                DiskCacheAdapter diskCacheAdapter = new DiskCacheAdapter();
                this.diskCache = diskCacheAdapter;
                return this.diskCache;
            }
        }
    }

    public static class LoadStatus {
        private final ResourceCallback cb;
        private final EngineJob<?> engineJob;

        LoadStatus(ResourceCallback resourceCallback, EngineJob<?> engineJob) {
            this.cb = resourceCallback;
            this.engineJob = engineJob;
        }

        public void cancel() {
            this.engineJob.removeCallback(this.cb);
        }
    }
}

