/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import androidx.core.os.TraceCompat;
import androidx.core.util.Pools;
import com.bumptech.glide.GlideContext;
import com.bumptech.glide.Priority;
import com.bumptech.glide.Registry;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.EncodeStrategy;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.ResourceEncoder;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.data.DataFetcher;
import com.bumptech.glide.load.data.DataRewinder;
import com.bumptech.glide.load.engine.DataCacheGenerator;
import com.bumptech.glide.load.engine.DataCacheKey;
import com.bumptech.glide.load.engine.DataCacheWriter;
import com.bumptech.glide.load.engine.DataFetcherGenerator;
import com.bumptech.glide.load.engine.DecodeHelper;
import com.bumptech.glide.load.engine.DecodePath;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.engine.EngineKey;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.load.engine.Initializable;
import com.bumptech.glide.load.engine.LoadPath;
import com.bumptech.glide.load.engine.LockedResource;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.ResourceCacheGenerator;
import com.bumptech.glide.load.engine.ResourceCacheKey;
import com.bumptech.glide.load.engine.SourceGenerator;
import com.bumptech.glide.load.engine.cache.DiskCache;
import com.bumptech.glide.load.resource.bitmap.Downsampler;
import com.bumptech.glide.util.LogTime;
import com.bumptech.glide.util.pool.FactoryPools;
import com.bumptech.glide.util.pool.StateVerifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class DecodeJob<R>
implements DataFetcherGenerator.FetcherReadyCallback,
Runnable,
Comparable<DecodeJob<?>>,
FactoryPools.Poolable {
    private static final String TAG = "DecodeJob";
    private Callback<R> callback;
    private Key currentAttemptingKey;
    private Object currentData;
    private DataSource currentDataSource;
    private DataFetcher<?> currentFetcher;
    private volatile DataFetcherGenerator currentGenerator;
    private Key currentSourceKey;
    private Thread currentThread;
    private final DecodeHelper<R> decodeHelper = new DecodeHelper();
    private final DeferredEncodeManager<?> deferredEncodeManager;
    private final DiskCacheProvider diskCacheProvider;
    private DiskCacheStrategy diskCacheStrategy;
    private GlideContext glideContext;
    private int height;
    private volatile boolean isCallbackNotified;
    private volatile boolean isCancelled;
    private EngineKey loadKey;
    private boolean onlyRetrieveFromCache;
    private Options options;
    private int order;
    private final Pools.Pool<DecodeJob<?>> pool;
    private Priority priority;
    private final ReleaseManager releaseManager;
    private RunReason runReason;
    private Key signature;
    private Stage stage;
    private long startFetchTime;
    private final StateVerifier stateVerifier;
    private final List<Throwable> throwables = new ArrayList<Throwable>();
    private int width;

    DecodeJob(DiskCacheProvider diskCacheProvider, Pools.Pool<DecodeJob<?>> pool) {
        this.stateVerifier = StateVerifier.newInstance();
        this.deferredEncodeManager = new DeferredEncodeManager();
        this.releaseManager = new ReleaseManager();
        this.diskCacheProvider = diskCacheProvider;
        this.pool = pool;
    }

    private <Data> Resource<R> decodeFromData(DataFetcher<?> dataFetcher, Data object, DataSource object2) throws GlideException {
        if (object == null) {
            dataFetcher.cleanup();
            return null;
        }
        try {
            long l3 = LogTime.getLogTime();
            object = this.decodeFromFetcher(object, (DataSource)((Object)object2));
            if (Log.isLoggable((String)TAG, (int)2)) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("Decoded result ");
                ((StringBuilder)object2).append(object);
                this.logWithTimeAndKey(((StringBuilder)object2).toString(), l3);
            }
            return object;
        }
        finally {
            dataFetcher.cleanup();
        }
    }

    private <Data> Resource<R> decodeFromFetcher(Data Data, DataSource dataSource) throws GlideException {
        return this.runLoadPath(Data, dataSource, this.decodeHelper.getLoadPath(Data.getClass()));
    }

    private void decodeFromRetrievedData() {
        Object object;
        if (Log.isLoggable((String)TAG, (int)2)) {
            long l3 = this.startFetchTime;
            object = new StringBuilder();
            ((StringBuilder)object).append("data: ");
            ((StringBuilder)object).append(this.currentData);
            ((StringBuilder)object).append(", cache key: ");
            ((StringBuilder)object).append(this.currentSourceKey);
            ((StringBuilder)object).append(", fetcher: ");
            ((StringBuilder)object).append(this.currentFetcher);
            this.logWithTimeAndKey("Retrieved data", l3, ((StringBuilder)object).toString());
        }
        object = null;
        try {
            Resource<R> resource = this.decodeFromData(this.currentFetcher, this.currentData, this.currentDataSource);
            object = resource;
        }
        catch (GlideException glideException) {
            glideException.setLoggingDetails(this.currentAttemptingKey, this.currentDataSource);
            this.throwables.add(glideException);
        }
        if (object != null) {
            this.notifyEncodeAndRelease((Resource<R>)object, this.currentDataSource);
        } else {
            this.runGenerators();
        }
    }

    private DataFetcherGenerator getNextGenerator() {
        int n2 = 1.$SwitchMap$com$bumptech$glide$load$engine$DecodeJob$Stage[this.stage.ordinal()];
        if (n2 != 1) {
            if (n2 != 2) {
                if (n2 != 3) {
                    if (n2 == 4) {
                        return null;
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Unrecognized stage: ");
                    stringBuilder.append((Object)this.stage);
                    throw new IllegalStateException(stringBuilder.toString());
                }
                return new SourceGenerator(this.decodeHelper, this);
            }
            return new DataCacheGenerator(this.decodeHelper, this);
        }
        return new ResourceCacheGenerator(this.decodeHelper, this);
    }

    private Stage getNextStage(Stage stage) {
        int n2 = 1.$SwitchMap$com$bumptech$glide$load$engine$DecodeJob$Stage[stage.ordinal()];
        if (n2 != 1) {
            if (n2 != 2) {
                if (n2 != 3 && n2 != 4) {
                    if (n2 == 5) {
                        stage = this.diskCacheStrategy.decodeCachedResource() ? Stage.RESOURCE_CACHE : this.getNextStage(Stage.RESOURCE_CACHE);
                        return stage;
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Unrecognized stage: ");
                    stringBuilder.append((Object)stage);
                    throw new IllegalArgumentException(stringBuilder.toString());
                }
                return Stage.FINISHED;
            }
            stage = this.onlyRetrieveFromCache ? Stage.FINISHED : Stage.SOURCE;
            return stage;
        }
        stage = this.diskCacheStrategy.decodeCachedData() ? Stage.DATA_CACHE : this.getNextStage(Stage.DATA_CACHE);
        return stage;
    }

    private Options getOptionsWithHardwareConfig(DataSource object) {
        block6: {
            block5: {
                Options options = this.options;
                if (Build.VERSION.SDK_INT < 26) {
                    return options;
                }
                if (options.get(Downsampler.ALLOW_HARDWARE_CONFIG) != null) {
                    return options;
                }
                if (object == DataSource.RESOURCE_DISK_CACHE) break block5;
                object = options;
                if (!this.decodeHelper.isScaleOnlyOrNoTransform()) break block6;
            }
            object = new Options();
            ((Options)object).putAll(this.options);
            ((Options)object).set(Downsampler.ALLOW_HARDWARE_CONFIG, true);
        }
        return object;
    }

    private int getPriority() {
        return this.priority.ordinal();
    }

    private void logWithTimeAndKey(String string2, long l3) {
        this.logWithTimeAndKey(string2, l3, null);
    }

    private void logWithTimeAndKey(String charSequence, long l3, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((String)charSequence);
        stringBuilder.append(" in ");
        stringBuilder.append(LogTime.getElapsedMillis(l3));
        stringBuilder.append(", load key: ");
        stringBuilder.append(this.loadKey);
        if (string2 != null) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append(", ");
            ((StringBuilder)charSequence).append(string2);
            charSequence = ((StringBuilder)charSequence).toString();
        } else {
            charSequence = "";
        }
        stringBuilder.append((String)charSequence);
        stringBuilder.append(", thread: ");
        stringBuilder.append(Thread.currentThread().getName());
        Log.v((String)TAG, (String)stringBuilder.toString());
    }

    private void notifyComplete(Resource<R> resource, DataSource dataSource) {
        this.setNotifiedOrThrow();
        this.callback.onResourceReady(resource, dataSource);
    }

    private void notifyEncodeAndRelease(Resource<R> resource, DataSource dataSource) {
        if (resource instanceof Initializable) {
            ((Initializable)((Object)resource)).initialize();
        }
        Resource<R> resource2 = null;
        Resource<R> resource3 = resource;
        if (this.deferredEncodeManager.hasResourceToEncode()) {
            resource2 = resource3 = LockedResource.obtain(resource);
        }
        this.notifyComplete(resource3, dataSource);
        this.stage = Stage.ENCODE;
        try {
            if (this.deferredEncodeManager.hasResourceToEncode()) {
                this.deferredEncodeManager.encode(this.diskCacheProvider, this.options);
            }
            this.onEncodeComplete();
            return;
        }
        finally {
            if (resource2 != null) {
                ((LockedResource)resource2).unlock();
            }
        }
    }

    private void notifyFailed() {
        this.setNotifiedOrThrow();
        GlideException glideException = new GlideException("Failed to load resource", new ArrayList<Throwable>(this.throwables));
        this.callback.onLoadFailed(glideException);
        this.onLoadFailed();
    }

    private void onEncodeComplete() {
        if (this.releaseManager.onEncodeComplete()) {
            this.releaseInternal();
        }
    }

    private void onLoadFailed() {
        if (this.releaseManager.onFailed()) {
            this.releaseInternal();
        }
    }

    private void releaseInternal() {
        this.releaseManager.reset();
        this.deferredEncodeManager.clear();
        this.decodeHelper.clear();
        this.isCallbackNotified = false;
        this.glideContext = null;
        this.signature = null;
        this.options = null;
        this.priority = null;
        this.loadKey = null;
        this.callback = null;
        this.stage = null;
        this.currentGenerator = null;
        this.currentThread = null;
        this.currentSourceKey = null;
        this.currentData = null;
        this.currentDataSource = null;
        this.currentFetcher = null;
        this.startFetchTime = 0L;
        this.isCancelled = false;
        this.throwables.clear();
        this.pool.release((Object)this);
    }

    private void runGenerators() {
        boolean bl;
        block2: {
            this.currentThread = Thread.currentThread();
            this.startFetchTime = LogTime.getLogTime();
            boolean bl2 = false;
            do {
                bl = bl2;
                if (this.isCancelled) break block2;
                bl = bl2;
                if (this.currentGenerator == null) break block2;
                bl = bl2 = this.currentGenerator.startNext();
                if (bl2) break block2;
                this.stage = this.getNextStage(this.stage);
                this.currentGenerator = this.getNextGenerator();
            } while (this.stage != Stage.SOURCE);
            this.reschedule();
            return;
        }
        if ((this.stage == Stage.FINISHED || this.isCancelled) && !bl) {
            this.notifyFailed();
        }
    }

    private <Data, ResourceType> Resource<R> runLoadPath(Data object, DataSource object2, LoadPath<Data, ResourceType, R> loadPath) throws GlideException {
        Options options = this.getOptionsWithHardwareConfig((DataSource)((Object)object2));
        object = this.glideContext.getRegistry().getRewinder(object);
        try {
            int n2 = this.width;
            int n3 = this.height;
            DecodeCallback decodeCallback = new DecodeCallback((DataSource)((Object)object2));
            object2 = loadPath.load((DataRewinder<Data>)object, options, n2, n3, decodeCallback);
            return object2;
        }
        finally {
            object.cleanup();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void runWrapped() {
        int n2 = 1.$SwitchMap$com$bumptech$glide$load$engine$DecodeJob$RunReason[this.runReason.ordinal()];
        if (n2 == 1) {
            this.stage = this.getNextStage(Stage.INITIALIZE);
            this.currentGenerator = this.getNextGenerator();
            this.runGenerators();
            return;
        }
        if (n2 == 2) {
            this.runGenerators();
            return;
        }
        if (n2 == 3) {
            this.decodeFromRetrievedData();
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Unrecognized run reason: ");
        stringBuilder.append((Object)this.runReason);
        throw new IllegalStateException(stringBuilder.toString());
    }

    private void setNotifiedOrThrow() {
        this.stateVerifier.throwIfRecycled();
        if (!this.isCallbackNotified) {
            this.isCallbackNotified = true;
            return;
        }
        throw new IllegalStateException("Already notified");
    }

    public void cancel() {
        this.isCancelled = true;
        DataFetcherGenerator dataFetcherGenerator = this.currentGenerator;
        if (dataFetcherGenerator != null) {
            dataFetcherGenerator.cancel();
        }
    }

    @Override
    public int compareTo(DecodeJob<?> decodeJob) {
        int n2;
        int n3 = n2 = this.getPriority() - super.getPriority();
        if (n2 == 0) {
            n3 = this.order - decodeJob.order;
        }
        return n3;
    }

    @Override
    public StateVerifier getVerifier() {
        return this.stateVerifier;
    }

    DecodeJob<R> init(GlideContext glideContext, Object object, EngineKey engineKey, Key key, int n2, int n3, Class<?> clazz, Class<R> clazz2, Priority priority, DiskCacheStrategy diskCacheStrategy, Map<Class<?>, Transformation<?>> map, boolean bl, boolean bl2, boolean bl3, Options options, Callback<R> callback, int n4) {
        this.decodeHelper.init(glideContext, object, key, n2, n3, diskCacheStrategy, clazz, clazz2, priority, options, map, bl, bl2, this.diskCacheProvider);
        this.glideContext = glideContext;
        this.signature = key;
        this.priority = priority;
        this.loadKey = engineKey;
        this.width = n2;
        this.height = n3;
        this.diskCacheStrategy = diskCacheStrategy;
        this.onlyRetrieveFromCache = bl3;
        this.options = options;
        this.callback = callback;
        this.order = n4;
        this.runReason = RunReason.INITIALIZE;
        return this;
    }

    @Override
    public void onDataFetcherFailed(Key key, Exception exception, DataFetcher<?> dataFetcher, DataSource dataSource) {
        dataFetcher.cleanup();
        exception = new GlideException("Fetching data failed", exception);
        ((GlideException)exception).setLoggingDetails(key, dataSource, dataFetcher.getDataClass());
        this.throwables.add(exception);
        if (Thread.currentThread() != this.currentThread) {
            this.runReason = RunReason.SWITCH_TO_SOURCE_SERVICE;
            this.callback.reschedule(this);
        } else {
            this.runGenerators();
        }
    }

    @Override
    public void onDataFetcherReady(Key key, Object object, DataFetcher<?> dataFetcher, DataSource dataSource, Key key2) {
        this.currentSourceKey = key;
        this.currentData = object;
        this.currentFetcher = dataFetcher;
        this.currentDataSource = dataSource;
        this.currentAttemptingKey = key2;
        if (Thread.currentThread() != this.currentThread) {
            this.runReason = RunReason.DECODE_DATA;
            this.callback.reschedule(this);
        } else {
            TraceCompat.beginSection((String)"DecodeJob.decodeFromRetrievedData");
            this.decodeFromRetrievedData();
        }
        return;
        finally {
            TraceCompat.endSection();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    <Z> Resource<Z> onResourceDecoded(DataSource object, Resource<Z> resourceEncoder) {
        EncodeStrategy encodeStrategy;
        Transformation<?> transformation;
        Class<?> clazz = resourceEncoder.get().getClass();
        Object object2 = DataSource.RESOURCE_DISK_CACHE;
        Object object3 = null;
        if (object != object2) {
            transformation = this.decodeHelper.getTransformation(clazz);
            object2 = transformation.transform((Context)this.glideContext, (Resource<?>)((Object)resourceEncoder), this.width, this.height);
        } else {
            object2 = resourceEncoder;
            transformation = null;
        }
        if (!resourceEncoder.equals(object2)) {
            resourceEncoder.recycle();
        }
        if (this.decodeHelper.isResourceEncoderAvailable((Resource<?>)object2)) {
            resourceEncoder = this.decodeHelper.getResultEncoder(object2);
            encodeStrategy = resourceEncoder.getEncodeStrategy(this.options);
        } else {
            encodeStrategy = EncodeStrategy.NONE;
            resourceEncoder = object3;
        }
        boolean bl = this.decodeHelper.isSourceKey(this.currentSourceKey);
        object3 = object2;
        if (!this.diskCacheStrategy.isResourceCacheable(bl ^ true, (DataSource)((Object)object), encodeStrategy)) return object3;
        if (resourceEncoder == null) throw new Registry.NoResultEncoderAvailableException(object2.get().getClass());
        int n2 = 1.$SwitchMap$com$bumptech$glide$load$EncodeStrategy[encodeStrategy.ordinal()];
        if (n2 != 1) {
            if (n2 != 2) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Unknown strategy: ");
                ((StringBuilder)object).append((Object)encodeStrategy);
                throw new IllegalArgumentException(((StringBuilder)object).toString());
            }
            object = new ResourceCacheKey(this.decodeHelper.getArrayPool(), this.currentSourceKey, this.signature, this.width, this.height, transformation, clazz, this.options);
        } else {
            object = new DataCacheKey(this.currentSourceKey, this.signature);
        }
        object3 = LockedResource.obtain(object2);
        this.deferredEncodeManager.init((Key)object, resourceEncoder, object3);
        return object3;
    }

    void release(boolean bl) {
        if (this.releaseManager.release(bl)) {
            this.releaseInternal();
        }
    }

    @Override
    public void reschedule() {
        this.runReason = RunReason.SWITCH_TO_SOURCE_SERVICE;
        this.callback.reschedule(this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        block10: {
            TraceCompat.beginSection((String)"DecodeJob#run");
            var1_1 = this.currentFetcher;
            try {
                if (this.isCancelled) {
                    this.notifyFailed();
                    if (var1_1 != null) {
                        var1_1.cleanup();
                    }
                }
                ** GOTO lbl-1000
            }
            catch (Throwable var2_2) {
                try {
                    if (Log.isLoggable((String)"DecodeJob", (int)3)) {
                        var3_3 = new StringBuilder();
                        var3_3.append("DecodeJob threw unexpectedly, isCancelled: ");
                        var3_3.append(this.isCancelled);
                        var3_3.append(", stage: ");
                        var3_3.append((Object)this.stage);
                        Log.d((String)"DecodeJob", (String)var3_3.toString(), (Throwable)var2_2);
                    }
                    if (this.stage != Stage.ENCODE) {
                        this.throwables.add(var2_2);
                        this.notifyFailed();
                    }
                    if (this.isCancelled == false) throw var2_2;
                    if (var1_1 == null) break block10;
                    ** GOTO lbl40
                }
                catch (Throwable var3_4) {
                    if (var1_1 != null) {
                        var1_1.cleanup();
                    }
                    TraceCompat.endSection();
                    throw var3_4;
                }
            }
            TraceCompat.endSection();
            return;
lbl-1000:
            // 1 sources

            {
                this.runWrapped();
                if (var1_1 == null) break block10;
lbl40:
                // 2 sources

                var1_1.cleanup();
            }
        }
        TraceCompat.endSection();
    }

    boolean willDecodeFromCache() {
        Stage stage = this.getNextStage(Stage.INITIALIZE);
        boolean bl = stage == Stage.RESOURCE_CACHE || stage == Stage.DATA_CACHE;
        return bl;
    }

    static interface Callback<R> {
        public void onLoadFailed(GlideException var1);

        public void onResourceReady(Resource<R> var1, DataSource var2);

        public void reschedule(DecodeJob<?> var1);
    }

    private final class DecodeCallback<Z>
    implements DecodePath.DecodeCallback<Z> {
        private final DataSource dataSource;

        DecodeCallback(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        @Override
        public Resource<Z> onResourceDecoded(Resource<Z> resource) {
            return DecodeJob.this.onResourceDecoded(this.dataSource, resource);
        }
    }

    private static class DeferredEncodeManager<Z> {
        private ResourceEncoder<Z> encoder;
        private Key key;
        private LockedResource<Z> toEncode;

        DeferredEncodeManager() {
        }

        void clear() {
            this.key = null;
            this.encoder = null;
            this.toEncode = null;
        }

        void encode(DiskCacheProvider dataCacheWriter, Options options) {
            TraceCompat.beginSection((String)"DecodeJob.encode");
            try {
                DiskCache diskCache = dataCacheWriter.getDiskCache();
                Key key = this.key;
                dataCacheWriter = new DataCacheWriter<LockedResource<Z>>(this.encoder, this.toEncode, options);
                diskCache.put(key, dataCacheWriter);
                return;
            }
            finally {
                this.toEncode.unlock();
                TraceCompat.endSection();
            }
        }

        boolean hasResourceToEncode() {
            boolean bl = this.toEncode != null;
            return bl;
        }

        <X> void init(Key key, ResourceEncoder<X> resourceEncoder, LockedResource<X> lockedResource) {
            this.key = key;
            this.encoder = resourceEncoder;
            this.toEncode = lockedResource;
        }
    }

    static interface DiskCacheProvider {
        public DiskCache getDiskCache();
    }

    private static class ReleaseManager {
        private boolean isEncodeComplete;
        private boolean isFailed;
        private boolean isReleased;

        ReleaseManager() {
        }

        private boolean isComplete(boolean bl) {
            bl = (this.isFailed || bl || this.isEncodeComplete) && this.isReleased;
            return bl;
        }

        boolean onEncodeComplete() {
            synchronized (this) {
                this.isEncodeComplete = true;
                boolean bl = this.isComplete(false);
                return bl;
            }
        }

        boolean onFailed() {
            synchronized (this) {
                this.isFailed = true;
                boolean bl = this.isComplete(false);
                return bl;
            }
        }

        boolean release(boolean bl) {
            synchronized (this) {
                this.isReleased = true;
                bl = this.isComplete(bl);
                return bl;
            }
        }

        void reset() {
            synchronized (this) {
                this.isEncodeComplete = false;
                this.isReleased = false;
                this.isFailed = false;
                return;
            }
        }
    }

    private static enum RunReason {
        INITIALIZE,
        SWITCH_TO_SOURCE_SERVICE,
        DECODE_DATA;

    }

    private static enum Stage {
        INITIALIZE,
        RESOURCE_CACHE,
        DATA_CACHE,
        SOURCE,
        ENCODE,
        FINISHED;

    }
}

