/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.engine.EngineResource;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.util.Preconditions;
import com.bumptech.glide.util.Util;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

final class ActiveResources {
    private static final int MSG_CLEAN_REF = 1;
    final Map<Key, ResourceWeakReference> activeEngineResources;
    private volatile DequeuedResourceCallback cb;
    private Thread cleanReferenceQueueThread;
    private final boolean isActiveResourceRetentionAllowed;
    private volatile boolean isShutdown;
    private EngineResource.ResourceListener listener;
    private final Handler mainHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

        public boolean handleMessage(Message message) {
            if (message.what == 1) {
                ActiveResources.this.cleanupActiveReference((ResourceWeakReference)message.obj);
                return true;
            }
            return false;
        }
    });
    private ReferenceQueue<EngineResource<?>> resourceReferenceQueue;

    ActiveResources(boolean bl) {
        this.activeEngineResources = new HashMap<Key, ResourceWeakReference>();
        this.isActiveResourceRetentionAllowed = bl;
    }

    private ReferenceQueue<EngineResource<?>> getReferenceQueue() {
        if (this.resourceReferenceQueue == null) {
            this.resourceReferenceQueue = new ReferenceQueue();
            this.cleanReferenceQueueThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    Process.setThreadPriority((int)10);
                    ActiveResources.this.cleanReferenceQueue();
                }
            }, "glide-active-resources");
            this.cleanReferenceQueueThread.start();
        }
        return this.resourceReferenceQueue;
    }

    void activate(Key object, EngineResource<?> object2) {
        if ((object = this.activeEngineResources.put((Key)object, (ResourceWeakReference)(object2 = new ResourceWeakReference((Key)object, (EngineResource<?>)object2, (ReferenceQueue<? super EngineResource<?>>)this.getReferenceQueue(), this.isActiveResourceRetentionAllowed)))) != null) {
            ((ResourceWeakReference)object).reset();
        }
    }

    void cleanReferenceQueue() {
        while (!this.isShutdown) {
            Object object = (ResourceWeakReference)this.resourceReferenceQueue.remove();
            this.mainHandler.obtainMessage(1, object).sendToTarget();
            object = this.cb;
            if (object == null) continue;
            try {
                object.onResourceDequeued();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    void cleanupActiveReference(ResourceWeakReference resourceWeakReference) {
        Util.assertMainThread();
        this.activeEngineResources.remove(resourceWeakReference.key);
        if (resourceWeakReference.isCacheable && resourceWeakReference.resource != null) {
            EngineResource engineResource = new EngineResource(resourceWeakReference.resource, true, false);
            engineResource.setResourceListener(resourceWeakReference.key, this.listener);
            this.listener.onResourceReleased(resourceWeakReference.key, engineResource);
        }
    }

    void deactivate(Key object) {
        if ((object = this.activeEngineResources.remove(object)) != null) {
            ((ResourceWeakReference)object).reset();
        }
    }

    EngineResource<?> get(Key object) {
        ResourceWeakReference resourceWeakReference = this.activeEngineResources.get(object);
        if (resourceWeakReference == null) {
            return null;
        }
        object = (EngineResource)resourceWeakReference.get();
        if (object == null) {
            this.cleanupActiveReference(resourceWeakReference);
        }
        return object;
    }

    void setDequeuedResourceCallback(DequeuedResourceCallback dequeuedResourceCallback) {
        this.cb = dequeuedResourceCallback;
    }

    void setListener(EngineResource.ResourceListener resourceListener) {
        this.listener = resourceListener;
    }

    void shutdown() {
        this.isShutdown = true;
        Object object = this.cleanReferenceQueueThread;
        if (object == null) {
            return;
        }
        ((Thread)object).interrupt();
        try {
            this.cleanReferenceQueueThread.join(TimeUnit.SECONDS.toMillis(5L));
            if (this.cleanReferenceQueueThread.isAlive()) {
                object = new RuntimeException("Failed to join in time");
                throw object;
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    static interface DequeuedResourceCallback {
        public void onResourceDequeued();
    }

    static final class ResourceWeakReference
    extends WeakReference<EngineResource<?>> {
        final boolean isCacheable;
        final Key key;
        Resource<?> resource;

        ResourceWeakReference(Key resource, EngineResource<?> engineResource, ReferenceQueue<? super EngineResource<?>> referenceQueue, boolean bl) {
            super(engineResource, referenceQueue);
            this.key = Preconditions.checkNotNull(resource);
            resource = engineResource.isCacheable() && bl ? Preconditions.checkNotNull(engineResource.getResource()) : null;
            this.resource = resource;
            this.isCacheable = engineResource.isCacheable();
        }

        void reset() {
            this.resource = null;
            this.clear();
        }
    }
}

