/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.data;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class ExifOrientationStream
extends FilterInputStream {
    private static final byte[] EXIF_SEGMENT = new byte[]{-1, -31, 0, 28, 69, 120, 105, 102, 0, 0, 77, 77, 0, 0, 0, 0, 0, 8, 0, 1, 1, 18, 0, 2, 0, 0, 0, 1, 0};
    private static final int ORIENTATION_POSITION;
    private static final int SEGMENT_LENGTH;
    private static final int SEGMENT_START_POSITION = 2;
    private final byte orientation;
    private int position;

    static {
        SEGMENT_LENGTH = EXIF_SEGMENT.length;
        ORIENTATION_POSITION = SEGMENT_LENGTH + 2;
    }

    public ExifOrientationStream(InputStream object, int n2) {
        super((InputStream)object);
        if (n2 >= -1 && n2 <= 8) {
            this.orientation = (byte)n2;
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Cannot add invalid orientation: ");
        ((StringBuilder)object).append(n2);
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    @Override
    public void mark(int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        int n2;
        int n3 = this.position;
        n2 = n3 >= 2 && n3 <= (n2 = ORIENTATION_POSITION) ? (n3 == n2 ? (int)this.orientation : EXIF_SEGMENT[n3 - 2] & 0xFF) : super.read();
        if (n2 != -1) {
            ++this.position;
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.position;
        int n5 = ORIENTATION_POSITION;
        if (n4 > n5) {
            n2 = super.read(byArray, n2, n3);
        } else if (n4 == n5) {
            byArray[n2] = this.orientation;
            n2 = 1;
        } else if (n4 < 2) {
            n2 = super.read(byArray, n2, 2 - n4);
        } else {
            n3 = Math.min(n5 - n4, n3);
            System.arraycopy(EXIF_SEGMENT, this.position - 2, byArray, n2, n3);
            n2 = n3;
        }
        if (n2 > 0) {
            this.position += n2;
        }
        return n2;
    }

    @Override
    public void reset() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long skip(long l3) throws IOException {
        if ((l3 = super.skip(l3)) > 0L) {
            this.position = (int)((long)this.position + l3);
        }
        return l3;
    }
}

