/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load;

import com.bumptech.glide.load.ImageHeaderParser;
import com.bumptech.glide.load.engine.bitmap_recycle.ArrayPool;
import com.bumptech.glide.load.resource.bitmap.RecyclableBufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;

public final class ImageHeaderParserUtils {
    private static final int MARK_POSITION = 0x500000;

    private ImageHeaderParserUtils() {
    }

    public static int getOrientation(List<ImageHeaderParser> list, InputStream object, ArrayPool arrayPool) throws IOException {
        if (object == null) {
            return -1;
        }
        InputStream inputStream = object;
        if (!((InputStream)object).markSupported()) {
            inputStream = new RecyclableBufferedInputStream((InputStream)object, arrayPool);
        }
        inputStream.mark(0x500000);
        int n2 = list.size();
        for (int i3 = 0; i3 < n2; ++i3) {
            block5: {
                int n3;
                object = list.get(i3);
                try {
                    n3 = object.getOrientation(inputStream, arrayPool);
                    if (n3 == -1) break block5;
                }
                catch (Throwable throwable) {
                    inputStream.reset();
                    throw throwable;
                }
                inputStream.reset();
                return n3;
            }
            inputStream.reset();
        }
        return -1;
    }

    public static ImageHeaderParser.ImageType getType(List<ImageHeaderParser> list, InputStream object, ArrayPool object2) throws IOException {
        if (object == null) {
            return ImageHeaderParser.ImageType.UNKNOWN;
        }
        InputStream inputStream = object;
        if (!((InputStream)object).markSupported()) {
            inputStream = new RecyclableBufferedInputStream((InputStream)object, (ArrayPool)object2);
        }
        inputStream.mark(0x500000);
        int n2 = list.size();
        for (int i3 = 0; i3 < n2; ++i3) {
            block5: {
                object = list.get(i3);
                try {
                    object = object.getType(inputStream);
                    object2 = ImageHeaderParser.ImageType.UNKNOWN;
                    if (object == object2) break block5;
                }
                catch (Throwable throwable) {
                    inputStream.reset();
                    throw throwable;
                }
                inputStream.reset();
                return object;
            }
            inputStream.reset();
        }
        return ImageHeaderParser.ImageType.UNKNOWN;
    }

    public static ImageHeaderParser.ImageType getType(List<ImageHeaderParser> list, ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer == null) {
            return ImageHeaderParser.ImageType.UNKNOWN;
        }
        int n2 = list.size();
        for (int i3 = 0; i3 < n2; ++i3) {
            ImageHeaderParser.ImageType imageType = list.get(i3).getType(byteBuffer);
            if (imageType == ImageHeaderParser.ImageType.UNKNOWN) continue;
            return imageType;
        }
        return ImageHeaderParser.ImageType.UNKNOWN;
    }
}

