/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.gifdecoder;

import android.graphics.Bitmap;
import android.util.Log;
import com.bumptech.glide.gifdecoder.GifDecoder;
import com.bumptech.glide.gifdecoder.GifFrame;
import com.bumptech.glide.gifdecoder.GifHeader;
import com.bumptech.glide.gifdecoder.GifHeaderParser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class StandardGifDecoder
implements GifDecoder {
    private static final int BYTES_PER_INTEGER = 4;
    private static final int COLOR_TRANSPARENT_BLACK = 0;
    private static final int INITIAL_FRAME_POINTER = -1;
    private static final int MASK_INT_LOWEST_BYTE = 255;
    private static final int MAX_STACK_SIZE = 4096;
    private static final int NULL_CODE = -1;
    private static final String TAG = StandardGifDecoder.class.getSimpleName();
    private int[] act;
    private Bitmap.Config bitmapConfig;
    private final GifDecoder.BitmapProvider bitmapProvider;
    private byte[] block;
    private int downsampledHeight;
    private int downsampledWidth;
    private int framePointer;
    private GifHeader header;
    private Boolean isFirstFrameTransparent;
    private byte[] mainPixels;
    private int[] mainScratch;
    private GifHeaderParser parser;
    private final int[] pct = new int[256];
    private byte[] pixelStack;
    private short[] prefix;
    private Bitmap previousImage;
    private ByteBuffer rawData;
    private int sampleSize;
    private boolean savePrevious;
    private int status;
    private byte[] suffix;

    public StandardGifDecoder(GifDecoder.BitmapProvider bitmapProvider) {
        this.bitmapConfig = Bitmap.Config.ARGB_8888;
        this.bitmapProvider = bitmapProvider;
        this.header = new GifHeader();
    }

    public StandardGifDecoder(GifDecoder.BitmapProvider bitmapProvider, GifHeader gifHeader, ByteBuffer byteBuffer) {
        this(bitmapProvider, gifHeader, byteBuffer, 1);
    }

    public StandardGifDecoder(GifDecoder.BitmapProvider bitmapProvider, GifHeader gifHeader, ByteBuffer byteBuffer, int n2) {
        this(bitmapProvider);
        this.setData(gifHeader, byteBuffer, n2);
    }

    private int averageColorsNear(int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        byte[] byArray;
        int n10;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        for (n10 = n2; n10 < this.sampleSize + n2 && n10 < (byArray = this.mainPixels).length && n10 < n3; ++n10) {
            n9 = byArray[n10];
            int n16 = this.act[n9 & 0xFF];
            n8 = n11;
            n7 = n12;
            n6 = n13;
            n5 = n14;
            n9 = n15;
            if (n16 != 0) {
                n8 = n11 + (n16 >> 24 & 0xFF);
                n7 = n12 + (n16 >> 16 & 0xFF);
                n6 = n13 + (n16 >> 8 & 0xFF);
                n5 = n14 + (n16 & 0xFF);
                n9 = n15 + 1;
            }
            n11 = n8;
            n12 = n7;
            n13 = n6;
            n14 = n5;
            n15 = n9;
        }
        n9 = n11;
        for (n2 = n7 = n2 + n4; n2 < this.sampleSize + n7 && n2 < (byArray = this.mainPixels).length && n2 < n3; ++n2) {
            n4 = byArray[n2];
            n8 = this.act[n4 & 0xFF];
            n6 = n9;
            n5 = n12;
            n10 = n13;
            n11 = n14;
            n4 = n15;
            if (n8 != 0) {
                n6 = n9 + (n8 >> 24 & 0xFF);
                n5 = n12 + (n8 >> 16 & 0xFF);
                n10 = n13 + (n8 >> 8 & 0xFF);
                n11 = n14 + (n8 & 0xFF);
                n4 = n15 + 1;
            }
            n9 = n6;
            n12 = n5;
            n13 = n10;
            n14 = n11;
            n15 = n4;
        }
        if (n15 == 0) {
            return 0;
        }
        return n9 / n15 << 24 | n12 / n15 << 16 | n13 / n15 << 8 | n14 / n15;
    }

    private void copyCopyIntoScratchRobust(GifFrame gifFrame) {
        int[] nArray = this.mainScratch;
        int n2 = gifFrame.ih / this.sampleSize;
        int n3 = gifFrame.iy / this.sampleSize;
        int n4 = gifFrame.iw / this.sampleSize;
        int n5 = gifFrame.ix / this.sampleSize;
        int n6 = this.framePointer;
        Boolean bl = true;
        boolean bl2 = n6 == 0;
        int n7 = this.sampleSize;
        int n8 = this.downsampledWidth;
        int n9 = this.downsampledHeight;
        byte[] byArray = this.mainPixels;
        int[] nArray2 = this.act;
        Boolean bl3 = this.isFirstFrameTransparent;
        n6 = 0;
        int n10 = 1;
        int n11 = 8;
        for (int i3 = 0; i3 < n2; ++i3) {
            int n12;
            int n13;
            block26: {
                Boolean bl4;
                block25: {
                    int n14;
                    if (gifFrame.interlace) {
                        if (n6 >= n2) {
                            if (++n10 != 2) {
                                if (n10 != 3) {
                                    if (n10 == 4) {
                                        n6 = 1;
                                        n11 = 2;
                                    }
                                } else {
                                    n6 = 2;
                                    n11 = 4;
                                }
                            } else {
                                n6 = 4;
                            }
                        }
                        n13 = n6 + n11;
                        n12 = n10;
                        n10 = n6;
                        n6 = n13;
                        n13 = n11;
                    } else {
                        n14 = i3;
                        n13 = n11;
                        n12 = n10;
                        n10 = n14;
                    }
                    n11 = n10 + n3;
                    n10 = n7 == 1 ? 1 : 0;
                    if (n11 < n9) {
                        n14 = (n11 *= n8) + n5;
                        int n15 = n14 + n4;
                        int n16 = n11 + n8;
                        n11 = n15;
                        if (n16 < n15) {
                            n11 = n16;
                        }
                        n15 = i3 * n7 * gifFrame.iw;
                        if (n10 != 0) {
                            while (true) {
                                n10 = n4;
                                bl4 = bl3;
                                if (n14 < n11) {
                                    n10 = nArray2[byArray[n15] & 0xFF];
                                    if (n10 != 0) {
                                        nArray[n14] = n10;
                                        bl4 = bl3;
                                    } else {
                                        bl4 = bl3;
                                        if (bl2) {
                                            bl4 = bl3;
                                            if (bl3 == null) {
                                                bl4 = bl;
                                            }
                                        }
                                    }
                                    n15 += n7;
                                    ++n14;
                                    bl3 = bl4;
                                    continue;
                                }
                                break block25;
                                break;
                            }
                        }
                        n16 = n4;
                        int n17 = n14;
                        bl4 = bl3;
                        n10 = n15;
                        n4 = n11;
                        while (true) {
                            int n18 = n10;
                            n10 = n4;
                            bl3 = bl4;
                            n4 = n16;
                            if (n17 < n10) {
                                n4 = this.averageColorsNear(n18, (n11 - n14) * n7 + n15, gifFrame.iw);
                                if (n4 != 0) {
                                    nArray[n17] = n4;
                                    bl3 = bl4;
                                } else {
                                    bl3 = bl4;
                                    if (bl2) {
                                        bl3 = bl4;
                                        if (bl4 == null) {
                                            bl3 = bl;
                                        }
                                    }
                                }
                                ++n17;
                                n4 = n10;
                                n10 = n18 += n7;
                                bl4 = bl3;
                                continue;
                            }
                            break block26;
                            break;
                        }
                    }
                    bl4 = bl3;
                    n10 = n4;
                }
                n4 = n10;
                bl3 = bl4;
            }
            n10 = n12;
            n11 = n13;
        }
        if (this.isFirstFrameTransparent == null) {
            boolean bl5 = bl3 == null ? false : bl3;
            this.isFirstFrameTransparent = bl5;
        }
    }

    private void copyIntoScratchFast(GifFrame gifFrame) {
        Object object = gifFrame;
        int[] nArray = this.mainScratch;
        int n2 = ((GifFrame)object).ih;
        int n3 = ((GifFrame)object).iy;
        int n4 = ((GifFrame)object).iw;
        int n5 = ((GifFrame)object).ix;
        boolean bl = this.framePointer == 0;
        int n6 = this.downsampledWidth;
        byte[] byArray = this.mainPixels;
        object = this.act;
        int n7 = -1;
        for (int i3 = 0; i3 < n2; ++i3) {
            int n8 = (i3 + n3) * n6;
            int n9 = n8 + n5;
            int n10 = n9 + n4;
            Object object2 = n8 + n6;
            n8 = n10;
            if (object2 < n10) {
                n8 = object2;
            }
            n10 = gifFrame.iw * i3;
            while (n9 < n8) {
                Object object3 = byArray[n10];
                int n11 = object3 & 0xFF;
                object2 = n7;
                if (n11 != n7) {
                    object2 = object[n11];
                    if (object2 != 0) {
                        nArray[n9] = object2;
                        object2 = n7;
                    } else {
                        object2 = object3;
                    }
                }
                ++n10;
                ++n9;
                n7 = object2;
            }
        }
        boolean bl2 = this.isFirstFrameTransparent == null && bl && n7 != -1;
        this.isFirstFrameTransparent = bl2;
    }

    private void decodeBitmapData(GifFrame object) {
        int n2;
        int n3;
        StandardGifDecoder standardGifDecoder = this;
        if (object != null) {
            standardGifDecoder.rawData.position(((GifFrame)object).bufferFrameStart);
        }
        if (object == null) {
            n3 = standardGifDecoder.header.width * standardGifDecoder.header.height;
        } else {
            n2 = ((GifFrame)object).iw;
            n3 = ((GifFrame)object).ih * n2;
        }
        object = standardGifDecoder.mainPixels;
        if (object == null || ((Object)object).length < n3) {
            standardGifDecoder.mainPixels = standardGifDecoder.bitmapProvider.obtainByteArray(n3);
        }
        byte[] byArray = standardGifDecoder.mainPixels;
        if (standardGifDecoder.prefix == null) {
            standardGifDecoder.prefix = new short[4096];
        }
        short[] sArray = standardGifDecoder.prefix;
        if (standardGifDecoder.suffix == null) {
            standardGifDecoder.suffix = new byte[4096];
        }
        byte[] byArray2 = standardGifDecoder.suffix;
        if (standardGifDecoder.pixelStack == null) {
            standardGifDecoder.pixelStack = new byte[4097];
        }
        byte[] byArray3 = standardGifDecoder.pixelStack;
        n2 = this.readByte();
        int n4 = 1 << n2;
        int n5 = n4 + 2;
        int n6 = n2 + 1;
        int n7 = (1 << n6) - 1;
        int n8 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            sArray[n2] = (short)0;
            byArray2[n2] = (byte)n2;
        }
        byte[] byArray4 = standardGifDecoder.block;
        int n9 = n6;
        int n10 = n5;
        int n11 = n7;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = -1;
        int n18 = 0;
        int n19 = 0;
        n2 = n8;
        object = standardGifDecoder;
        block1: while (n2 < n3) {
            n8 = n12;
            if (n12 == 0) {
                n8 = this.readBlock();
                if (n8 <= 0) {
                    ((StandardGifDecoder)object).status = 3;
                    break;
                }
                n15 = 0;
            }
            n14 += (byArray4[n15] & 0xFF) << n13;
            int n20 = n15 + 1;
            int n21 = n8 - 1;
            n15 = n13 + 8;
            n13 = n17;
            n17 = n18;
            n12 = n10;
            n10 = n16;
            n18 = n9;
            n16 = n12;
            n9 = n10;
            n10 = n2;
            n2 = n13;
            n12 = n6;
            n13 = n15;
            while (n13 >= n18) {
                n15 = n14 & n11;
                n14 >>= n18;
                n13 -= n18;
                if (n15 == n4) {
                    n18 = n12;
                    n16 = n5;
                    n11 = n7;
                    n2 = -1;
                    continue;
                }
                if (n15 == n4 + 1) {
                    n8 = n18;
                    n15 = n10;
                    n10 = n16;
                    n18 = n17;
                    n17 = n2;
                    n6 = n12;
                    n2 = n15;
                    n12 = n21;
                    n15 = n20;
                    n16 = n9;
                    n9 = n8;
                    continue block1;
                }
                if (n2 == -1) {
                    byArray3[n19] = byArray2[n15];
                    ++n19;
                    object = this;
                    n17 = n2 = n15;
                    continue;
                }
                n6 = n16;
                if (n15 >= n6) {
                    byArray3[n19] = (byte)n17;
                    ++n19;
                    n16 = n2;
                } else {
                    n16 = n15;
                }
                while (n16 >= n4) {
                    byArray3[n19] = byArray2[n16];
                    ++n19;
                    n16 = sArray[n16];
                }
                int n22 = byArray2[n16] & 0xFF;
                byte by = (byte)n22;
                byArray[n9] = by;
                while (true) {
                    ++n9;
                    ++n10;
                    if (n19 <= 0) break;
                    byArray[n9] = byArray3[--n19];
                }
                n16 = n6;
                n8 = n18;
                n17 = n11;
                if (n6 < 4096) {
                    sArray[n6] = (short)n2;
                    byArray2[n6] = by;
                    n16 = n2 = n6 + 1;
                    n8 = n18;
                    n17 = n11;
                    if ((n2 & n11) == 0) {
                        n16 = n2;
                        n8 = n18;
                        n17 = n11;
                        if (n2 < 4096) {
                            n8 = n18 + 1;
                            n17 = n11 + n2;
                            n16 = n2;
                        }
                    }
                }
                n2 = n15;
                n15 = n22;
                object = this;
                n18 = n8;
                n11 = n17;
                n17 = n15;
            }
            n8 = n18;
            n18 = n17;
            n15 = n10;
            n10 = n16;
            n17 = n2;
            object = this;
            n6 = n12;
            n2 = n15;
            n12 = n21;
            n15 = n20;
            n16 = n9;
            n9 = n8;
        }
        Arrays.fill(byArray, n16, n3, (byte)0);
    }

    private GifHeaderParser getHeaderParser() {
        if (this.parser == null) {
            this.parser = new GifHeaderParser();
        }
        return this.parser;
    }

    private Bitmap getNextBitmap() {
        Boolean bl = this.isFirstFrameTransparent;
        bl = bl != null && !bl.booleanValue() ? this.bitmapConfig : Bitmap.Config.ARGB_8888;
        bl = this.bitmapProvider.obtain(this.downsampledWidth, this.downsampledHeight, (Bitmap.Config)bl);
        bl.setHasAlpha(true);
        return bl;
    }

    private int readBlock() {
        int n2 = this.readByte();
        if (n2 <= 0) {
            return n2;
        }
        ByteBuffer byteBuffer = this.rawData;
        byteBuffer.get(this.block, 0, Math.min(n2, byteBuffer.remaining()));
        return n2;
    }

    private int readByte() {
        return this.rawData.get() & 0xFF;
    }

    private Bitmap setPixels(GifFrame gifFrame, GifFrame gifFrame2) {
        int[] nArray = this.mainScratch;
        int n2 = 0;
        if (gifFrame2 == null) {
            Bitmap bitmap2 = this.previousImage;
            if (bitmap2 != null) {
                this.bitmapProvider.release(bitmap2);
            }
            this.previousImage = null;
            Arrays.fill(nArray, 0);
        }
        if (gifFrame2 != null && gifFrame2.dispose == 3 && this.previousImage == null) {
            Arrays.fill(nArray, 0);
        }
        if (gifFrame2 != null && gifFrame2.dispose > 0) {
            if (gifFrame2.dispose == 2) {
                int n3;
                int n4;
                if (!gifFrame.transparency) {
                    n4 = this.header.bgColor;
                    if (gifFrame.lct != null && this.header.bgIndex == gifFrame.transIndex) {
                        n4 = n2;
                    }
                } else {
                    n4 = n2;
                    if (this.framePointer == 0) {
                        this.isFirstFrameTransparent = true;
                        n4 = n2;
                    }
                }
                int n5 = gifFrame2.ih / this.sampleSize;
                int n6 = gifFrame2.iy / this.sampleSize;
                int n7 = gifFrame2.iw / this.sampleSize;
                n2 = gifFrame2.ix / this.sampleSize;
                int n8 = this.downsampledWidth;
                for (n2 = n3 = n6 * n8 + n2; n2 < n5 * n8 + n3; n2 += this.downsampledWidth) {
                    for (n6 = n2; n6 < n2 + n7; ++n6) {
                        nArray[n6] = n4;
                    }
                }
            } else if (gifFrame2.dispose == 3 && (gifFrame2 = this.previousImage) != null) {
                n2 = this.downsampledWidth;
                gifFrame2.getPixels(nArray, 0, n2, 0, 0, n2, this.downsampledHeight);
            }
        }
        this.decodeBitmapData(gifFrame);
        if (!gifFrame.interlace && this.sampleSize == 1) {
            this.copyIntoScratchFast(gifFrame);
        } else {
            this.copyCopyIntoScratchRobust(gifFrame);
        }
        if (this.savePrevious && (gifFrame.dispose == 0 || gifFrame.dispose == 1)) {
            if (this.previousImage == null) {
                this.previousImage = this.getNextBitmap();
            }
            gifFrame = this.previousImage;
            n2 = this.downsampledWidth;
            gifFrame.setPixels(nArray, 0, n2, 0, 0, n2, this.downsampledHeight);
        }
        gifFrame = this.getNextBitmap();
        n2 = this.downsampledWidth;
        gifFrame.setPixels(nArray, 0, n2, 0, 0, n2, this.downsampledHeight);
        return gifFrame;
    }

    @Override
    public void advance() {
        this.framePointer = (this.framePointer + 1) % this.header.frameCount;
    }

    @Override
    public void clear() {
        this.header = null;
        Object object = this.mainPixels;
        if (object != null) {
            this.bitmapProvider.release((byte[])object);
        }
        if ((object = (Object)this.mainScratch) != null) {
            this.bitmapProvider.release((int[])object);
        }
        if ((object = (Object)this.previousImage) != null) {
            this.bitmapProvider.release((Bitmap)object);
        }
        this.previousImage = null;
        this.rawData = null;
        this.isFirstFrameTransparent = null;
        object = this.block;
        if (object != null) {
            this.bitmapProvider.release((byte[])object);
        }
    }

    @Override
    public int getByteSize() {
        return this.rawData.limit() + this.mainPixels.length + this.mainScratch.length * 4;
    }

    @Override
    public int getCurrentFrameIndex() {
        return this.framePointer;
    }

    @Override
    public ByteBuffer getData() {
        return this.rawData;
    }

    @Override
    public int getDelay(int n2) {
        n2 = n2 >= 0 && n2 < this.header.frameCount ? this.header.frames.get((int)n2).delay : -1;
        return n2;
    }

    @Override
    public int getFrameCount() {
        return this.header.frameCount;
    }

    @Override
    public int getHeight() {
        return this.header.height;
    }

    @Override
    @Deprecated
    public int getLoopCount() {
        if (this.header.loopCount == -1) {
            return 1;
        }
        return this.header.loopCount;
    }

    @Override
    public int getNetscapeLoopCount() {
        return this.header.loopCount;
    }

    @Override
    public int getNextDelay() {
        int n2;
        if (this.header.frameCount > 0 && (n2 = this.framePointer) >= 0) {
            return this.getDelay(n2);
        }
        return 0;
    }

    @Override
    public Bitmap getNextFrame() {
        synchronized (this) {
            Object object;
            Object object2;
            block13: {
                GifFrame gifFrame;
                block16: {
                    block15: {
                        block14: {
                            if (this.header.frameCount <= 0 || this.framePointer < 0) {
                                if (Log.isLoggable((String)TAG, (int)3)) {
                                    object2 = TAG;
                                    object = new StringBuilder();
                                    ((StringBuilder)object).append("Unable to decode frame, frameCount=");
                                    ((StringBuilder)object).append(this.header.frameCount);
                                    ((StringBuilder)object).append(", framePointer=");
                                    ((StringBuilder)object).append(this.framePointer);
                                    Log.d((String)object2, (String)((StringBuilder)object).toString());
                                }
                                this.status = 1;
                            }
                            if (this.status == 1 || this.status == 2) break block13;
                            this.status = 0;
                            if (this.block == null) {
                                this.block = this.bitmapProvider.obtainByteArray(255);
                            }
                            gifFrame = this.header.frames.get(this.framePointer);
                            int n2 = this.framePointer - 1;
                            if (n2 < 0) break block14;
                            object2 = this.header.frames.get(n2);
                            break block15;
                        }
                        object2 = null;
                    }
                    object = gifFrame.lct != null ? (Object)gifFrame.lct : (Object)this.header.gct;
                    this.act = (int[])object;
                    if (this.act != null) break block16;
                    if (Log.isLoggable((String)TAG, (int)3)) {
                        object2 = TAG;
                        object = new StringBuilder();
                        ((StringBuilder)object).append("No valid color table found for frame #");
                        ((StringBuilder)object).append(this.framePointer);
                        Log.d((String)object2, (String)((StringBuilder)object).toString());
                    }
                    this.status = 1;
                    return null;
                }
                if (gifFrame.transparency) {
                    System.arraycopy(this.act, 0, this.pct, 0, this.act.length);
                    this.act = this.pct;
                    this.act[gifFrame.transIndex] = 0;
                }
                object2 = this.setPixels(gifFrame, (GifFrame)object2);
                return object2;
            }
            if (Log.isLoggable((String)TAG, (int)3)) {
                object2 = TAG;
                object = new StringBuilder();
                ((StringBuilder)object).append("Unable to decode frame, status=");
                ((StringBuilder)object).append(this.status);
                Log.d((String)object2, (String)((StringBuilder)object).toString());
            }
            return null;
        }
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public int getTotalIterationCount() {
        if (this.header.loopCount == -1) {
            return 1;
        }
        if (this.header.loopCount == 0) {
            return 0;
        }
        return this.header.loopCount + 1;
    }

    @Override
    public int getWidth() {
        return this.header.width;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(InputStream inputStream, int n2) {
        if (inputStream != null) {
            n2 = n2 > 0 ? (n2 += 4096) : 16384;
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
                byte[] byArray = new byte[16384];
                while ((n2 = inputStream.read(byArray, 0, byArray.length)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n2);
                }
                byteArrayOutputStream.flush();
                this.read(byteArrayOutputStream.toByteArray());
            }
            catch (IOException iOException) {
                Log.w((String)TAG, (String)"Error reading data from stream", (Throwable)iOException);
            }
        } else {
            this.status = 2;
        }
        if (inputStream == null) return this.status;
        try {
            inputStream.close();
            return this.status;
        }
        catch (IOException iOException) {
            Log.w((String)TAG, (String)"Error closing stream", (Throwable)iOException);
        }
        return this.status;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int read(byte[] byArray) {
        synchronized (this) {
            this.header = this.getHeaderParser().setData(byArray).parseHeader();
            if (byArray == null) return this.status;
            this.setData(this.header, byArray);
            return this.status;
        }
    }

    @Override
    public void resetFrameIndex() {
        this.framePointer = -1;
    }

    @Override
    public void setData(GifHeader gifHeader, ByteBuffer byteBuffer) {
        synchronized (this) {
            this.setData(gifHeader, byteBuffer, 1);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setData(GifHeader object, ByteBuffer object2, int n2) {
        synchronized (this) {
            Throwable throwable2;
            if (n2 > 0) {
                try {
                    n2 = Integer.highestOneBit(n2);
                    this.status = 0;
                    this.header = object;
                    this.framePointer = -1;
                    this.rawData = ((ByteBuffer)object2).asReadOnlyBuffer();
                    this.rawData.position(0);
                    this.rawData.order(ByteOrder.LITTLE_ENDIAN);
                    this.savePrevious = false;
                    object2 = ((GifHeader)object).frames.iterator();
                    while (object2.hasNext()) {
                        if (((GifFrame)object2.next()).dispose != 3) continue;
                        this.savePrevious = true;
                        break;
                    }
                    this.sampleSize = n2;
                    this.downsampledWidth = ((GifHeader)object).width / n2;
                    this.downsampledHeight = ((GifHeader)object).height / n2;
                    this.mainPixels = this.bitmapProvider.obtainByteArray(((GifHeader)object).width * ((GifHeader)object).height);
                    this.mainScratch = this.bitmapProvider.obtainIntArray(this.downsampledWidth * this.downsampledHeight);
                    return;
                }
                catch (Throwable throwable2) {}
            } else {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("Sample size must be >=0, not: ");
                ((StringBuilder)object2).append(n2);
                object = new IllegalArgumentException(((StringBuilder)object2).toString());
                throw object;
            }
            throw throwable2;
        }
    }

    @Override
    public void setData(GifHeader gifHeader, byte[] byArray) {
        synchronized (this) {
            this.setData(gifHeader, ByteBuffer.wrap(byArray));
            return;
        }
    }

    @Override
    public void setDefaultBitmapConfig(Bitmap.Config config) {
        if (config != Bitmap.Config.ARGB_8888 && config != Bitmap.Config.RGB_565) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Unsupported format: ");
            stringBuilder.append(config);
            stringBuilder.append(", must be one of ");
            stringBuilder.append(Bitmap.Config.ARGB_8888);
            stringBuilder.append(" or ");
            stringBuilder.append(Bitmap.Config.RGB_565);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        this.bitmapConfig = config;
    }
}

