/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.disklrucache;

import com.bumptech.glide.disklrucache.Util;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

class StrictLineReader
implements Closeable {
    private static final byte CR = 13;
    private static final byte LF = 10;
    private byte[] buf;
    private final Charset charset;
    private int end;
    private final InputStream in;
    private int pos;

    public StrictLineReader(InputStream inputStream, int n2, Charset charset) {
        if (inputStream != null && charset != null) {
            if (n2 >= 0) {
                if (charset.equals(Util.US_ASCII)) {
                    this.in = inputStream;
                    this.charset = charset;
                    this.buf = new byte[n2];
                    return;
                }
                throw new IllegalArgumentException("Unsupported encoding");
            }
            throw new IllegalArgumentException("capacity <= 0");
        }
        throw new NullPointerException();
    }

    public StrictLineReader(InputStream inputStream, Charset charset) {
        this(inputStream, 8192, charset);
    }

    private void fillBuf() throws IOException {
        InputStream inputStream = this.in;
        byte[] byArray = this.buf;
        int n2 = inputStream.read(byArray, 0, byArray.length);
        if (n2 != -1) {
            this.pos = 0;
            this.end = n2;
            return;
        }
        throw new EOFException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws IOException {
        InputStream inputStream = this.in;
        synchronized (inputStream) {
            if (this.buf != null) {
                this.buf = null;
                this.in.close();
            }
            return;
        }
    }

    public boolean hasUnterminatedLine() {
        boolean bl = this.end == -1;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String readLine() throws IOException {
        InputStream inputStream = this.in;
        synchronized (inputStream) {
            int n2;
            if (this.buf == null) {
                IOException iOException = new IOException("LineReader is closed");
                throw iOException;
            }
            if (this.pos >= this.end) {
                this.fillBuf();
            }
            for (n2 = this.pos; n2 != this.end; ++n2) {
                int n3;
                Object object;
                if (this.buf[n2] != 10) continue;
                if (n2 == this.pos || (object = this.buf)[n3 = n2 - 1] != 13) {
                    n3 = n2;
                }
                object = new String;
                object(this.buf, this.pos, n3 - this.pos, this.charset.name());
                this.pos = n2 + 1;
                return object;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.end - this.pos + 80){

                @Override
                public String toString() {
                    int n2 = this.count > 0 && this.buf[this.count - 1] == 13 ? this.count - 1 : this.count;
                    try {
                        String string2 = new String(this.buf, 0, n2, StrictLineReader.this.charset.name());
                        return string2;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new AssertionError((Object)unsupportedEncodingException);
                    }
                }
            };
            block6: while (true) {
                byteArrayOutputStream.write(this.buf, this.pos, this.end - this.pos);
                this.end = -1;
                this.fillBuf();
                n2 = this.pos;
                while (true) {
                    if (n2 == this.end) continue block6;
                    if (this.buf[n2] == 10) {
                        if (n2 != this.pos) {
                            byteArrayOutputStream.write(this.buf, this.pos, n2 - this.pos);
                        }
                        this.pos = n2 + 1;
                        return byteArrayOutputStream.toString();
                    }
                    ++n2;
                }
                break;
            }
        }
    }
}

