/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.GlideContext;
import com.bumptech.glide.ModelTypes;
import com.bumptech.glide.Priority;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.TransitionOptions;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.ErrorRequestCoordinator;
import com.bumptech.glide.request.FutureTarget;
import com.bumptech.glide.request.Request;
import com.bumptech.glide.request.RequestCoordinator;
import com.bumptech.glide.request.RequestFutureTarget;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.SingleRequest;
import com.bumptech.glide.request.ThumbnailRequestCoordinator;
import com.bumptech.glide.request.target.PreloadTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.target.ViewTarget;
import com.bumptech.glide.signature.ApplicationVersionSignature;
import com.bumptech.glide.util.Preconditions;
import com.bumptech.glide.util.Util;
import java.io.File;
import java.net.URL;

public class RequestBuilder<TranscodeType>
implements Cloneable,
ModelTypes<RequestBuilder<TranscodeType>> {
    protected static final RequestOptions DOWNLOAD_ONLY_OPTIONS = new RequestOptions().diskCacheStrategy(DiskCacheStrategy.DATA).priority(Priority.LOW).skipMemoryCache(true);
    private final Context context;
    private final RequestOptions defaultRequestOptions;
    private RequestBuilder<TranscodeType> errorBuilder;
    private final Glide glide;
    private final GlideContext glideContext;
    private boolean isDefaultTransitionOptionsSet = true;
    private boolean isModelSet;
    private boolean isThumbnailBuilt;
    private Object model;
    private RequestListener<TranscodeType> requestListener;
    private final RequestManager requestManager;
    protected RequestOptions requestOptions;
    private Float thumbSizeMultiplier;
    private RequestBuilder<TranscodeType> thumbnailBuilder;
    private final Class<TranscodeType> transcodeClass;
    private TransitionOptions<?, ? super TranscodeType> transitionOptions;

    protected RequestBuilder(Glide glide, RequestManager requestManager, Class<TranscodeType> clazz, Context context) {
        this.glide = glide;
        this.requestManager = requestManager;
        this.transcodeClass = clazz;
        this.defaultRequestOptions = requestManager.getDefaultRequestOptions();
        this.context = context;
        this.transitionOptions = requestManager.getDefaultTransitionOptions(clazz);
        this.requestOptions = this.defaultRequestOptions;
        this.glideContext = glide.getGlideContext();
    }

    protected RequestBuilder(Class<TranscodeType> clazz, RequestBuilder<?> requestBuilder) {
        this(requestBuilder.glide, requestBuilder.requestManager, clazz, requestBuilder.context);
        this.model = requestBuilder.model;
        this.isModelSet = requestBuilder.isModelSet;
        this.requestOptions = requestBuilder.requestOptions;
    }

    private Request buildRequest(Target<TranscodeType> target, RequestListener<TranscodeType> requestListener, RequestOptions requestOptions) {
        return this.buildRequestRecursive(target, requestListener, null, this.transitionOptions, requestOptions.getPriority(), requestOptions.getOverrideWidth(), requestOptions.getOverrideHeight(), requestOptions);
    }

    private Request buildRequestRecursive(Target<TranscodeType> target, RequestListener<TranscodeType> requestListener, RequestCoordinator requestCoordinator, TransitionOptions<?, ? super TranscodeType> object, Priority object2, int n2, int n3, RequestOptions requestOptions) {
        RequestCoordinator requestCoordinator2;
        if (this.errorBuilder != null) {
            requestCoordinator = requestCoordinator2 = new ErrorRequestCoordinator(requestCoordinator);
        } else {
            Object var10_10 = null;
            requestCoordinator2 = requestCoordinator;
            requestCoordinator = var10_10;
        }
        object = this.buildThumbnailRequestRecursive(target, requestListener, requestCoordinator2, (TransitionOptions<?, ? super TranscodeType>)object, (Priority)((Object)object2), n2, n3, requestOptions);
        if (requestCoordinator == null) {
            return object;
        }
        int n4 = this.errorBuilder.requestOptions.getOverrideWidth();
        int n5 = this.errorBuilder.requestOptions.getOverrideHeight();
        int n6 = n4;
        int n7 = n5;
        if (Util.isValidDimensions(n2, n3)) {
            n6 = n4;
            n7 = n5;
            if (!this.errorBuilder.requestOptions.isValidOverride()) {
                n6 = requestOptions.getOverrideWidth();
                n7 = requestOptions.getOverrideHeight();
            }
        }
        object2 = this.errorBuilder;
        ((ErrorRequestCoordinator)requestCoordinator).setRequests((Request)object, super.buildRequestRecursive(target, requestListener, requestCoordinator, ((RequestBuilder)object2).transitionOptions, ((RequestBuilder)object2).requestOptions.getPriority(), n6, n7, this.errorBuilder.requestOptions));
        return requestCoordinator;
    }

    private Request buildThumbnailRequestRecursive(Target<TranscodeType> object, RequestListener<TranscodeType> requestListener, RequestCoordinator requestCoordinator, TransitionOptions<?, ? super TranscodeType> object2, Priority object3, int n2, int n3, RequestOptions requestOptions) {
        Object object4 = this.thumbnailBuilder;
        if (object4 != null) {
            if (!this.isThumbnailBuilt) {
                TransitionOptions<?, ? super TranscodeType> transitionOptions = object4.transitionOptions;
                if (object4.isDefaultTransitionOptionsSet) {
                    transitionOptions = object2;
                }
                object4 = this.thumbnailBuilder.requestOptions.isPrioritySet() ? this.thumbnailBuilder.requestOptions.getPriority() : this.getThumbnailPriority((Priority)((Object)object3));
                int n4 = this.thumbnailBuilder.requestOptions.getOverrideWidth();
                int n5 = this.thumbnailBuilder.requestOptions.getOverrideHeight();
                int n6 = n4;
                int n7 = n5;
                if (Util.isValidDimensions(n2, n3)) {
                    n6 = n4;
                    n7 = n5;
                    if (!this.thumbnailBuilder.requestOptions.isValidOverride()) {
                        n6 = requestOptions.getOverrideWidth();
                        n7 = requestOptions.getOverrideHeight();
                    }
                }
                requestCoordinator = new ThumbnailRequestCoordinator(requestCoordinator);
                object2 = this.obtainRequest((Target<TranscodeType>)object, requestListener, requestOptions, requestCoordinator, (TransitionOptions<?, ? super TranscodeType>)object2, (Priority)((Object)object3), n2, n3);
                this.isThumbnailBuilt = true;
                object3 = this.thumbnailBuilder;
                object = super.buildRequestRecursive((Target<TranscodeType>)object, requestListener, requestCoordinator, transitionOptions, (Priority)((Object)object4), n6, n7, ((RequestBuilder)object3).requestOptions);
                this.isThumbnailBuilt = false;
                ((ThumbnailRequestCoordinator)requestCoordinator).setRequests((Request)object2, (Request)object);
                return requestCoordinator;
            }
            throw new IllegalStateException("You cannot use a request as both the main request and a thumbnail, consider using clone() on the request(s) passed to thumbnail()");
        }
        if (this.thumbSizeMultiplier != null) {
            requestCoordinator = new ThumbnailRequestCoordinator(requestCoordinator);
            ((ThumbnailRequestCoordinator)requestCoordinator).setRequests(this.obtainRequest((Target<TranscodeType>)object, requestListener, requestOptions, requestCoordinator, (TransitionOptions<?, ? super TranscodeType>)object2, (Priority)((Object)object3), n2, n3), this.obtainRequest((Target<TranscodeType>)object, requestListener, requestOptions.clone().sizeMultiplier(this.thumbSizeMultiplier.floatValue()), requestCoordinator, (TransitionOptions<?, ? super TranscodeType>)object2, this.getThumbnailPriority((Priority)((Object)object3)), n2, n3));
            return requestCoordinator;
        }
        return this.obtainRequest((Target<TranscodeType>)object, requestListener, requestOptions, requestCoordinator, (TransitionOptions<?, ? super TranscodeType>)object2, (Priority)((Object)object3), n2, n3);
    }

    private Priority getThumbnailPriority(Priority object) {
        int n2 = 2.$SwitchMap$com$bumptech$glide$Priority[((Enum)object).ordinal()];
        if (n2 != 1) {
            if (n2 != 2) {
                if (n2 != 3 && n2 != 4) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("unknown priority: ");
                    ((StringBuilder)object).append((Object)this.requestOptions.getPriority());
                    throw new IllegalArgumentException(((StringBuilder)object).toString());
                }
                return Priority.IMMEDIATE;
            }
            return Priority.HIGH;
        }
        return Priority.NORMAL;
    }

    private <Y extends Target<TranscodeType>> Y into(Y y2, RequestListener<TranscodeType> object, RequestOptions requestOptions) {
        Util.assertMainThread();
        Preconditions.checkNotNull(y2);
        if (this.isModelSet) {
            Request request = this.buildRequest(y2, (RequestListener<TranscodeType>)object, requestOptions = requestOptions.autoClone());
            if (request.isEquivalentTo((Request)(object = y2.getRequest())) && !this.isSkipMemoryCacheWithCompletePreviousRequest(requestOptions, (Request)object)) {
                request.recycle();
                if (!((Request)Preconditions.checkNotNull(object)).isRunning()) {
                    object.begin();
                }
                return y2;
            }
            this.requestManager.clear(y2);
            y2.setRequest(request);
            this.requestManager.track(y2, request);
            return y2;
        }
        throw new IllegalArgumentException("You must call #load() before calling #into()");
    }

    private boolean isSkipMemoryCacheWithCompletePreviousRequest(RequestOptions requestOptions, Request request) {
        boolean bl = !requestOptions.isMemoryCacheable() && request.isComplete();
        return bl;
    }

    private RequestBuilder<TranscodeType> loadGeneric(Object object) {
        this.model = object;
        this.isModelSet = true;
        return this;
    }

    private Request obtainRequest(Target<TranscodeType> target, RequestListener<TranscodeType> requestListener, RequestOptions requestOptions, RequestCoordinator requestCoordinator, TransitionOptions<?, ? super TranscodeType> transitionOptions, Priority priority, int n2, int n3) {
        Context context = this.context;
        GlideContext glideContext = this.glideContext;
        return SingleRequest.obtain(context, glideContext, this.model, this.transcodeClass, requestOptions, n2, n3, priority, target, requestListener, this.requestListener, requestCoordinator, glideContext.getEngine(), transitionOptions.getTransitionFactory());
    }

    public RequestBuilder<TranscodeType> apply(RequestOptions requestOptions) {
        Preconditions.checkNotNull(requestOptions);
        this.requestOptions = this.getMutableOptions().apply(requestOptions);
        return this;
    }

    public RequestBuilder<TranscodeType> clone() {
        try {
            RequestBuilder requestBuilder = (RequestBuilder)super.clone();
            requestBuilder.requestOptions = requestBuilder.requestOptions.clone();
            requestBuilder.transitionOptions = requestBuilder.transitionOptions.clone();
            return requestBuilder;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Deprecated
    public FutureTarget<File> downloadOnly(int n2, int n3) {
        return this.getDownloadOnlyRequest().submit(n2, n3);
    }

    @Deprecated
    public <Y extends Target<File>> Y downloadOnly(Y y2) {
        return this.getDownloadOnlyRequest().into(y2);
    }

    public RequestBuilder<TranscodeType> error(RequestBuilder<TranscodeType> requestBuilder) {
        this.errorBuilder = requestBuilder;
        return this;
    }

    protected RequestBuilder<File> getDownloadOnlyRequest() {
        return new RequestBuilder<File>(File.class, this).apply(DOWNLOAD_ONLY_OPTIONS);
    }

    protected RequestOptions getMutableOptions() {
        RequestOptions requestOptions;
        RequestOptions requestOptions2 = this.defaultRequestOptions;
        RequestOptions requestOptions3 = requestOptions = this.requestOptions;
        if (requestOptions2 == requestOptions) {
            requestOptions3 = requestOptions.clone();
        }
        return requestOptions3;
    }

    @Deprecated
    public FutureTarget<TranscodeType> into(int n2, int n3) {
        return this.submit(n2, n3);
    }

    public <Y extends Target<TranscodeType>> Y into(Y y2) {
        return this.into(y2, null);
    }

    <Y extends Target<TranscodeType>> Y into(Y y2, RequestListener<TranscodeType> requestListener) {
        return this.into(y2, requestListener, this.getMutableOptions());
    }

    public ViewTarget<ImageView, TranscodeType> into(ImageView imageView) {
        RequestOptions requestOptions;
        Util.assertMainThread();
        Preconditions.checkNotNull(imageView);
        RequestOptions requestOptions2 = requestOptions = this.requestOptions;
        if (!requestOptions.isTransformationSet()) {
            requestOptions2 = requestOptions;
            if (requestOptions.isTransformationAllowed()) {
                requestOptions2 = requestOptions;
                if (imageView.getScaleType() != null) {
                    switch (imageView.getScaleType()) {
                        default: {
                            requestOptions2 = requestOptions;
                            break;
                        }
                        case FIT_XY: {
                            requestOptions2 = requestOptions.clone().optionalCenterInside();
                            break;
                        }
                        case FIT_CENTER: 
                        case FIT_START: 
                        case FIT_END: {
                            requestOptions2 = requestOptions.clone().optionalFitCenter();
                            break;
                        }
                        case CENTER_INSIDE: {
                            requestOptions2 = requestOptions.clone().optionalCenterInside();
                            break;
                        }
                        case CENTER_CROP: {
                            requestOptions2 = requestOptions.clone().optionalCenterCrop();
                        }
                    }
                }
            }
        }
        return this.into(this.glideContext.buildImageViewTarget(imageView, this.transcodeClass), null, requestOptions2);
    }

    public RequestBuilder<TranscodeType> listener(RequestListener<TranscodeType> requestListener) {
        this.requestListener = requestListener;
        return this;
    }

    @Override
    public RequestBuilder<TranscodeType> load(Bitmap bitmap2) {
        return this.loadGeneric(bitmap2).apply(RequestOptions.diskCacheStrategyOf(DiskCacheStrategy.NONE));
    }

    @Override
    public RequestBuilder<TranscodeType> load(Drawable drawable2) {
        return this.loadGeneric(drawable2).apply(RequestOptions.diskCacheStrategyOf(DiskCacheStrategy.NONE));
    }

    @Override
    public RequestBuilder<TranscodeType> load(Uri uri) {
        return this.loadGeneric(uri);
    }

    @Override
    public RequestBuilder<TranscodeType> load(File file) {
        return this.loadGeneric(file);
    }

    @Override
    public RequestBuilder<TranscodeType> load(Integer n2) {
        return this.loadGeneric(n2).apply(RequestOptions.signatureOf(ApplicationVersionSignature.obtain(this.context)));
    }

    @Override
    public RequestBuilder<TranscodeType> load(Object object) {
        return this.loadGeneric(object);
    }

    @Override
    public RequestBuilder<TranscodeType> load(String string2) {
        return this.loadGeneric(string2);
    }

    @Override
    @Deprecated
    public RequestBuilder<TranscodeType> load(URL uRL) {
        return this.loadGeneric(uRL);
    }

    @Override
    public RequestBuilder<TranscodeType> load(byte[] object) {
        RequestBuilder<TranscodeType> requestBuilder = this.loadGeneric(object);
        object = requestBuilder;
        if (!requestBuilder.requestOptions.isDiskCacheStrategySet()) {
            object = requestBuilder.apply(RequestOptions.diskCacheStrategyOf(DiskCacheStrategy.NONE));
        }
        requestBuilder = (RequestBuilder<TranscodeType>)object;
        if (!((RequestBuilder)object).requestOptions.isSkipMemoryCacheSet()) {
            requestBuilder = ((RequestBuilder)object).apply(RequestOptions.skipMemoryCacheOf(true));
        }
        return requestBuilder;
    }

    public Target<TranscodeType> preload() {
        return this.preload(Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public Target<TranscodeType> preload(int n2, int n3) {
        return this.into(PreloadTarget.obtain(this.requestManager, n2, n3));
    }

    public FutureTarget<TranscodeType> submit() {
        return this.submit(Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public FutureTarget<TranscodeType> submit(int n2, int n3) {
        final RequestFutureTarget requestFutureTarget = new RequestFutureTarget(this.glideContext.getMainHandler(), n2, n3);
        if (Util.isOnBackgroundThread()) {
            this.glideContext.getMainHandler().post(new Runnable(){

                @Override
                public void run() {
                    if (!requestFutureTarget.isCancelled()) {
                        RequestBuilder requestBuilder = RequestBuilder.this;
                        RequestFutureTarget requestFutureTarget2 = requestFutureTarget;
                        requestBuilder.into(requestFutureTarget2, requestFutureTarget2);
                    }
                }
            });
        } else {
            this.into(requestFutureTarget, requestFutureTarget);
        }
        return requestFutureTarget;
    }

    public RequestBuilder<TranscodeType> thumbnail(float f3) {
        if (!(f3 < 0.0f) && !(f3 > 1.0f)) {
            this.thumbSizeMultiplier = Float.valueOf(f3);
            return this;
        }
        throw new IllegalArgumentException("sizeMultiplier must be between 0 and 1");
    }

    public RequestBuilder<TranscodeType> thumbnail(RequestBuilder<TranscodeType> requestBuilder) {
        this.thumbnailBuilder = requestBuilder;
        return this;
    }

    public RequestBuilder<TranscodeType> thumbnail(RequestBuilder<TranscodeType> ... requestBuilderArray) {
        RequestBuilder<TranscodeType> requestBuilder = null;
        if (requestBuilderArray != null && requestBuilderArray.length != 0) {
            for (int i3 = requestBuilderArray.length - 1; i3 >= 0; --i3) {
                RequestBuilder<TranscodeType> requestBuilder2 = requestBuilderArray[i3];
                if (requestBuilder2 == null) continue;
                requestBuilder = requestBuilder == null ? requestBuilder2 : requestBuilder2.thumbnail(requestBuilder);
            }
            return this.thumbnail(requestBuilder);
        }
        return this.thumbnail((RequestBuilder<TranscodeType>)null);
    }

    public RequestBuilder<TranscodeType> transition(TransitionOptions<?, ? super TranscodeType> transitionOptions) {
        this.transitionOptions = Preconditions.checkNotNull(transitionOptions);
        this.isDefaultTransitionOptionsSet = false;
        return this;
    }
}

