/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide;

import android.widget.AbsListView;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.request.target.BaseTarget;
import com.bumptech.glide.request.target.SizeReadyCallback;
import com.bumptech.glide.request.transition.Transition;
import com.bumptech.glide.util.Util;
import java.util.List;
import java.util.Queue;

public class ListPreloader<T>
implements AbsListView.OnScrollListener {
    private boolean isIncreasing = true;
    private int lastEnd;
    private int lastFirstVisible;
    private int lastStart;
    private final int maxPreload;
    private final PreloadSizeProvider<T> preloadDimensionProvider;
    private final PreloadModelProvider<T> preloadModelProvider;
    private final PreloadTargetQueue preloadTargetQueue;
    private final RequestManager requestManager;
    private int totalItemCount;

    public ListPreloader(RequestManager requestManager, PreloadModelProvider<T> preloadModelProvider, PreloadSizeProvider<T> preloadSizeProvider, int n2) {
        this.requestManager = requestManager;
        this.preloadModelProvider = preloadModelProvider;
        this.preloadDimensionProvider = preloadSizeProvider;
        this.maxPreload = n2;
        this.preloadTargetQueue = new PreloadTargetQueue(n2 + 1);
    }

    private void cancelAll() {
        for (int i3 = 0; i3 < this.maxPreload; ++i3) {
            this.requestManager.clear(this.preloadTargetQueue.next(0, 0));
        }
    }

    private void preload(int n2, int n3) {
        int n4;
        int n5;
        if (n2 < n3) {
            n5 = Math.max(this.lastEnd, n2);
            n4 = n3;
        } else {
            n4 = Math.min(this.lastStart, n2);
            n5 = n3;
        }
        n4 = Math.min(this.totalItemCount, n4);
        n5 = Math.min(this.totalItemCount, Math.max(0, n5));
        if (n2 < n3) {
            for (n2 = n5; n2 < n4; ++n2) {
                this.preloadAdapterPosition(this.preloadModelProvider.getPreloadItems(n2), n2, true);
            }
        } else {
            for (n2 = n4 - 1; n2 >= n5; --n2) {
                this.preloadAdapterPosition(this.preloadModelProvider.getPreloadItems(n2), n2, false);
            }
        }
        this.lastStart = n5;
        this.lastEnd = n4;
    }

    private void preload(int n2, boolean bl) {
        if (this.isIncreasing != bl) {
            this.isIncreasing = bl;
            this.cancelAll();
        }
        int n3 = bl ? this.maxPreload : -this.maxPreload;
        this.preload(n2, n3 + n2);
    }

    private void preloadAdapterPosition(List<T> list, int n2, boolean bl) {
        int n3 = list.size();
        if (bl) {
            for (int i3 = 0; i3 < n3; ++i3) {
                this.preloadItem(list.get(i3), n2, i3);
            }
        } else {
            for (int i4 = n3 - 1; i4 >= 0; --i4) {
                this.preloadItem(list.get(i4), n2, i4);
            }
        }
    }

    private void preloadItem(T object, int n2, int n3) {
        if (object == null) {
            return;
        }
        int[] nArray = this.preloadDimensionProvider.getPreloadSize(object, n2, n3);
        if (nArray == null) {
            return;
        }
        if ((object = this.preloadModelProvider.getPreloadRequestBuilder(object)) == null) {
            return;
        }
        ((RequestBuilder)object).into((PreloadTarget)this.preloadTargetQueue.next(nArray[0], nArray[1]));
    }

    public void onScroll(AbsListView absListView, int n2, int n3, int n4) {
        this.totalItemCount = n4;
        n4 = this.lastFirstVisible;
        if (n2 > n4) {
            this.preload(n3 + n2, true);
        } else if (n2 < n4) {
            this.preload(n2, false);
        }
        this.lastFirstVisible = n2;
    }

    public void onScrollStateChanged(AbsListView absListView, int n2) {
    }

    public static interface PreloadModelProvider<U> {
        public List<U> getPreloadItems(int var1);

        public RequestBuilder<?> getPreloadRequestBuilder(U var1);
    }

    public static interface PreloadSizeProvider<T> {
        public int[] getPreloadSize(T var1, int var2, int var3);
    }

    private static final class PreloadTarget
    extends BaseTarget<Object> {
        int photoHeight;
        int photoWidth;

        PreloadTarget() {
        }

        @Override
        public void getSize(SizeReadyCallback sizeReadyCallback) {
            sizeReadyCallback.onSizeReady(this.photoWidth, this.photoHeight);
        }

        @Override
        public void onResourceReady(Object object, Transition<? super Object> transition) {
        }

        @Override
        public void removeCallback(SizeReadyCallback sizeReadyCallback) {
        }
    }

    private static final class PreloadTargetQueue {
        private final Queue<PreloadTarget> queue;

        PreloadTargetQueue(int n2) {
            this.queue = Util.createQueue(n2);
            for (int i3 = 0; i3 < n2; ++i3) {
                this.queue.offer(new PreloadTarget());
            }
        }

        public PreloadTarget next(int n2, int n3) {
            PreloadTarget preloadTarget = this.queue.poll();
            this.queue.offer(preloadTarget);
            preloadTarget.photoWidth = n2;
            preloadTarget.photoHeight = n3;
            return preloadTarget;
        }
    }
}

