/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide;

import android.content.Context;
import android.content.ContextWrapper;
import android.os.Handler;
import android.os.Looper;
import android.widget.ImageView;
import com.bumptech.glide.GenericTransitionOptions;
import com.bumptech.glide.Registry;
import com.bumptech.glide.TransitionOptions;
import com.bumptech.glide.load.engine.Engine;
import com.bumptech.glide.load.engine.bitmap_recycle.ArrayPool;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.ImageViewTargetFactory;
import com.bumptech.glide.request.target.ViewTarget;
import java.util.Iterator;
import java.util.Map;

public class GlideContext
extends ContextWrapper {
    static final TransitionOptions<?, ?> DEFAULT_TRANSITION_OPTIONS = new GenericTransitionOptions();
    private final ArrayPool arrayPool;
    private final RequestOptions defaultRequestOptions;
    private final Map<Class<?>, TransitionOptions<?, ?>> defaultTransitionOptions;
    private final Engine engine;
    private final ImageViewTargetFactory imageViewTargetFactory;
    private final int logLevel;
    private final Handler mainHandler;
    private final Registry registry;

    public GlideContext(Context context, ArrayPool arrayPool, Registry registry, ImageViewTargetFactory imageViewTargetFactory, RequestOptions requestOptions, Map<Class<?>, TransitionOptions<?, ?>> map, Engine engine, int n2) {
        super(context.getApplicationContext());
        this.arrayPool = arrayPool;
        this.registry = registry;
        this.imageViewTargetFactory = imageViewTargetFactory;
        this.defaultRequestOptions = requestOptions;
        this.defaultTransitionOptions = map;
        this.engine = engine;
        this.logLevel = n2;
        this.mainHandler = new Handler(Looper.getMainLooper());
    }

    public <X> ViewTarget<ImageView, X> buildImageViewTarget(ImageView imageView, Class<X> clazz) {
        return this.imageViewTargetFactory.buildTarget(imageView, clazz);
    }

    public ArrayPool getArrayPool() {
        return this.arrayPool;
    }

    public RequestOptions getDefaultRequestOptions() {
        return this.defaultRequestOptions;
    }

    public <T> TransitionOptions<?, T> getDefaultTransitionOptions(Class<T> transitionOptions) {
        TransitionOptions transitionOptions2 = this.defaultTransitionOptions.get(transitionOptions);
        Map.Entry<Class<?>, TransitionOptions<?, ?>> entry = transitionOptions2;
        if (transitionOptions2 == null) {
            Iterator<Map.Entry<Class<?>, TransitionOptions<?, ?>>> iterator = this.defaultTransitionOptions.entrySet().iterator();
            while (true) {
                entry = transitionOptions2;
                if (!iterator.hasNext()) break;
                entry = iterator.next();
                if (!((Class)entry.getKey()).isAssignableFrom((Class<?>)((Object)transitionOptions))) continue;
                transitionOptions2 = (TransitionOptions)entry.getValue();
            }
        }
        transitionOptions = entry;
        if (entry == null) {
            transitionOptions = DEFAULT_TRANSITION_OPTIONS;
        }
        return transitionOptions;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public Handler getMainHandler() {
        return this.mainHandler;
    }

    public Registry getRegistry() {
        return this.registry;
    }
}

