/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide;

import android.app.Activity;
import android.app.Fragment;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import android.view.View;
import androidx.fragment.app.FragmentActivity;
import com.bumptech.glide.GeneratedAppGlideModule;
import com.bumptech.glide.GlideBuilder;
import com.bumptech.glide.GlideContext;
import com.bumptech.glide.MemoryCategory;
import com.bumptech.glide.Registry;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.TransitionOptions;
import com.bumptech.glide.gifdecoder.GifDecoder;
import com.bumptech.glide.load.ResourceDecoder;
import com.bumptech.glide.load.data.InputStreamRewinder;
import com.bumptech.glide.load.engine.Engine;
import com.bumptech.glide.load.engine.bitmap_recycle.ArrayPool;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.engine.cache.MemoryCache;
import com.bumptech.glide.load.engine.prefill.BitmapPreFiller;
import com.bumptech.glide.load.engine.prefill.PreFillType;
import com.bumptech.glide.load.model.AssetUriLoader;
import com.bumptech.glide.load.model.ByteArrayLoader;
import com.bumptech.glide.load.model.ByteBufferEncoder;
import com.bumptech.glide.load.model.ByteBufferFileLoader;
import com.bumptech.glide.load.model.DataUrlLoader;
import com.bumptech.glide.load.model.FileLoader;
import com.bumptech.glide.load.model.GlideUrl;
import com.bumptech.glide.load.model.MediaStoreFileLoader;
import com.bumptech.glide.load.model.ResourceLoader;
import com.bumptech.glide.load.model.StreamEncoder;
import com.bumptech.glide.load.model.StringLoader;
import com.bumptech.glide.load.model.UnitModelLoader;
import com.bumptech.glide.load.model.UriLoader;
import com.bumptech.glide.load.model.UrlUriLoader;
import com.bumptech.glide.load.model.stream.HttpGlideUrlLoader;
import com.bumptech.glide.load.model.stream.HttpUriLoader;
import com.bumptech.glide.load.model.stream.MediaStoreImageThumbLoader;
import com.bumptech.glide.load.model.stream.MediaStoreVideoThumbLoader;
import com.bumptech.glide.load.model.stream.UrlLoader;
import com.bumptech.glide.load.resource.bitmap.BitmapDrawableDecoder;
import com.bumptech.glide.load.resource.bitmap.BitmapDrawableEncoder;
import com.bumptech.glide.load.resource.bitmap.BitmapEncoder;
import com.bumptech.glide.load.resource.bitmap.ByteBufferBitmapDecoder;
import com.bumptech.glide.load.resource.bitmap.DefaultImageHeaderParser;
import com.bumptech.glide.load.resource.bitmap.Downsampler;
import com.bumptech.glide.load.resource.bitmap.ResourceBitmapDecoder;
import com.bumptech.glide.load.resource.bitmap.StreamBitmapDecoder;
import com.bumptech.glide.load.resource.bitmap.UnitBitmapDecoder;
import com.bumptech.glide.load.resource.bitmap.VideoDecoder;
import com.bumptech.glide.load.resource.bytes.ByteBufferRewinder;
import com.bumptech.glide.load.resource.drawable.ResourceDrawableDecoder;
import com.bumptech.glide.load.resource.drawable.UnitDrawableDecoder;
import com.bumptech.glide.load.resource.file.FileDecoder;
import com.bumptech.glide.load.resource.gif.ByteBufferGifDecoder;
import com.bumptech.glide.load.resource.gif.GifDrawable;
import com.bumptech.glide.load.resource.gif.GifDrawableEncoder;
import com.bumptech.glide.load.resource.gif.GifFrameResourceDecoder;
import com.bumptech.glide.load.resource.gif.StreamGifDecoder;
import com.bumptech.glide.load.resource.transcode.BitmapBytesTranscoder;
import com.bumptech.glide.load.resource.transcode.BitmapDrawableTranscoder;
import com.bumptech.glide.load.resource.transcode.DrawableBytesTranscoder;
import com.bumptech.glide.load.resource.transcode.GifDrawableBytesTranscoder;
import com.bumptech.glide.manager.ConnectivityMonitorFactory;
import com.bumptech.glide.manager.RequestManagerRetriever;
import com.bumptech.glide.module.GlideModule;
import com.bumptech.glide.module.ManifestParser;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.ImageViewTargetFactory;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.util.Preconditions;
import com.bumptech.glide.util.Util;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Glide
implements ComponentCallbacks2 {
    private static final String DEFAULT_DISK_CACHE_DIR = "image_manager_disk_cache";
    private static final String TAG = "Glide";
    private static volatile Glide glide;
    private static volatile boolean isInitializing;
    private final ArrayPool arrayPool;
    private final BitmapPool bitmapPool;
    private final BitmapPreFiller bitmapPreFiller;
    private final ConnectivityMonitorFactory connectivityMonitorFactory;
    private final Engine engine;
    private final GlideContext glideContext;
    private final List<RequestManager> managers = new ArrayList<RequestManager>();
    private final MemoryCache memoryCache;
    private MemoryCategory memoryCategory = MemoryCategory.NORMAL;
    private final Registry registry;
    private final RequestManagerRetriever requestManagerRetriever;

    Glide(Context context, Engine engine, MemoryCache object, BitmapPool bitmapPool, ArrayPool arrayPool, RequestManagerRetriever object2, ConnectivityMonitorFactory object3, int n2, RequestOptions requestOptions, Map<Class<?>, TransitionOptions<?, ?>> map) {
        this.engine = engine;
        this.bitmapPool = bitmapPool;
        this.arrayPool = arrayPool;
        this.memoryCache = object;
        this.requestManagerRetriever = object2;
        this.connectivityMonitorFactory = object3;
        this.bitmapPreFiller = new BitmapPreFiller((MemoryCache)object, bitmapPool, requestOptions.getOptions().get(Downsampler.DECODE_FORMAT));
        object = context.getResources();
        this.registry = new Registry();
        this.registry.register(new DefaultImageHeaderParser());
        Object object4 = new Downsampler(this.registry.getImageHeaderParsers(), object.getDisplayMetrics(), bitmapPool, arrayPool);
        object3 = new ByteBufferGifDecoder(context, this.registry.getImageHeaderParsers(), bitmapPool, arrayPool);
        object2 = VideoDecoder.parcel(bitmapPool);
        ByteBufferBitmapDecoder byteBufferBitmapDecoder = new ByteBufferBitmapDecoder((Downsampler)object4);
        StreamBitmapDecoder streamBitmapDecoder = new StreamBitmapDecoder((Downsampler)object4, arrayPool);
        object4 = new ResourceDrawableDecoder(context);
        ResourceLoader.StreamFactory streamFactory = new ResourceLoader.StreamFactory((Resources)object);
        ResourceLoader.UriFactory uriFactory = new ResourceLoader.UriFactory((Resources)object);
        ResourceLoader.FileDescriptorFactory fileDescriptorFactory = new ResourceLoader.FileDescriptorFactory((Resources)object);
        ResourceLoader.AssetFileDescriptorFactory assetFileDescriptorFactory = new ResourceLoader.AssetFileDescriptorFactory((Resources)object);
        BitmapEncoder bitmapEncoder = new BitmapEncoder();
        BitmapBytesTranscoder bitmapBytesTranscoder = new BitmapBytesTranscoder();
        GifDrawableBytesTranscoder gifDrawableBytesTranscoder = new GifDrawableBytesTranscoder();
        ContentResolver contentResolver = context.getContentResolver();
        this.registry.append(ByteBuffer.class, new ByteBufferEncoder()).append(InputStream.class, new StreamEncoder(arrayPool)).append("Bitmap", ByteBuffer.class, Bitmap.class, byteBufferBitmapDecoder).append("Bitmap", InputStream.class, Bitmap.class, streamBitmapDecoder).append("Bitmap", ParcelFileDescriptor.class, Bitmap.class, object2).append("Bitmap", AssetFileDescriptor.class, Bitmap.class, VideoDecoder.asset(bitmapPool)).append(Bitmap.class, Bitmap.class, UnitModelLoader.Factory.getInstance()).append("Bitmap", Bitmap.class, Bitmap.class, new UnitBitmapDecoder()).append(Bitmap.class, bitmapEncoder).append("BitmapDrawable", ByteBuffer.class, BitmapDrawable.class, new BitmapDrawableDecoder<ByteBuffer>((Resources)object, byteBufferBitmapDecoder)).append("BitmapDrawable", InputStream.class, BitmapDrawable.class, new BitmapDrawableDecoder<InputStream>((Resources)object, streamBitmapDecoder)).append("BitmapDrawable", ParcelFileDescriptor.class, BitmapDrawable.class, new BitmapDrawableDecoder((Resources)object, object2)).append(BitmapDrawable.class, new BitmapDrawableEncoder(bitmapPool, bitmapEncoder)).append("Gif", InputStream.class, GifDrawable.class, new StreamGifDecoder(this.registry.getImageHeaderParsers(), (ResourceDecoder<ByteBuffer, GifDrawable>)object3, arrayPool)).append("Gif", ByteBuffer.class, GifDrawable.class, object3).append(GifDrawable.class, new GifDrawableEncoder()).append(GifDecoder.class, GifDecoder.class, UnitModelLoader.Factory.getInstance()).append("Bitmap", GifDecoder.class, Bitmap.class, new GifFrameResourceDecoder(bitmapPool)).append(Uri.class, Drawable.class, object4).append(Uri.class, Bitmap.class, new ResourceBitmapDecoder((ResourceDrawableDecoder)object4, bitmapPool)).register(new ByteBufferRewinder.Factory()).append(File.class, ByteBuffer.class, new ByteBufferFileLoader.Factory()).append(File.class, InputStream.class, new FileLoader.StreamFactory()).append(File.class, File.class, new FileDecoder()).append(File.class, ParcelFileDescriptor.class, new FileLoader.FileDescriptorFactory()).append(File.class, File.class, UnitModelLoader.Factory.getInstance()).register(new InputStreamRewinder.Factory(arrayPool)).append(Integer.TYPE, InputStream.class, streamFactory).append(Integer.TYPE, ParcelFileDescriptor.class, fileDescriptorFactory).append(Integer.class, InputStream.class, streamFactory).append(Integer.class, ParcelFileDescriptor.class, fileDescriptorFactory).append(Integer.class, Uri.class, uriFactory).append(Integer.TYPE, AssetFileDescriptor.class, assetFileDescriptorFactory).append(Integer.class, AssetFileDescriptor.class, assetFileDescriptorFactory).append(Integer.TYPE, Uri.class, uriFactory).append(String.class, InputStream.class, new DataUrlLoader.StreamFactory()).append(String.class, InputStream.class, new StringLoader.StreamFactory()).append(String.class, ParcelFileDescriptor.class, new StringLoader.FileDescriptorFactory()).append(String.class, AssetFileDescriptor.class, new StringLoader.AssetFileDescriptorFactory()).append(Uri.class, InputStream.class, new HttpUriLoader.Factory()).append(Uri.class, InputStream.class, new AssetUriLoader.StreamFactory(context.getAssets())).append(Uri.class, ParcelFileDescriptor.class, new AssetUriLoader.FileDescriptorFactory(context.getAssets())).append(Uri.class, InputStream.class, new MediaStoreImageThumbLoader.Factory(context)).append(Uri.class, InputStream.class, new MediaStoreVideoThumbLoader.Factory(context)).append(Uri.class, InputStream.class, new UriLoader.StreamFactory(contentResolver)).append(Uri.class, ParcelFileDescriptor.class, new UriLoader.FileDescriptorFactory(contentResolver)).append(Uri.class, AssetFileDescriptor.class, new UriLoader.AssetFileDescriptorFactory(contentResolver)).append(Uri.class, InputStream.class, new UrlUriLoader.StreamFactory()).append(URL.class, InputStream.class, new UrlLoader.StreamFactory()).append(Uri.class, File.class, new MediaStoreFileLoader.Factory(context)).append(GlideUrl.class, InputStream.class, new HttpGlideUrlLoader.Factory()).append(byte[].class, ByteBuffer.class, new ByteArrayLoader.ByteBufferFactory()).append(byte[].class, InputStream.class, new ByteArrayLoader.StreamFactory()).append(Uri.class, Uri.class, UnitModelLoader.Factory.getInstance()).append(Drawable.class, Drawable.class, UnitModelLoader.Factory.getInstance()).append(Drawable.class, Drawable.class, new UnitDrawableDecoder()).register(Bitmap.class, BitmapDrawable.class, new BitmapDrawableTranscoder((Resources)object)).register(Bitmap.class, byte[].class, bitmapBytesTranscoder).register(Drawable.class, byte[].class, new DrawableBytesTranscoder(bitmapPool, bitmapBytesTranscoder, gifDrawableBytesTranscoder)).register(GifDrawable.class, byte[].class, gifDrawableBytesTranscoder);
        object = new ImageViewTargetFactory();
        this.glideContext = new GlideContext(context, arrayPool, this.registry, (ImageViewTargetFactory)object, requestOptions, map, engine, n2);
    }

    private static void checkAndInitializeGlide(Context context) {
        if (!isInitializing) {
            isInitializing = true;
            Glide.initializeGlide(context);
            isInitializing = false;
            return;
        }
        throw new IllegalStateException("You cannot call Glide.get() in registerComponents(), use the provided Glide instance instead");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Glide get(Context context) {
        if (glide != null) return glide;
        synchronized (Glide.class) {
            if (glide != null) return glide;
            Glide.checkAndInitializeGlide(context);
            return glide;
        }
    }

    private static GeneratedAppGlideModule getAnnotationGeneratedGlideModules() {
        GeneratedAppGlideModule generatedAppGlideModule;
        block6: {
            block7: {
                try {
                    generatedAppGlideModule = (GeneratedAppGlideModule)Class.forName("com.bumptech.glide.GeneratedAppGlideModuleImpl").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    break block6;
                }
                catch (InvocationTargetException invocationTargetException) {
                    Glide.throwIncorrectGlideModule(invocationTargetException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Glide.throwIncorrectGlideModule(noSuchMethodException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    Glide.throwIncorrectGlideModule(illegalAccessException);
                }
                catch (InstantiationException instantiationException) {
                    Glide.throwIncorrectGlideModule(instantiationException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (!Log.isLoggable((String)TAG, (int)5)) break block7;
                    Log.w((String)TAG, (String)"Failed to find GeneratedAppGlideModule. You should include an annotationProcessor compile dependency on com.github.bumptech.glide:compiler in your application and a @GlideModule annotated AppGlideModule implementation or LibraryGlideModules will be silently ignored");
                }
            }
            generatedAppGlideModule = null;
        }
        return generatedAppGlideModule;
    }

    public static File getPhotoCacheDir(Context context) {
        return Glide.getPhotoCacheDir(context, DEFAULT_DISK_CACHE_DIR);
    }

    public static File getPhotoCacheDir(Context object, String string2) {
        if ((object = object.getCacheDir()) != null) {
            if (!(((File)(object = new File((File)object, string2))).mkdirs() || ((File)object).exists() && ((File)object).isDirectory())) {
                return null;
            }
            return object;
        }
        if (Log.isLoggable((String)TAG, (int)6)) {
            Log.e((String)TAG, (String)"default disk cache dir is null");
        }
        return null;
    }

    private static RequestManagerRetriever getRetriever(Context context) {
        Preconditions.checkNotNull(context, "You cannot start a load on a not yet attached View or a Fragment where getActivity() returns null (which usually occurs when getActivity() is called before the Fragment is attached or after the Fragment is destroyed).");
        return Glide.get(context).getRequestManagerRetriever();
    }

    public static void init(Context context, GlideBuilder glideBuilder) {
        synchronized (Glide.class) {
            if (glide != null) {
                Glide.tearDown();
            }
            Glide.initializeGlide(context, glideBuilder);
            return;
        }
    }

    @Deprecated
    public static void init(Glide glide) {
        synchronized (Glide.class) {
            if (Glide.glide != null) {
                Glide.tearDown();
            }
            Glide.glide = glide;
            return;
        }
    }

    private static void initializeGlide(Context context) {
        Glide.initializeGlide(context, new GlideBuilder());
    }

    private static void initializeGlide(Context object, GlideBuilder object2) {
        Object object3;
        Object object4;
        Object object5;
        Context context = object.getApplicationContext();
        GeneratedAppGlideModule generatedAppGlideModule = Glide.getAnnotationGeneratedGlideModules();
        object = Collections.emptyList();
        if (generatedAppGlideModule == null || generatedAppGlideModule.isManifestParsingEnabled()) {
            object = new ManifestParser(context).parse();
        }
        if (generatedAppGlideModule != null && !generatedAppGlideModule.getExcludedModuleClasses().isEmpty()) {
            object5 = generatedAppGlideModule.getExcludedModuleClasses();
            object4 = object.iterator();
            while (object4.hasNext()) {
                object3 = (GlideModule)object4.next();
                if (!object5.contains(object3.getClass())) continue;
                if (Log.isLoggable((String)TAG, (int)3)) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("AppGlideModule excludes manifest GlideModule: ");
                    stringBuilder.append(object3);
                    Log.d((String)TAG, (String)stringBuilder.toString());
                }
                object4.remove();
            }
        }
        if (Log.isLoggable((String)TAG, (int)3)) {
            object3 = object.iterator();
            while (object3.hasNext()) {
                object4 = (GlideModule)object3.next();
                object5 = new StringBuilder();
                ((StringBuilder)object5).append("Discovered GlideModule from manifest: ");
                ((StringBuilder)object5).append(object4.getClass());
                Log.d((String)TAG, (String)((StringBuilder)object5).toString());
            }
        }
        object4 = generatedAppGlideModule != null ? generatedAppGlideModule.getRequestManagerFactory() : null;
        ((GlideBuilder)object2).setRequestManagerFactory((RequestManagerRetriever.RequestManagerFactory)object4);
        object4 = object.iterator();
        while (object4.hasNext()) {
            ((GlideModule)object4.next()).applyOptions(context, (GlideBuilder)object2);
        }
        if (generatedAppGlideModule != null) {
            generatedAppGlideModule.applyOptions(context, (GlideBuilder)object2);
        }
        object2 = ((GlideBuilder)object2).build(context);
        object = object.iterator();
        while (object.hasNext()) {
            ((GlideModule)object.next()).registerComponents(context, (Glide)object2, ((Glide)object2).registry);
        }
        if (generatedAppGlideModule != null) {
            generatedAppGlideModule.registerComponents(context, (Glide)object2, ((Glide)object2).registry);
        }
        context.registerComponentCallbacks((ComponentCallbacks)object2);
        glide = object2;
    }

    public static void tearDown() {
        synchronized (Glide.class) {
            if (glide != null) {
                glide.getContext().getApplicationContext().unregisterComponentCallbacks((ComponentCallbacks)glide);
                Glide.glide.engine.shutdown();
            }
            glide = null;
            return;
        }
    }

    private static void throwIncorrectGlideModule(Exception exception) {
        throw new IllegalStateException("GeneratedAppGlideModuleImpl is implemented incorrectly. If you've manually implemented this class, remove your implementation. The Annotation processor will generate a correct implementation.", exception);
    }

    public static RequestManager with(Activity activity) {
        return Glide.getRetriever((Context)activity).get(activity);
    }

    public static RequestManager with(Fragment fragment) {
        return Glide.getRetriever((Context)fragment.getActivity()).get(fragment);
    }

    public static RequestManager with(Context context) {
        return Glide.getRetriever(context).get(context);
    }

    public static RequestManager with(View view) {
        return Glide.getRetriever(view.getContext()).get(view);
    }

    public static RequestManager with(androidx.fragment.app.Fragment fragment) {
        return Glide.getRetriever((Context)fragment.getActivity()).get(fragment);
    }

    public static RequestManager with(FragmentActivity fragmentActivity) {
        return Glide.getRetriever((Context)fragmentActivity).get(fragmentActivity);
    }

    public void clearDiskCache() {
        Util.assertBackgroundThread();
        this.engine.clearDiskCache();
    }

    public void clearMemory() {
        Util.assertMainThread();
        this.memoryCache.clearMemory();
        this.bitmapPool.clearMemory();
        this.arrayPool.clearMemory();
    }

    public ArrayPool getArrayPool() {
        return this.arrayPool;
    }

    public BitmapPool getBitmapPool() {
        return this.bitmapPool;
    }

    ConnectivityMonitorFactory getConnectivityMonitorFactory() {
        return this.connectivityMonitorFactory;
    }

    public Context getContext() {
        return this.glideContext.getBaseContext();
    }

    GlideContext getGlideContext() {
        return this.glideContext;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public RequestManagerRetriever getRequestManagerRetriever() {
        return this.requestManagerRetriever;
    }

    public void onConfigurationChanged(Configuration configuration) {
    }

    public void onLowMemory() {
        this.clearMemory();
    }

    public void onTrimMemory(int n2) {
        this.trimMemory(n2);
    }

    public void preFillBitmapPool(PreFillType.Builder ... builderArray) {
        this.bitmapPreFiller.preFill(builderArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void registerRequestManager(RequestManager object) {
        List<RequestManager> list = this.managers;
        synchronized (list) {
            if (!this.managers.contains(object)) {
                this.managers.add((RequestManager)object);
                return;
            }
            object = new IllegalStateException("Cannot register already registered manager");
            throw object;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean removeFromManagers(Target<?> target) {
        List<RequestManager> list = this.managers;
        synchronized (list) {
            Iterator<RequestManager> iterator = this.managers.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!iterator.next().untrack(target));
            return true;
        }
    }

    public MemoryCategory setMemoryCategory(MemoryCategory memoryCategory) {
        Util.assertMainThread();
        this.memoryCache.setSizeMultiplier(memoryCategory.getMultiplier());
        this.bitmapPool.setSizeMultiplier(memoryCategory.getMultiplier());
        MemoryCategory memoryCategory2 = this.memoryCategory;
        this.memoryCategory = memoryCategory;
        return memoryCategory2;
    }

    public void trimMemory(int n2) {
        Util.assertMainThread();
        this.memoryCache.trimMemory(n2);
        this.bitmapPool.trimMemory(n2);
        this.arrayPool.trimMemory(n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void unregisterRequestManager(RequestManager object) {
        List<RequestManager> list = this.managers;
        synchronized (list) {
            if (this.managers.contains(object)) {
                this.managers.remove(object);
                return;
            }
            object = new IllegalStateException("Cannot unregister not yet registered manager");
            throw object;
        }
    }
}

