/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.module_grayscale;

import android.graphics.Rect;
import com.ailiwean.module_grayscale.Dispatch;
import java.util.HashSet;

class InterruptGrayScale_
implements Dispatch {
    private static final int BLOCK_SIZE = 4;
    private static final int BLOCK_SIZE_MASK = 3;
    private static final int BLOCK_SIZE_POWER = 2;
    private static final int MINIMUM_DIMENSION = 20;
    private static final int MIN_DYNAMIC_RANGE = 24;
    private int stepX = 10;
    private int stepY = 10;

    InterruptGrayScale_() {
    }

    private int[][] calculateBlackPoints(byte[] byArray, int n2, int n3, int n4, int n5) {
        int n6 = n5 - 4;
        int n7 = n4 - 4;
        int[][] nArray = new int[n3][n2];
        for (int i3 = 0; i3 < n3; ++i3) {
            int n8 = n5 = i3 << 2;
            if (n5 > n6) {
                n8 = n6;
            }
            for (int i4 = 0; i4 < n2; ++i4) {
                int n9;
                int n10;
                n5 = n10 = i4 << 2;
                if (n10 > n7) {
                    n5 = n7;
                }
                n5 = n8 * n4 + n5;
                n10 = 0;
                int n11 = 0;
                int n12 = 0;
                int n13 = 255;
                while (n10 < 4) {
                    int n14;
                    int n15;
                    for (n9 = 0; n9 < 4; ++n9) {
                        n15 = byArray[n5 + n9] & 0xFF;
                        n14 = n11 + n15;
                        n11 = n13;
                        if (n15 < n13) {
                            n11 = n15;
                        }
                        n13 = n12;
                        if (n15 > n12) {
                            n13 = n15;
                        }
                        n12 = n13;
                        n13 = n11;
                        n11 = n14;
                    }
                    n14 = n10;
                    n15 = n5;
                    n9 = n11;
                    if (n12 - n13 > 24) {
                        n15 = n5;
                        int n16 = n10;
                        block4: while (true) {
                            n5 = n16 + 1;
                            n10 = n15 + n4;
                            n14 = n5;
                            n15 = n10;
                            n9 = n11;
                            if (n5 >= 4) break;
                            n14 = 0;
                            n9 = n11;
                            while (true) {
                                n16 = n5;
                                n15 = n10;
                                n11 = n9;
                                if (n14 >= 4) continue block4;
                                n9 += byArray[n10 + n14] & 0xFF;
                                ++n14;
                            }
                            break;
                        }
                    }
                    n11 = n9;
                    n10 = n14 + 1;
                    n5 = n15 + n4;
                }
                n5 = n11 >> 4;
                if (n12 - n13 <= 24) {
                    n5 = n10 = n13 / 2;
                    if (i3 > 0) {
                        n5 = n10;
                        if (i4 > 0) {
                            n9 = i3 - 1;
                            n5 = nArray[n9][i4];
                            int[] nArray2 = nArray[i3];
                            n11 = i4 - 1;
                            n11 = (n5 + nArray2[n11] * 2 + nArray[n9][n11]) / 4;
                            n5 = n10;
                            if (n13 < n11) {
                                n5 = n11;
                            }
                        }
                    }
                }
                nArray[i3][i4] = n5;
            }
        }
        return nArray;
    }

    private void calculateThresholdForBlock(byte[] byArray, int n2, int n3, int n4, int n5, int[][] nArray) {
        int n6 = n5 - 4;
        int n7 = n4 - 4;
        for (n5 = 0; n5 < n3; ++n5) {
            int n8 = n5 << 2;
            if (n8 > n6) {
                n8 = n6;
            }
            int n9 = this.cap(n5, n3 - 3);
            for (int i3 = 0; i3 < n2; ++i3) {
                int n10 = i3 << 2;
                if (n10 > n7) {
                    n10 = n7;
                }
                int n11 = this.cap(i3, n2 - 3);
                int n12 = 0;
                for (int i4 = -2; i4 <= 2; ++i4) {
                    int[] nArray2 = nArray[n9 + i4];
                    n12 += nArray2[n11 - 2] + nArray2[n11 - 1] + nArray2[n11] + nArray2[n11 + 1] + nArray2[2 + n11];
                }
                this.thresholdBlock(byArray, n10, n8, n12 / 25, n4);
            }
        }
    }

    private int cap(int n2, int n3) {
        int n4 = 2;
        n2 = n2 < 2 ? n4 : Math.min(n2, n3);
        return n2;
    }

    private void closeOp(byte[] byArray, int n2, int n3, int n4) {
        Object object = new HashSet();
        int n5 = n4;
        while (this.stepY + n5 < n3) {
            int n6 = n4;
            while (this.stepX + n6 < n2) {
                int n7;
                int n8 = 0;
                for (n7 = n5; n7 < this.stepY + n5; ++n7) {
                    for (int i3 = n6; i3 < this.stepX + n6; ++i3) {
                        int n9 = n7 * n2 + i3;
                        if (n9 >= n2 * n3) {
                            return;
                        }
                        int n10 = n8;
                        if ((byArray[n9] & 0xFF) == 255) {
                            n10 = n8 + 1;
                        }
                        n8 = n10;
                    }
                }
                if (n8 != 0) {
                    for (n8 = n5; n8 < this.stepY + n5; ++n8) {
                        for (n7 = n6; n7 < this.stepX + n6; ++n7) {
                            object.add(n8 * n2 + n7);
                        }
                    }
                }
                n6 += this.stepX;
            }
            n5 += this.stepY;
        }
        object = object.iterator();
        while (object.hasNext()) {
            byArray[((Integer)object.next()).intValue()] = (byte)-1;
        }
    }

    private void openOp(byte[] byArray, int n2, int n3, int n4) {
        Object object = new HashSet();
        int n5 = n4;
        while (this.stepY + n5 < n3) {
            int n6 = n4;
            while (this.stepX + n6 < n2) {
                int n7;
                int n8 = 0;
                for (n7 = n5; n7 < this.stepY + n5; ++n7) {
                    for (int i3 = n6; i3 < this.stepX + n6; ++i3) {
                        int n9 = n7 * n2 + i3;
                        if (n9 >= n2 * n3) {
                            return;
                        }
                        int n10 = n8;
                        if ((byArray[n9] & 0xFF) == 0) {
                            n10 = n8 + 1;
                        }
                        n8 = n10;
                    }
                }
                if (n8 != 0) {
                    for (n8 = n5; n8 < this.stepY + n5; ++n8) {
                        for (n7 = n6; n7 < this.stepX + n6; ++n7) {
                            object.add(n8 * n2 + n7);
                        }
                    }
                }
                n6 += this.stepX;
            }
            n5 += this.stepY;
        }
        object = object.iterator();
        while (object.hasNext()) {
            byArray[((Integer)object.next()).intValue()] = (byte)0;
        }
    }

    private void thresholdBlock(byte[] byArray, int n2, int n3, int n4, int n5) {
        n3 = n3 * n5 + n2;
        n2 = 0;
        while (n2 < 4) {
            for (int i3 = 0; i3 < 4; ++i3) {
                int n6 = n3 + i3;
                byArray[n6] = (byArray[n6] & 0xFF) <= n4 ? (byte)0 : (byte)-1;
            }
            ++n2;
            n3 += n5;
        }
    }

    private void toBinarization(byte[] byArray, int n2, int n3) {
        int n4;
        int n5;
        int n6 = n5 = n2 >> 2;
        if ((n2 & 3) != 0) {
            n6 = n5 + 1;
        }
        n5 = n4 = n3 >> 2;
        if ((n3 & 3) != 0) {
            n5 = n4 + 1;
        }
        this.calculateThresholdForBlock(byArray, n6, n5, n2, n3, this.calculateBlackPoints(byArray, n6, n5, n2, n3));
    }

    @Override
    public byte[] dispatch(byte[] byArray, int n2, int n3) {
        byArray = (byte[])byArray.clone();
        int n4 = 0;
        while (this.stepY + n4 < n3) {
            int n5 = 0;
            while (this.stepX + n5 < n2) {
                int n6;
                int n7;
                int n8 = 0;
                int n9 = 0;
                for (n7 = n4; n7 < this.stepY + n4; ++n7) {
                    for (n6 = n5; n6 < this.stepX + n5; ++n6) {
                        int n10 = n7 * n2 + n6;
                        int n11 = n8;
                        if ((byArray[n10] & 0xFF) < 130) {
                            n11 = n8 + 1;
                        }
                        n9 += byArray[n10] & 0xFF;
                        n8 = n11;
                    }
                }
                if (n8 != 0) {
                    for (n8 = n4; n8 < this.stepY + n4; ++n8) {
                        for (n7 = n5; n7 < this.stepX + n5; ++n7) {
                            n6 = n8 * n2 + n7;
                            byArray[n6] = (byArray[n6] & 0xFF) > n9 ? (byte)((byte)(n9 & 0xFF)) : (byte)((byte)(byArray[n6] & 0xFF));
                        }
                    }
                }
                n5 += this.stepX;
            }
            n4 += this.stepY;
        }
        return byArray;
    }

    @Override
    public byte[] dispatch(byte[] byArray, int n2, int n3, Rect rect) {
        int n4;
        byte[] byArray2 = (byte[])byArray.clone();
        byArray = new byte[rect.width() * rect.height()];
        int n5 = 0;
        int n6 = 0;
        for (n3 = rect.top; n3 < rect.bottom; ++n3) {
            n4 = rect.left;
            while (n4 < rect.right) {
                byArray[n6] = byArray2[n3 * n2 + n4];
                ++n4;
                ++n6;
            }
        }
        this.toBinarization(byArray, rect.width(), rect.height());
        for (n3 = 0; n3 < 5; ++n3) {
            this.openOp(byArray, rect.width(), rect.height(), 0);
            this.closeOp(byArray, rect.width(), rect.height(), 0);
        }
        n6 = n5;
        for (n3 = rect.top; n3 < rect.bottom; ++n3) {
            n4 = rect.left;
            while (n4 < rect.right) {
                byArray2[n3 * n2 + n4] = byArray[n6];
                ++n4;
                ++n6;
            }
        }
        return byArray2;
    }
}

