/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.qrcode.encoder;

import com.ailiwean.core.zxing.core.WriterException;
import com.ailiwean.core.zxing.core.common.BitArray;
import com.ailiwean.core.zxing.core.qrcode.decoder.ErrorCorrectionLevel;
import com.ailiwean.core.zxing.core.qrcode.decoder.Version;
import com.ailiwean.core.zxing.core.qrcode.encoder.ByteMatrix;
import com.ailiwean.core.zxing.core.qrcode.encoder.MaskUtil;
import com.ailiwean.core.zxing.core.qrcode.encoder.QRCode;

final class MatrixUtil {
    private static final int[][] POSITION_ADJUSTMENT_PATTERN;
    private static final int[][] POSITION_ADJUSTMENT_PATTERN_COORDINATE_TABLE;
    private static final int[][] POSITION_DETECTION_PATTERN;
    private static final int[][] TYPE_INFO_COORDINATES;
    private static final int TYPE_INFO_MASK_PATTERN = 21522;
    private static final int TYPE_INFO_POLY = 1335;
    private static final int VERSION_INFO_POLY = 7973;

    static {
        int[] nArray = new int[]{1, 1, 1, 1, 1, 1, 1};
        int[] nArray2 = new int[]{1, 0, 1, 1, 1, 0, 1};
        int[] nArray3 = new int[]{1, 0, 1, 1, 1, 0, 1};
        int[] nArray4 = new int[]{1, 0, 1, 1, 1, 0, 1};
        int[] nArray5 = new int[]{1, 0, 0, 0, 0, 0, 1};
        int[] nArray6 = new int[]{1, 1, 1, 1, 1, 1, 1};
        POSITION_DETECTION_PATTERN = new int[][]{nArray, {1, 0, 0, 0, 0, 0, 1}, nArray2, nArray3, nArray4, nArray5, nArray6};
        nArray = new int[]{1, 0, 0, 0, 1};
        nArray2 = new int[]{1, 0, 1, 0, 1};
        POSITION_ADJUSTMENT_PATTERN = new int[][]{{1, 1, 1, 1, 1}, nArray, nArray2, {1, 0, 0, 0, 1}, {1, 1, 1, 1, 1}};
        nArray = new int[]{-1, -1, -1, -1, -1, -1, -1};
        nArray2 = new int[]{6, 22, -1, -1, -1, -1, -1};
        nArray3 = new int[]{6, 26, -1, -1, -1, -1, -1};
        nArray4 = new int[]{6, 34, -1, -1, -1, -1, -1};
        nArray5 = new int[]{6, 24, 42, -1, -1, -1, -1};
        nArray6 = new int[]{6, 26, 46, -1, -1, -1, -1};
        int[] nArray7 = new int[]{6, 26, 46, 66, -1, -1, -1};
        int[] nArray8 = new int[]{6, 26, 48, 70, -1, -1, -1};
        int[] nArray9 = new int[]{6, 30, 54, 78, -1, -1, -1};
        int[] nArray10 = new int[]{6, 30, 56, 82, -1, -1, -1};
        int[] nArray11 = new int[]{6, 30, 58, 86, -1, -1, -1};
        int[] nArray12 = new int[]{6, 28, 50, 72, 94, -1, -1};
        int[] nArray13 = new int[]{6, 26, 50, 74, 98, -1, -1};
        int[] nArray14 = new int[]{6, 28, 54, 80, 106, -1, -1};
        int[] nArray15 = new int[]{6, 30, 58, 86, 114, 142, -1};
        int[] nArray16 = new int[]{6, 30, 54, 78, 102, 126, 150};
        int[] nArray17 = new int[]{6, 24, 50, 76, 102, 128, 154};
        int[] nArray18 = new int[]{6, 28, 54, 80, 106, 132, 158};
        int[] nArray19 = new int[]{6, 32, 58, 84, 110, 136, 162};
        int[] nArray20 = new int[]{6, 26, 54, 82, 110, 138, 166};
        int[] nArray21 = new int[]{6, 30, 58, 86, 114, 142, 170};
        POSITION_ADJUSTMENT_PATTERN_COORDINATE_TABLE = new int[][]{nArray, {6, 18, -1, -1, -1, -1, -1}, nArray2, nArray3, {6, 30, -1, -1, -1, -1, -1}, nArray4, {6, 22, 38, -1, -1, -1, -1}, nArray5, nArray6, {6, 28, 50, -1, -1, -1, -1}, {6, 30, 54, -1, -1, -1, -1}, {6, 32, 58, -1, -1, -1, -1}, {6, 34, 62, -1, -1, -1, -1}, nArray7, nArray8, {6, 26, 50, 74, -1, -1, -1}, nArray9, nArray10, nArray11, {6, 34, 62, 90, -1, -1, -1}, nArray12, nArray13, {6, 30, 54, 78, 102, -1, -1}, nArray14, {6, 32, 58, 84, 110, -1, -1}, {6, 30, 58, 86, 114, -1, -1}, {6, 34, 62, 90, 118, -1, -1}, {6, 26, 50, 74, 98, 122, -1}, {6, 30, 54, 78, 102, 126, -1}, {6, 26, 52, 78, 104, 130, -1}, {6, 30, 56, 82, 108, 134, -1}, {6, 34, 60, 86, 112, 138, -1}, nArray15, {6, 34, 62, 90, 118, 146, -1}, nArray16, nArray17, nArray18, nArray19, nArray20, nArray21};
        nArray = new int[]{8, 1};
        nArray2 = new int[]{8, 2};
        nArray3 = new int[]{8, 4};
        nArray4 = new int[]{8, 7};
        nArray5 = new int[]{5, 8};
        nArray6 = new int[]{4, 8};
        nArray7 = new int[]{2, 8};
        nArray8 = new int[]{0, 8};
        TYPE_INFO_COORDINATES = new int[][]{{8, 0}, nArray, nArray2, {8, 3}, nArray3, {8, 5}, nArray4, {8, 8}, {7, 8}, nArray5, nArray6, {3, 8}, nArray7, {1, 8}, nArray8};
    }

    private MatrixUtil() {
    }

    static void buildMatrix(BitArray bitArray, ErrorCorrectionLevel errorCorrectionLevel, Version version, int n2, ByteMatrix byteMatrix) throws WriterException {
        MatrixUtil.clearMatrix(byteMatrix);
        MatrixUtil.embedBasicPatterns(version, byteMatrix);
        MatrixUtil.embedTypeInfo(errorCorrectionLevel, n2, byteMatrix);
        MatrixUtil.maybeEmbedVersionInfo(version, byteMatrix);
        MatrixUtil.embedDataBits(bitArray, n2, byteMatrix);
    }

    static int calculateBCHCode(int n2, int n3) {
        if (n3 != 0) {
            int n4 = MatrixUtil.findMSBSet(n3);
            n2 <<= n4 - 1;
            while (MatrixUtil.findMSBSet(n2) >= n4) {
                n2 ^= n3 << MatrixUtil.findMSBSet(n2) - n4;
            }
            return n2;
        }
        throw new IllegalArgumentException("0 polynomial");
    }

    static void clearMatrix(ByteMatrix byteMatrix) {
        byteMatrix.clear((byte)-1);
    }

    static void embedBasicPatterns(Version version, ByteMatrix byteMatrix) throws WriterException {
        MatrixUtil.embedPositionDetectionPatternsAndSeparators(byteMatrix);
        MatrixUtil.embedDarkDotAtLeftBottomCorner(byteMatrix);
        MatrixUtil.maybeEmbedPositionAdjustmentPatterns(version, byteMatrix);
        MatrixUtil.embedTimingPatterns(byteMatrix);
    }

    private static void embedDarkDotAtLeftBottomCorner(ByteMatrix byteMatrix) throws WriterException {
        if (byteMatrix.get(8, byteMatrix.getHeight() - 8) != 0) {
            byteMatrix.set(8, byteMatrix.getHeight() - 8, 1);
            return;
        }
        throw new WriterException();
    }

    static void embedDataBits(BitArray bitArray, int n2, ByteMatrix object) throws WriterException {
        int n3 = ((ByteMatrix)object).getWidth() - 1;
        int n4 = ((ByteMatrix)object).getHeight() - 1;
        int n5 = 0;
        int n6 = -1;
        while (n3 > 0) {
            int n7 = n3;
            int n8 = n5;
            int n9 = n4;
            if (n3 == 6) {
                n7 = n3 - 1;
                n9 = n4;
                n8 = n5;
            }
            while (n9 >= 0 && n9 < ((ByteMatrix)object).getHeight()) {
                for (n4 = 0; n4 < 2; ++n4) {
                    boolean bl;
                    n3 = n7 - n4;
                    if (!MatrixUtil.isEmpty(((ByteMatrix)object).get(n3, n9))) continue;
                    if (n8 < bitArray.getSize()) {
                        bl = bitArray.get(n8);
                        ++n8;
                    } else {
                        bl = false;
                    }
                    boolean bl2 = bl;
                    if (n2 != -1) {
                        bl2 = bl;
                        if (MaskUtil.getDataMaskBit(n2, n3, n9)) {
                            bl2 = bl ^ true;
                        }
                    }
                    ((ByteMatrix)object).set(n3, n9, bl2);
                }
                n9 += n6;
            }
            n6 = -n6;
            n4 = n9 + n6;
            n3 = n7 - 2;
            n5 = n8;
        }
        if (n5 == bitArray.getSize()) {
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Not all bits consumed: ");
        ((StringBuilder)object).append(n5);
        ((StringBuilder)object).append('/');
        ((StringBuilder)object).append(bitArray.getSize());
        throw new WriterException(((StringBuilder)object).toString());
    }

    private static void embedHorizontalSeparationPattern(int n2, int n3, ByteMatrix byteMatrix) throws WriterException {
        for (int i3 = 0; i3 < 8; ++i3) {
            int n4 = n2 + i3;
            if (MatrixUtil.isEmpty(byteMatrix.get(n4, n3))) {
                byteMatrix.set(n4, n3, 0);
                continue;
            }
            throw new WriterException();
        }
    }

    private static void embedPositionAdjustmentPattern(int n2, int n3, ByteMatrix byteMatrix) {
        for (int i3 = 0; i3 < 5; ++i3) {
            int[] nArray = POSITION_ADJUSTMENT_PATTERN[i3];
            for (int i4 = 0; i4 < 5; ++i4) {
                byteMatrix.set(n2 + i4, n3 + i3, nArray[i4]);
            }
        }
    }

    private static void embedPositionDetectionPattern(int n2, int n3, ByteMatrix byteMatrix) {
        for (int i3 = 0; i3 < 7; ++i3) {
            int[] nArray = POSITION_DETECTION_PATTERN[i3];
            for (int i4 = 0; i4 < 7; ++i4) {
                byteMatrix.set(n2 + i4, n3 + i3, nArray[i4]);
            }
        }
    }

    private static void embedPositionDetectionPatternsAndSeparators(ByteMatrix byteMatrix) throws WriterException {
        int n2 = POSITION_DETECTION_PATTERN[0].length;
        MatrixUtil.embedPositionDetectionPattern(0, 0, byteMatrix);
        MatrixUtil.embedPositionDetectionPattern(byteMatrix.getWidth() - n2, 0, byteMatrix);
        MatrixUtil.embedPositionDetectionPattern(0, byteMatrix.getWidth() - n2, byteMatrix);
        MatrixUtil.embedHorizontalSeparationPattern(0, 7, byteMatrix);
        MatrixUtil.embedHorizontalSeparationPattern(byteMatrix.getWidth() - 8, 7, byteMatrix);
        MatrixUtil.embedHorizontalSeparationPattern(0, byteMatrix.getWidth() - 8, byteMatrix);
        MatrixUtil.embedVerticalSeparationPattern(7, 0, byteMatrix);
        MatrixUtil.embedVerticalSeparationPattern(byteMatrix.getHeight() - 7 - 1, 0, byteMatrix);
        MatrixUtil.embedVerticalSeparationPattern(7, byteMatrix.getHeight() - 7, byteMatrix);
    }

    private static void embedTimingPatterns(ByteMatrix byteMatrix) {
        int n2 = 8;
        while (n2 < byteMatrix.getWidth() - 8) {
            int n3 = n2 + 1;
            int n4 = n3 % 2;
            if (MatrixUtil.isEmpty(byteMatrix.get(n2, 6))) {
                byteMatrix.set(n2, 6, n4);
            }
            if (MatrixUtil.isEmpty(byteMatrix.get(6, n2))) {
                byteMatrix.set(6, n2, n4);
            }
            n2 = n3;
        }
    }

    static void embedTypeInfo(ErrorCorrectionLevel object, int n2, ByteMatrix byteMatrix) throws WriterException {
        BitArray bitArray = new BitArray();
        MatrixUtil.makeTypeInfoBits(object, n2, bitArray);
        for (n2 = 0; n2 < bitArray.getSize(); ++n2) {
            int n3;
            boolean bl = bitArray.get(bitArray.getSize() - 1 - n2);
            object = TYPE_INFO_COORDINATES[n2];
            byteMatrix.set((int)object[0], (int)object[1], bl);
            int n4 = 8;
            if (n2 < 8) {
                n3 = byteMatrix.getWidth() - n2 - 1;
            } else {
                n4 = byteMatrix.getHeight() - 7 + (n2 - 8);
                n3 = 8;
            }
            byteMatrix.set(n3, n4, bl);
        }
    }

    private static void embedVerticalSeparationPattern(int n2, int n3, ByteMatrix byteMatrix) throws WriterException {
        for (int i3 = 0; i3 < 7; ++i3) {
            int n4 = n3 + i3;
            if (MatrixUtil.isEmpty(byteMatrix.get(n2, n4))) {
                byteMatrix.set(n2, n4, 0);
                continue;
            }
            throw new WriterException();
        }
    }

    static int findMSBSet(int n2) {
        return 32 - Integer.numberOfLeadingZeros(n2);
    }

    private static boolean isEmpty(int n2) {
        boolean bl = n2 == -1;
        return bl;
    }

    static void makeTypeInfoBits(ErrorCorrectionLevel object, int n2, BitArray bitArray) throws WriterException {
        if (QRCode.isValidMaskPattern(n2)) {
            n2 = ((ErrorCorrectionLevel)((Object)object)).getBits() << 3 | n2;
            bitArray.appendBits(n2, 5);
            bitArray.appendBits(MatrixUtil.calculateBCHCode(n2, 1335), 10);
            object = new BitArray();
            ((BitArray)object).appendBits(21522, 15);
            bitArray.xor((BitArray)object);
            if (bitArray.getSize() == 15) {
                return;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("should not happen but we got: ");
            ((StringBuilder)object).append(bitArray.getSize());
            throw new WriterException(((StringBuilder)object).toString());
        }
        throw new WriterException("Invalid mask pattern");
    }

    static void makeVersionInfoBits(Version object, BitArray bitArray) throws WriterException {
        bitArray.appendBits(((Version)object).getVersionNumber(), 6);
        bitArray.appendBits(MatrixUtil.calculateBCHCode(((Version)object).getVersionNumber(), 7973), 12);
        if (bitArray.getSize() == 18) {
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("should not happen but we got: ");
        ((StringBuilder)object).append(bitArray.getSize());
        throw new WriterException(((StringBuilder)object).toString());
    }

    private static void maybeEmbedPositionAdjustmentPatterns(Version object, ByteMatrix byteMatrix) {
        if (((Version)object).getVersionNumber() < 2) {
            return;
        }
        int n2 = ((Version)object).getVersionNumber();
        object = POSITION_ADJUSTMENT_PATTERN_COORDINATE_TABLE[n2 - 1];
        int n3 = ((Object)object).length;
        for (n2 = 0; n2 < n3; ++n2) {
            Object object2 = object[n2];
            if (object2 < 0) continue;
            int n4 = ((Object)object).length;
            for (int i3 = 0; i3 < n4; ++i3) {
                Object object3 = object[i3];
                if (object3 < 0 || !MatrixUtil.isEmpty(byteMatrix.get((int)object3, (int)object2))) continue;
                MatrixUtil.embedPositionAdjustmentPattern((int)(object3 - 2), (int)(object2 - 2), byteMatrix);
            }
        }
    }

    static void maybeEmbedVersionInfo(Version version, ByteMatrix byteMatrix) throws WriterException {
        if (version.getVersionNumber() < 7) {
            return;
        }
        BitArray bitArray = new BitArray();
        MatrixUtil.makeVersionInfoBits(version, bitArray);
        int n2 = 17;
        for (int i3 = 0; i3 < 6; ++i3) {
            for (int i4 = 0; i4 < 3; ++i4) {
                boolean bl = bitArray.get(n2);
                --n2;
                byteMatrix.set(i3, byteMatrix.getHeight() - 11 + i4, bl);
                byteMatrix.set(byteMatrix.getHeight() - 11 + i4, i3, bl);
            }
        }
    }
}

