/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.qrcode.encoder;

import com.ailiwean.core.zxing.core.EncodeHintType;
import com.ailiwean.core.zxing.core.WriterException;
import com.ailiwean.core.zxing.core.common.BitArray;
import com.ailiwean.core.zxing.core.common.CharacterSetECI;
import com.ailiwean.core.zxing.core.common.reedsolomon.GenericGF;
import com.ailiwean.core.zxing.core.common.reedsolomon.ReedSolomonEncoder;
import com.ailiwean.core.zxing.core.qrcode.decoder.ErrorCorrectionLevel;
import com.ailiwean.core.zxing.core.qrcode.decoder.Mode;
import com.ailiwean.core.zxing.core.qrcode.decoder.Version;
import com.ailiwean.core.zxing.core.qrcode.encoder.BlockPair;
import com.ailiwean.core.zxing.core.qrcode.encoder.ByteMatrix;
import com.ailiwean.core.zxing.core.qrcode.encoder.MaskUtil;
import com.ailiwean.core.zxing.core.qrcode.encoder.MatrixUtil;
import com.ailiwean.core.zxing.core.qrcode.encoder.QRCode;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;

public final class Encoder {
    private static final int[] ALPHANUMERIC_TABLE = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 36, -1, -1, -1, 37, 38, -1, -1, -1, -1, 39, 40, -1, 41, 42, 43, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 44, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, -1, -1, -1, -1, -1};
    static final String DEFAULT_BYTE_MODE_ENCODING = "ISO-8859-1";

    private Encoder() {
    }

    static void append8BitBytes(String object, BitArray bitArray, String string2) throws WriterException {
        try {
            object = ((String)object).getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new WriterException(unsupportedEncodingException);
        }
        int n2 = ((Object)object).length;
        for (int i3 = 0; i3 < n2; ++i3) {
            bitArray.appendBits((int)object[i3], 8);
        }
        return;
    }

    static void appendAlphanumericBytes(CharSequence charSequence, BitArray bitArray) throws WriterException {
        int n2 = charSequence.length();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = Encoder.getAlphanumericCode(charSequence.charAt(n3));
            if (n4 != -1) {
                int n5 = n3 + 1;
                if (n5 < n2) {
                    if ((n5 = Encoder.getAlphanumericCode(charSequence.charAt(n5))) != -1) {
                        bitArray.appendBits(n4 * 45 + n5, 11);
                        n3 += 2;
                        continue;
                    }
                    throw new WriterException();
                }
                bitArray.appendBits(n4, 6);
                n3 = n5;
                continue;
            }
            throw new WriterException();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static void appendBytes(String charSequence, Mode mode, BitArray bitArray, String string2) throws WriterException {
        int n2 = 1.$SwitchMap$com$ailiwean$core$zxing$core$qrcode$decoder$Mode[mode.ordinal()];
        if (n2 == 1) {
            Encoder.appendNumericBytes(charSequence, bitArray);
            return;
        }
        if (n2 == 2) {
            Encoder.appendAlphanumericBytes(charSequence, bitArray);
            return;
        }
        if (n2 == 3) {
            Encoder.append8BitBytes((String)charSequence, bitArray, string2);
            return;
        }
        if (n2 == 4) {
            Encoder.appendKanjiBytes((String)charSequence, bitArray);
            return;
        }
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("Invalid mode: ");
        ((StringBuilder)charSequence).append((Object)mode);
        throw new WriterException(((StringBuilder)charSequence).toString());
    }

    private static void appendECI(CharacterSetECI characterSetECI, BitArray bitArray) {
        bitArray.appendBits(Mode.ECI.getBits(), 4);
        bitArray.appendBits(characterSetECI.getValue(), 8);
    }

    /*
     * Unable to fully structure code
     */
    static void appendKanjiBytes(String var0, BitArray var1_2) throws WriterException {
        try {
            var0 = var0.getBytes("Shift_JIS");
        }
        catch (UnsupportedEncodingException var0_1) {
            throw new WriterException(var0_1);
        }
        if (((Object)var0).length % 2 == 0) {
            var2_3 = ((Object)var0).length;
            for (var3_4 = 0; var3_4 < var2_3 - 1; var3_4 += 2) {
                var4_5 = (var0[var3_4] & 255) << 8 | var0[var3_4 + 1] & 255;
                var5_6 = 33088;
                if (var4_5 >= 33088 && var4_5 <= 40956) lbl-1000:
                // 2 sources

                {
                    while (true) {
                        var5_6 = var4_5 - var5_6;
                        break;
                    }
                } else {
                    if (var4_5 >= 57408 && var4_5 <= 60351) {
                        var5_6 = 49472;
                        ** continue;
                    }
                    var5_6 = -1;
                }
                if (var5_6 != -1) {
                    var1_2.appendBits((var5_6 >> 8) * 192 + (var5_6 & 255), 13);
                    continue;
                }
                throw new WriterException("Invalid byte sequence");
            }
            return;
        }
        throw new WriterException("Kanji byte size not even");
    }

    static void appendLengthInfo(int n2, Version object, Mode mode, BitArray bitArray) throws WriterException {
        int n3 = mode.getCharacterCountBits((Version)object);
        int n4 = 1 << n3;
        if (n2 < n4) {
            bitArray.appendBits(n2, n3);
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append(n2);
        ((StringBuilder)object).append(" is bigger than ");
        ((StringBuilder)object).append(n4 - 1);
        throw new WriterException(((StringBuilder)object).toString());
    }

    static void appendModeInfo(Mode mode, BitArray bitArray) {
        bitArray.appendBits(mode.getBits(), 4);
    }

    static void appendNumericBytes(CharSequence charSequence, BitArray bitArray) {
        int n2 = charSequence.length();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = charSequence.charAt(n3) - 48;
            int n5 = n3 + 2;
            if (n5 < n2) {
                bitArray.appendBits(n4 * 100 + (charSequence.charAt(n3 + 1) - 48) * 10 + (charSequence.charAt(n5) - 48), 10);
                n3 += 3;
                continue;
            }
            if (++n3 < n2) {
                bitArray.appendBits(n4 * 10 + (charSequence.charAt(n3) - 48), 7);
                n3 = n5;
                continue;
            }
            bitArray.appendBits(n4, 4);
        }
    }

    private static int calculateBitsNeeded(Mode mode, BitArray bitArray, BitArray bitArray2, Version version) {
        return bitArray.getSize() + mode.getCharacterCountBits(version) + bitArray2.getSize();
    }

    private static int calculateMaskPenalty(ByteMatrix byteMatrix) {
        return MaskUtil.applyMaskPenaltyRule1(byteMatrix) + MaskUtil.applyMaskPenaltyRule2(byteMatrix) + MaskUtil.applyMaskPenaltyRule3(byteMatrix) + MaskUtil.applyMaskPenaltyRule4(byteMatrix);
    }

    private static int chooseMaskPattern(BitArray bitArray, ErrorCorrectionLevel errorCorrectionLevel, Version version, ByteMatrix byteMatrix) throws WriterException {
        int n2 = Integer.MAX_VALUE;
        int n3 = -1;
        for (int i3 = 0; i3 < 8; ++i3) {
            MatrixUtil.buildMatrix(bitArray, errorCorrectionLevel, version, i3, byteMatrix);
            int n4 = Encoder.calculateMaskPenalty(byteMatrix);
            int n5 = n2;
            if (n4 < n2) {
                n3 = i3;
                n5 = n4;
            }
            n2 = n5;
        }
        return n3;
    }

    public static Mode chooseMode(String string2) {
        return Encoder.chooseMode(string2, null);
    }

    private static Mode chooseMode(String string2, String string3) {
        if ("Shift_JIS".equals(string3) && Encoder.isOnlyDoubleByteKanji(string2)) {
            return Mode.KANJI;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (int i3 = 0; i3 < string2.length(); ++i3) {
            char c3 = string2.charAt(i3);
            if (c3 >= '0' && c3 <= '9') {
                bl2 = true;
                continue;
            }
            if (Encoder.getAlphanumericCode(c3) != -1) {
                bl = true;
                continue;
            }
            return Mode.BYTE;
        }
        if (bl) {
            return Mode.ALPHANUMERIC;
        }
        if (bl2) {
            return Mode.NUMERIC;
        }
        return Mode.BYTE;
    }

    private static Version chooseVersion(int n2, ErrorCorrectionLevel errorCorrectionLevel) throws WriterException {
        for (int i3 = 1; i3 <= 40; ++i3) {
            Version version = Version.getVersionForNumber(i3);
            if (!Encoder.willFit(n2, version, errorCorrectionLevel)) continue;
            return version;
        }
        throw new WriterException("Data too big");
    }

    public static QRCode encode(String string2, ErrorCorrectionLevel errorCorrectionLevel) throws WriterException {
        return Encoder.encode(string2, errorCorrectionLevel, null);
    }

    public static QRCode encode(String object, ErrorCorrectionLevel errorCorrectionLevel, Map<EncodeHintType, ?> map) throws WriterException {
        Object object2;
        int n2 = 1;
        int n3 = map != null && map.containsKey((Object)EncodeHintType.CHARACTER_SET) ? 1 : 0;
        Object object3 = n3 != 0 ? map.get((Object)EncodeHintType.CHARACTER_SET).toString() : DEFAULT_BYTE_MODE_ENCODING;
        Object object4 = Encoder.chooseMode((String)object, (String)object3);
        Object object5 = new BitArray();
        if (object4 == Mode.BYTE && n3 != 0 && (object2 = CharacterSetECI.getCharacterSetECIByName((String)object3)) != null) {
            Encoder.appendECI((CharacterSetECI)((Object)object2), (BitArray)object5);
        }
        if ((n3 = map != null && map.containsKey((Object)EncodeHintType.GS1_FORMAT) ? n2 : 0) != 0 && Boolean.parseBoolean(map.get((Object)EncodeHintType.GS1_FORMAT).toString())) {
            Encoder.appendModeInfo(Mode.FNC1_FIRST_POSITION, (BitArray)object5);
        }
        Encoder.appendModeInfo(object4, (BitArray)object5);
        object2 = new BitArray();
        Encoder.appendBytes((String)object, object4, (BitArray)object2, (String)object3);
        if (map != null && map.containsKey((Object)EncodeHintType.QR_VERSION)) {
            object3 = Version.getVersionForNumber(Integer.parseInt(map.get((Object)EncodeHintType.QR_VERSION).toString()));
            if (!Encoder.willFit(Encoder.calculateBitsNeeded(object4, (BitArray)object5, (BitArray)object2, (Version)object3), (Version)object3, errorCorrectionLevel)) {
                throw new WriterException("Data too big for requested version");
            }
        } else {
            object3 = Encoder.recommendVersion(errorCorrectionLevel, object4, (BitArray)object5, (BitArray)object2);
        }
        BitArray bitArray = new BitArray();
        bitArray.appendBitArray((BitArray)object5);
        n3 = object4 == Mode.BYTE ? ((BitArray)object2).getSizeInBytes() : ((String)object).length();
        Encoder.appendLengthInfo(n3, (Version)object3, object4, bitArray);
        bitArray.appendBitArray((BitArray)object2);
        object = ((Version)object3).getECBlocksForLevel(errorCorrectionLevel);
        n3 = ((Version)object3).getTotalCodewords() - ((Version.ECBlocks)object).getTotalECCodewords();
        Encoder.terminateBits(n3, bitArray);
        object = Encoder.interleaveWithECBytes(bitArray, ((Version)object3).getTotalCodewords(), n3, ((Version.ECBlocks)object).getNumBlocks());
        object5 = new QRCode();
        ((QRCode)object5).setECLevel(errorCorrectionLevel);
        ((QRCode)object5).setMode((Mode)((Object)object4));
        ((QRCode)object5).setVersion((Version)object3);
        n3 = ((Version)object3).getDimensionForVersion();
        object4 = new ByteMatrix(n3, n3);
        if (map == null || !map.containsKey((Object)EncodeHintType.QR_MASK_PATTERN) || !QRCode.isValidMaskPattern(n3 = Integer.parseInt(map.get((Object)EncodeHintType.QR_MASK_PATTERN).toString()))) {
            n3 = -1;
        }
        n2 = n3;
        if (n3 == -1) {
            n2 = Encoder.chooseMaskPattern((BitArray)object, errorCorrectionLevel, (Version)object3, (ByteMatrix)object4);
        }
        ((QRCode)object5).setMaskPattern(n2);
        MatrixUtil.buildMatrix((BitArray)object, errorCorrectionLevel, (Version)object3, n2, (ByteMatrix)object4);
        ((QRCode)object5).setMatrix((ByteMatrix)object4);
        return object5;
    }

    static byte[] generateECBytes(byte[] byArray, int n2) {
        int n3;
        int n4 = byArray.length;
        int[] nArray = new int[n4 + n2];
        int n5 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            nArray[n3] = byArray[n3] & 0xFF;
        }
        new ReedSolomonEncoder(GenericGF.QR_CODE_FIELD_256).encode(nArray, n2);
        byArray = new byte[n2];
        for (n3 = n5; n3 < n2; ++n3) {
            byArray[n3] = (byte)nArray[n4 + n3];
        }
        return byArray;
    }

    static int getAlphanumericCode(int n2) {
        int[] nArray = ALPHANUMERIC_TABLE;
        if (n2 < nArray.length) {
            return nArray[n2];
        }
        return -1;
    }

    static void getNumDataBytesAndNumECBytesForBlockID(int n2, int n3, int n4, int n5, int[] nArray, int[] nArray2) throws WriterException {
        if (n5 < n4) {
            int n6 = n2 % n4;
            int n7 = n4 - n6;
            int n8 = n2 / n4;
            int n9 = n3 / n4;
            int n10 = n9 + 1;
            if ((n3 = n8 - n9) == (n8 = n8 + 1 - n10)) {
                if (n4 == n7 + n6) {
                    if (n2 == (n9 + n3) * n7 + (n10 + n8) * n6) {
                        if (n5 < n7) {
                            nArray[0] = n9;
                            nArray2[0] = n3;
                        } else {
                            nArray[0] = n10;
                            nArray2[0] = n8;
                        }
                        return;
                    }
                    throw new WriterException("Total bytes mismatch");
                }
                throw new WriterException("RS blocks mismatch");
            }
            throw new WriterException("EC bytes mismatch");
        }
        throw new WriterException("Block ID too large");
    }

    static BitArray interleaveWithECBytes(BitArray bitArray, int n2, int n3, int n4) throws WriterException {
        if (bitArray.getSizeInBytes() == n3) {
            Object object;
            Object object2;
            Serializable serializable = new ArrayList(n4);
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            for (int i3 = 0; i3 < n4; ++i3) {
                object2 = new int[1];
                Object[] objectArray = new int[1];
                Encoder.getNumDataBytesAndNumECBytesForBlockID(n2, n3, n4, i3, object2, objectArray);
                int n9 = object2[0];
                object = new byte[n9];
                bitArray.toBytes(n6 * 8, (byte[])object, 0, n9);
                objectArray = Encoder.generateECBytes((byte[])object, objectArray[0]);
                serializable.add(new BlockPair((byte[])object, (byte[])objectArray));
                n7 = Math.max(n7, n9);
                n8 = Math.max(n8, objectArray.length);
                n6 += object2[0];
            }
            if (n3 == n6) {
                bitArray = new BitArray();
                n4 = 0;
                while (true) {
                    if (n4 >= n7) break;
                    object = serializable.iterator();
                    while (object.hasNext()) {
                        object2 = ((BlockPair)object.next()).getDataBytes();
                        if (n4 >= ((int[])object2).length) continue;
                        bitArray.appendBits(object2[n4], 8);
                    }
                    ++n4;
                }
                for (n3 = n5; n3 < n8; ++n3) {
                    object2 = serializable.iterator();
                    while (object2.hasNext()) {
                        object = ((BlockPair)object2.next()).getErrorCorrectionBytes();
                        if (n3 >= ((Object)object).length) continue;
                        bitArray.appendBits((int)object[n3], 8);
                    }
                }
                if (n2 == bitArray.getSizeInBytes()) {
                    return bitArray;
                }
                serializable = new StringBuilder();
                ((StringBuilder)serializable).append("Interleaving error: ");
                ((StringBuilder)serializable).append(n2);
                ((StringBuilder)serializable).append(" and ");
                ((StringBuilder)serializable).append(bitArray.getSizeInBytes());
                ((StringBuilder)serializable).append(" differ.");
                throw new WriterException(((StringBuilder)serializable).toString());
            }
            throw new WriterException("Data bytes does not match offset");
        }
        throw new WriterException("Number of bits and data bytes does not match");
    }

    private static boolean isOnlyDoubleByteKanji(String object) {
        try {
            object = ((String)object).getBytes("Shift_JIS");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
        int n2 = ((Object)object).length;
        if (n2 % 2 != 0) {
            return false;
        }
        for (int i3 = 0; i3 < n2; i3 += 2) {
            int n3 = object[i3] & 0xFF;
            if (n3 >= 129 && n3 <= 159 || n3 >= 224 && n3 <= 235) {
                continue;
            }
            return false;
        }
        return true;
    }

    private static Version recommendVersion(ErrorCorrectionLevel errorCorrectionLevel, Mode mode, BitArray bitArray, BitArray bitArray2) throws WriterException {
        return Encoder.chooseVersion(Encoder.calculateBitsNeeded(mode, bitArray, bitArray2, Encoder.chooseVersion(Encoder.calculateBitsNeeded(mode, bitArray, bitArray2, Version.getVersionForNumber(1)), errorCorrectionLevel)), errorCorrectionLevel);
    }

    static void terminateBits(int n2, BitArray bitArray) throws WriterException {
        int n3 = n2 * 8;
        if (bitArray.getSize() <= n3) {
            int n4;
            int n5 = 0;
            for (n4 = 0; n4 < 4 && bitArray.getSize() < n3; ++n4) {
                bitArray.appendBit(false);
            }
            n4 = bitArray.getSize() & 7;
            if (n4 > 0) {
                while (n4 < 8) {
                    bitArray.appendBit(false);
                    ++n4;
                }
            }
            int n6 = bitArray.getSizeInBytes();
            for (n4 = n5; n4 < n2 - n6; ++n4) {
                n5 = (n4 & 1) == 0 ? 236 : 17;
                bitArray.appendBits(n5, 8);
            }
            if (bitArray.getSize() == n3) {
                return;
            }
            throw new WriterException("Bits size does not equal capacity");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("data bits cannot fit in the QR Code");
        stringBuilder.append(bitArray.getSize());
        stringBuilder.append(" > ");
        stringBuilder.append(n3);
        throw new WriterException(stringBuilder.toString());
    }

    private static boolean willFit(int n2, Version version, ErrorCorrectionLevel errorCorrectionLevel) {
        boolean bl = version.getTotalCodewords() - version.getECBlocksForLevel(errorCorrectionLevel).getTotalECCodewords() >= (n2 + 7) / 8;
        return bl;
    }
}

