/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.qrcode.encoder;

import java.util.Arrays;

public final class ByteMatrix {
    private final byte[][] bytes;
    private final int height;
    private final int width;

    public ByteMatrix(int n2, int n3) {
        this.bytes = new byte[n3][n2];
        this.width = n2;
        this.height = n3;
    }

    public void clear(byte by) {
        byte[][] byArray = this.bytes;
        int n2 = byArray.length;
        for (int i3 = 0; i3 < n2; ++i3) {
            Arrays.fill(byArray[i3], by);
        }
    }

    public byte get(int n2, int n3) {
        return this.bytes[n3][n2];
    }

    public byte[][] getArray() {
        return this.bytes;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void set(int n2, int n3, byte by) {
        this.bytes[n3][n2] = by;
    }

    public void set(int n2, int n3, int n4) {
        this.bytes[n3][n2] = (byte)n4;
    }

    public void set(int n2, int n3, boolean bl) {
        this.bytes[n3][n2] = (byte)(bl ? 1 : 0);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.width * 2 * this.height + 2);
        for (int i3 = 0; i3 < this.height; ++i3) {
            byte[] byArray = this.bytes[i3];
            for (int i4 = 0; i4 < this.width; ++i4) {
                byte by = byArray[i4];
                if (by != 0) {
                    if (by != 1) {
                        stringBuilder.append("  ");
                        continue;
                    }
                    stringBuilder.append(" 1");
                    continue;
                }
                stringBuilder.append(" 0");
            }
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }
}

