/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.qrcode.detector;

import android.os.Build;
import com.ailiwean.core.zxing.core.DecodeHintType;
import com.ailiwean.core.zxing.core.NotFoundException;
import com.ailiwean.core.zxing.core.ResultPoint;
import com.ailiwean.core.zxing.core.ResultPointCallback;
import com.ailiwean.core.zxing.core.common.BitMatrix;
import com.ailiwean.core.zxing.core.qrcode.detector.FinderPattern;
import com.ailiwean.core.zxing.core.qrcode.detector.FinderPatternInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class FinderPatternFinder2 {
    private static final int CENTER_QUORUM = 2;
    protected static final int MAX_MODULES = 97;
    protected static final int MIN_SKIP = 3;
    private static final EstimatedModuleComparator moduleComparator = new EstimatedModuleComparator();
    private final int[] clearStateCount;
    private final int[] crossCheckStateCount;
    private boolean hasSkipped;
    private final BitMatrix image;
    private final List<FinderPattern> possibleCenters;
    private final ResultPointCallback resultPointCallback;

    public FinderPatternFinder2(BitMatrix bitMatrix) {
        this(bitMatrix, null);
    }

    public FinderPatternFinder2(BitMatrix bitMatrix, ResultPointCallback resultPointCallback) {
        this.image = bitMatrix;
        this.possibleCenters = new ArrayList<FinderPattern>();
        this.crossCheckStateCount = new int[5];
        this.clearStateCount = new int[5];
        this.resultPointCallback = resultPointCallback;
    }

    private static float centerFromEnd(int[] nArray, int n2) {
        return (float)(n2 - nArray[4] - nArray[3]) - (float)nArray[2] / 2.0f;
    }

    private int[] clearBlackEdgeCount(int[] nArray) {
        int n2;
        this.doClearCopy(nArray);
        nArray = this.clearStateCount;
        nArray[4] = n2 = Math.min(nArray[0], nArray[4]);
        nArray[0] = n2;
        return this.clearStateCount;
    }

    private boolean crossCheckDiagonal(int n2, int n3) {
        int n4;
        int n5;
        int[] nArray = this.getCrossCheckStateCount();
        for (n5 = 0; n2 >= n5 && n3 >= n5 && this.image.get(n3 - n5, n2 - n5); ++n5) {
            nArray[2] = nArray[2] + 1;
        }
        if (nArray[2] == 0) {
            return false;
        }
        while (n2 >= n5 && n3 >= n5 && !this.image.get(n3 - n5, n2 - n5)) {
            nArray[1] = nArray[1] + 1;
            ++n5;
        }
        if (nArray[1] == 0) {
            return false;
        }
        while (n2 >= n5 && n3 >= n5 && this.image.get(n3 - n5, n2 - n5)) {
            nArray[0] = nArray[0] + 1;
            ++n5;
        }
        if (nArray[0] == 0) {
            return false;
        }
        int n6 = this.image.getHeight();
        int n7 = this.image.getWidth();
        int n8 = 1;
        while (true) {
            n4 = n2 + n8;
            n5 = n8;
            if (n4 >= n6) break;
            int n9 = n3 + n8;
            n5 = n8;
            if (n9 >= n7) break;
            n5 = n8++;
            if (!this.image.get(n9, n4)) break;
            nArray[2] = nArray[2] + 1;
        }
        while ((n8 = n2 + n5) < n6 && (n4 = n3 + n5) < n7 && !this.image.get(n4, n8)) {
            nArray[3] = nArray[3] + 1;
            ++n5;
        }
        if (nArray[3] == 0) {
            return false;
        }
        while ((n8 = n2 + n5) < n6 && (n4 = n3 + n5) < n7 && this.image.get(n4, n8)) {
            nArray[4] = nArray[4] + 1;
            ++n5;
        }
        if (nArray[4] != 0 && nArray[0] != 0) {
            nArray[4] = n2 = Math.min(nArray[0], nArray[4]);
            nArray[0] = n2;
        }
        if (nArray[4] == 0) {
            return false;
        }
        return FinderPatternFinder2.foundPatternDiagonal(nArray);
    }

    private float crossCheckHorizontal(int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        BitMatrix bitMatrix = this.image;
        int n8 = bitMatrix.getWidth();
        int[] nArray = this.getCrossCheckStateCount();
        for (n7 = n2; n7 >= 0 && bitMatrix.get(n7, n3); --n7) {
            nArray[2] = nArray[2] + 1;
        }
        float f3 = Float.NaN;
        if (n7 < 0) {
            return Float.NaN;
        }
        for (n6 = n7; n6 >= 0 && !bitMatrix.get(n6, n3) && nArray[1] <= n4; --n6) {
            nArray[1] = nArray[1] + 1;
        }
        float f4 = f3;
        if (n6 >= 0) {
            if (nArray[1] > n4) {
                f4 = f3;
            } else {
                while (n6 >= 0 && bitMatrix.get(n6, n3)) {
                    nArray[0] = nArray[0] + 1;
                    --n6;
                }
                for (n6 = n2 + 1; n6 < n8 && bitMatrix.get(n6, n3); ++n6) {
                    nArray[2] = nArray[2] + 1;
                }
                if (n6 == n8) {
                    return Float.NaN;
                }
                for (n2 = n6; n2 < n8 && !bitMatrix.get(n2, n3) && nArray[3] < n4; ++n2) {
                    nArray[3] = nArray[3] + 1;
                }
                f4 = f3;
                if (n2 != n8) {
                    if (nArray[3] >= n4) {
                        f4 = f3;
                    } else {
                        while (n2 < n8 && bitMatrix.get(n2, n3)) {
                            nArray[4] = nArray[4] + 1;
                            ++n2;
                        }
                        n3 = n2;
                        if (nArray[0] != 0) {
                            n3 = n2;
                            if (nArray[4] != 0) {
                                n3 = n2;
                                if (nArray[0] < nArray[4]) {
                                    n3 = n2 - (nArray[4] - nArray[0]);
                                }
                                nArray[4] = n2 = Math.min(nArray[0], nArray[4]);
                                nArray[0] = n2;
                            }
                        }
                        if (nArray[4] >= n4) {
                            return Float.NaN;
                        }
                        if (Math.abs(nArray[0] + nArray[1] + nArray[2] + nArray[3] + nArray[4] - n5) * 5 >= n5) {
                            return Float.NaN;
                        }
                        f4 = f3;
                        if (FinderPatternFinder2.foundPatternCross(nArray)) {
                            f4 = FinderPatternFinder2.centerFromEnd(nArray, n3);
                        }
                    }
                }
            }
        }
        return f4;
    }

    private float crossCheckVertical(int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        BitMatrix bitMatrix = this.image;
        int n8 = bitMatrix.getHeight();
        int[] nArray = this.getCrossCheckStateCount();
        for (n7 = n2; n7 >= 0 && bitMatrix.get(n3, n7); --n7) {
            nArray[2] = nArray[2] + 1;
        }
        float f3 = Float.NaN;
        if (n7 < 0) {
            return Float.NaN;
        }
        for (n6 = n7; n6 >= 0 && !bitMatrix.get(n3, n6) && nArray[1] <= n4; --n6) {
            nArray[1] = nArray[1] + 1;
        }
        float f4 = f3;
        if (n6 >= 0) {
            if (nArray[1] > n4) {
                f4 = f3;
            } else {
                while (n6 >= 0 && bitMatrix.get(n3, n6)) {
                    nArray[0] = nArray[0] + 1;
                    --n6;
                }
                for (n6 = n2 + 1; n6 < n8 && bitMatrix.get(n3, n6); ++n6) {
                    nArray[2] = nArray[2] + 1;
                }
                if (n6 == n8) {
                    return Float.NaN;
                }
                for (n2 = n6; n2 < n8 && !bitMatrix.get(n3, n2) && nArray[3] < n4; ++n2) {
                    nArray[3] = nArray[3] + 1;
                }
                f4 = f3;
                if (n2 != n8) {
                    if (nArray[3] >= n4) {
                        f4 = f3;
                    } else {
                        while (n2 < n8 && bitMatrix.get(n3, n2)) {
                            nArray[4] = nArray[4] + 1;
                            ++n2;
                        }
                        n3 = n2;
                        if (nArray[0] != 0) {
                            n3 = n2;
                            if (nArray[4] != 0) {
                                n3 = n2;
                                if (nArray[0] < nArray[4]) {
                                    n3 = n2 - (nArray[4] - nArray[0]);
                                }
                                nArray[4] = n2 = Math.min(nArray[0], nArray[4]);
                                nArray[0] = n2;
                            }
                        }
                        if (nArray[4] >= n4) {
                            return Float.NaN;
                        }
                        if (Math.abs(nArray[0] + nArray[1] + nArray[2] + nArray[3] + nArray[4] - n5) * 5 >= n5 * 2) {
                            return Float.NaN;
                        }
                        f4 = f3;
                        if (FinderPatternFinder2.foundPatternCross(nArray)) {
                            f4 = FinderPatternFinder2.centerFromEnd(nArray, n3);
                        }
                    }
                }
            }
        }
        return f4;
    }

    private void doClearCopy(int[] nArray) {
        System.arraycopy(nArray, 0, this.clearStateCount, 0, nArray.length);
    }

    protected static void doClearCounts(int[] nArray) {
        Arrays.fill(nArray, 0);
    }

    protected static void doShiftCounts2(int[] nArray) {
        nArray[0] = nArray[2];
        nArray[1] = nArray[3];
        nArray[2] = nArray[4];
        nArray[3] = 1;
        nArray[4] = 0;
    }

    private int findRowSkip() {
        if (this.possibleCenters.size() <= 1) {
            return 0;
        }
        FinderPattern finderPattern = null;
        for (FinderPattern finderPattern2 : this.possibleCenters) {
            if (finderPattern2.getCount() < 2) continue;
            if (finderPattern == null) {
                finderPattern = finderPattern2;
                continue;
            }
            this.hasSkipped = true;
            return (int)(Math.abs(finderPattern.getX() - finderPattern2.getX()) - Math.abs(finderPattern.getY() - finderPattern2.getY())) / 2;
        }
        return 0;
    }

    protected static boolean foundPatternCross(int[] nArray) {
        boolean bl = false;
        int n2 = 0;
        for (int i3 = 0; i3 < 5; ++i3) {
            int n3 = nArray[i3];
            if (n3 == 0) {
                return false;
            }
            n2 += n3;
        }
        if (n2 < 14) {
            return false;
        }
        float f3 = (float)n2 / 7.0f;
        float f4 = f3 / 2.0f;
        boolean bl2 = bl;
        if (Math.abs(f3 - (float)nArray[0]) < f4) {
            bl2 = bl;
            if (Math.abs(f3 - (float)nArray[1]) < f4) {
                bl2 = bl;
                if (Math.abs(f3 * 3.0f - (float)nArray[2]) < 3.0f * f4) {
                    bl2 = bl;
                    if (Math.abs(f3 - (float)nArray[3]) < f4) {
                        bl2 = bl;
                        if (Math.abs(f3 - (float)nArray[4]) < f4) {
                            bl2 = true;
                        }
                    }
                }
            }
        }
        return bl2;
    }

    protected static boolean foundPatternDiagonal(int[] nArray) {
        boolean bl = false;
        int n2 = 0;
        for (int i3 = 0; i3 < 5; ++i3) {
            int n3 = nArray[i3];
            if (n3 == 0) {
                return false;
            }
            n2 += n3;
        }
        if (n2 < 14) {
            return false;
        }
        float f3 = (float)n2 / 7.0f;
        float f4 = f3 / 1.333f;
        boolean bl2 = bl;
        if (Math.abs(f3 - (float)nArray[0]) < f4) {
            bl2 = bl;
            if (Math.abs(f3 - (float)nArray[1]) < f4) {
                bl2 = bl;
                if (Math.abs(f3 * 3.0f - (float)nArray[2]) < 3.0f * f4) {
                    bl2 = bl;
                    if (Math.abs(f3 - (float)nArray[3]) < f4) {
                        bl2 = bl;
                        if (Math.abs(f3 - (float)nArray[4]) < f4) {
                            bl2 = true;
                        }
                    }
                }
            }
        }
        return bl2;
    }

    private int getBlackEdgeOffset(int[] nArray) {
        if (((float)nArray[0] / (float)nArray[4] > 2.0f || (float)nArray[0] / (float)nArray[4] < 0.5f) && nArray[4] > nArray[0]) {
            return nArray[4] - nArray[0];
        }
        return 0;
    }

    private int[] getCrossCheckStateCount() {
        FinderPatternFinder2.doClearCounts(this.crossCheckStateCount);
        return this.crossCheckStateCount;
    }

    private boolean haveMultiplyConfirmedCenters() {
        Object object;
        int n2 = this.possibleCenters.size();
        Iterator<FinderPattern> iterator = this.possibleCenters.iterator();
        float f3 = 0.0f;
        boolean bl = false;
        int n3 = 0;
        float f4 = 0.0f;
        while (iterator.hasNext()) {
            object = iterator.next();
            if (((FinderPattern)object).getCount() < 2) continue;
            ++n3;
            f4 += ((FinderPattern)object).getEstimatedModuleSize();
        }
        if (n3 < 3) {
            return false;
        }
        float f5 = f4 / (float)n2;
        object = this.possibleCenters.iterator();
        while (object.hasNext()) {
            f3 += Math.abs(((FinderPattern)object.next()).getEstimatedModuleSize() - f5);
        }
        if (f3 <= f4 * 0.05f) {
            bl = true;
        }
        return bl;
    }

    private FinderPattern[] selectBestPatterns() throws NotFoundException {
        block6: {
            if (this.possibleCenters.size() < 3) break block6;
            if (Build.VERSION.SDK_INT >= 24) {
                this.possibleCenters.sort(moduleComparator);
            }
            FinderPattern[] finderPatternArray = new FinderPattern[3];
            double d3 = Double.MAX_VALUE;
            int n2 = 0;
            while (n2 < this.possibleCenters.size() - 2) {
                FinderPattern finderPattern = this.possibleCenters.get(n2);
                float f3 = finderPattern.getEstimatedModuleSize();
                int n3 = ++n2;
                while (n3 < this.possibleCenters.size() - 1) {
                    FinderPattern finderPattern2 = this.possibleCenters.get(n3);
                    double d4 = FinderPatternFinder2.squaredDistance(finderPattern, finderPattern2);
                    double d5 = d3;
                    for (int i3 = ++n3; i3 < this.possibleCenters.size(); ++i3) {
                        block8: {
                            double d6;
                            double d7;
                            FinderPattern finderPattern3;
                            block12: {
                                block16: {
                                    block14: {
                                        block15: {
                                            block13: {
                                                block9: {
                                                    block10: {
                                                        block11: {
                                                            block7: {
                                                                finderPattern3 = this.possibleCenters.get(i3);
                                                                if (!(finderPattern3.getEstimatedModuleSize() > 1.4f * f3)) break block7;
                                                                d3 = d5;
                                                                break block8;
                                                            }
                                                            d3 = FinderPatternFinder2.squaredDistance(finderPattern2, finderPattern3);
                                                            d7 = FinderPatternFinder2.squaredDistance(finderPattern, finderPattern3);
                                                            if (!(d4 < d3)) break block9;
                                                            if (!(d3 > d7)) break block10;
                                                            if (!(d4 < d7)) break block11;
                                                            d6 = d4;
                                                            break block12;
                                                        }
                                                        d6 = d7;
                                                        break block13;
                                                    }
                                                    d6 = d4;
                                                    double d8 = d3;
                                                    d3 = d7;
                                                    d7 = d8;
                                                    break block12;
                                                }
                                                if (!(d3 < d7)) break block14;
                                                if (!(d4 < d7)) break block15;
                                                d6 = d3;
                                                d3 = d7;
                                            }
                                            d7 = d4;
                                            break block12;
                                        }
                                        d6 = d3;
                                        break block16;
                                    }
                                    d6 = d7;
                                    d7 = d3;
                                }
                                d3 = d4;
                            }
                            d7 = Math.abs(d3 - d7 * 2.0) + Math.abs(d3 - d6 * 2.0);
                            d3 = d5;
                            if (d7 < d5) {
                                finderPatternArray[0] = finderPattern;
                                finderPatternArray[1] = finderPattern2;
                                finderPatternArray[2] = finderPattern3;
                                d3 = d7;
                            }
                        }
                        d5 = d3;
                    }
                    d3 = d5;
                }
            }
            if (d3 != Double.MAX_VALUE) {
                return finderPatternArray;
            }
            throw NotFoundException.getNotFoundInstance();
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static double squaredDistance(FinderPattern finderPattern, FinderPattern finderPattern2) {
        double d3 = finderPattern.getX() - finderPattern2.getX();
        double d4 = finderPattern.getY() - finderPattern2.getY();
        return d3 * d3 + d4 * d4;
    }

    @Deprecated
    protected final void clearCounts(int[] nArray) {
        FinderPatternFinder2.doClearCounts(nArray);
    }

    final FinderPatternInfo find(Map<DecodeHintType, ?> resultPointArray) throws NotFoundException {
        int n2 = resultPointArray != null && resultPointArray.containsKey((Object)DecodeHintType.TRY_HARDER) ? 1 : 0;
        int n3 = this.image.getHeight();
        int n4 = this.image.getWidth();
        Object object = n3 * 3 / 388;
        if (object < 3 || n2 != 0) {
            object = 3;
        }
        resultPointArray = (ResultPoint[])new int[5];
        boolean bl = false;
        for (Object object2 = object - 1; object2 < n3 && !bl; object2 += object) {
            FinderPatternFinder2.doClearCounts((int[])resultPointArray);
            int n5 = 0;
            int n6 = object;
            object = n5;
            for (n2 = 0; n2 < n4; ++n2) {
                if (this.image.get(n2, (int)object2)) {
                    n5 = object;
                    if ((object & 1) == 1) {
                        n5 = object + 1;
                    }
                    resultPointArray[n5] = resultPointArray[n5] + true;
                    object = n5;
                    continue;
                }
                if ((object & 1) == 0) {
                    if (object == 4) {
                        if (FinderPatternFinder2.foundPatternCross(this.clearBlackEdgeCount((int[])resultPointArray))) {
                            if (this.handlePossibleCenter(this.clearBlackEdgeCount((int[])resultPointArray), (int)object2, n2 - this.getBlackEdgeOffset((int[])resultPointArray))) {
                                boolean bl2;
                                if (this.hasSkipped) {
                                    bl2 = this.haveMultiplyConfirmedCenters();
                                    object = object2;
                                } else {
                                    n6 = this.findRowSkip();
                                    object = object2;
                                    bl2 = bl;
                                    if (n6 > resultPointArray[2]) {
                                        object = object2 + (n6 - resultPointArray[2] - 2);
                                        n2 = n4 - 1;
                                        bl2 = bl;
                                    }
                                }
                                FinderPatternFinder2.doClearCounts((int[])resultPointArray);
                                n5 = 0;
                                n6 = 2;
                                object2 = object;
                                object = n5;
                                bl = bl2;
                                continue;
                            }
                            FinderPatternFinder2.doShiftCounts2((int[])resultPointArray);
                        } else {
                            FinderPatternFinder2.doShiftCounts2((int[])resultPointArray);
                        }
                        object = 3;
                        continue;
                    }
                    resultPointArray[++object] = resultPointArray[object] + true;
                    continue;
                }
                resultPointArray[object] = resultPointArray[object] + true;
            }
            if (FinderPatternFinder2.foundPatternCross(this.clearBlackEdgeCount((int[])resultPointArray)) && this.handlePossibleCenter(this.clearBlackEdgeCount((int[])resultPointArray), (int)object2, n4 - this.getBlackEdgeOffset((int[])resultPointArray))) {
                object = resultPointArray[0];
                if (!this.hasSkipped) continue;
                bl = this.haveMultiplyConfirmedCenters();
                continue;
            }
            object = n6;
        }
        resultPointArray = this.selectBestPatterns();
        ResultPoint.orderBestPatterns(resultPointArray);
        return new FinderPatternInfo((FinderPattern[])resultPointArray);
    }

    protected final BitMatrix getImage() {
        return this.image;
    }

    protected final List<FinderPattern> getPossibleCenters() {
        return this.possibleCenters;
    }

    protected final boolean handlePossibleCenter(int[] object, int n2, int n3) {
        float f3;
        int n4 = 0;
        int n5 = object[0] + object[1] + object[2] + object[3] + object[4];
        float f4 = this.crossCheckVertical(n2, n3 = (int)FinderPatternFinder2.centerFromEnd((int[])object, n3), object[2], n5);
        if (!Float.isNaN(f4) && !Float.isNaN(f3 = this.crossCheckHorizontal(n3, n2 = (int)f4, object[2], n5)) && this.crossCheckDiagonal(n2, (int)f3)) {
            float f5 = (float)n5 / 7.0f;
            n2 = 0;
            while (true) {
                n3 = n4;
                if (n2 >= this.possibleCenters.size()) break;
                object = this.possibleCenters.get(n2);
                if (((FinderPattern)object).aboutEquals(f5, f4, f3)) {
                    this.possibleCenters.set(n2, ((FinderPattern)object).combineEstimate(f4, f3, f5));
                    n3 = 1;
                    break;
                }
                ++n2;
            }
            if (n3 == 0) {
                object = new FinderPattern(f3, f4, f5);
                this.possibleCenters.add((FinderPattern)object);
                ResultPointCallback resultPointCallback = this.resultPointCallback;
                if (resultPointCallback != null) {
                    resultPointCallback.foundPossibleResultPoint((ResultPoint)object);
                }
            }
            return true;
        }
        return false;
    }

    @Deprecated
    protected final boolean handlePossibleCenter(int[] nArray, int n2, int n3, boolean bl) {
        return this.handlePossibleCenter(nArray, n2, n3);
    }

    @Deprecated
    protected final void shiftCounts2(int[] nArray) {
        FinderPatternFinder2.doShiftCounts2(nArray);
    }

    private static final class EstimatedModuleComparator
    implements Comparator<FinderPattern>,
    Serializable {
        private EstimatedModuleComparator() {
        }

        @Override
        public int compare(FinderPattern finderPattern, FinderPattern finderPattern2) {
            return Float.compare(finderPattern.getEstimatedModuleSize(), finderPattern2.getEstimatedModuleSize());
        }
    }
}

