/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.qrcode.detector;

import com.ailiwean.core.zxing.core.DecodeHintType;
import com.ailiwean.core.zxing.core.FormatException;
import com.ailiwean.core.zxing.core.NotFoundException;
import com.ailiwean.core.zxing.core.ResultPoint;
import com.ailiwean.core.zxing.core.ResultPointCallback;
import com.ailiwean.core.zxing.core.common.BitMatrix;
import com.ailiwean.core.zxing.core.common.DetectorResult;
import com.ailiwean.core.zxing.core.common.GridSampler;
import com.ailiwean.core.zxing.core.common.PerspectiveTransform;
import com.ailiwean.core.zxing.core.common.detector.MathUtils;
import com.ailiwean.core.zxing.core.qrcode.decoder.Version;
import com.ailiwean.core.zxing.core.qrcode.detector.AlignmentPattern;
import com.ailiwean.core.zxing.core.qrcode.detector.AlignmentPatternFinder;
import com.ailiwean.core.zxing.core.qrcode.detector.FinderPattern;
import com.ailiwean.core.zxing.core.qrcode.detector.FinderPatternFinder;
import com.ailiwean.core.zxing.core.qrcode.detector.FinderPatternInfo;
import java.util.Map;

public class Detector {
    private final BitMatrix image;
    private ResultPointCallback resultPointCallback;

    public Detector(BitMatrix bitMatrix) {
        this.image = bitMatrix;
    }

    private float calculateModuleSizeOneWay(ResultPoint resultPoint, ResultPoint resultPoint2) {
        float f3 = this.sizeOfBlackWhiteBlackRunBothWays((int)resultPoint.getX(), (int)resultPoint.getY(), (int)resultPoint2.getX(), (int)resultPoint2.getY());
        float f4 = this.sizeOfBlackWhiteBlackRunBothWays((int)resultPoint2.getX(), (int)resultPoint2.getY(), (int)resultPoint.getX(), (int)resultPoint.getY());
        if (Float.isNaN(f3)) {
            return f4 / 7.0f;
        }
        if (Float.isNaN(f4)) {
            return f3 / 7.0f;
        }
        return (f3 + f4) / 14.0f;
    }

    private static int computeDimension(ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, float f3) throws NotFoundException {
        int n2 = (MathUtils.round(ResultPoint.distance(resultPoint, resultPoint2) / f3) + MathUtils.round(ResultPoint.distance(resultPoint, resultPoint3) / f3)) / 2 + 7;
        int n3 = n2 & 3;
        if (n3 != 0) {
            if (n3 != 2) {
                if (n3 == 3) {
                    throw NotFoundException.getNotFoundInstance();
                }
            } else {
                --n2;
            }
        } else {
            ++n2;
        }
        return n2;
    }

    private static PerspectiveTransform createTransform(ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, ResultPoint resultPoint4, int n2) {
        float f3;
        float f4;
        float f5;
        float f6 = (float)n2 - 3.5f;
        if (resultPoint4 != null) {
            f5 = resultPoint4.getX();
            f4 = resultPoint4.getY();
            f3 = f6 - 3.0f;
        } else {
            float f7 = resultPoint2.getX();
            f5 = resultPoint.getX();
            float f8 = resultPoint3.getX();
            float f9 = resultPoint2.getY();
            f4 = resultPoint.getY();
            f3 = resultPoint3.getY();
            f5 = f7 - f5 + f8;
            f4 = f9 - f4 + f3;
            f3 = f6;
        }
        return PerspectiveTransform.quadrilateralToQuadrilateral(3.5f, 3.5f, f6, 3.5f, f3, f3, 3.5f, f6, resultPoint.getX(), resultPoint.getY(), resultPoint2.getX(), resultPoint2.getY(), f5, f4, resultPoint3.getX(), resultPoint3.getY());
    }

    private static BitMatrix sampleGrid(BitMatrix bitMatrix, PerspectiveTransform perspectiveTransform, int n2) throws NotFoundException {
        return GridSampler.getInstance().sampleGrid(bitMatrix, n2, n2, perspectiveTransform);
    }

    private float sizeOfBlackWhiteBlackRun(int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        block9: {
            int n9;
            n8 = Math.abs(n5 - n3) > Math.abs(n4 - n2) ? 1 : 0;
            if (n8 != 0) {
                n9 = n2;
                n2 = n5;
                n5 = n3;
                n7 = n4;
                n4 = n9;
            } else {
                n9 = n3;
                n3 = n4;
                n4 = n9;
                n7 = n5;
                n5 = n2;
                n2 = n3;
            }
            int n10 = Math.abs(n2 - n5);
            int n11 = Math.abs(n7 - n4);
            int n12 = -n10 / 2;
            int n13 = -1;
            int n14 = n5 < n2 ? 1 : -1;
            if (n4 < n7) {
                n13 = 1;
            }
            n6 = n2 + n14;
            n3 = n4;
            n9 = 0;
            int n15 = n8;
            for (n2 = n5; n2 != n6; n2 += n14) {
                int n16 = n15 != 0 ? n3 : n2;
                int n17 = n15 != 0 ? n2 : n3;
                boolean bl = n9 == 1;
                n8 = n9;
                if (bl == this.image.get(n16, n17)) {
                    if (n9 == 2) {
                        return MathUtils.distance(n2, n3, n5, n4);
                    }
                    n8 = n9 + 1;
                }
                n16 = n12 + n11;
                n9 = n3;
                n12 = n16;
                if (n16 > 0) {
                    if (n3 == n7) break block9;
                    n9 = n3 + n13;
                    n12 = n16 - n10;
                }
                n3 = n9;
                n9 = n8;
            }
            n8 = n9;
        }
        if (n8 == 2) {
            return MathUtils.distance(n6, n7, n5, n4);
        }
        return Float.NaN;
    }

    private float sizeOfBlackWhiteBlackRunBothWays(int n2, int n3, int n4, int n5) {
        float f3;
        float f4 = this.sizeOfBlackWhiteBlackRun(n2, n3, n4, n5);
        n4 = n2 - (n4 - n2);
        int n6 = 0;
        if (n4 < 0) {
            f3 = (float)n2 / (float)(n2 - n4);
            n4 = 0;
        } else if (n4 >= this.image.getWidth()) {
            f3 = (float)(this.image.getWidth() - 1 - n2) / (float)(n4 - n2);
            n4 = this.image.getWidth() - 1;
        } else {
            f3 = 1.0f;
        }
        float f5 = n3;
        n5 = (int)(f5 - (float)(n5 - n3) * f3);
        if (n5 < 0) {
            f3 = f5 / (float)(n3 - n5);
            n5 = n6;
        } else if (n5 >= this.image.getHeight()) {
            f3 = (float)(this.image.getHeight() - 1 - n3) / (float)(n5 - n3);
            n5 = this.image.getHeight() - 1;
        } else {
            f3 = 1.0f;
        }
        return f4 + this.sizeOfBlackWhiteBlackRun(n2, n3, (int)((float)n2 + (float)(n4 - n2) * f3), n5) - 1.0f;
    }

    protected final float calculateModuleSize(ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3) {
        return (this.calculateModuleSizeOneWay(resultPoint, resultPoint2) + this.calculateModuleSizeOneWay(resultPoint, resultPoint3)) / 2.0f;
    }

    public DetectorResult detect() throws NotFoundException, FormatException {
        return this.detect(null);
    }

    public final DetectorResult detect(Map<DecodeHintType, ?> map) throws NotFoundException, FormatException {
        ResultPointCallback resultPointCallback = map == null ? null : (ResultPointCallback)map.get((Object)DecodeHintType.NEED_RESULT_POINT_CALLBACK);
        this.resultPointCallback = resultPointCallback;
        return this.processFinderPatternInfo(new FinderPatternFinder(this.image, this.resultPointCallback).find(map));
    }

    protected final AlignmentPattern findAlignmentInRegion(float f3, int n2, int n3, float f4) throws NotFoundException {
        float f5;
        int n4 = (int)(f4 * f3);
        int n5 = Math.max(0, n2 - n4);
        int n6 = Math.min(this.image.getWidth() - 1, n2 + n4) - n5;
        f4 = n6;
        if (!(f4 < (f5 = 3.0f * f3))) {
            n2 = Math.max(0, n3 - n4);
            n3 = Math.min(this.image.getHeight() - 1, n3 + n4) - n2;
            if (!((float)n3 < f5)) {
                return new AlignmentPatternFinder(this.image, n5, n2, n6, n3, f3, this.resultPointCallback).find();
            }
            throw NotFoundException.getNotFoundInstance();
        }
        throw NotFoundException.getNotFoundInstance();
    }

    protected final BitMatrix getImage() {
        return this.image;
    }

    protected final ResultPointCallback getResultPointCallback() {
        return this.resultPointCallback;
    }

    protected final DetectorResult processFinderPatternInfo(FinderPatternInfo object) throws NotFoundException, FormatException {
        FinderPattern finderPattern;
        FinderPattern finderPattern2;
        FinderPattern finderPattern3 = object.getTopLeft();
        float f3 = this.calculateModuleSize(finderPattern3, finderPattern2 = object.getTopRight(), finderPattern = object.getBottomLeft());
        if (!(f3 < 1.0f)) {
            int n2 = Detector.computeDimension(finderPattern3, finderPattern2, finderPattern, f3);
            Version version = Version.getProvisionalVersionForDimension(n2);
            int n3 = version.getDimensionForVersion();
            Object object2 = null;
            object = object2;
            if (version.getAlignmentPatternCenters().length > 0) {
                float f4 = finderPattern2.getX();
                float f5 = finderPattern3.getX();
                float f6 = finderPattern.getX();
                float f7 = finderPattern2.getY();
                float f8 = finderPattern3.getY();
                float f9 = finderPattern.getY();
                float f10 = 1.0f - 3.0f / (float)(n3 - 7);
                int n4 = (int)(finderPattern3.getX() + (f4 - f5 + f6 - finderPattern3.getX()) * f10);
                int n5 = (int)(finderPattern3.getY() + f10 * (f7 - f8 + f9 - finderPattern3.getY()));
                n3 = 4;
                while (true) {
                    object = object2;
                    if (n3 > 16) break;
                    f4 = n3;
                    try {
                        object = this.findAlignmentInRegion(f3, n4, n5, f4);
                    }
                    catch (NotFoundException notFoundException) {
                        n3 <<= 1;
                        continue;
                    }
                    break;
                }
            }
            object2 = Detector.createTransform(finderPattern3, finderPattern2, finderPattern, (ResultPoint)object, n2);
            object2 = Detector.sampleGrid(this.image, (PerspectiveTransform)object2, n2);
            object = object == null ? new ResultPoint[]{finderPattern, finderPattern3, finderPattern2} : new ResultPoint[]{finderPattern, finderPattern3, finderPattern2, object};
            return new DetectorResult((BitMatrix)object2, (ResultPoint[])object);
        }
        throw NotFoundException.getNotFoundInstance();
    }
}

