/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.qrcode.detector;

import com.ailiwean.core.zxing.core.NotFoundException;
import com.ailiwean.core.zxing.core.ResultPointCallback;
import com.ailiwean.core.zxing.core.common.BitMatrix;
import com.ailiwean.core.zxing.core.qrcode.detector.AlignmentPattern;
import java.util.ArrayList;
import java.util.List;

final class AlignmentPatternFinder {
    private final int[] crossCheckStateCount;
    private final int height;
    private final BitMatrix image;
    private final float moduleSize;
    private final List<AlignmentPattern> possibleCenters;
    private final ResultPointCallback resultPointCallback;
    private final int startX;
    private final int startY;
    private final int width;

    AlignmentPatternFinder(BitMatrix bitMatrix, int n2, int n3, int n4, int n5, float f3, ResultPointCallback resultPointCallback) {
        this.image = bitMatrix;
        this.possibleCenters = new ArrayList<AlignmentPattern>(5);
        this.startX = n2;
        this.startY = n3;
        this.width = n4;
        this.height = n5;
        this.moduleSize = f3;
        this.crossCheckStateCount = new int[3];
        this.resultPointCallback = resultPointCallback;
    }

    private static float centerFromEnd(int[] nArray, int n2) {
        return (float)(n2 - nArray[2]) - (float)nArray[1] / 2.0f;
    }

    private float crossCheckVertical(int n2, int n3, int n4, int n5) {
        float f3;
        int n6;
        BitMatrix bitMatrix = this.image;
        int n7 = bitMatrix.getHeight();
        int[] nArray = this.crossCheckStateCount;
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        for (n6 = n2; n6 >= 0 && bitMatrix.get(n3, n6) && nArray[1] <= n4; --n6) {
            nArray[1] = nArray[1] + 1;
        }
        float f4 = f3 = Float.NaN;
        if (n6 >= 0) {
            if (nArray[1] > n4) {
                f4 = f3;
            } else {
                while (n6 >= 0 && !bitMatrix.get(n3, n6) && nArray[0] <= n4) {
                    nArray[0] = nArray[0] + 1;
                    --n6;
                }
                if (nArray[0] > n4) {
                    return Float.NaN;
                }
                ++n2;
                while (n2 < n7 && bitMatrix.get(n3, n2) && nArray[1] <= n4) {
                    nArray[1] = nArray[1] + 1;
                    ++n2;
                }
                f4 = f3;
                if (n2 != n7) {
                    if (nArray[1] > n4) {
                        f4 = f3;
                    } else {
                        while (n2 < n7 && !bitMatrix.get(n3, n2) && nArray[2] <= n4) {
                            nArray[2] = nArray[2] + 1;
                            ++n2;
                        }
                        if (nArray[2] > n4) {
                            return Float.NaN;
                        }
                        if (Math.abs(nArray[0] + nArray[1] + nArray[2] - n5) * 5 >= n5 * 2) {
                            return Float.NaN;
                        }
                        f4 = f3;
                        if (this.foundPatternCross(nArray)) {
                            f4 = AlignmentPatternFinder.centerFromEnd(nArray, n2);
                        }
                    }
                }
            }
        }
        return f4;
    }

    private boolean foundPatternCross(int[] nArray) {
        float f3 = this.moduleSize;
        float f4 = f3 / 2.0f;
        for (int i3 = 0; i3 < 3; ++i3) {
            if (!(Math.abs(f3 - (float)nArray[i3]) >= f4)) continue;
            return false;
        }
        return true;
    }

    private AlignmentPattern handlePossibleCenter(int[] object, int n2, int n3) {
        int n4 = object[0];
        int n5 = object[1];
        int n6 = object[2];
        float f3 = AlignmentPatternFinder.centerFromEnd((int[])object, n3);
        float f4 = this.crossCheckVertical(n2, (int)f3, object[1] * 2, n4 + n5 + n6);
        if (!Float.isNaN(f4)) {
            AlignmentPattern alignmentPattern;
            float f5 = (float)(object[0] + object[1] + object[2]) / 3.0f;
            object = this.possibleCenters.iterator();
            while (object.hasNext()) {
                alignmentPattern = (AlignmentPattern)object.next();
                if (!alignmentPattern.aboutEquals(f5, f4, f3)) continue;
                return alignmentPattern.combineEstimate(f4, f3, f5);
            }
            alignmentPattern = new AlignmentPattern(f3, f4, f5);
            this.possibleCenters.add(alignmentPattern);
            object = this.resultPointCallback;
            if (object != null) {
                object.foundPossibleResultPoint(alignmentPattern);
            }
        }
        return null;
    }

    AlignmentPattern find() throws NotFoundException {
        int n2 = this.startX;
        int n3 = this.height;
        int n4 = this.width + n2;
        int n5 = this.startY;
        int n6 = n3 / 2;
        int[] nArray = new int[3];
        for (int i3 = 0; i3 < n3; ++i3) {
            AlignmentPattern alignmentPattern;
            int n7;
            int n8 = (i3 & 1) == 0 ? (i3 + 1) / 2 : -((i3 + 1) / 2);
            int n9 = n8 + (n5 + n6);
            nArray[0] = 0;
            nArray[1] = 0;
            nArray[2] = 0;
            for (n7 = n2; n7 < n4 && !this.image.get(n7, n9); ++n7) {
            }
            n8 = 0;
            for (int i4 = n7; i4 < n4; ++i4) {
                if (this.image.get(i4, n9)) {
                    if (n8 == 1) {
                        nArray[1] = nArray[1] + 1;
                        continue;
                    }
                    if (n8 == 2) {
                        if (this.foundPatternCross(nArray) && (alignmentPattern = this.handlePossibleCenter(nArray, n9, i4)) != null) {
                            return alignmentPattern;
                        }
                        nArray[0] = nArray[2];
                        nArray[1] = 1;
                        nArray[2] = 0;
                        n8 = 1;
                        continue;
                    }
                    nArray[++n8] = nArray[n8] + 1;
                    continue;
                }
                n7 = n8;
                if (n8 == 1) {
                    n7 = n8 + 1;
                }
                nArray[n7] = nArray[n7] + 1;
                n8 = n7;
            }
            if (!this.foundPatternCross(nArray) || (alignmentPattern = this.handlePossibleCenter(nArray, n9, n4)) == null) continue;
            return alignmentPattern;
        }
        if (!this.possibleCenters.isEmpty()) {
            return this.possibleCenters.get(0);
        }
        throw NotFoundException.getNotFoundInstance();
    }
}

