/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.qrcode.decoder;

import com.ailiwean.core.zxing.core.qrcode.decoder.ErrorCorrectionLevel;

final class FormatInformation {
    private static final int[][] FORMAT_INFO_DECODE_LOOKUP;
    private static final int FORMAT_INFO_MASK_QR = 21522;
    private final byte dataMask;
    private final ErrorCorrectionLevel errorCorrectionLevel;

    static {
        int[] nArray = new int[]{21522, 0};
        int[] nArray2 = new int[]{20773, 1};
        int[] nArray3 = new int[]{24188, 2};
        int[] nArray4 = new int[]{23371, 3};
        int[] nArray5 = new int[]{17913, 4};
        int[] nArray6 = new int[]{16590, 5};
        int[] nArray7 = new int[]{20375, 6};
        int[] nArray8 = new int[]{19104, 7};
        int[] nArray9 = new int[]{30660, 8};
        int[] nArray10 = new int[]{29427, 9};
        int[] nArray11 = new int[]{32170, 10};
        int[] nArray12 = new int[]{30877, 11};
        int[] nArray13 = new int[]{26159, 12};
        int[] nArray14 = new int[]{25368, 13};
        int[] nArray15 = new int[]{27713, 14};
        int[] nArray16 = new int[]{26998, 15};
        int[] nArray17 = new int[]{5769, 16};
        int[] nArray18 = new int[]{5054, 17};
        int[] nArray19 = new int[]{6608, 19};
        int[] nArray20 = new int[]{1890, 20};
        int[] nArray21 = new int[]{597, 21};
        int[] nArray22 = new int[]{13663, 24};
        int[] nArray23 = new int[]{12392, 25};
        int[] nArray24 = new int[]{16177, 26};
        int[] nArray25 = new int[]{8579, 29};
        int[] nArray26 = new int[]{11994, 30};
        int[] nArray27 = new int[]{11245, 31};
        FORMAT_INFO_DECODE_LOOKUP = new int[][]{nArray, nArray2, nArray3, nArray4, nArray5, nArray6, nArray7, nArray8, nArray9, nArray10, nArray11, nArray12, nArray13, nArray14, nArray15, nArray16, nArray17, nArray18, {7399, 18}, nArray19, nArray20, nArray21, {3340, 22}, {2107, 23}, nArray22, nArray23, nArray24, {14854, 27}, {9396, 28}, nArray25, nArray26, nArray27};
    }

    private FormatInformation(int n2) {
        this.errorCorrectionLevel = ErrorCorrectionLevel.forBits(n2 >> 3 & 3);
        this.dataMask = (byte)(n2 & 7);
    }

    static FormatInformation decodeFormatInformation(int n2, int n3) {
        FormatInformation formatInformation = FormatInformation.doDecodeFormatInformation(n2, n3);
        if (formatInformation != null) {
            return formatInformation;
        }
        return FormatInformation.doDecodeFormatInformation(n2 ^ 0x5412, n3 ^ 0x5412);
    }

    private static FormatInformation doDecodeFormatInformation(int n2, int n3) {
        int[][] nArray = FORMAT_INFO_DECODE_LOOKUP;
        int n4 = nArray.length;
        int n5 = Integer.MAX_VALUE;
        int n6 = 0;
        for (int i3 = 0; i3 < n4; ++i3) {
            int[] nArray2 = nArray[i3];
            int n7 = nArray2[0];
            if (n7 != n2 && n7 != n3) {
                int n8 = FormatInformation.numBitsDiffering(n2, n7);
                int n9 = n5;
                if (n8 < n5) {
                    n6 = nArray2[1];
                    n9 = n8;
                }
                n5 = n9;
                n8 = n6;
                if (n2 != n3) {
                    n7 = FormatInformation.numBitsDiffering(n3, n7);
                    n5 = n9;
                    n8 = n6;
                    if (n7 < n9) {
                        n8 = nArray2[1];
                        n5 = n7;
                    }
                }
                n6 = n8;
                continue;
            }
            return new FormatInformation(nArray2[1]);
        }
        if (n5 <= 3) {
            return new FormatInformation(n6);
        }
        return null;
    }

    static int numBitsDiffering(int n2, int n3) {
        return Integer.bitCount(n2 ^ n3);
    }

    public boolean equals(Object object) {
        boolean bl = object instanceof FormatInformation;
        boolean bl2 = false;
        if (!bl) {
            return false;
        }
        object = (FormatInformation)object;
        bl = bl2;
        if (this.errorCorrectionLevel == ((FormatInformation)object).errorCorrectionLevel) {
            bl = bl2;
            if (this.dataMask == ((FormatInformation)object).dataMask) {
                bl = true;
            }
        }
        return bl;
    }

    byte getDataMask() {
        return this.dataMask;
    }

    ErrorCorrectionLevel getErrorCorrectionLevel() {
        return this.errorCorrectionLevel;
    }

    public int hashCode() {
        return this.errorCorrectionLevel.ordinal() << 3 | this.dataMask;
    }
}

