/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.qrcode.decoder;

import com.ailiwean.core.zxing.core.ChecksumException;
import com.ailiwean.core.zxing.core.DecodeHintType;
import com.ailiwean.core.zxing.core.FormatException;
import com.ailiwean.core.zxing.core.common.BitMatrix;
import com.ailiwean.core.zxing.core.common.DecoderResult;
import com.ailiwean.core.zxing.core.common.reedsolomon.GenericGF;
import com.ailiwean.core.zxing.core.common.reedsolomon.ReedSolomonDecoder;
import com.ailiwean.core.zxing.core.common.reedsolomon.ReedSolomonException;
import com.ailiwean.core.zxing.core.qrcode.decoder.BitMatrixParser;
import com.ailiwean.core.zxing.core.qrcode.decoder.DataBlock;
import com.ailiwean.core.zxing.core.qrcode.decoder.DecodedBitStreamParser;
import com.ailiwean.core.zxing.core.qrcode.decoder.ErrorCorrectionLevel;
import com.ailiwean.core.zxing.core.qrcode.decoder.QRCodeDecoderMetaData;
import com.ailiwean.core.zxing.core.qrcode.decoder.Version;
import java.util.Map;

public final class Decoder {
    private final ReedSolomonDecoder rsDecoder = new ReedSolomonDecoder(GenericGF.QR_CODE_FIELD_256);

    private void correctErrors(byte[] byArray, int n2) throws ChecksumException {
        int n3;
        int n4 = byArray.length;
        int[] nArray = new int[n4];
        int n5 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            nArray[n3] = byArray[n3] & 0xFF;
        }
        try {
            this.rsDecoder.decode(nArray, byArray.length - n2);
        }
        catch (ReedSolomonException reedSolomonException) {
            throw ChecksumException.getChecksumInstance();
        }
        for (n3 = n5; n3 < n2; ++n3) {
            byArray[n3] = (byte)nArray[n3];
        }
        return;
    }

    private DecoderResult decode(BitMatrixParser object, Map<DecodeHintType, ?> map) throws FormatException, ChecksumException {
        int n2;
        Version version = ((BitMatrixParser)object).readVersion();
        ErrorCorrectionLevel errorCorrectionLevel = ((BitMatrixParser)object).readFormatInformation().getErrorCorrectionLevel();
        DataBlock[] dataBlockArray = DataBlock.getDataBlocks(((BitMatrixParser)object).readCodewords(), version, errorCorrectionLevel);
        int n3 = dataBlockArray.length;
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            n4 += dataBlockArray[n2].getNumDataCodewords();
        }
        byte[] byArray = new byte[n4];
        int n5 = dataBlockArray.length;
        n2 = 0;
        for (n4 = 0; n4 < n5; ++n4) {
            DataBlock dataBlock = dataBlockArray[n4];
            object = dataBlock.getCodewords();
            int n6 = dataBlock.getNumDataCodewords();
            this.correctErrors((byte[])object, n6);
            n3 = 0;
            while (n3 < n6) {
                byArray[n2] = (byte)object[n3];
                ++n3;
                ++n2;
            }
        }
        return DecodedBitStreamParser.decode(byArray, version, errorCorrectionLevel, map);
    }

    public DecoderResult decode(BitMatrix bitMatrix) throws ChecksumException, FormatException {
        return this.decode(bitMatrix, null);
    }

    public DecoderResult decode(BitMatrix bitMatrix, Map<DecodeHintType, ?> object) throws FormatException, ChecksumException {
        Object var4_8;
        Object object2 = new BitMatrixParser(bitMatrix);
        bitMatrix = null;
        try {
            DecoderResult decoderResult = this.decode((BitMatrixParser)object2, (Map<DecodeHintType, ?>)object);
            return decoderResult;
        }
        catch (ChecksumException checksumException) {
        }
        catch (FormatException formatException) {
            var4_8 = null;
        }
        try {
            ((BitMatrixParser)object2).remask();
            ((BitMatrixParser)object2).setMirror(true);
            ((BitMatrixParser)object2).readVersion();
            ((BitMatrixParser)object2).readFormatInformation();
            ((BitMatrixParser)object2).mirror();
            object = this.decode((BitMatrixParser)object2, (Map<DecodeHintType, ?>)object);
            object2 = new QRCodeDecoderMetaData(true);
            ((DecoderResult)object).setOther(object2);
            return object;
        }
        catch (ChecksumException | FormatException readerException) {
            if (bitMatrix != null) {
                throw bitMatrix;
            }
            throw var4_8;
        }
    }

    public DecoderResult decode(boolean[][] blArray) throws ChecksumException, FormatException {
        return this.decode(blArray, null);
    }

    public DecoderResult decode(boolean[][] blArray, Map<DecodeHintType, ?> map) throws ChecksumException, FormatException {
        return this.decode(BitMatrix.parse(blArray), map);
    }
}

