/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.qrcode.decoder;

import com.ailiwean.core.zxing.core.DecodeHintType;
import com.ailiwean.core.zxing.core.FormatException;
import com.ailiwean.core.zxing.core.common.BitSource;
import com.ailiwean.core.zxing.core.common.CharacterSetECI;
import com.ailiwean.core.zxing.core.common.DecoderResult;
import com.ailiwean.core.zxing.core.common.StringUtils;
import com.ailiwean.core.zxing.core.qrcode.decoder.ErrorCorrectionLevel;
import com.ailiwean.core.zxing.core.qrcode.decoder.Mode;
import com.ailiwean.core.zxing.core.qrcode.decoder.Version;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

final class DecodedBitStreamParser {
    private static final char[] ALPHANUMERIC_CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ $%*+-./:".toCharArray();
    private static final int GB2312_SUBSET = 1;

    private DecodedBitStreamParser() {
    }

    /*
     * Handled duff style switch with additional control
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static DecoderResult decode(byte[] byArray, Version arrayList, ErrorCorrectionLevel object, Map<DecodeHintType, ?> object2) throws FormatException {
        BitSource bitSource = new BitSource(byArray);
        StringBuilder stringBuilder = new StringBuilder(50);
        ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>(1);
        CharacterSetECI characterSetECI = null;
        boolean bl = false;
        int n2 = -1;
        int n3 = -1;
        try {
            Enum enum_;
            Mode mode;
            block9: do {
                int n4;
                block16: {
                    block17: {
                        block18: {
                            int n5;
                            block15: {
                                mode = bitSource.available() < 4 ? Mode.TERMINATOR : Mode.forBits(bitSource.readBits(4));
                                enum_ = characterSetECI;
                                n5 = n2;
                                n4 = n3;
                                int n6 = 0;
                                block10: do {
                                    switch (n6 == 0 ? 1.$SwitchMap$com$ailiwean$core$zxing$core$qrcode$decoder$Mode[mode.ordinal()] : n6) {
                                        default: {
                                            n4 = mode.getCharacterCountBits((Version)((Object)arrayList));
                                            break;
                                        }
                                        case 10: {
                                            int n7 = bitSource.readBits(4);
                                            int n8 = bitSource.readBits(mode.getCharacterCountBits((Version)((Object)arrayList)));
                                            enum_ = characterSetECI;
                                            n5 = n2;
                                            n4 = n3;
                                            n6 = 5;
                                            if (n7 != 1) continue block10;
                                            DecodedBitStreamParser.decodeHanziSegment(bitSource, stringBuilder, n8);
                                            enum_ = characterSetECI;
                                            n5 = n2;
                                            n4 = n3;
                                            n6 = 5;
                                            continue block10;
                                        }
                                        case 9: {
                                            enum_ = CharacterSetECI.getCharacterSetECIByValue(DecodedBitStreamParser.parseECIValue(bitSource));
                                            if (enum_ == null) throw FormatException.getFormatInstance();
                                            n4 = n3;
                                            n5 = n2;
                                            n6 = 5;
                                            continue block10;
                                        }
                                        case 8: {
                                            if (bitSource.available() < 16) throw FormatException.getFormatInstance();
                                            n5 = bitSource.readBits(8);
                                            n4 = bitSource.readBits(8);
                                            enum_ = characterSetECI;
                                        }
                                        case 5: {
                                            break block15;
                                        }
                                        case 6: 
                                        case 7: {
                                            bl = true;
                                            continue block9;
                                        }
                                    }
                                    break;
                                } while (true);
                                n4 = bitSource.readBits(n4);
                                n5 = 1.$SwitchMap$com$ailiwean$core$zxing$core$qrcode$decoder$Mode[mode.ordinal()];
                                if (n5 == 1) break block16;
                                if (n5 == 2) break block17;
                                if (n5 == 3) break block18;
                                if (n5 != 4) throw FormatException.getFormatInstance();
                                DecodedBitStreamParser.decodeKanjiSegment(bitSource, stringBuilder, n4);
                                enum_ = characterSetECI;
                                n5 = n2;
                                n4 = n3;
                            }
                            characterSetECI = enum_;
                            n2 = n5;
                            n3 = n4;
                            continue;
                        }
                        DecodedBitStreamParser.decodeByteSegment(bitSource, stringBuilder, n4, characterSetECI, arrayList2, object2);
                        continue;
                    }
                    DecodedBitStreamParser.decodeAlphanumericSegment(bitSource, stringBuilder, n4, bl);
                    continue;
                }
                DecodedBitStreamParser.decodeNumericSegment(bitSource, stringBuilder, n4);
            } while (mode != (enum_ = Mode.TERMINATOR));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw FormatException.getFormatInstance();
        }
        object2 = stringBuilder.toString();
        arrayList = arrayList2.isEmpty() ? null : arrayList2;
        if (object == null) {
            object = null;
            return new DecoderResult(byArray, (String)object2, arrayList, (String)object, n2, n3);
        }
        object = ((Enum)object).toString();
        return new DecoderResult(byArray, (String)object2, arrayList, (String)object, n2, n3);
    }

    private static void decodeAlphanumericSegment(BitSource bitSource, StringBuilder stringBuilder, int n2, boolean bl) throws FormatException {
        int n3 = stringBuilder.length();
        while (n2 > 1) {
            if (bitSource.available() >= 11) {
                int n4 = bitSource.readBits(11);
                stringBuilder.append(DecodedBitStreamParser.toAlphaNumericChar(n4 / 45));
                stringBuilder.append(DecodedBitStreamParser.toAlphaNumericChar(n4 % 45));
                n2 -= 2;
                continue;
            }
            throw FormatException.getFormatInstance();
        }
        if (n2 == 1) {
            if (bitSource.available() >= 6) {
                stringBuilder.append(DecodedBitStreamParser.toAlphaNumericChar(bitSource.readBits(6)));
            } else {
                throw FormatException.getFormatInstance();
            }
        }
        if (bl) {
            for (n2 = n3; n2 < stringBuilder.length(); ++n2) {
                if (stringBuilder.charAt(n2) != '%') continue;
                if (n2 < stringBuilder.length() - 1 && stringBuilder.charAt(n3 = n2 + 1) == '%') {
                    stringBuilder.deleteCharAt(n3);
                    continue;
                }
                stringBuilder.setCharAt(n2, '\u001d');
            }
        }
    }

    private static void decodeByteSegment(BitSource object, StringBuilder stringBuilder, int n2, CharacterSetECI object2, Collection<byte[]> collection, Map<DecodeHintType, ?> map) throws FormatException {
        if (n2 * 8 <= ((BitSource)object).available()) {
            byte[] byArray = new byte[n2];
            for (int i3 = 0; i3 < n2; ++i3) {
                byArray[i3] = (byte)((BitSource)object).readBits(8);
            }
            object = object2 == null ? StringUtils.guessEncoding(byArray, map) : object2.name();
            try {
                object2 = new String(byArray, (String)object);
                stringBuilder.append((String)object2);
                collection.add(byArray);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw FormatException.getFormatInstance();
            }
            return;
        }
        throw FormatException.getFormatInstance();
    }

    private static void decodeHanziSegment(BitSource object, StringBuilder stringBuilder, int n2) throws FormatException {
        if (n2 * 13 <= ((BitSource)object).available()) {
            byte[] byArray = new byte[n2 * 2];
            int n3 = 0;
            while (n2 > 0) {
                int n4 = ((BitSource)object).readBits(13);
                int n5 = n4 % 96 | n4 / 96 << 8;
                n4 = n5 < 2560 ? 41377 : 42657;
                n4 = n5 + n4;
                byArray[n3] = (byte)(n4 >> 8 & 0xFF);
                byArray[n3 + 1] = (byte)(n4 & 0xFF);
                n3 += 2;
                --n2;
            }
            try {
                object = new String(byArray, "GB2312");
                stringBuilder.append((String)object);
                return;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw FormatException.getFormatInstance();
            }
        }
        throw FormatException.getFormatInstance();
    }

    private static void decodeKanjiSegment(BitSource object, StringBuilder stringBuilder, int n2) throws FormatException {
        if (n2 * 13 <= ((BitSource)object).available()) {
            byte[] byArray = new byte[n2 * 2];
            int n3 = 0;
            while (n2 > 0) {
                int n4 = ((BitSource)object).readBits(13);
                int n5 = n4 % 192 | n4 / 192 << 8;
                n4 = n5 < 7936 ? 33088 : 49472;
                n4 = n5 + n4;
                byArray[n3] = (byte)(n4 >> 8);
                byArray[n3 + 1] = (byte)n4;
                n3 += 2;
                --n2;
            }
            try {
                object = new String(byArray, "SJIS");
                stringBuilder.append((String)object);
                return;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw FormatException.getFormatInstance();
            }
        }
        throw FormatException.getFormatInstance();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void decodeNumericSegment(BitSource bitSource, StringBuilder stringBuilder, int n2) throws FormatException {
        while (n2 >= 3) {
            if (bitSource.available() < 10) throw FormatException.getFormatInstance();
            int n3 = bitSource.readBits(10);
            if (n3 >= 1000) throw FormatException.getFormatInstance();
            stringBuilder.append(DecodedBitStreamParser.toAlphaNumericChar(n3 / 100));
            stringBuilder.append(DecodedBitStreamParser.toAlphaNumericChar(n3 / 10 % 10));
            stringBuilder.append(DecodedBitStreamParser.toAlphaNumericChar(n3 % 10));
            n2 -= 3;
        }
        if (n2 == 2) {
            if (bitSource.available() < 7) throw FormatException.getFormatInstance();
            n2 = bitSource.readBits(7);
            if (n2 >= 100) throw FormatException.getFormatInstance();
            stringBuilder.append(DecodedBitStreamParser.toAlphaNumericChar(n2 / 10));
            stringBuilder.append(DecodedBitStreamParser.toAlphaNumericChar(n2 % 10));
            return;
        } else {
            if (n2 != 1) return;
            if (bitSource.available() < 4) throw FormatException.getFormatInstance();
            n2 = bitSource.readBits(4);
            if (n2 >= 10) throw FormatException.getFormatInstance();
            stringBuilder.append(DecodedBitStreamParser.toAlphaNumericChar(n2));
        }
    }

    private static int parseECIValue(BitSource bitSource) throws FormatException {
        int n2 = bitSource.readBits(8);
        if ((n2 & 0x80) == 0) {
            return n2 & 0x7F;
        }
        if ((n2 & 0xC0) == 128) {
            return bitSource.readBits(8) | (n2 & 0x3F) << 8;
        }
        if ((n2 & 0xE0) == 192) {
            return bitSource.readBits(16) | (n2 & 0x1F) << 16;
        }
        throw FormatException.getFormatInstance();
    }

    private static char toAlphaNumericChar(int n2) throws FormatException {
        char[] cArray = ALPHANUMERIC_CHARS;
        if (n2 < cArray.length) {
            return cArray[n2];
        }
        throw FormatException.getFormatInstance();
    }
}

