/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.qrcode.decoder;

import com.ailiwean.core.zxing.core.common.BitMatrix;

enum DataMask {
    DATA_MASK_000{

        @Override
        boolean isMasked(int n2, int n3) {
            boolean bl = true;
            if ((n2 + n3 & 1) != 0) {
                bl = false;
            }
            return bl;
        }
    }
    ,
    DATA_MASK_001{

        @Override
        boolean isMasked(int n2, int n3) {
            boolean bl = true;
            if ((n2 & 1) != 0) {
                bl = false;
            }
            return bl;
        }
    }
    ,
    DATA_MASK_010{

        @Override
        boolean isMasked(int n2, int n3) {
            boolean bl = n3 % 3 == 0;
            return bl;
        }
    }
    ,
    DATA_MASK_011{

        @Override
        boolean isMasked(int n2, int n3) {
            boolean bl = (n2 + n3) % 3 == 0;
            return bl;
        }
    }
    ,
    DATA_MASK_100{

        @Override
        boolean isMasked(int n2, int n3) {
            boolean bl = true;
            if (((n2 /= 2) + (n3 /= 3) & 1) != 0) {
                bl = false;
            }
            return bl;
        }
    }
    ,
    DATA_MASK_101{

        @Override
        boolean isMasked(int n2, int n3) {
            boolean bl = n2 * n3 % 6 == 0;
            return bl;
        }
    }
    ,
    DATA_MASK_110{

        @Override
        boolean isMasked(int n2, int n3) {
            boolean bl = n2 * n3 % 6 < 3;
            return bl;
        }
    }
    ,
    DATA_MASK_111{

        @Override
        boolean isMasked(int n2, int n3) {
            boolean bl = true;
            if ((n2 + n3 + n2 * n3 % 3 & 1) != 0) {
                bl = false;
            }
            return bl;
        }
    };


    abstract boolean isMasked(int var1, int var2);

    final void unmaskBitMatrix(BitMatrix bitMatrix, int n2) {
        for (int i3 = 0; i3 < n2; ++i3) {
            for (int i4 = 0; i4 < n2; ++i4) {
                if (!this.isMasked(i3, i4)) continue;
                bitMatrix.flip(i4, i3);
            }
        }
    }
}

