/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.qrcode.decoder;

import com.ailiwean.core.zxing.core.FormatException;
import com.ailiwean.core.zxing.core.common.BitMatrix;
import com.ailiwean.core.zxing.core.qrcode.decoder.DataMask;
import com.ailiwean.core.zxing.core.qrcode.decoder.FormatInformation;
import com.ailiwean.core.zxing.core.qrcode.decoder.Version;

final class BitMatrixParser {
    private final BitMatrix bitMatrix;
    private boolean mirror;
    private FormatInformation parsedFormatInfo;
    private Version parsedVersion;

    BitMatrixParser(BitMatrix bitMatrix) throws FormatException {
        int n2 = bitMatrix.getHeight();
        if (n2 >= 21 && (n2 & 3) == 1) {
            this.bitMatrix = bitMatrix;
            return;
        }
        throw FormatException.getFormatInstance();
    }

    private int copyBit(int n2, int n3, int n4) {
        boolean bl = this.mirror ? this.bitMatrix.get(n3, n2) : this.bitMatrix.get(n2, n3);
        n2 = bl ? n4 << 1 | 1 : n4 << 1;
        return n2;
    }

    void mirror() {
        int n2 = 0;
        while (n2 < this.bitMatrix.getWidth()) {
            int n3;
            for (int i3 = n3 = n2 + 1; i3 < this.bitMatrix.getHeight(); ++i3) {
                if (this.bitMatrix.get(n2, i3) == this.bitMatrix.get(i3, n2)) continue;
                this.bitMatrix.flip(i3, n2);
                this.bitMatrix.flip(n2, i3);
            }
            n2 = n3;
        }
    }

    byte[] readCodewords() throws FormatException {
        int n2;
        Object object = this.readFormatInformation();
        Version version = this.readVersion();
        object = DataMask.values()[object.getDataMask()];
        int n3 = this.bitMatrix.getHeight();
        ((DataMask)((Object)object)).unmaskBitMatrix(this.bitMatrix, n3);
        BitMatrix bitMatrix = version.buildFunctionPattern();
        object = new byte[version.getTotalCodewords()];
        int n4 = n2 = n3 - 1;
        int n5 = 0;
        boolean bl = true;
        int n6 = 0;
        int n7 = 0;
        while (n4 > 0) {
            int n8 = n4;
            if (n4 == 6) {
                n8 = n4 - 1;
            }
            for (n4 = 0; n4 < n3; ++n4) {
                int n9 = bl ? n2 - n4 : n4;
                int n10 = n7;
                n7 = n6;
                n6 = n10;
                for (int i3 = 0; i3 < 2; ++i3) {
                    int n11 = n8 - i3;
                    int n12 = n5;
                    n10 = n7;
                    int n13 = n6;
                    if (!bitMatrix.get(n11, n9)) {
                        n10 = n7 + 1;
                        n6 <<= 1;
                        if (this.bitMatrix.get(n11, n9)) {
                            n6 |= 1;
                        }
                        if (n10 == 8) {
                            object[n5] = (FormatInformation)((byte)((byte)n6));
                            n12 = n5 + 1;
                            n10 = 0;
                            n13 = 0;
                        } else {
                            n13 = n6;
                            n12 = n5;
                        }
                    }
                    n5 = n12;
                    n7 = n10;
                    n6 = n13;
                }
                n10 = n6;
                n6 = n7;
                n7 = n10;
            }
            bl ^= true;
            n4 = n8 - 2;
        }
        if (n5 == version.getTotalCodewords()) {
            return object;
        }
        throw FormatException.getFormatInstance();
    }

    FormatInformation readFormatInformation() throws FormatException {
        int n2;
        int n3;
        FormatInformation formatInformation = this.parsedFormatInfo;
        if (formatInformation != null) {
            return formatInformation;
        }
        int n4 = 0;
        int n5 = 0;
        for (n3 = 0; n3 < 6; ++n3) {
            n5 = this.copyBit(n3, 8, n5);
        }
        n5 = this.copyBit(8, 7, this.copyBit(8, 8, this.copyBit(7, 8, n5)));
        for (n3 = 5; n3 >= 0; --n3) {
            n5 = this.copyBit(8, n3, n5);
        }
        int n6 = this.bitMatrix.getHeight();
        n3 = n4;
        for (n2 = n6 - 1; n2 >= n6 - 7; --n2) {
            n3 = this.copyBit(8, n2, n3);
        }
        for (n2 = n6 - 8; n2 < n6; ++n2) {
            n3 = this.copyBit(n2, 8, n3);
        }
        this.parsedFormatInfo = FormatInformation.decodeFormatInformation(n5, n3);
        formatInformation = this.parsedFormatInfo;
        if (formatInformation != null) {
            return formatInformation;
        }
        throw FormatException.getFormatInstance();
    }

    Version readVersion() throws FormatException {
        int n2;
        Version version = this.parsedVersion;
        if (version != null) {
            return version;
        }
        int n3 = this.bitMatrix.getHeight();
        int n4 = (n3 - 17) / 4;
        if (n4 <= 6) {
            return Version.getVersionForNumber(n4);
        }
        int n5 = n3 - 11;
        int n6 = 5;
        int n7 = 0;
        int n8 = 0;
        for (n4 = 5; n4 >= 0; --n4) {
            for (n2 = n3 - 9; n2 >= n5; --n2) {
                n8 = this.copyBit(n2, n4, n8);
            }
        }
        version = Version.decodeVersionInformation(n8);
        n4 = n6;
        n8 = n7;
        if (version != null) {
            n4 = n6;
            n8 = n7;
            if (version.getDimensionForVersion() == n3) {
                this.parsedVersion = version;
                return version;
            }
        }
        while (n4 >= 0) {
            for (n2 = n3 - 9; n2 >= n5; --n2) {
                n8 = this.copyBit(n4, n2, n8);
            }
            --n4;
        }
        version = Version.decodeVersionInformation(n8);
        if (version != null && version.getDimensionForVersion() == n3) {
            this.parsedVersion = version;
            return version;
        }
        throw FormatException.getFormatInstance();
    }

    void remask() {
        if (this.parsedFormatInfo == null) {
            return;
        }
        DataMask dataMask = DataMask.values()[this.parsedFormatInfo.getDataMask()];
        int n2 = this.bitMatrix.getHeight();
        dataMask.unmaskBitMatrix(this.bitMatrix, n2);
    }

    void setMirror(boolean bl) {
        this.parsedVersion = null;
        this.parsedFormatInfo = null;
        this.mirror = bl;
    }
}

