/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.qrcode;

import com.ailiwean.core.zxing.core.BarcodeFormat;
import com.ailiwean.core.zxing.core.EncodeHintType;
import com.ailiwean.core.zxing.core.Writer;
import com.ailiwean.core.zxing.core.WriterException;
import com.ailiwean.core.zxing.core.common.BitMatrix;
import com.ailiwean.core.zxing.core.qrcode.decoder.ErrorCorrectionLevel;
import com.ailiwean.core.zxing.core.qrcode.encoder.ByteMatrix;
import com.ailiwean.core.zxing.core.qrcode.encoder.Encoder;
import com.ailiwean.core.zxing.core.qrcode.encoder.QRCode;
import java.util.Map;

public final class QRCodeWriter
implements Writer {
    private static final int QUIET_ZONE_SIZE = 4;

    private static BitMatrix renderResult(QRCode object, int n2, int n3, int n4) {
        if ((object = ((QRCode)object).getMatrix()) != null) {
            int n5 = ((ByteMatrix)object).getWidth();
            int n6 = ((ByteMatrix)object).getHeight();
            int n7 = n5 + (n4 *= 2);
            int n8 = n4 + n6;
            n2 = Math.max(n2, n7);
            n4 = Math.max(n3, n8);
            int n9 = Math.min(n2 / n7, n4 / n8);
            n8 = (n2 - n5 * n9) / 2;
            n3 = (n4 - n6 * n9) / 2;
            BitMatrix bitMatrix = new BitMatrix(n2, n4);
            n2 = 0;
            while (n2 < n6) {
                n4 = n8;
                n7 = 0;
                while (n7 < n5) {
                    if (((ByteMatrix)object).get(n7, n2) == 1) {
                        bitMatrix.setRegion(n4, n3, n9, n9);
                    }
                    ++n7;
                    n4 += n9;
                }
                ++n2;
                n3 += n9;
            }
            return bitMatrix;
        }
        throw new IllegalStateException();
    }

    @Override
    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n2, int n3) throws WriterException {
        return this.encode(string2, barcodeFormat, n2, n3, null);
    }

    @Override
    public BitMatrix encode(String charSequence, BarcodeFormat enum_, int n2, int n3, Map<EncodeHintType, ?> map) throws WriterException {
        if (!((String)charSequence).isEmpty()) {
            if (enum_ == BarcodeFormat.QR_CODE) {
                if (n2 >= 0 && n3 >= 0) {
                    int n4;
                    enum_ = ErrorCorrectionLevel.L;
                    int n5 = n4 = 4;
                    Enum enum_2 = enum_;
                    if (map != null) {
                        if (map.containsKey((Object)EncodeHintType.ERROR_CORRECTION)) {
                            enum_ = ErrorCorrectionLevel.valueOf(map.get((Object)EncodeHintType.ERROR_CORRECTION).toString());
                        }
                        n5 = n4;
                        enum_2 = enum_;
                        if (map.containsKey((Object)EncodeHintType.MARGIN)) {
                            n5 = Integer.parseInt(map.get((Object)EncodeHintType.MARGIN).toString());
                            enum_2 = enum_;
                        }
                    }
                    return QRCodeWriter.renderResult(Encoder.encode((String)charSequence, (ErrorCorrectionLevel)enum_2, map), n2, n3, n5);
                }
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append("Requested dimensions are too small: ");
                ((StringBuilder)charSequence).append(n2);
                ((StringBuilder)charSequence).append('x');
                ((StringBuilder)charSequence).append(n3);
                throw new IllegalArgumentException(((StringBuilder)charSequence).toString());
            }
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("Can only encode QR_CODE, but got ");
            ((StringBuilder)charSequence).append(enum_);
            throw new IllegalArgumentException(((StringBuilder)charSequence).toString());
        }
        throw new IllegalArgumentException("Found empty contents");
    }
}

