/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.qrcode;

import com.ailiwean.core.Config;
import com.ailiwean.core.zxing.core.BarcodeFormat;
import com.ailiwean.core.zxing.core.BinaryBitmap;
import com.ailiwean.core.zxing.core.ChecksumException;
import com.ailiwean.core.zxing.core.DecodeHintType;
import com.ailiwean.core.zxing.core.FormatException;
import com.ailiwean.core.zxing.core.NotFoundException;
import com.ailiwean.core.zxing.core.Reader;
import com.ailiwean.core.zxing.core.Result;
import com.ailiwean.core.zxing.core.ResultMetadataType;
import com.ailiwean.core.zxing.core.ResultPoint;
import com.ailiwean.core.zxing.core.common.BitMatrix;
import com.ailiwean.core.zxing.core.common.DecoderResult;
import com.ailiwean.core.zxing.core.common.DetectorResult;
import com.ailiwean.core.zxing.core.qrcode.decoder.Decoder;
import com.ailiwean.core.zxing.core.qrcode.decoder.QRCodeDecoderMetaData;
import com.ailiwean.core.zxing.core.qrcode.detector.Detector;
import com.ailiwean.core.zxing.core.qrcode.detector.Detector2;
import java.util.Map;

public class QRCodeReader
implements Reader {
    private static final ResultPoint[] NO_POINTS = new ResultPoint[0];
    private final Decoder decoder = new Decoder();

    private static BitMatrix extractPureBits(BitMatrix bitMatrix) throws NotFoundException {
        int[] nArray = bitMatrix.getTopLeftOnBit();
        Object object = bitMatrix.getBottomRightOnBit();
        if (nArray != null && object != null) {
            float f3 = QRCodeReader.moduleSize(nArray, bitMatrix);
            int n2 = nArray[1];
            int n3 = object[1];
            int n4 = nArray[0];
            int n5 = object[0];
            if (n4 < n5 && n2 < n3) {
                int n6 = n3 - n2;
                int n7 = n5;
                if (n6 != n5 - n4 && (n7 = n4 + n6) >= bitMatrix.getWidth()) {
                    throw NotFoundException.getNotFoundInstance();
                }
                int n8 = Math.round((float)(n7 - n4 + 1) / f3);
                n6 = Math.round((float)(n6 + 1) / f3);
                if (n8 > 0 && n6 > 0) {
                    if (n6 == n8) {
                        int n9 = (int)(f3 / 2.0f);
                        n2 += n9;
                        n5 = n4 + n9;
                        n4 = (int)((float)(n8 - 1) * f3) + n5 - n7;
                        n7 = n5;
                        if (n4 > 0) {
                            if (n4 <= n9) {
                                n7 = n5 - n4;
                            } else {
                                throw NotFoundException.getNotFoundInstance();
                            }
                        }
                        n3 = (int)((float)(n6 - 1) * f3) + n2 - n3;
                        n5 = n2;
                        if (n3 > 0) {
                            if (n3 <= n9) {
                                n5 = n2 - n3;
                            } else {
                                throw NotFoundException.getNotFoundInstance();
                            }
                        }
                        object = new BitMatrix(n8, n6);
                        for (n2 = 0; n2 < n6; ++n2) {
                            n9 = (int)((float)n2 * f3);
                            for (n3 = 0; n3 < n8; ++n3) {
                                if (!bitMatrix.get((int)((float)n3 * f3) + n7, n9 + n5)) continue;
                                ((BitMatrix)object).set(n3, n2);
                            }
                        }
                        return object;
                    }
                    throw NotFoundException.getNotFoundInstance();
                }
                throw NotFoundException.getNotFoundInstance();
            }
            throw NotFoundException.getNotFoundInstance();
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static float moduleSize(int[] nArray, BitMatrix bitMatrix) throws NotFoundException {
        int n2;
        int n3 = bitMatrix.getHeight();
        int n4 = bitMatrix.getWidth();
        int n5 = nArray[0];
        boolean bl = true;
        int n6 = 0;
        for (n2 = nArray[1]; n5 < n4 && n2 < n3; ++n5, ++n2) {
            boolean bl2 = bl;
            int n7 = n6;
            if (bl != bitMatrix.get(n5, n2)) {
                n7 = n6 + 1;
                if (n7 == 5) break;
                bl2 = bl ^ true;
            }
            bl = bl2;
            n6 = n7;
        }
        if (n5 != n4 && n2 != n3) {
            return (float)(n5 - nArray[0]) / 7.0f;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap) throws NotFoundException, ChecksumException, FormatException {
        return this.decode(binaryBitmap, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Result decode(BinaryBitmap object, Map<DecodeHintType, ?> object2) throws ChecksumException, FormatException, NotFoundException {
        block13: {
            Object object3;
            if (object2 != null && object2.containsKey((Object)DecodeHintType.PURE_BARCODE)) {
                try {
                    object = QRCodeReader.extractPureBits(((BinaryBitmap)object).getBlackMatrix());
                    object = this.decoder.decode((BitMatrix)object, (Map<DecodeHintType, ?>)object2);
                    object2 = NO_POINTS;
                }
                catch (NotFoundException notFoundException) {
                    return null;
                }
            }
            try {
                object3 = new Detector(((BinaryBitmap)object).getBlackMatrix());
                object3 = object3.detect((Map<DecodeHintType, ?>)object2);
                object = object3;
            }
            catch (NotFoundException notFoundException) {
                if (!Config.isSupportBlackEdge) break block13;
                try {
                    object3 = new Detector2(((BinaryBitmap)object).getBlackMatrix());
                    object = object3.detect((Map<DecodeHintType, ?>)object2);
                }
                catch (NotFoundException notFoundException2) {
                    throw NotFoundException.getNotFoundInstance();
                }
            }
            object3 = ((DetectorResult)object).getPoints();
            try {
                object = this.decoder.decode(((DetectorResult)object).getBits(), (Map<DecodeHintType, ?>)object2);
                object2 = object3;
            }
            catch (Exception exception) {
                return new Result(null, null, (ResultPoint[])object3, null);
            }
            if (((DecoderResult)object).getOther() instanceof QRCodeDecoderMetaData) {
                ((QRCodeDecoderMetaData)((DecoderResult)object).getOther()).applyMirroredCorrection((ResultPoint[])object2);
            }
            object2 = new Result(((DecoderResult)object).getText(), ((DecoderResult)object).getRawBytes(), (ResultPoint[])object2, BarcodeFormat.QR_CODE);
            object3 = ((DecoderResult)object).getByteSegments();
            if (object3 != null) {
                ((Result)object2).putMetadata(ResultMetadataType.BYTE_SEGMENTS, object3);
            }
            if ((object3 = ((DecoderResult)object).getECLevel()) != null) {
                ((Result)object2).putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, object3);
            }
            if (((DecoderResult)object).hasStructuredAppend()) {
                ((Result)object2).putMetadata(ResultMetadataType.STRUCTURED_APPEND_SEQUENCE, ((DecoderResult)object).getStructuredAppendSequenceNumber());
                ((Result)object2).putMetadata(ResultMetadataType.STRUCTURED_APPEND_PARITY, ((DecoderResult)object).getStructuredAppendParity());
            }
            return object2;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    protected final Decoder getDecoder() {
        return this.decoder;
    }

    @Override
    public void reset() {
    }
}

