/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.pdf417.encoder;

import com.ailiwean.core.zxing.core.WriterException;
import com.ailiwean.core.zxing.core.common.CharacterSetECI;
import com.ailiwean.core.zxing.core.pdf417.encoder.Compaction;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

final class PDF417HighLevelEncoder {
    private static final int BYTE_COMPACTION = 1;
    private static final Charset DEFAULT_ENCODING;
    private static final int ECI_CHARSET = 927;
    private static final int ECI_GENERAL_PURPOSE = 926;
    private static final int ECI_USER_DEFINED = 925;
    private static final int LATCH_TO_BYTE = 924;
    private static final int LATCH_TO_BYTE_PADDED = 901;
    private static final int LATCH_TO_NUMERIC = 902;
    private static final int LATCH_TO_TEXT = 900;
    private static final byte[] MIXED;
    private static final int NUMERIC_COMPACTION = 2;
    private static final byte[] PUNCTUATION;
    private static final int SHIFT_TO_BYTE = 913;
    private static final int SUBMODE_ALPHA = 0;
    private static final int SUBMODE_LOWER = 1;
    private static final int SUBMODE_MIXED = 2;
    private static final int SUBMODE_PUNCTUATION = 3;
    private static final int TEXT_COMPACTION = 0;
    private static final byte[] TEXT_MIXED_RAW;
    private static final byte[] TEXT_PUNCTUATION_RAW;

    static {
        byte[] byArray;
        int n2;
        TEXT_MIXED_RAW = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 38, 13, 9, 44, 58, 35, 45, 46, 36, 47, 43, 37, 42, 61, 94, 0, 32, 0, 0, 0};
        TEXT_PUNCTUATION_RAW = new byte[]{59, 60, 62, 64, 91, 92, 93, 95, 96, 126, 33, 13, 9, 44, 58, 10, 45, 46, 36, 47, 34, 124, 42, 40, 41, 63, 123, 125, 39, 0};
        MIXED = new byte[128];
        PUNCTUATION = new byte[128];
        DEFAULT_ENCODING = StandardCharsets.ISO_8859_1;
        Arrays.fill(MIXED, (byte)-1);
        int n3 = 0;
        for (n2 = 0; n2 < (byArray = TEXT_MIXED_RAW).length; ++n2) {
            byte by = byArray[n2];
            if (by <= 0) continue;
            PDF417HighLevelEncoder.MIXED[by] = (byte)n2;
        }
        Arrays.fill(PUNCTUATION, (byte)-1);
        for (n2 = n3; n2 < (byArray = TEXT_PUNCTUATION_RAW).length; ++n2) {
            n3 = byArray[n2];
            if (n3 <= 0) continue;
            PDF417HighLevelEncoder.PUNCTUATION[n3] = (byte)n2;
        }
    }

    private PDF417HighLevelEncoder() {
    }

    private static int determineConsecutiveBinaryCount(String charSequence, int n2, Charset object) throws WriterException {
        int n3;
        object = ((Charset)object).newEncoder();
        int n4 = ((String)charSequence).length();
        for (n3 = n2; n3 < n4; ++n3) {
            char c3 = ((String)charSequence).charAt(n3);
            char c4 = '\u0000';
            char c5 = c3;
            while (true) {
                c3 = c4;
                if (c4 >= '\r') break;
                c3 = c4++;
                if (!PDF417HighLevelEncoder.isDigit(c5)) break;
                c3 = n3 + c4;
                if (c3 >= n4) {
                    c3 = c4;
                    break;
                }
                c5 = c3 = (char)((String)charSequence).charAt(c3);
            }
            if (c3 >= '\r') {
                return n3 - n2;
            }
            c5 = ((String)charSequence).charAt(n3);
            if (((CharsetEncoder)object).canEncode(c5)) {
                continue;
            }
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("Non-encodable character detected: ");
            ((StringBuilder)charSequence).append(c5);
            ((StringBuilder)charSequence).append(" (Unicode: ");
            ((StringBuilder)charSequence).append((int)c5);
            ((StringBuilder)charSequence).append(')');
            throw new WriterException(((StringBuilder)charSequence).toString());
        }
        return n3 - n2;
    }

    private static int determineConsecutiveDigitCount(CharSequence charSequence, int n2) {
        int n3 = charSequence.length();
        int n4 = 0;
        int n5 = 0;
        if (n2 < n3) {
            n4 = charSequence.charAt(n2);
            int n6 = n2;
            int n7 = n4;
            n2 = n5;
            while (true) {
                n4 = n2;
                if (!PDF417HighLevelEncoder.isDigit((char)n7)) break;
                n4 = n2;
                if (n6 >= n3) break;
                n5 = n2 + 1;
                n4 = n6 + 1;
                n2 = n5;
                n6 = n4;
                if (n4 >= n3) continue;
                n6 = charSequence.charAt(n4);
                n2 = n5;
                n7 = n6;
                n6 = n4;
            }
        }
        return n4;
    }

    private static int determineConsecutiveTextCount(CharSequence charSequence, int n2) {
        int n3;
        int n4 = charSequence.length();
        int n5 = n2;
        while (true) {
            n3 = n5;
            if (n5 >= n4) break;
            int n6 = charSequence.charAt(n5);
            n3 = 0;
            int n7 = n6;
            while (n3 < 13 && PDF417HighLevelEncoder.isDigit((char)n7) && n5 < n4) {
                int n8 = n3 + 1;
                n5 = n6 = n5 + 1;
                n3 = n8;
                if (n6 >= n4) continue;
                n3 = charSequence.charAt(n6);
                n5 = n6;
                n7 = n3;
                n3 = n8;
            }
            if (n3 >= 13) {
                return n5 - n2 - n3;
            }
            if (n3 > 0) continue;
            if (!PDF417HighLevelEncoder.isText(charSequence.charAt(n5))) {
                n3 = n5;
                break;
            }
            ++n5;
        }
        return n3 - n2;
    }

    private static void encodeBinary(byte[] byArray, int n2, int n3, int n4, StringBuilder stringBuilder) {
        int n5;
        if (n3 == 1 && n4 == 0) {
            stringBuilder.append('\u0391');
        } else if (n3 % 6 == 0) {
            stringBuilder.append('\u039c');
        } else {
            stringBuilder.append('\u0385');
        }
        if (n3 >= 6) {
            char[] cArray = new char[5];
            n4 = n2;
            while (true) {
                n5 = n4;
                if (n2 + n3 - n4 >= 6) {
                    long l3;
                    int n6 = 0;
                    long l4 = 0L;
                    int n7 = 0;
                    while (true) {
                        l3 = l4;
                        if (n7 >= 6) break;
                        l4 = (l4 << 8) + (long)(byArray[n4 + n7] & 0xFF);
                        ++n7;
                    }
                    for (n5 = n6; n5 < 5; ++n5) {
                        cArray[n5] = (char)(l3 % 900L);
                        l3 /= 900L;
                    }
                    for (n5 = cArray.length - 1; n5 >= 0; --n5) {
                        stringBuilder.append(cArray[n5]);
                    }
                    n4 += 6;
                    continue;
                }
                break;
            }
        } else {
            n5 = n2;
        }
        while (n5 < n2 + n3) {
            stringBuilder.append((char)(byArray[n5] & 0xFF));
            ++n5;
        }
    }

    static String encodeHighLevel(String object, Compaction object2, Charset charset) throws WriterException {
        Charset charset2;
        StringBuilder stringBuilder = new StringBuilder(((String)object).length());
        if (charset == null) {
            charset2 = DEFAULT_ENCODING;
        } else {
            charset2 = charset;
            if (!DEFAULT_ENCODING.equals(charset)) {
                CharacterSetECI characterSetECI = CharacterSetECI.getCharacterSetECIByName(charset.name());
                charset2 = charset;
                if (characterSetECI != null) {
                    PDF417HighLevelEncoder.encodingECI(characterSetECI.getValue(), stringBuilder);
                    charset2 = charset;
                }
            }
        }
        int n2 = ((String)object).length();
        int n3 = 1.$SwitchMap$com$ailiwean$core$zxing$core$pdf417$encoder$Compaction[object2.ordinal()];
        if (n3 != 1) {
            if (n3 != 2) {
                if (n3 != 3) {
                    int n4 = 0;
                    n3 = 0;
                    int n5 = 0;
                    while (n4 < n2) {
                        int n6 = PDF417HighLevelEncoder.determineConsecutiveDigitCount((CharSequence)object, n4);
                        if (n6 >= 13) {
                            stringBuilder.append('\u0386');
                            PDF417HighLevelEncoder.encodeNumeric((String)object, n4, n6, stringBuilder);
                            n4 += n6;
                            n3 = 0;
                            n5 = 2;
                            continue;
                        }
                        int n7 = PDF417HighLevelEncoder.determineConsecutiveTextCount((CharSequence)object, n4);
                        if (n7 < 5 && n6 != n2) {
                            n6 = n7 = PDF417HighLevelEncoder.determineConsecutiveBinaryCount((String)object, n4, charset2);
                            if (n7 == 0) {
                                n6 = 1;
                            }
                            if (((Compaction)(object2 = (Object)((String)object).substring(n4, n6 += n4).getBytes(charset2))).length == 1 && n5 == 0) {
                                PDF417HighLevelEncoder.encodeBinary((byte[])object2, 0, 1, 0, stringBuilder);
                            } else {
                                PDF417HighLevelEncoder.encodeBinary((byte[])object2, 0, ((Compaction)object2).length, n5, stringBuilder);
                                n3 = 0;
                                n5 = 1;
                            }
                            n4 = n6;
                            continue;
                        }
                        n6 = n5;
                        if (n5 != 0) {
                            stringBuilder.append('\u0384');
                            n3 = 0;
                            n6 = 0;
                        }
                        n3 = PDF417HighLevelEncoder.encodeText((CharSequence)object, n4, n7, stringBuilder, n3);
                        n4 += n7;
                        n5 = n6;
                    }
                } else {
                    stringBuilder.append('\u0386');
                    PDF417HighLevelEncoder.encodeNumeric((String)object, 0, n2, stringBuilder);
                }
            } else {
                object = ((String)object).getBytes(charset2);
                PDF417HighLevelEncoder.encodeBinary((byte[])object, 0, ((Object)object).length, 1, stringBuilder);
            }
        } else {
            PDF417HighLevelEncoder.encodeText((CharSequence)object, 0, n2, stringBuilder, 0);
        }
        return stringBuilder.toString();
    }

    private static void encodeNumeric(String string2, int n2, int n3, StringBuilder stringBuilder) {
        int n4;
        StringBuilder stringBuilder2 = new StringBuilder(n3 / 3 + 1);
        BigInteger bigInteger = BigInteger.valueOf(900L);
        BigInteger bigInteger2 = BigInteger.valueOf(0L);
        for (int i3 = 0; i3 < n3; i3 += n4) {
            BigInteger bigInteger3;
            stringBuilder2.setLength(0);
            n4 = Math.min(44, n3 - i3);
            Comparable<StringBuilder> comparable = new StringBuilder();
            ((StringBuilder)comparable).append('1');
            int n5 = n2 + i3;
            ((StringBuilder)comparable).append(string2.substring(n5, n5 + n4));
            comparable = new BigInteger(((StringBuilder)comparable).toString());
            do {
                stringBuilder2.append((char)((BigInteger)comparable).mod(bigInteger).intValue());
                bigInteger3 = ((BigInteger)comparable).divide(bigInteger);
                comparable = bigInteger3;
            } while (!bigInteger3.equals(bigInteger2));
            for (n5 = stringBuilder2.length() - 1; n5 >= 0; --n5) {
                stringBuilder.append(stringBuilder2.charAt(n5));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int encodeText(CharSequence charSequence, int n2, int n3, StringBuilder stringBuilder, int n4) {
        char c3;
        int n5;
        StringBuilder stringBuilder2 = new StringBuilder(n3);
        int n6 = 0;
        while (true) {
            block18: {
                block34: {
                    block31: {
                        block33: {
                            block27: {
                                block32: {
                                    block19: {
                                        block30: {
                                            block29: {
                                                block28: {
                                                    block20: {
                                                        block26: {
                                                            block25: {
                                                                block23: {
                                                                    block24: {
                                                                        block21: {
                                                                            block22: {
                                                                                n5 = n2 + n6;
                                                                                c3 = charSequence.charAt(n5);
                                                                                if (n4 == 0) break block19;
                                                                                if (n4 == 1) break block20;
                                                                                if (n4 == 2) break block21;
                                                                                if (!PDF417HighLevelEncoder.isPunctuation(c3)) break block22;
                                                                                stringBuilder2.append((char)PUNCTUATION[c3]);
                                                                                break block18;
                                                                            }
                                                                            stringBuilder2.append('\u001d');
                                                                            break block23;
                                                                        }
                                                                        if (!PDF417HighLevelEncoder.isMixed(c3)) break block24;
                                                                        stringBuilder2.append((char)MIXED[c3]);
                                                                        break block18;
                                                                    }
                                                                    if (!PDF417HighLevelEncoder.isAlphaUpper(c3)) break block25;
                                                                    stringBuilder2.append('\u001c');
                                                                }
                                                                n4 = 0;
                                                                continue;
                                                            }
                                                            if (!PDF417HighLevelEncoder.isAlphaLower(c3)) break block26;
                                                            stringBuilder2.append('\u001b');
                                                            break block27;
                                                        }
                                                        if (++n5 < n3 && PDF417HighLevelEncoder.isPunctuation(charSequence.charAt(n5))) {
                                                            n4 = 3;
                                                            stringBuilder2.append('\u0019');
                                                            continue;
                                                        }
                                                        stringBuilder2.append('\u001d');
                                                        stringBuilder2.append((char)PUNCTUATION[c3]);
                                                        break block18;
                                                    }
                                                    if (!PDF417HighLevelEncoder.isAlphaLower(c3)) break block28;
                                                    if (c3 == ' ') {
                                                        stringBuilder2.append('\u001a');
                                                        break block18;
                                                    } else {
                                                        stringBuilder2.append((char)(c3 - 97));
                                                    }
                                                    break block18;
                                                }
                                                if (!PDF417HighLevelEncoder.isAlphaUpper(c3)) break block29;
                                                stringBuilder2.append('\u001b');
                                                stringBuilder2.append((char)(c3 - 65));
                                                break block18;
                                            }
                                            if (!PDF417HighLevelEncoder.isMixed(c3)) break block30;
                                            stringBuilder2.append('\u001c');
                                            break block31;
                                        }
                                        stringBuilder2.append('\u001d');
                                        stringBuilder2.append((char)PUNCTUATION[c3]);
                                        break block18;
                                    }
                                    if (!PDF417HighLevelEncoder.isAlphaUpper(c3)) break block32;
                                    if (c3 == ' ') {
                                        stringBuilder2.append('\u001a');
                                        break block18;
                                    } else {
                                        stringBuilder2.append((char)(c3 - 65));
                                    }
                                    break block18;
                                }
                                if (!PDF417HighLevelEncoder.isAlphaLower(c3)) break block33;
                                stringBuilder2.append('\u001b');
                            }
                            n4 = 1;
                            continue;
                        }
                        if (!PDF417HighLevelEncoder.isMixed(c3)) break block34;
                        stringBuilder2.append('\u001c');
                    }
                    n4 = 2;
                    continue;
                }
                stringBuilder2.append('\u001d');
                stringBuilder2.append((char)PUNCTUATION[c3]);
            }
            n6 = n5 = n6 + 1;
            if (n5 >= n3) break;
        }
        n5 = stringBuilder2.length();
        n3 = 0;
        for (n2 = 0; n2 < n5; ++n2) {
            n6 = n2 % 2 != 0 ? 1 : 0;
            if (n6 != 0) {
                c3 = (char)(n3 * 30 + stringBuilder2.charAt(n2));
                stringBuilder.append(c3);
                n3 = c3;
                continue;
            }
            n3 = stringBuilder2.charAt(n2);
        }
        if (n5 % 2 != 0) {
            stringBuilder.append((char)(n3 * 30 + 29));
        }
        return n4;
    }

    private static void encodingECI(int n2, StringBuilder stringBuilder) throws WriterException {
        block5: {
            block3: {
                block4: {
                    block2: {
                        if (n2 < 0 || n2 >= 900) break block2;
                        stringBuilder.append('\u039f');
                        stringBuilder.append((char)n2);
                        break block3;
                    }
                    if (n2 >= 810900) break block4;
                    stringBuilder.append('\u039e');
                    stringBuilder.append((char)(n2 / 900 - 1));
                    stringBuilder.append((char)(n2 % 900));
                    break block3;
                }
                if (n2 >= 811800) break block5;
                stringBuilder.append('\u039d');
                stringBuilder.append((char)(810900 - n2));
            }
            return;
        }
        stringBuilder = new StringBuilder();
        stringBuilder.append("ECI number not in valid range from 0..811799, but was ");
        stringBuilder.append(n2);
        throw new WriterException(stringBuilder.toString());
    }

    private static boolean isAlphaLower(char c3) {
        boolean bl = c3 == ' ' || c3 >= 'a' && c3 <= 'z';
        return bl;
    }

    private static boolean isAlphaUpper(char c3) {
        boolean bl = c3 == ' ' || c3 >= 'A' && c3 <= 'Z';
        return bl;
    }

    private static boolean isDigit(char c3) {
        boolean bl = c3 >= '0' && c3 <= '9';
        return bl;
    }

    private static boolean isMixed(char c3) {
        boolean bl = MIXED[c3] != -1;
        return bl;
    }

    private static boolean isPunctuation(char c3) {
        boolean bl = PUNCTUATION[c3] != -1;
        return bl;
    }

    private static boolean isText(char c3) {
        boolean bl = c3 == '\t' || c3 == '\n' || c3 == '\r' || c3 >= ' ' && c3 <= '~';
        return bl;
    }
}

