/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.pdf417.encoder;

import com.ailiwean.core.zxing.core.pdf417.encoder.BarcodeRow;

public final class BarcodeMatrix {
    private int currentRow;
    private final int height;
    private final BarcodeRow[] matrix;
    private final int width;

    BarcodeMatrix(int n2, int n3) {
        this.matrix = new BarcodeRow[n2];
        int n4 = this.matrix.length;
        for (int i3 = 0; i3 < n4; ++i3) {
            this.matrix[i3] = new BarcodeRow((n3 + 4) * 17 + 1);
        }
        this.width = n3 * 17;
        this.height = n2;
        this.currentRow = -1;
    }

    BarcodeRow getCurrentRow() {
        return this.matrix[this.currentRow];
    }

    public byte[][] getMatrix() {
        return this.getScaledMatrix(1, 1);
    }

    public byte[][] getScaledMatrix(int n2, int n3) {
        byte[][] byArray = new byte[this.height * n3][this.width * n2];
        int n4 = this.height * n3;
        for (int i3 = 0; i3 < n4; ++i3) {
            byArray[n4 - i3 - 1] = this.matrix[i3 / n3].getScaledRow(n2);
        }
        return byArray;
    }

    void set(int n2, int n3, byte by) {
        this.matrix[n3].set(n2, by);
    }

    void startRow() {
        ++this.currentRow;
    }
}

