/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.pdf417.detector;

import com.ailiwean.core.zxing.core.BinaryBitmap;
import com.ailiwean.core.zxing.core.DecodeHintType;
import com.ailiwean.core.zxing.core.NotFoundException;
import com.ailiwean.core.zxing.core.ResultPoint;
import com.ailiwean.core.zxing.core.common.BitMatrix;
import com.ailiwean.core.zxing.core.pdf417.detector.PDF417DetectorResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class Detector {
    private static final int BARCODE_MIN_HEIGHT = 10;
    private static final int[] INDEXES_START_PATTERN = new int[]{0, 4, 1, 5};
    private static final int[] INDEXES_STOP_PATTERN = new int[]{6, 2, 7, 3};
    private static final float MAX_AVG_VARIANCE = 0.42f;
    private static final float MAX_INDIVIDUAL_VARIANCE = 0.8f;
    private static final int MAX_PATTERN_DRIFT = 5;
    private static final int MAX_PIXEL_DRIFT = 3;
    private static final int ROW_STEP = 5;
    private static final int SKIPPED_ROW_COUNT_MAX = 25;
    private static final int[] START_PATTERN = new int[]{8, 1, 1, 1, 1, 1, 1, 3};
    private static final int[] STOP_PATTERN = new int[]{7, 1, 1, 3, 1, 1, 1, 2, 1};

    private Detector() {
    }

    private static void copyToResult(ResultPoint[] resultPointArray, ResultPoint[] resultPointArray2, int[] nArray) {
        for (int i3 = 0; i3 < nArray.length; ++i3) {
            resultPointArray[nArray[i3]] = resultPointArray2[i3];
        }
    }

    public static PDF417DetectorResult detect(BinaryBitmap list, Map<DecodeHintType, ?> object, boolean bl) throws NotFoundException {
        BitMatrix bitMatrix = ((BinaryBitmap)((Object)list)).getBlackMatrix();
        List<ResultPoint[]> list2 = Detector.detect(bl, bitMatrix);
        object = bitMatrix;
        list = list2;
        if (list2.isEmpty()) {
            object = bitMatrix.clone();
            ((BitMatrix)object).rotate180();
            list = Detector.detect(bl, (BitMatrix)object);
        }
        return new PDF417DetectorResult((BitMatrix)object, list);
    }

    private static List<ResultPoint[]> detect(boolean bl, BitMatrix bitMatrix) {
        ArrayList<ResultPoint[]> arrayList = new ArrayList<ResultPoint[]>();
        int n2 = 0;
        block0: while (true) {
            int n3 = 0;
            boolean bl2 = false;
            while (n2 < bitMatrix.getHeight()) {
                float f3;
                ResultPoint[] resultPointArray = Detector.findVertices(bitMatrix, n2, n3);
                if (resultPointArray[0] == null && resultPointArray[3] == null) {
                    if (!bl2) break block0;
                    for (ResultPoint[] resultPointArray2 : arrayList) {
                        n3 = n2;
                        if (resultPointArray2[1] != null) {
                            n3 = (int)Math.max((float)n2, resultPointArray2[1].getY());
                        }
                        n2 = n3;
                        if (resultPointArray2[3] == null) continue;
                        n2 = Math.max(n3, (int)resultPointArray2[3].getY());
                    }
                    n2 += 5;
                    continue block0;
                }
                arrayList.add(resultPointArray);
                if (!bl) break block0;
                if (resultPointArray[2] != null) {
                    n2 = (int)((ResultPoint)resultPointArray[2]).getX();
                    f3 = ((ResultPoint)resultPointArray[2]).getY();
                } else {
                    n2 = (int)((ResultPoint)resultPointArray[4]).getX();
                    f3 = ((ResultPoint)resultPointArray[4]).getY();
                }
                int n4 = (int)f3;
                n3 = n2;
                bl2 = true;
                n2 = n4;
            }
            break;
        }
        return arrayList;
    }

    private static int[] findGuardPattern(BitMatrix bitMatrix, int n2, int n3, int n4, boolean bl, int[] nArray, int[] nArray2) {
        int n5;
        Arrays.fill(nArray2, 0, nArray2.length, 0);
        for (n5 = 0; bitMatrix.get(n2, n3) && n2 > 0 && n5 < 3; --n2, ++n5) {
        }
        int n6 = nArray.length;
        int n7 = n2;
        n5 = 0;
        int n8 = n2;
        n2 = n7;
        while (n8 < n4) {
            if (bitMatrix.get(n8, n3) != bl) {
                nArray2[n5] = nArray2[n5] + 1;
            } else {
                if (n5 == n6 - 1) {
                    if (Detector.patternMatchVariance(nArray2, nArray, 0.8f) < 0.42f) {
                        return new int[]{n2, n8};
                    }
                    n2 += nArray2[0] + nArray2[1];
                    n7 = n5 - 1;
                    System.arraycopy(nArray2, 2, nArray2, 0, n7);
                    nArray2[n7] = 0;
                    nArray2[n5] = 0;
                    --n5;
                } else {
                    ++n5;
                }
                nArray2[n5] = 1;
                bl ^= true;
            }
            ++n8;
        }
        if (n5 == n6 - 1 && Detector.patternMatchVariance(nArray2, nArray, 0.8f) < 0.42f) {
            return new int[]{n2, n8 - 1};
        }
        return null;
    }

    private static ResultPoint[] findRowsWithPattern(BitMatrix bitMatrix, int n2, int n3, int n4, int n5, int[] nArray) {
        float f3;
        float f4;
        int[] nArray2;
        int n6;
        int[] nArray3;
        int[] nArray4;
        Object[] objectArray;
        block9: {
            objectArray = new ResultPoint[4];
            nArray4 = new int[nArray.length];
            while (n4 < n2) {
                nArray3 = Detector.findGuardPattern(bitMatrix, n5, n4, n3, false, nArray, nArray4);
                if (nArray3 != null) {
                    block8: {
                        n6 = n4;
                        while (true) {
                            n4 = n6;
                            if (n6 <= 0) break block8;
                            if ((nArray2 = Detector.findGuardPattern(bitMatrix, n5, --n6, n3, false, nArray, nArray4)) == null) break;
                            nArray3 = nArray2;
                        }
                        n4 = n6 + 1;
                    }
                    f4 = nArray3[0];
                    f3 = n4;
                    objectArray[0] = new ResultPoint(f4, f3);
                    objectArray[1] = new ResultPoint(nArray3[1], f3);
                    n6 = 1;
                    n5 = n4;
                    break block9;
                }
                n4 += 5;
            }
            n6 = 0;
            n5 = n4;
        }
        int n7 = n4 = n5 + 1;
        if (n6 != 0) {
            nArray3 = new int[]{(int)objectArray[0].getX(), (int)((ResultPoint)objectArray[1]).getX()};
            n7 = 0;
            n6 = n4;
            n4 = n7;
            while (n6 < n2) {
                int n8 = nArray3[0];
                n7 = n4;
                nArray2 = Detector.findGuardPattern(bitMatrix, n8, n6, n3, false, nArray, nArray4);
                if (nArray2 != null && Math.abs(nArray3[0] - nArray2[0]) < 5 && Math.abs(nArray3[1] - nArray2[1]) < 5) {
                    nArray3 = nArray2;
                    n4 = 0;
                } else {
                    if (n7 > 25) break;
                    n4 = n7 + 1;
                }
                ++n6;
            }
            n7 = n6 - (n4 + 1);
            f4 = nArray3[0];
            f3 = n7;
            objectArray[2] = new ResultPoint(f4, f3);
            objectArray[3] = new ResultPoint(nArray3[1], f3);
        }
        if (n7 - n5 < 10) {
            Arrays.fill(objectArray, null);
        }
        return objectArray;
    }

    private static ResultPoint[] findVertices(BitMatrix bitMatrix, int n2, int n3) {
        int n4 = bitMatrix.getHeight();
        int n5 = bitMatrix.getWidth();
        ResultPoint[] resultPointArray = new ResultPoint[8];
        Detector.copyToResult(resultPointArray, Detector.findRowsWithPattern(bitMatrix, n4, n5, n2, n3, START_PATTERN), INDEXES_START_PATTERN);
        if (resultPointArray[4] != null) {
            n3 = (int)resultPointArray[4].getX();
            n2 = (int)resultPointArray[4].getY();
        }
        Detector.copyToResult(resultPointArray, Detector.findRowsWithPattern(bitMatrix, n4, n5, n2, n3, STOP_PATTERN), INDEXES_STOP_PATTERN);
        return resultPointArray;
    }

    private static float patternMatchVariance(int[] nArray, int[] nArray2, float f3) {
        int n2 = nArray.length;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i3 = 0; i3 < n2; ++i3) {
            n4 += nArray[i3];
            n5 += nArray2[i3];
        }
        if (n4 < n5) {
            return Float.POSITIVE_INFINITY;
        }
        float f4 = n4;
        float f5 = f4 / (float)n5;
        float f6 = 0.0f;
        for (n5 = n3; n5 < n2; ++n5) {
            n4 = nArray[n5];
            float f7 = n4;
            float f8 = (float)nArray2[n5] * f5;
            f8 = f7 > f8 ? f7 - f8 : (f8 -= f7);
            if (f8 > f3 * f5) {
                return Float.POSITIVE_INFINITY;
            }
            f6 += f8;
        }
        return f6 / f4;
    }
}

