/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.pdf417.decoder.ec;

import com.ailiwean.core.zxing.core.pdf417.decoder.ec.ModulusGF;

final class ModulusPoly {
    private final int[] coefficients;
    private final ModulusGF field;

    ModulusPoly(ModulusGF object, int[] nArray) {
        if (nArray.length != 0) {
            this.field = object;
            int n2 = nArray.length;
            if (n2 > 1 && nArray[0] == 0) {
                int n3;
                for (n3 = 1; n3 < n2 && nArray[n3] == 0; ++n3) {
                }
                if (n3 == n2) {
                    this.coefficients = new int[]{0};
                } else {
                    this.coefficients = new int[n2 - n3];
                    object = this.coefficients;
                    System.arraycopy(nArray, n3, object, 0, ((Object)object).length);
                }
            } else {
                this.coefficients = nArray;
            }
            return;
        }
        throw new IllegalArgumentException();
    }

    ModulusPoly add(ModulusPoly object) {
        if (this.field.equals(((ModulusPoly)object).field)) {
            if (this.isZero()) {
                return object;
            }
            if (((ModulusPoly)object).isZero()) {
                return this;
            }
            int[] nArray = this.coefficients;
            int[] nArray2 = ((ModulusPoly)object).coefficients;
            int[] nArray3 = nArray;
            object = nArray2;
            if (nArray.length > nArray2.length) {
                nArray3 = nArray2;
                object = nArray;
            }
            nArray = new int[((Object)object).length];
            int n2 = ((Object)object).length - nArray3.length;
            System.arraycopy(object, 0, nArray, 0, n2);
            for (int i3 = n2; i3 < ((Object)object).length; ++i3) {
                nArray[i3] = this.field.add(nArray3[i3 - n2], (int)object[i3]);
            }
            return new ModulusPoly(this.field, nArray);
        }
        throw new IllegalArgumentException("ModulusPolys do not have same ModulusGF field");
    }

    int evaluateAt(int n2) {
        int n3;
        int n4 = 0;
        if (n2 == 0) {
            return this.getCoefficient(0);
        }
        if (n2 == 1) {
            int[] nArray = this.coefficients;
            int n5 = nArray.length;
            n3 = 0;
            for (n2 = n4; n2 < n5; ++n2) {
                n4 = nArray[n2];
                n3 = this.field.add(n3, n4);
            }
            return n3;
        }
        Object object = this.coefficients;
        n4 = object[0];
        int n6 = ((int[])object).length;
        for (n3 = 1; n3 < n6; ++n3) {
            object = this.field;
            n4 = ((ModulusGF)object).add(((ModulusGF)object).multiply(n2, n4), this.coefficients[n3]);
        }
        return n4;
    }

    int getCoefficient(int n2) {
        int[] nArray = this.coefficients;
        return nArray[nArray.length - 1 - n2];
    }

    int[] getCoefficients() {
        return this.coefficients;
    }

    int getDegree() {
        return this.coefficients.length - 1;
    }

    boolean isZero() {
        int[] nArray = this.coefficients;
        boolean bl = false;
        if (nArray[0] == 0) {
            bl = true;
        }
        return bl;
    }

    ModulusPoly multiply(int n2) {
        if (n2 == 0) {
            return this.field.getZero();
        }
        if (n2 == 1) {
            return this;
        }
        int n3 = this.coefficients.length;
        int[] nArray = new int[n3];
        for (int i3 = 0; i3 < n3; ++i3) {
            nArray[i3] = this.field.multiply(this.coefficients[i3], n2);
        }
        return new ModulusPoly(this.field, nArray);
    }

    ModulusPoly multiply(ModulusPoly object) {
        if (this.field.equals(((ModulusPoly)object).field)) {
            if (!this.isZero() && !((ModulusPoly)object).isZero()) {
                int[] nArray = this.coefficients;
                int n2 = nArray.length;
                int[] nArray2 = ((ModulusPoly)object).coefficients;
                int n3 = nArray2.length;
                int[] nArray3 = new int[n2 + n3 - 1];
                for (int i3 = 0; i3 < n2; ++i3) {
                    int n4 = nArray[i3];
                    for (int i4 = 0; i4 < n3; ++i4) {
                        int n5 = i3 + i4;
                        object = this.field;
                        nArray3[n5] = ((ModulusGF)object).add(nArray3[n5], ((ModulusGF)object).multiply(n4, nArray2[i4]));
                    }
                }
                return new ModulusPoly(this.field, nArray3);
            }
            return this.field.getZero();
        }
        throw new IllegalArgumentException("ModulusPolys do not have same ModulusGF field");
    }

    ModulusPoly multiplyByMonomial(int n2, int n3) {
        if (n2 >= 0) {
            if (n3 == 0) {
                return this.field.getZero();
            }
            int n4 = this.coefficients.length;
            int[] nArray = new int[n2 + n4];
            for (n2 = 0; n2 < n4; ++n2) {
                nArray[n2] = this.field.multiply(this.coefficients[n2], n3);
            }
            return new ModulusPoly(this.field, nArray);
        }
        throw new IllegalArgumentException();
    }

    ModulusPoly negative() {
        int n2 = this.coefficients.length;
        int[] nArray = new int[n2];
        for (int i3 = 0; i3 < n2; ++i3) {
            nArray[i3] = this.field.subtract(0, this.coefficients[i3]);
        }
        return new ModulusPoly(this.field, nArray);
    }

    ModulusPoly subtract(ModulusPoly modulusPoly) {
        if (this.field.equals(modulusPoly.field)) {
            if (modulusPoly.isZero()) {
                return this;
            }
            return this.add(modulusPoly.negative());
        }
        throw new IllegalArgumentException("ModulusPolys do not have same ModulusGF field");
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getDegree() * 8);
        for (int i3 = this.getDegree(); i3 >= 0; --i3) {
            int n2;
            int n3 = this.getCoefficient(i3);
            if (n3 == 0) continue;
            if (n3 < 0) {
                stringBuilder.append(" - ");
                n2 = -n3;
            } else {
                n2 = n3;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(" + ");
                    n2 = n3;
                }
            }
            if (i3 == 0 || n2 != 1) {
                stringBuilder.append(n2);
            }
            if (i3 == 0) continue;
            if (i3 == 1) {
                stringBuilder.append('x');
                continue;
            }
            stringBuilder.append("x^");
            stringBuilder.append(i3);
        }
        return stringBuilder.toString();
    }
}

