/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.pdf417.decoder.ec;

import com.ailiwean.core.zxing.core.pdf417.decoder.ec.ModulusPoly;

public final class ModulusGF {
    public static final ModulusGF PDF417_GF = new ModulusGF(929, 3);
    private final int[] expTable;
    private final int[] logTable;
    private final int modulus;
    private final ModulusPoly one;
    private final ModulusPoly zero;

    private ModulusGF(int n2, int n3) {
        this.modulus = n2;
        this.expTable = new int[n2];
        this.logTable = new int[n2];
        int n4 = 1;
        for (int i3 = 0; i3 < n2; ++i3) {
            this.expTable[i3] = n4;
            n4 = n4 * n3 % n2;
        }
        for (n3 = 0; n3 < n2 - 1; ++n3) {
            this.logTable[this.expTable[n3]] = n3;
        }
        this.zero = new ModulusPoly(this, new int[]{0});
        this.one = new ModulusPoly(this, new int[]{1});
    }

    int add(int n2, int n3) {
        return (n2 + n3) % this.modulus;
    }

    ModulusPoly buildMonomial(int n2, int n3) {
        if (n2 >= 0) {
            if (n3 == 0) {
                return this.zero;
            }
            int[] nArray = new int[n2 + 1];
            nArray[0] = n3;
            return new ModulusPoly(this, nArray);
        }
        throw new IllegalArgumentException();
    }

    int exp(int n2) {
        return this.expTable[n2];
    }

    ModulusPoly getOne() {
        return this.one;
    }

    int getSize() {
        return this.modulus;
    }

    ModulusPoly getZero() {
        return this.zero;
    }

    int inverse(int n2) {
        if (n2 != 0) {
            return this.expTable[this.modulus - this.logTable[n2] - 1];
        }
        throw new ArithmeticException();
    }

    int log(int n2) {
        if (n2 != 0) {
            return this.logTable[n2];
        }
        throw new IllegalArgumentException();
    }

    int multiply(int n2, int n3) {
        if (n2 != 0 && n3 != 0) {
            int[] nArray = this.expTable;
            int[] nArray2 = this.logTable;
            return nArray[(nArray2[n2] + nArray2[n3]) % (this.modulus - 1)];
        }
        return 0;
    }

    int subtract(int n2, int n3) {
        int n4 = this.modulus;
        return (n2 + n4 - n3) % n4;
    }
}

