/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.pdf417.decoder.ec;

import com.ailiwean.core.zxing.core.ChecksumException;
import com.ailiwean.core.zxing.core.pdf417.decoder.ec.ModulusGF;
import com.ailiwean.core.zxing.core.pdf417.decoder.ec.ModulusPoly;

public final class ErrorCorrection {
    private final ModulusGF field = ModulusGF.PDF417_GF;

    private int[] findErrorLocations(ModulusPoly modulusPoly) throws ChecksumException {
        int n2 = modulusPoly.getDegree();
        int[] nArray = new int[n2];
        int n3 = 0;
        for (int i3 = 1; i3 < this.field.getSize() && n3 < n2; ++i3) {
            int n4 = n3;
            if (modulusPoly.evaluateAt(i3) == 0) {
                nArray[n3] = this.field.inverse(i3);
                n4 = n3 + 1;
            }
            n3 = n4;
        }
        if (n3 == n2) {
            return nArray;
        }
        throw ChecksumException.getChecksumInstance();
    }

    private int[] findErrorMagnitudes(ModulusPoly modulusPoly, ModulusPoly object, int[] nArray) {
        int n2;
        int n3 = ((ModulusPoly)object).getDegree();
        Object object2 = new int[n3];
        for (n2 = 1; n2 <= n3; ++n2) {
            object2[n3 - n2] = this.field.multiply(n2, ((ModulusPoly)object).getCoefficient(n2));
        }
        object2 = new ModulusPoly(this.field, (int[])object2);
        n3 = nArray.length;
        object = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            int n4 = this.field.inverse(nArray[n2]);
            int n5 = this.field.subtract(0, modulusPoly.evaluateAt(n4));
            n4 = this.field.inverse(((ModulusPoly)object2).evaluateAt(n4));
            object[n2] = this.field.multiply(n5, n4);
        }
        return object;
    }

    private ModulusPoly[] runEuclideanAlgorithm(ModulusPoly modulusPoly, ModulusPoly modulusPoly2, int n2) throws ChecksumException {
        ModulusPoly modulusPoly3;
        block4: {
            modulusPoly3 = modulusPoly;
            ModulusPoly modulusPoly4 = modulusPoly2;
            if (modulusPoly.getDegree() < modulusPoly2.getDegree()) {
                modulusPoly4 = modulusPoly;
                modulusPoly3 = modulusPoly2;
            }
            ModulusPoly modulusPoly5 = this.field.getZero();
            modulusPoly2 = this.field.getOne();
            modulusPoly = modulusPoly4;
            modulusPoly4 = modulusPoly5;
            while (true) {
                modulusPoly5 = modulusPoly4;
                modulusPoly4 = modulusPoly3;
                modulusPoly3 = modulusPoly;
                if (modulusPoly3.getDegree() < n2 / 2) break block4;
                if (modulusPoly3.isZero()) break;
                ModulusPoly modulusPoly6 = this.field.getZero();
                int n3 = modulusPoly3.getCoefficient(modulusPoly3.getDegree());
                n3 = this.field.inverse(n3);
                modulusPoly = modulusPoly4;
                modulusPoly4 = modulusPoly6;
                while (modulusPoly.getDegree() >= modulusPoly3.getDegree() && !modulusPoly.isZero()) {
                    int n4 = modulusPoly.getDegree() - modulusPoly3.getDegree();
                    int n5 = this.field.multiply(modulusPoly.getCoefficient(modulusPoly.getDegree()), n3);
                    modulusPoly4 = modulusPoly4.add(this.field.buildMonomial(n4, n5));
                    modulusPoly = modulusPoly.subtract(modulusPoly3.multiplyByMonomial(n4, n5));
                }
                modulusPoly5 = modulusPoly4.multiply(modulusPoly2).subtract(modulusPoly5).negative();
                modulusPoly4 = modulusPoly2;
                modulusPoly2 = modulusPoly5;
            }
            throw ChecksumException.getChecksumInstance();
        }
        n2 = modulusPoly2.getCoefficient(0);
        if (n2 != 0) {
            n2 = this.field.inverse(n2);
            return new ModulusPoly[]{modulusPoly2.multiply(n2), modulusPoly3.multiply(n2)};
        }
        throw ChecksumException.getChecksumInstance();
    }

    public int decode(int[] nArray, int n2, int[] object) throws ChecksumException {
        Object object2;
        int n3;
        Object object3 = new ModulusPoly(this.field, nArray);
        Object object4 = new int[n2];
        int n4 = 0;
        int n5 = 0;
        for (n3 = n2; n3 > 0; --n3) {
            object4[n2 - n3] = object2 = object3.evaluateAt(this.field.exp(n3));
            if (object2 == 0) continue;
            n5 = 1;
        }
        if (n5 == 0) {
            return 0;
        }
        object3 = this.field.getOne();
        if (object != null) {
            n5 = ((Object)object).length;
            for (n3 = 0; n3 < n5; ++n3) {
                object2 = object[n3];
                object2 = this.field.exp(nArray.length - 1 - object2);
                ModulusGF modulusGF = this.field;
                object3 = object3.multiply(new ModulusPoly(modulusGF, new int[]{modulusGF.subtract(0, (int)object2), 1}));
            }
        }
        ModulusPoly modulusPoly = new ModulusPoly(this.field, (int[])object4);
        object3 = this.runEuclideanAlgorithm(this.field.buildMonomial(n2, 1), modulusPoly, n2);
        ModulusPoly modulusPoly2 = object3[0];
        object4 = object3[1];
        object3 = this.findErrorLocations(modulusPoly2);
        int[] nArray2 = this.findErrorMagnitudes((ModulusPoly)object4, modulusPoly2, (int[])object3);
        for (n2 = n4; n2 < ((ModulusPoly[])object3).length; ++n2) {
            n3 = nArray.length - 1 - this.field.log((int)object3[n2]);
            if (n3 >= 0) {
                nArray[n3] = this.field.subtract(nArray[n3], nArray2[n2]);
                continue;
            }
            throw ChecksumException.getChecksumInstance();
        }
        return ((ModulusPoly[])object3).length;
    }
}

