/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.pdf417.decoder;

import com.ailiwean.core.zxing.core.ChecksumException;
import com.ailiwean.core.zxing.core.FormatException;
import com.ailiwean.core.zxing.core.NotFoundException;
import com.ailiwean.core.zxing.core.ResultPoint;
import com.ailiwean.core.zxing.core.common.BitMatrix;
import com.ailiwean.core.zxing.core.common.DecoderResult;
import com.ailiwean.core.zxing.core.common.detector.MathUtils;
import com.ailiwean.core.zxing.core.pdf417.PDF417Common;
import com.ailiwean.core.zxing.core.pdf417.decoder.BarcodeMetadata;
import com.ailiwean.core.zxing.core.pdf417.decoder.BarcodeValue;
import com.ailiwean.core.zxing.core.pdf417.decoder.BoundingBox;
import com.ailiwean.core.zxing.core.pdf417.decoder.Codeword;
import com.ailiwean.core.zxing.core.pdf417.decoder.DecodedBitStreamParser;
import com.ailiwean.core.zxing.core.pdf417.decoder.DetectionResult;
import com.ailiwean.core.zxing.core.pdf417.decoder.DetectionResultColumn;
import com.ailiwean.core.zxing.core.pdf417.decoder.DetectionResultRowIndicatorColumn;
import com.ailiwean.core.zxing.core.pdf417.decoder.PDF417CodewordDecoder;
import com.ailiwean.core.zxing.core.pdf417.decoder.ec.ErrorCorrection;
import java.util.ArrayList;
import java.util.Formatter;

public final class PDF417ScanningDecoder {
    private static final int CODEWORD_SKEW_SIZE = 2;
    private static final int MAX_EC_CODEWORDS = 512;
    private static final int MAX_ERRORS = 3;
    private static final ErrorCorrection errorCorrection = new ErrorCorrection();

    private PDF417ScanningDecoder() {
    }

    private static BoundingBox adjustBoundingBox(DetectionResultRowIndicatorColumn detectionResultRowIndicatorColumn) throws NotFoundException {
        int n2;
        if (detectionResultRowIndicatorColumn == null) {
            return null;
        }
        int[] nArray = detectionResultRowIndicatorColumn.getRowHeights();
        if (nArray == null) {
            return null;
        }
        int n3 = PDF417ScanningDecoder.getMax(nArray);
        int n4 = nArray.length;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (true) {
            n2 = n7;
            if (n6 >= n4) break;
            n2 = nArray[n6];
            n7 += n3 - n2;
            if (n2 > 0) {
                n2 = n7;
                break;
            }
            ++n6;
        }
        Codeword[] codewordArray = detectionResultRowIndicatorColumn.getCodewords();
        n7 = 0;
        n6 = n2;
        while (n6 > 0 && codewordArray[n7] == null) {
            --n6;
            ++n7;
        }
        n4 = nArray.length - 1;
        n2 = n5;
        while (true) {
            n7 = n2;
            if (n4 < 0) break;
            n7 = n2 + (n3 - nArray[n4]);
            if (nArray[n4] > 0) break;
            --n4;
            n2 = n7;
        }
        n4 = codewordArray.length - 1;
        n2 = n7;
        n7 = n4;
        while (n2 > 0 && codewordArray[n7] == null) {
            --n2;
            --n7;
        }
        return detectionResultRowIndicatorColumn.getBoundingBox().addMissingRows(n6, n2, detectionResultRowIndicatorColumn.isLeft());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void adjustCodewordCount(DetectionResult detectionResult, BarcodeValue[][] object) throws NotFoundException {
        BarcodeValue barcodeValue = object[0][1];
        int[] nArray = barcodeValue.getValue();
        int n2 = detectionResult.getBarcodeColumnCount() * detectionResult.getBarcodeRowCount() - PDF417ScanningDecoder.getNumberOfECCodeWords(detectionResult.getBarcodeECLevel());
        if (nArray.length == 0) {
            if (n2 < 1 || n2 > 928) throw NotFoundException.getNotFoundInstance();
            barcodeValue.setValue(n2);
            return;
        } else {
            if (nArray[0] == n2 || n2 < 1 || n2 > 928) return;
            barcodeValue.setValue(n2);
        }
    }

    private static int adjustCodewordStartColumn(BitMatrix bitMatrix, int n2, int n3, boolean bl, int n4, int n5) {
        int n6 = bl ? -1 : 1;
        int n7 = n4;
        for (int i3 = 0; i3 < 2; ++i3) {
            while ((bl ? n7 >= n2 : n7 < n3) && bl == bitMatrix.get(n7, n5)) {
                if (Math.abs(n4 - n7) > 2) {
                    return n4;
                }
                n7 += n6;
            }
            n6 = -n6;
            bl ^= true;
        }
        return n7;
    }

    private static boolean checkCodewordSkew(int n2, int n3, int n4) {
        boolean bl = n3 - 2 <= n2 && n2 <= n4 + 2;
        return bl;
    }

    private static int correctErrors(int[] nArray, int[] nArray2, int n2) throws ChecksumException {
        if ((nArray2 == null || nArray2.length <= n2 / 2 + 3) && n2 >= 0 && n2 <= 512) {
            return errorCorrection.decode(nArray, n2, nArray2);
        }
        throw ChecksumException.getChecksumInstance();
    }

    private static BarcodeValue[][] createBarcodeMatrix(DetectionResult detectionResultColumnArray) {
        int n2;
        int n3;
        BarcodeValue[][] barcodeValueArray = new BarcodeValue[detectionResultColumnArray.getBarcodeRowCount()][detectionResultColumnArray.getBarcodeColumnCount() + 2];
        for (n3 = 0; n3 < barcodeValueArray.length; ++n3) {
            for (n2 = 0; n2 < barcodeValueArray[n3].length; ++n2) {
                barcodeValueArray[n3][n2] = new BarcodeValue();
            }
        }
        detectionResultColumnArray = detectionResultColumnArray.getDetectionResultColumns();
        int n4 = detectionResultColumnArray.length;
        n2 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            DetectionResultColumn detectionResultColumn = detectionResultColumnArray[n3];
            if (detectionResultColumn != null) {
                for (Codeword codeword : detectionResultColumn.getCodewords()) {
                    int n5;
                    if (codeword == null || (n5 = codeword.getRowNumber()) < 0 || n5 >= barcodeValueArray.length) continue;
                    barcodeValueArray[n5][n2].setValue(codeword.getValue());
                }
            }
            ++n2;
        }
        return barcodeValueArray;
    }

    private static DecoderResult createDecoderResult(DetectionResult detectionResult) throws FormatException, ChecksumException, NotFoundException {
        int n2;
        Object object = PDF417ScanningDecoder.createBarcodeMatrix(detectionResult);
        PDF417ScanningDecoder.adjustCodewordCount(detectionResult, object);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int[] nArray = new int[detectionResult.getBarcodeRowCount() * detectionResult.getBarcodeColumnCount()];
        ArrayList<BarcodeValue[]> arrayList2 = new ArrayList<BarcodeValue[]>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        int n3 = 0;
        for (n2 = 0; n2 < detectionResult.getBarcodeRowCount(); ++n2) {
            int n4 = 0;
            while (n4 < detectionResult.getBarcodeColumnCount()) {
                Object[] objectArray = object[n2];
                int n5 = n4 + 1;
                objectArray = objectArray[n5].getValue();
                n4 = detectionResult.getBarcodeColumnCount() * n2 + n4;
                if (objectArray.length == 0) {
                    arrayList.add(n4);
                } else if (objectArray.length == 1) {
                    nArray[n4] = (int)objectArray[0];
                } else {
                    arrayList3.add(n4);
                    arrayList2.add((BarcodeValue[])objectArray);
                }
                n4 = n5;
            }
        }
        object = new int[arrayList2.size()][];
        for (n2 = n3; n2 < ((BarcodeValue[][])object).length; ++n2) {
            object[n2] = (BarcodeValue[])((int[])arrayList2.get(n2));
        }
        return PDF417ScanningDecoder.createDecoderResultFromAmbiguousValues(detectionResult.getBarcodeECLevel(), nArray, PDF417Common.toIntArray(arrayList), PDF417Common.toIntArray(arrayList3), (int[][])object);
    }

    private static DecoderResult createDecoderResultFromAmbiguousValues(int n2, int[] nArray, int[] nArray2, int[] nArray3, int[][] nArray4) throws FormatException, ChecksumException {
        int[] nArray5 = new int[nArray3.length];
        block2: for (int i3 = 100; i3 > 0; --i3) {
            int n3;
            for (n3 = 0; n3 < nArray5.length; ++n3) {
                nArray[nArray3[n3]] = nArray4[n3][nArray5[n3]];
            }
            try {
                DecoderResult decoderResult = PDF417ScanningDecoder.decodeCodewords(nArray, n2, nArray2);
                return decoderResult;
            }
            catch (ChecksumException checksumException) {
                if (nArray5.length != 0) {
                    for (n3 = 0; n3 < nArray5.length; ++n3) {
                        if (nArray5[n3] < nArray4[n3].length - 1) {
                            nArray5[n3] = nArray5[n3] + 1;
                            continue block2;
                        }
                        nArray5[n3] = 0;
                        if (n3 != nArray5.length - 1) {
                            continue;
                        }
                        throw ChecksumException.getChecksumInstance();
                    }
                    continue;
                }
                throw ChecksumException.getChecksumInstance();
            }
        }
        throw ChecksumException.getChecksumInstance();
    }

    public static DecoderResult decode(BitMatrix bitMatrix, ResultPoint object, ResultPoint object2, ResultPoint resultPoint, ResultPoint object3, int n2, int n3) throws NotFoundException, FormatException, ChecksumException {
        block8: {
            DetectionResult detectionResult;
            object3 = new BoundingBox(bitMatrix, (ResultPoint)object, (ResultPoint)object2, resultPoint, (ResultPoint)object3);
            Object object4 = object2 = null;
            int n4 = 1;
            while (true) {
                if (object != null) {
                    object2 = PDF417ScanningDecoder.getRowIndicatorColumn(bitMatrix, (BoundingBox)object3, (ResultPoint)object, true, n2, n3);
                }
                if (resultPoint != null) {
                    object4 = PDF417ScanningDecoder.getRowIndicatorColumn(bitMatrix, (BoundingBox)object3, resultPoint, false, n2, n3);
                }
                if ((detectionResult = PDF417ScanningDecoder.merge((DetectionResultRowIndicatorColumn)object2, (DetectionResultRowIndicatorColumn)object4)) == null) break block8;
                BoundingBox boundingBox = detectionResult.getBoundingBox();
                if (n4 == 0 || boundingBox == null || boundingBox.getMinY() >= ((BoundingBox)object3).getMinY() && boundingBox.getMaxY() <= ((BoundingBox)object3).getMaxY()) break;
                object3 = boundingBox;
                n4 = 0;
            }
            detectionResult.setBoundingBox((BoundingBox)object3);
            int n5 = detectionResult.getBarcodeColumnCount() + 1;
            detectionResult.setDetectionResultColumn(0, (DetectionResultColumn)object2);
            detectionResult.setDetectionResultColumn(n5, (DetectionResultColumn)object4);
            boolean bl = object2 != null;
            for (n4 = 1; n4 <= n5; ++n4) {
                int n6 = bl ? n4 : n5 - n4;
                if (detectionResult.getDetectionResultColumn(n6) != null) continue;
                if (n6 != 0 && n6 != n5) {
                    object = new DetectionResultColumn((BoundingBox)object3);
                } else {
                    boolean bl2 = n6 == 0;
                    object = new DetectionResultRowIndicatorColumn((BoundingBox)object3, bl2);
                }
                detectionResult.setDetectionResultColumn(n6, (DetectionResultColumn)object);
                int n7 = -1;
                int n8 = n2;
                n2 = n3;
                n3 = n7;
                for (int i3 = ((BoundingBox)object3).getMinY(); i3 <= ((BoundingBox)object3).getMaxY(); ++i3) {
                    n7 = PDF417ScanningDecoder.getStartColumn(detectionResult, n6, i3, bl);
                    if (n7 < 0 || n7 > ((BoundingBox)object3).getMaxX()) {
                        if (n3 == -1) continue;
                        n7 = n3;
                    }
                    if ((object2 = PDF417ScanningDecoder.detectCodeword(bitMatrix, ((BoundingBox)object3).getMinX(), ((BoundingBox)object3).getMaxX(), bl, n7, i3, n8, n2)) == null) continue;
                    ((DetectionResultColumn)object).setCodeword(i3, (Codeword)object2);
                    n8 = Math.min(n8, ((Codeword)object2).getWidth());
                    n2 = Math.max(n2, ((Codeword)object2).getWidth());
                    n3 = n7;
                }
                n3 = n2;
                n2 = n8;
            }
            return PDF417ScanningDecoder.createDecoderResult(detectionResult);
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static DecoderResult decodeCodewords(int[] object, int n2, int[] nArray) throws FormatException, ChecksumException {
        if (((int[])object).length != 0) {
            int n3 = 1 << n2 + 1;
            int n4 = PDF417ScanningDecoder.correctErrors((int[])object, nArray, n3);
            PDF417ScanningDecoder.verifyCodewordCount((int[])object, n3);
            object = DecodedBitStreamParser.decode((int[])object, String.valueOf(n2));
            ((DecoderResult)object).setErrorsCorrected(n4);
            ((DecoderResult)object).setErasures(nArray.length);
            return object;
        }
        throw FormatException.getFormatInstance();
    }

    private static Codeword detectCodeword(BitMatrix object, int n2, int object2, boolean bl, int n3, int n4, int n5, int n6) {
        if ((object = (Object)PDF417ScanningDecoder.getModuleBitCount((BitMatrix)object, n2, object2, bl, n3 = PDF417ScanningDecoder.adjustCodewordStartColumn((BitMatrix)object, n2, object2, bl, n3, n4), n4)) == null) {
            return null;
        }
        n4 = MathUtils.sum((int[])object);
        if (bl) {
            object2 = n3 + n4;
            n2 = n3;
            n3 = object2;
        } else {
            for (n2 = 0; n2 < ((Object)object).length / 2; ++n2) {
                object2 = object[n2];
                object[n2] = object[((Object)object).length - 1 - n2];
                object[((Object)object).length - 1 - n2] = object2;
            }
            n2 = n3 - n4;
        }
        if (!PDF417ScanningDecoder.checkCodewordSkew(n4, n5, n6)) {
            return null;
        }
        object2 = PDF417CodewordDecoder.getDecodedValue((int[])object);
        n4 = PDF417Common.getCodeword(object2);
        if (n4 == -1) {
            return null;
        }
        return new Codeword(n2, n3, PDF417ScanningDecoder.getCodewordBucketNumber(object2), n4);
    }

    private static BarcodeMetadata getBarcodeMetadata(DetectionResultRowIndicatorColumn object, DetectionResultRowIndicatorColumn object2) {
        Object var2_2 = null;
        if (object != null && (object = ((DetectionResultRowIndicatorColumn)object).getBarcodeMetadata()) != null) {
            if (object2 != null && (object2 = ((DetectionResultRowIndicatorColumn)object2).getBarcodeMetadata()) != null && ((BarcodeMetadata)object).getColumnCount() != ((BarcodeMetadata)object2).getColumnCount() && ((BarcodeMetadata)object).getErrorCorrectionLevel() != ((BarcodeMetadata)object2).getErrorCorrectionLevel() && ((BarcodeMetadata)object).getRowCount() != ((BarcodeMetadata)object2).getRowCount()) {
                return null;
            }
            return object;
        }
        object = object2 == null ? var2_2 : ((DetectionResultRowIndicatorColumn)object2).getBarcodeMetadata();
        return object;
    }

    private static int[] getBitCountForCodeword(int n2) {
        int[] nArray = new int[8];
        int n3 = nArray.length - 1;
        int n4 = 0;
        while (true) {
            int n5 = n2 & 1;
            int n6 = n3;
            int n7 = n4;
            if (n5 != n4) {
                n6 = n3 - 1;
                if (n6 < 0) {
                    return nArray;
                }
                n7 = n5;
            }
            nArray[n6] = nArray[n6] + 1;
            n2 >>= 1;
            n3 = n6;
            n4 = n7;
        }
    }

    private static int getCodewordBucketNumber(int n2) {
        return PDF417ScanningDecoder.getCodewordBucketNumber(PDF417ScanningDecoder.getBitCountForCodeword(n2));
    }

    private static int getCodewordBucketNumber(int[] nArray) {
        return (nArray[0] - nArray[2] + nArray[4] - nArray[6] + 9) % 9;
    }

    private static int getMax(int[] nArray) {
        int n2 = nArray.length;
        int n3 = -1;
        for (int i3 = 0; i3 < n2; ++i3) {
            n3 = Math.max(n3, nArray[i3]);
        }
        return n3;
    }

    private static int[] getModuleBitCount(BitMatrix bitMatrix, int n2, int n3, boolean bl, int n4, int n5) {
        int[] nArray = new int[8];
        int n6 = bl ? 1 : -1;
        int n7 = 0;
        boolean bl2 = bl;
        while ((bl ? n4 < n3 : n4 >= n2) && n7 < nArray.length) {
            if (bitMatrix.get(n4, n5) == bl2) {
                nArray[n7] = nArray[n7] + 1;
                n4 += n6;
                continue;
            }
            ++n7;
            bl2 ^= true;
        }
        if (n7 != nArray.length) {
            if (bl) {
                n2 = n3;
            }
            if (n4 != n2 || n7 != nArray.length - 1) {
                return null;
            }
        }
        return nArray;
    }

    private static int getNumberOfECCodeWords(int n2) {
        return 2 << n2;
    }

    private static DetectionResultRowIndicatorColumn getRowIndicatorColumn(BitMatrix bitMatrix, BoundingBox boundingBox, ResultPoint resultPoint, boolean bl, int n2, int n3) {
        DetectionResultRowIndicatorColumn detectionResultRowIndicatorColumn = new DetectionResultRowIndicatorColumn(boundingBox, bl);
        for (int i3 = 0; i3 < 2; ++i3) {
            int n4 = i3 == 0 ? 1 : -1;
            int n5 = (int)resultPoint.getX();
            for (int i4 = (int)resultPoint.getY(); i4 <= boundingBox.getMaxY() && i4 >= boundingBox.getMinY(); i4 += n4) {
                Codeword codeword = PDF417ScanningDecoder.detectCodeword(bitMatrix, 0, bitMatrix.getWidth(), bl, n5, i4, n2, n3);
                if (codeword == null) continue;
                detectionResultRowIndicatorColumn.setCodeword(i4, codeword);
                n5 = bl ? codeword.getStartX() : codeword.getEndX();
            }
        }
        return detectionResultRowIndicatorColumn;
    }

    private static int getStartColumn(DetectionResult object, int n2, int n3, boolean bl) {
        int n4 = bl ? 1 : -1;
        Codeword codeword = null;
        int n5 = n2 - n4;
        if (PDF417ScanningDecoder.isValidBarcodeColumn((DetectionResult)object, n5)) {
            codeword = ((DetectionResult)object).getDetectionResultColumn(n5).getCodeword(n3);
        }
        if (codeword != null) {
            n2 = bl ? codeword.getEndX() : codeword.getStartX();
            return n2;
        }
        codeword = ((DetectionResult)object).getDetectionResultColumn(n2).getCodewordNearby(n3);
        if (codeword != null) {
            n2 = bl ? codeword.getStartX() : codeword.getEndX();
            return n2;
        }
        if (PDF417ScanningDecoder.isValidBarcodeColumn((DetectionResult)object, n5)) {
            codeword = ((DetectionResult)object).getDetectionResultColumn(n5).getCodewordNearby(n3);
        }
        if (codeword != null) {
            n2 = bl ? codeword.getEndX() : codeword.getStartX();
            return n2;
        }
        n5 = 0;
        n3 = n2;
        n2 = n5;
        while (PDF417ScanningDecoder.isValidBarcodeColumn((DetectionResult)object, n5 = n3 - n4)) {
            Codeword[] codewordArray = ((DetectionResult)object).getDetectionResultColumn(n5).getCodewords();
            int n6 = codewordArray.length;
            for (n3 = 0; n3 < n6; ++n3) {
                codeword = codewordArray[n3];
                if (codeword == null) continue;
                n3 = bl ? codeword.getEndX() : codeword.getStartX();
                return n3 + n4 * n2 * (codeword.getEndX() - codeword.getStartX());
            }
            ++n2;
            n3 = n5;
        }
        object = ((DetectionResult)object).getBoundingBox();
        n2 = bl ? ((BoundingBox)object).getMinX() : ((BoundingBox)object).getMaxX();
        return n2;
    }

    private static boolean isValidBarcodeColumn(DetectionResult detectionResult, int n2) {
        boolean bl = true;
        if (n2 < 0 || n2 > detectionResult.getBarcodeColumnCount() + 1) {
            bl = false;
        }
        return bl;
    }

    private static DetectionResult merge(DetectionResultRowIndicatorColumn detectionResultRowIndicatorColumn, DetectionResultRowIndicatorColumn detectionResultRowIndicatorColumn2) throws NotFoundException {
        if (detectionResultRowIndicatorColumn == null && detectionResultRowIndicatorColumn2 == null) {
            return null;
        }
        BarcodeMetadata barcodeMetadata = PDF417ScanningDecoder.getBarcodeMetadata(detectionResultRowIndicatorColumn, detectionResultRowIndicatorColumn2);
        if (barcodeMetadata == null) {
            return null;
        }
        return new DetectionResult(barcodeMetadata, BoundingBox.merge(PDF417ScanningDecoder.adjustBoundingBox(detectionResultRowIndicatorColumn), PDF417ScanningDecoder.adjustBoundingBox(detectionResultRowIndicatorColumn2)));
    }

    public static String toString(BarcodeValue[][] object) {
        Formatter formatter = new Formatter();
        int n2 = 0;
        while (true) {
            if (n2 >= ((BarcodeValue[][])object).length) break;
            formatter.format("Row %2d: ", n2);
            int n3 = 0;
            while (true) {
                if (n3 >= object[n2].length) break;
                BarcodeValue barcodeValue = object[n2][n3];
                if (barcodeValue.getValue().length == 0) {
                    formatter.format("        ", (Object[])null);
                } else {
                    formatter.format("%4d(%2d)", barcodeValue.getValue()[0], barcodeValue.getConfidence(barcodeValue.getValue()[0]));
                }
                ++n3;
                continue;
                break;
            }
            formatter.format("%n", new Object[0]);
            ++n2;
            continue;
            break;
        }
        try {
            object = formatter.toString();
            formatter.close();
            return object;
        }
        catch (Throwable throwable) {
            try {
                throw throwable;
            }
            catch (Throwable throwable2) {
                try {
                    formatter.close();
                }
                catch (Throwable throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
    }

    private static void verifyCodewordCount(int[] nArray, int n2) throws FormatException {
        if (nArray.length >= 4) {
            int n3 = nArray[0];
            if (n3 <= nArray.length) {
                if (n3 == 0) {
                    if (n2 < nArray.length) {
                        nArray[0] = nArray.length - n2;
                    } else {
                        throw FormatException.getFormatInstance();
                    }
                }
                return;
            }
            throw FormatException.getFormatInstance();
        }
        throw FormatException.getFormatInstance();
    }
}

