/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.pdf417.decoder;

import com.ailiwean.core.zxing.core.common.detector.MathUtils;
import com.ailiwean.core.zxing.core.pdf417.PDF417Common;

final class PDF417CodewordDecoder {
    private static final float[][] RATIOS_TABLE = new float[PDF417Common.SYMBOL_TABLE.length][8];

    static {
        for (int i3 = 0; i3 < PDF417Common.SYMBOL_TABLE.length; ++i3) {
            int n2 = PDF417Common.SYMBOL_TABLE[i3];
            int n3 = n2 & 1;
            for (int i4 = 0; i4 < 8; ++i4) {
                int n4;
                float f3 = 0.0f;
                while ((n4 = n2 & 1) == n3) {
                    f3 += 1.0f;
                    n2 >>= 1;
                }
                PDF417CodewordDecoder.RATIOS_TABLE[i3][8 - i4 - 1] = f3 / 17.0f;
                n3 = n4;
            }
        }
    }

    private PDF417CodewordDecoder() {
    }

    private static int getBitValue(int[] nArray) {
        long l3 = 0L;
        for (int i3 = 0; i3 < nArray.length; ++i3) {
            for (int i4 = 0; i4 < nArray[i3]; ++i4) {
                int n2 = 1;
                if (i3 % 2 != 0) {
                    n2 = 0;
                }
                l3 = l3 << 1 | (long)n2;
            }
        }
        return (int)l3;
    }

    private static int getClosestDecodedValue(int[] object) {
        int n2;
        int n3 = MathUtils.sum(object);
        float[] fArray = new float[8];
        if (n3 > 1) {
            for (n2 = 0; n2 < fArray.length; ++n2) {
                fArray[n2] = (float)object[n2] / (float)n3;
            }
        }
        n3 = -1;
        float f3 = Float.MAX_VALUE;
        for (n2 = 0; n2 < ((int[])(object = (Object)RATIOS_TABLE)).length; ++n2) {
            float f4;
            object = object[n2];
            int n4 = 0;
            float f5 = 0.0f;
            while (true) {
                f4 = f5;
                if (n4 >= 8) break;
                f4 = object[n4] - fArray[n4];
                if ((f5 += f4 * f4) >= f3) {
                    f4 = f5;
                    break;
                }
                ++n4;
            }
            f5 = f3;
            if (f4 < f3) {
                n3 = PDF417Common.SYMBOL_TABLE[n2];
                f5 = f4;
            }
            f3 = f5;
        }
        return n3;
    }

    private static int getDecodedCodewordValue(int[] nArray) {
        int n2;
        int n3 = n2 = PDF417CodewordDecoder.getBitValue(nArray);
        if (PDF417Common.getCodeword(n2) == -1) {
            n3 = -1;
        }
        return n3;
    }

    static int getDecodedValue(int[] nArray) {
        int n2 = PDF417CodewordDecoder.getDecodedCodewordValue(PDF417CodewordDecoder.sampleBitCounts(nArray));
        if (n2 != -1) {
            return n2;
        }
        return PDF417CodewordDecoder.getClosestDecodedValue(nArray);
    }

    private static int[] sampleBitCounts(int[] nArray) {
        float f3 = MathUtils.sum(nArray);
        int[] nArray2 = new int[8];
        int n2 = 0;
        int n3 = 0;
        for (int i3 = 0; i3 < 17; ++i3) {
            float f4 = f3 / 34.0f;
            float f5 = (float)i3 * f3 / 17.0f;
            int n4 = n2;
            int n5 = n3;
            if ((float)(nArray[n3] + n2) <= f4 + f5) {
                n4 = n2 + nArray[n3];
                n5 = n3 + 1;
            }
            nArray2[n5] = nArray2[n5] + 1;
            n2 = n4;
            n3 = n5;
        }
        return nArray2;
    }
}

