/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.pdf417.decoder;

import com.ailiwean.core.zxing.core.pdf417.decoder.BoundingBox;
import com.ailiwean.core.zxing.core.pdf417.decoder.Codeword;
import java.util.Formatter;

class DetectionResultColumn {
    private static final int MAX_NEARBY_DISTANCE = 5;
    private final BoundingBox boundingBox;
    private final Codeword[] codewords;

    DetectionResultColumn(BoundingBox boundingBox) {
        this.boundingBox = new BoundingBox(boundingBox);
        this.codewords = new Codeword[boundingBox.getMaxY() - boundingBox.getMinY() + 1];
    }

    final BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    final Codeword getCodeword(int n2) {
        return this.codewords[this.imageRowToCodewordIndex(n2)];
    }

    final Codeword getCodewordNearby(int n2) {
        Object object = this.getCodeword(n2);
        if (object != null) {
            return object;
        }
        for (int i3 = 1; i3 < 5; ++i3) {
            int n3 = this.imageRowToCodewordIndex(n2) - i3;
            if (n3 >= 0 && (object = this.codewords[n3]) != null) {
                return object;
            }
            n3 = this.imageRowToCodewordIndex(n2) + i3;
            if (n3 >= ((Codeword[])(object = this.codewords)).length || (object = object[n3]) == null) continue;
            return object;
        }
        return null;
    }

    final Codeword[] getCodewords() {
        return this.codewords;
    }

    final int imageRowToCodewordIndex(int n2) {
        return n2 - this.boundingBox.getMinY();
    }

    final void setCodeword(int n2, Codeword codeword) {
        this.codewords[this.imageRowToCodewordIndex((int)n2)] = codeword;
    }

    public String toString() {
        Formatter formatter = new Formatter();
        Object object = this.codewords;
        int n2 = ((Codeword[])object).length;
        int n3 = 0;
        for (int i3 = 0; i3 < n2; ++i3) {
            Codeword codeword = object[i3];
            if (codeword == null) {
                formatter.format("%3d:    |   %n", n3);
                ++n3;
                continue;
            }
            formatter.format("%3d: %3d|%3d%n", n3, codeword.getRowNumber(), codeword.getValue());
            ++n3;
        }
        try {
            object = formatter.toString();
            formatter.close();
            return object;
        }
        catch (Throwable throwable) {
            try {
                throw throwable;
            }
            catch (Throwable throwable2) {
                try {
                    formatter.close();
                }
                catch (Throwable throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
    }
}

