/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.zxing.core.pdf417.decoder;

import com.ailiwean.core.zxing.core.pdf417.decoder.BarcodeMetadata;
import com.ailiwean.core.zxing.core.pdf417.decoder.BoundingBox;
import com.ailiwean.core.zxing.core.pdf417.decoder.Codeword;
import com.ailiwean.core.zxing.core.pdf417.decoder.DetectionResultColumn;
import com.ailiwean.core.zxing.core.pdf417.decoder.DetectionResultRowIndicatorColumn;
import java.util.Formatter;

final class DetectionResult {
    private static final int ADJUST_ROW_NUMBER_SKIP = 2;
    private final int barcodeColumnCount;
    private final BarcodeMetadata barcodeMetadata;
    private BoundingBox boundingBox;
    private final DetectionResultColumn[] detectionResultColumns;

    DetectionResult(BarcodeMetadata barcodeMetadata, BoundingBox boundingBox) {
        this.barcodeMetadata = barcodeMetadata;
        this.barcodeColumnCount = barcodeMetadata.getColumnCount();
        this.boundingBox = boundingBox;
        this.detectionResultColumns = new DetectionResultColumn[this.barcodeColumnCount + 2];
    }

    private void adjustIndicatorColumnRowNumbers(DetectionResultColumn detectionResultColumn) {
        if (detectionResultColumn != null) {
            ((DetectionResultRowIndicatorColumn)detectionResultColumn).adjustCompleteIndicatorColumnRowNumbers(this.barcodeMetadata);
        }
    }

    private static boolean adjustRowNumber(Codeword codeword, Codeword codeword2) {
        if (codeword2 == null) {
            return false;
        }
        if (codeword2.hasValidRowNumber() && codeword2.getBucket() == codeword.getBucket()) {
            codeword.setRowNumber(codeword2.getRowNumber());
            return true;
        }
        return false;
    }

    private static int adjustRowNumberIfValid(int n2, int n3, Codeword codeword) {
        if (codeword == null) {
            return n3;
        }
        int n4 = n3;
        if (!codeword.hasValidRowNumber()) {
            if (codeword.isValidRowNumber(n2)) {
                codeword.setRowNumber(n2);
                n4 = 0;
            } else {
                n4 = n3 + 1;
            }
        }
        return n4;
    }

    private int adjustRowNumbers() {
        int n2 = this.adjustRowNumbersByRow();
        if (n2 == 0) {
            return 0;
        }
        for (int i3 = 1; i3 < this.barcodeColumnCount + 1; ++i3) {
            Codeword[] codewordArray = this.detectionResultColumns[i3].getCodewords();
            for (int i4 = 0; i4 < codewordArray.length; ++i4) {
                if (codewordArray[i4] == null || codewordArray[i4].hasValidRowNumber()) continue;
                this.adjustRowNumbers(i3, i4, codewordArray);
            }
        }
        return n2;
    }

    private void adjustRowNumbers(int n2, int n3, Codeword[] codewordArray) {
        int n4;
        Codeword codeword = codewordArray[n3];
        Codeword[] codewordArray2 = this.detectionResultColumns[n2 - 1].getCodewords();
        Object[] objectArray = this.detectionResultColumns;
        objectArray = objectArray[++n2] != null ? objectArray[n2].getCodewords() : codewordArray2;
        Codeword[] codewordArray3 = new Codeword[14];
        codewordArray3[2] = codewordArray2[n3];
        codewordArray3[3] = objectArray[n3];
        n2 = 0;
        if (n3 > 0) {
            n4 = n3 - 1;
            codewordArray3[0] = codewordArray[n4];
            codewordArray3[4] = codewordArray2[n4];
            codewordArray3[5] = objectArray[n4];
        }
        if (n3 > 1) {
            n4 = n3 - 2;
            codewordArray3[8] = codewordArray[n4];
            codewordArray3[10] = codewordArray2[n4];
            codewordArray3[11] = objectArray[n4];
        }
        if (n3 < codewordArray.length - 1) {
            n4 = n3 + 1;
            codewordArray3[1] = codewordArray[n4];
            codewordArray3[6] = codewordArray2[n4];
            codewordArray3[7] = objectArray[n4];
        }
        if (n3 < codewordArray.length - 2) {
            codewordArray3[9] = codewordArray[n3 += 2];
            codewordArray3[12] = codewordArray2[n3];
            codewordArray3[13] = objectArray[n3];
        }
        n3 = codewordArray3.length;
        while (n2 < n3) {
            if (DetectionResult.adjustRowNumber(codeword, codewordArray3[n2])) {
                return;
            }
            ++n2;
        }
    }

    private int adjustRowNumbersByRow() {
        this.adjustRowNumbersFromBothRI();
        return this.adjustRowNumbersFromLRI() + this.adjustRowNumbersFromRRI();
    }

    private void adjustRowNumbersFromBothRI() {
        Object[] objectArray = this.detectionResultColumns;
        if (objectArray[0] != null && objectArray[this.barcodeColumnCount + 1] != null) {
            objectArray = objectArray[0].getCodewords();
            Codeword[] codewordArray = this.detectionResultColumns[this.barcodeColumnCount + 1].getCodewords();
            for (int i3 = 0; i3 < objectArray.length; ++i3) {
                if (objectArray[i3] == null || codewordArray[i3] == null || ((Codeword)objectArray[i3]).getRowNumber() != codewordArray[i3].getRowNumber()) continue;
                for (int i4 = 1; i4 <= this.barcodeColumnCount; ++i4) {
                    Codeword codeword = this.detectionResultColumns[i4].getCodewords()[i3];
                    if (codeword == null) continue;
                    codeword.setRowNumber(((Codeword)objectArray[i3]).getRowNumber());
                    if (codeword.hasValidRowNumber()) continue;
                    this.detectionResultColumns[i4].getCodewords()[i3] = null;
                }
            }
        }
    }

    private int adjustRowNumbersFromLRI() {
        Object object = this.detectionResultColumns;
        if (object[0] == null) {
            return 0;
        }
        Codeword[] codewordArray = object[0].getCodewords();
        int n2 = 0;
        for (int i3 = 0; i3 < codewordArray.length; ++i3) {
            if (codewordArray[i3] == null) continue;
            int n3 = codewordArray[i3].getRowNumber();
            int n4 = 0;
            for (int i4 = 1; i4 < this.barcodeColumnCount + 1 && n4 < 2; ++i4) {
                object = this.detectionResultColumns[i4].getCodewords()[i3];
                int n5 = n4;
                int n6 = n2;
                if (object != null) {
                    n5 = n4 = DetectionResult.adjustRowNumberIfValid(n3, n4, (Codeword)object);
                    n6 = n2;
                    if (!((Codeword)object).hasValidRowNumber()) {
                        n6 = n2 + 1;
                        n5 = n4;
                    }
                }
                n4 = n5;
                n2 = n6;
            }
        }
        return n2;
    }

    private int adjustRowNumbersFromRRI() {
        Object[] objectArray = this.detectionResultColumns;
        int n2 = this.barcodeColumnCount;
        if (objectArray[n2 + 1] == null) {
            return 0;
        }
        objectArray = objectArray[n2 + 1].getCodewords();
        n2 = 0;
        for (int i3 = 0; i3 < objectArray.length; ++i3) {
            if (objectArray[i3] == null) continue;
            int n3 = ((Codeword)objectArray[i3]).getRowNumber();
            int n4 = 0;
            for (int i4 = this.barcodeColumnCount + 1; i4 > 0 && n4 < 2; --i4) {
                Codeword codeword = this.detectionResultColumns[i4].getCodewords()[i3];
                int n5 = n4;
                int n6 = n2;
                if (codeword != null) {
                    n5 = n4 = DetectionResult.adjustRowNumberIfValid(n3, n4, codeword);
                    n6 = n2;
                    if (!codeword.hasValidRowNumber()) {
                        n6 = n2 + 1;
                        n5 = n4;
                    }
                }
                n4 = n5;
                n2 = n6;
            }
        }
        return n2;
    }

    int getBarcodeColumnCount() {
        return this.barcodeColumnCount;
    }

    int getBarcodeECLevel() {
        return this.barcodeMetadata.getErrorCorrectionLevel();
    }

    int getBarcodeRowCount() {
        return this.barcodeMetadata.getRowCount();
    }

    BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    DetectionResultColumn getDetectionResultColumn(int n2) {
        return this.detectionResultColumns[n2];
    }

    DetectionResultColumn[] getDetectionResultColumns() {
        int n2;
        this.adjustIndicatorColumnRowNumbers(this.detectionResultColumns[0]);
        this.adjustIndicatorColumnRowNumbers(this.detectionResultColumns[this.barcodeColumnCount + 1]);
        int n3 = 928;
        while ((n2 = this.adjustRowNumbers()) > 0 && n2 < n3) {
            n3 = n2;
        }
        return this.detectionResultColumns;
    }

    void setBoundingBox(BoundingBox boundingBox) {
        this.boundingBox = boundingBox;
    }

    void setDetectionResultColumn(int n2, DetectionResultColumn detectionResultColumn) {
        this.detectionResultColumns[n2] = detectionResultColumn;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toString() {
        Object object;
        Object object2 = this.detectionResultColumns;
        Object object3 = object = object2[0];
        if (object == null) {
            object3 = object2[this.barcodeColumnCount + 1];
        }
        object = new Formatter();
        int n2 = 0;
        while (true) {
            try {
                if (n2 >= ((DetectionResultColumn)object3).getCodewords().length) break;
                ((Formatter)object).format("CW %3d:", n2);
                for (int i3 = 0; i3 < this.barcodeColumnCount + 2; ++i3) {
                    object2 = this.detectionResultColumns[i3];
                    if (object2 == null) {
                        ((Formatter)object).format("    |   ", new Object[0]);
                        continue;
                    }
                    object2 = this.detectionResultColumns[i3].getCodewords()[n2];
                    if (object2 == null) {
                        ((Formatter)object).format("    |   ", new Object[0]);
                        continue;
                    }
                    ((Formatter)object).format(" %3d|%3d", ((Codeword)object2).getRowNumber(), ((Codeword)object2).getValue());
                }
            }
            catch (Throwable throwable) {
                try {
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    try {
                        ((Formatter)object).close();
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            {
                ((Formatter)object).format("%n", new Object[0]);
                ++n2;
                continue;
            }
            break;
        }
        {
            object3 = ((Formatter)object).toString();
            ((Formatter)object).close();
            return object3;
        }
    }
}

